/*
 * Decompiled with CFR 0.152.
 */
package com.baan.tech.b3.mqs;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.baan.tech.StateException;
import com.baan.tech.b3.mqs.MQSTransport;
import com.baan.tech.threadutil.HandlerLoop;
import com.baan.tech.threadutil.IHandlerRoutine;
import com.eibus.connection.BusListener;
import com.eibus.connection.Message;
import com.eibus.connection.NotHandledException;
import com.eibus.exception.BusException;
import com.ibm.mq.MQException;
import com.ibm.mq.MQMessage;
import java.io.IOException;

class MessageReader {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.tech.b3.mqs", "MessageReader");
    private static final ILogger s_innerLogger = LoggerFactory.createLogger("com.baan.tech.b3.mqs.MessageReader", "IHandlerRoutine");
    private MQSTransport transport;
    private BusListener busListener = null;
    private final HandlerLoop handlerLoop = new HandlerLoop(new Handler());

    MessageReader(MQSTransport mQSTransport) {
        s_logger.flowEntry("MessageReader(MQSTransport)");
        s_logger.message("Creating new MessageReader " + this);
        this.transport = mQSTransport;
        s_logger.flowExit("MessageReader(MQSTransport)");
    }

    void setBusListener(BusListener busListener) {
        s_logger.flowEntry("setBusListener(BusListener)");
        s_logger.message("messageReader.setBusListener() called on " + this);
        this.busListener = busListener;
        s_logger.flowExit("setBusListener(BusListener)");
    }

    void start() throws BusException {
        s_logger.flowEntry("start()");
        s_logger.message("messageReader.start() called on " + this);
        if (!this.handlerLoop.start()) {
            throw new BusException(this.handlerLoop + " in state " + this.handlerLoop.getStateString() + " will not start.");
        }
        s_logger.flowExit("start()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() throws BusException {
        s_logger.flowEntry("stop()");
        s_logger.message("messageReader.stop() called on " + this);
        HandlerLoop handlerLoop = this.handlerLoop;
        synchronized (handlerLoop) {
            block7: {
                try {
                    this.handlerLoop.suspend();
                }
                catch (InterruptedException interruptedException) {
                    s_logger.message("InterruptedException in stop() on " + this + ".");
                    s_logger.errorException(interruptedException);
                    if (this.handlerLoop.getState() != 0) {
                        throw new BusException(this.handlerLoop + " suspend() failed due to InterruptedException.");
                    }
                }
                catch (StateException stateException) {
                    s_logger.message("StateException in stop() on " + this + ".");
                    s_logger.errorException(stateException);
                    int n = this.handlerLoop.getState();
                    if (n == 0 || n == 4) break block7;
                    throw new BusException(stateException);
                }
            }
        }
        s_logger.flowExit("stop()");
    }

    private class Handler
    implements IHandlerRoutine {
        private Handler() {
        }

        public void handleNextItem(HandlerLoop handlerLoop) {
            s_innerLogger.flowEntry("handleNextItem(HandlerLoop");
            s_innerLogger.message("handleNextItem() on " + handlerLoop + " ...");
            try {
                s_innerLogger.message("*> Creating new com.ibm.mq.MQMessage ...");
                MQMessage mQMessage = new MQMessage();
                s_innerLogger.message("<* Created new com.ibm.mq.MQMessage.");
                if (MessageReader.this.transport.getRequest(mQMessage)) {
                    s_innerLogger.message("-> mQMessage.getDataLength()...");
                    byte[] byArray = new byte[mQMessage.getDataLength()];
                    s_innerLogger.message("<- mQMessage.getDatalength().\n-> mQMessage.readFully()...");
                    mQMessage.readFully(byArray);
                    s_innerLogger.message("<- mQMessage.readFully().\n-> mQMessage.clearMessage()...");
                    mQMessage.clearMessage();
                    s_innerLogger.message("<- mQMessage.clearMessage().");
                    Message message = new Message(byArray);
                    s_innerLogger.flowMessage("Passing message to " + MessageReader.this.busListener + " in " + handlerLoop + "...");
                    MessageReader.this.busListener.onReceive(message);
                    s_innerLogger.flowMessage("Message processed successfully in " + MessageReader.this.busListener + ".");
                    s_innerLogger.message("-> mQQueueManager.commit()...");
                    MessageReader.this.transport.getInputQueueManager().commit();
                    s_innerLogger.message("<- mQQueueManager.commit().");
                }
            }
            catch (MQException mQException) {
                s_innerLogger.message("MQSeries exception in " + handlerLoop + ".");
                s_innerLogger.errorException(mQException);
            }
            catch (NotHandledException notHandledException) {
                s_innerLogger.message("Application backout in " + handlerLoop + ".");
                s_innerLogger.errorException(notHandledException);
            }
            catch (BusException busException) {
                s_innerLogger.message("BusException in " + handlerLoop + ".");
                s_innerLogger.errorException(busException);
            }
            catch (IOException iOException) {
                s_innerLogger.message("IOException in " + handlerLoop + ".");
                s_innerLogger.errorException(iOException);
            }
            s_innerLogger.flowExit("handleNextItem(HandlerLoop");
        }
    }
}

