/*
 * Decompiled with CFR 0.152.
 */
package com.baan.tech.b3.mqs;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.baan.tech.b3.mqs.IMQSConstants;
import com.baan.tech.b3.mqs.MQSDeadLetter;
import com.baan.tech.b3.mqs.MQSDestination;
import com.baan.tech.b3.mqs.MQSExceptionReportMessage;
import com.baan.tech.b3.mqs.MQSProperties;
import com.eibus.exception.BusException;
import com.eibus.services.directory.ConnectionPoint;
import com.eibus.services.directory.URI;
import com.ibm.mq.MQC;
import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import java.io.IOException;
import java.util.Hashtable;

class MQSTransport
implements IMQSConstants {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.tech.b3.mqs", "MQSTransport");
    private static int count = 0;
    private final int nr = MQSTransport.nextNr();
    private final String name = "com.baan.tech.b3.mqs.MQSTransport" + this.nr;
    MQQueue deadLetterQueue = null;
    private static final String mqBlankName = "                                                ";
    private final String queueManagerName;
    private MQQueueManager inputQueueManager;
    private MQQueueManager outputQueueManager;
    private final String replyToQueueManagerName;
    private final MQQueue requestQueue;
    private final int backoutThreshold;
    private final String backoutQueueName;
    private final MQQueue backoutQueue;
    private final String deadLetterQueueName;
    private final MQQueue reportQueue;
    private final boolean mqRFH;
    private static final String MQ_RFH_STRUC_ID = "RFH ";
    private static final int MQ_RFH_VERSION = 1;
    private static final int MQ_RFH_MIN_STRUC_LENGTH = 32;
    private final int mqRFHStrucLength;
    private final int mqRFHEncoding = 273;
    private final int mqRFHCodedCharSetId;
    private final String mqRFHFormat;
    private final int mqRFHFlags = 0;
    private final String mqRFHOptionBuffer;
    private final Hashtable destinations = new Hashtable();
    final MQSProperties props;

    private static synchronized int nextNr() {
        return ++count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MQSTransport(ConnectionPoint connectionPoint) throws BusException {
        s_logger.flowEntry("MQSTransport(ConnectionPoint)");
        s_logger.flowMessage("Creating new " + this.name + " using ConnectionPoint " + connectionPoint);
        try {
            Object object;
            URI uRI;
            MQSProperties mQSProperties = MQSProperties.getProperties(connectionPoint.getURI());
            Object object2 = IMQSConstants.ENVIRONMENT_LOCK;
            synchronized (object2) {
                if (mQSProperties.mqTrace == 0) {
                    s_logger.message("-> MQEnvironment.disableTracing()...");
                    MQEnvironment.disableTracing();
                    s_logger.message("<- MQEnvironment.disableTracing().");
                } else {
                    s_logger.message("-> MQEnvironment.enableTracing()...");
                    MQEnvironment.enableTracing((int)mQSProperties.mqTrace);
                    s_logger.message("<- MQEnvironment.enableTracing().");
                }
                if (mQSProperties.binding == 2) {
                    MQEnvironment.channel = mQSProperties.channel;
                    MQEnvironment.hostname = mQSProperties.hostname;
                    MQEnvironment.port = mQSProperties.port;
                    MQEnvironment.password = mQSProperties.password;
                }
                s_logger.flowMessage("Connecting to input and output QueueManagers '" + mQSProperties.tentativeQueueManagerName + "' using binding=" + mQSProperties.binding + " (channel=" + mQSProperties.channel + ", host=" + mQSProperties.hostname + ", port=" + mQSProperties.port + ", password=" + mQSProperties.password + ")...");
                if (mQSProperties.binding == 2) {
                    s_logger.message("*> new com.ibm.mq.MQQueueManager(name)... (input)");
                    this.inputQueueManager = new MQQueueManager(mQSProperties.tentativeQueueManagerName);
                    s_logger.message("<* new com.ibm.mq.MQQueueManager(name). (input)\n*> new com.ibm.mq.MQQueueManager(name)... (output)");
                    this.outputQueueManager = new MQQueueManager(mQSProperties.tentativeQueueManagerName);
                    s_logger.message("<* new com.ibm.mq.MQQueueManager(name). (output)");
                } else {
                    s_logger.message("*> new com.ibm.mq.MQQueueManager(name,binding)... (input)");
                    this.inputQueueManager = new MQQueueManager(mQSProperties.tentativeQueueManagerName, mQSProperties.binding);
                    s_logger.message("<* new com.ibm.mq.MQQueueManager(name,binding). (input)\n*> new com.ibm.mq.MQQueueManager(name,binding)... (output)");
                    this.outputQueueManager = new MQQueueManager(mQSProperties.tentativeQueueManagerName, mQSProperties.binding);
                    s_logger.message("<* new com.ibm.mq.MQQueueManager(name,binding). (output)");
                }
            }
            int[] nArray = new int[]{2015};
            int[] nArray2 = new int[]{0};
            byte[] byArray = new byte[48];
            s_logger.message("-> mQQueueManager.inquire()... (inputQM)");
            this.inputQueueManager.inquire(nArray, nArray2, byArray);
            s_logger.message("<- mQQueueManager.inquire(). (inputQM)");
            this.queueManagerName = new String(byArray).trim();
            int[] nArray3 = new int[]{2006};
            int[] nArray4 = new int[]{0};
            byte[] byArray2 = new byte[48];
            s_logger.message("-> mQQueueManager.inquire()... (deadLetterQ)");
            this.inputQueueManager.inquire(nArray3, nArray4, byArray2);
            s_logger.message("<- mQQueueManager.inquire(). (deadLetterQ)");
            this.deadLetterQueueName = new String(byArray2);
            this.mqRFHCodedCharSetId = mQSProperties.characterSet;
            this.mqRFHFormat = mQSProperties.format;
            s_logger.message("-> mQQueueManager.accessQueue()... (requestQ)");
            this.requestQueue = this.inputQueueManager.accessQueue(mQSProperties.requestQueueName, 8225, "", "BAAN.CLIENT.REQ.Q.*", "");
            s_logger.message("<- mQQueueManager.accessQueue(). (requestQ)");
            String string = this.requestQueue.name.trim();
            if (!string.equals(mQSProperties.requestQueueName.trim())) {
                uRI = mQSProperties.deriveURI(string);
                mQSProperties = MQSProperties.getProperties(uRI);
                object = connectionPoint.getPolicy();
                if ("variable".equalsIgnoreCase((String)object)) {
                    connectionPoint.setURI(uRI);
                }
            }
            uRI = null;
            try {
                s_logger.message("-> mQQueueManager.accessQueue()... (reportQ)");
                uRI = this.inputQueueManager.accessQueue(mQSProperties.reportQueueName, 8208, "", "", "");
                s_logger.message("<- mQQueueManager.accessQueue(). (reportQ)");
            }
            catch (MQException mQException) {
                if (mQException.reasonCode == 2085) {
                    s_logger.message("Report queue not defined.");
                    s_logger.errorException(mQException);
                    uRI = null;
                }
                throw mQException;
            }
            this.reportQueue = uRI;
            object = new int[]{2019, 22};
            int[] nArray5 = new int[]{0};
            byte[] byArray3 = new byte[48];
            s_logger.message("-> mqQueue.inquire()...");
            this.requestQueue.inquire((int[])object, nArray5, byArray3);
            s_logger.message("<- mqQueue.inquire().");
            this.backoutQueueName = new String(byArray3);
            this.backoutThreshold = nArray5[0];
            if (this.backoutQueueName.equals(mqBlankName)) {
                this.backoutQueue = null;
            } else {
                s_logger.message("-> mQQueueManager.accessQueue()... (backoutQ)");
                this.backoutQueue = this.inputQueueManager.accessQueue(this.backoutQueueName, 8208, "", "", "");
                s_logger.message("<- mQQueueManager.accessQueue(). (backoutQ)");
            }
            this.replyToQueueManagerName = this.queueManagerName;
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            if (mQSProperties.applicationGroupRFH != "") {
                stringBuffer.append("OPT_APP_GRP " + mQSProperties.applicationGroupRFH + " ");
                bl = true;
            }
            if (mQSProperties.messageTypeRFH != "") {
                stringBuffer.append("OPT_MSG_TYPE " + mQSProperties.messageTypeRFH + " ");
                bl = true;
            }
            this.mqRFH = bl;
            this.mqRFHOptionBuffer = stringBuffer.toString();
            this.mqRFHStrucLength = 32 + this.mqRFHOptionBuffer.length();
            this.props = mQSProperties;
            s_logger.flowExit("MQSTransport(ConnectionPoint)");
        }
        catch (MQException mQException) {
            s_logger.message("MQException while creating " + this.name + ".");
            s_logger.errorException(mQException);
            throw new BusException((Exception)((Object)mQException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discardPoisonedMessage(MQMessage mQMessage, MQQueue mQQueue) throws MQException, BusException {
        MQPutMessageOptions mQPutMessageOptions;
        s_logger.flowEntry("discardPoisonedMessage(MQMessage,MQQueue)");
        if ((mQMessage.report & 0x8000000) != 0x8000000) {
            s_logger.message("*> new com.ibm.mq.MQPutMessageOptions()...");
            mQPutMessageOptions = new MQPutMessageOptions();
            s_logger.message("<* new com.ibm.mq.MQPutMessageOptions().\n-> mQQueue.put()... (poisonedMessage)");
            mQPutMessageOptions.options = 8226;
            this.backoutQueue.put(mQMessage, mQPutMessageOptions);
            s_logger.message("<- mQQueue.put(). (poisonedMessage)");
        }
        if ((mQMessage.report & 0x1000000) == 0x1000000) {
            mQPutMessageOptions = null;
            MQSExceptionReportMessage mQSExceptionReportMessage = new MQSExceptionReportMessage(mQMessage, 2003);
            try {
                s_logger.message("-> mQQueueManger.accessQueue()... (replyToQ)");
                mQPutMessageOptions = this.inputQueueManager.accessQueue(mQMessage.replyToQueueName, 8208, mQMessage.replyToQueueManagerName, "", "");
                s_logger.message("<- mQQueueManger.accessQueue(). (replyToQ)\n*> new com.ibm.mq.MQPutMessageOptions()...");
                MQPutMessageOptions mQPutMessageOptions2 = new MQPutMessageOptions();
                s_logger.message("<* new com.ibm.mq.MQPutMessageOptions().\n-> mQQueue.put()... (reportMessage)");
                mQPutMessageOptions2.options = 8226;
                mQPutMessageOptions.put((MQMessage)mQSExceptionReportMessage, mQPutMessageOptions2);
                s_logger.message("<- mQQueue.put(). (reportMessage)");
            }
            catch (MQException mQException) {
                s_logger.message("MQException in mQSTranport.discardPoisonedMessage().");
                s_logger.errorException(mQException);
                MQSDeadLetter mQSDeadLetter = new MQSDeadLetter(mQMessage, mQMessage.replyToQueueName, mQMessage.replyToQueueManagerName, 2003);
                this.putDeadLetter(mQSDeadLetter, this.requestQueue);
            }
            finally {
                if (mQPutMessageOptions != null) {
                    s_logger.message("-> mQQueue.close()... (replyToQ)");
                    mQPutMessageOptions.close();
                    s_logger.message("<- mQQueue.close(). (replyToQ)");
                }
            }
        }
        s_logger.flowExit("discardPoisonedMessage(MQMessage,MQQueue)");
    }

    void disconnect() throws MQException {
        s_logger.flowEntry("disconnect()");
        if (this.inputQueueManager != null) {
            s_logger.message("-> mQQueueManager.backout()... (inputQM)");
            this.inputQueueManager.backout();
            s_logger.message("<- mQQueueManager.backout(). (inputQM)\n-> mQQueueManager.disconnect()... (inputQM)");
            this.inputQueueManager.disconnect();
            s_logger.message("<- mQQueueManager.disconnect(). (inputQM)");
            this.inputQueueManager = null;
        }
        if (this.outputQueueManager != null) {
            s_logger.message("-> mQQueueManager.backout()... (outputQM)");
            this.outputQueueManager.backout();
            s_logger.message("<- mQQueueManager.backout(). (ouputQM)\n-> mQQueueManager.disconnect()... (outputQM)");
            this.outputQueueManager.disconnect();
            s_logger.message("<- mQQueueManager.disconnect(). (ouputQM)");
            this.outputQueueManager = null;
        }
        s_logger.flowExit("disconnect()");
    }

    public void finalize() {
        s_logger.flowEntry("finalize()");
        try {
            this.disconnect();
            super.finalize();
        }
        catch (MQException mQException) {
            s_logger.message("MQException in " + this.name + ".finalize().");
            s_logger.errorException(mQException);
        }
        catch (Throwable throwable) {
            s_logger.message("Throwable in " + this.name + ".finalize().");
            s_logger.errorException(throwable);
        }
        s_logger.flowExit("finalize()");
    }

    MQSDestination getDestination(URI uRI) throws BusException {
        s_logger.flowEntry("getDestination(URI)");
        try {
            MQSDestination mQSDestination = (MQSDestination)this.destinations.get(uRI);
            if (mQSDestination == null) {
                mQSDestination = new MQSDestination(this, uRI);
                this.destinations.put(uRI, mQSDestination);
            }
            s_logger.flowExit("getDestination(URI)");
            return mQSDestination;
        }
        catch (MQException mQException) {
            s_logger.message("MQException in " + this.name + ".getDestination().");
            s_logger.errorException(mQException);
            throw new BusException((Exception)((Object)mQException));
        }
    }

    MQQueueManager getInputQueueManager() {
        return this.inputQueueManager;
    }

    MQQueueManager getOutputQueueManager() {
        return this.outputQueueManager;
    }

    String getQueueManagerName() {
        return this.queueManagerName;
    }

    String getReplyToQueueManagerName() {
        return this.replyToQueueManagerName;
    }

    boolean getRequest(MQMessage mQMessage) throws MQException, BusException {
        s_logger.flowEntry("getRequest(MQMessage)");
        boolean bl = false;
        try {
            do {
                s_logger.message("-> mQMessage.clearMessage()...");
                mQMessage.clearMessage();
                s_logger.message("<- mQMessage.clearMessage().\n*> Creating new com.ibm.mq.MQGetMessageOptions...");
                MQGetMessageOptions mQGetMessageOptions = new MQGetMessageOptions();
                s_logger.message("<* Created new com.ibm.mq.MQGetMessageOptions.");
                mQGetMessageOptions.options = this.props.requestQueueGetOptions;
                mQGetMessageOptions.waitInterval = this.props.waitInterval;
                mQMessage.correlationId = MQC.MQCI_NONE;
                mQMessage.messageId = MQC.MQMI_NONE;
                mQMessage.characterSet = 1208;
                try {
                    s_logger.message("-> mQQueue.get()...");
                    this.requestQueue.get(mQMessage, mQGetMessageOptions);
                    s_logger.message("<- mQQueue.get().");
                }
                catch (MQException mQException) {
                    if (mQException.completionCode != 1) {
                        throw mQException;
                    }
                    s_logger.message("MQSeries Warning getting request message.");
                    s_logger.errorException(mQException);
                }
                if (this.backoutQueue != null && mQMessage.backoutCount > this.backoutThreshold) {
                    this.discardPoisonedMessage(mQMessage, this.requestQueue);
                    continue;
                }
                switch (mQMessage.messageType) {
                    case 1: 
                    case 2: 
                    case 8: {
                        bl = true;
                        break;
                    }
                    case 4: {
                        Object object;
                        if (this.reportQueue != null) {
                            s_logger.message("*> Creating new com.ibm.mq.MQPutMessageOptions...");
                            object = new MQPutMessageOptions();
                            s_logger.message("<* Created new com.ibm.mq.MQPutMessageOptionns.");
                            object.options = 8226;
                            try {
                                s_logger.message("-> mQQueue.put()...");
                                this.reportQueue.put(mQMessage, object);
                                s_logger.message("<- mQQueue.put().");
                            }
                            catch (MQException mQException) {
                                s_logger.message("MQException thrown in mQSTranport.getRequest(): report");
                                s_logger.errorException(mQException);
                                MQSDeadLetter mQSDeadLetter = new MQSDeadLetter(mQMessage, this.props.reportQueueName, this.queueManagerName, mQException.reasonCode);
                                this.putDeadLetter(mQSDeadLetter, this.requestQueue);
                            }
                        } else if ((mQMessage.report & 0x8000000) != 0x8000000) {
                            object = new MQSDeadLetter(mQMessage, this.props.requestQueueName, this.queueManagerName, 2039);
                            this.putDeadLetter((MQSDeadLetter)((Object)object), this.requestQueue);
                        }
                        s_logger.message("-> mQQueueManager.commit()...");
                        this.inputQueueManager.commit();
                        s_logger.message("<- mQQueueManager.commit().");
                        break;
                    }
                    default: {
                        Object object;
                        if ((mQMessage.report & 0x8000000) != 0x8000000) {
                            object = new MQSDeadLetter(mQMessage, this.props.requestQueueName, this.queueManagerName, 2029);
                            this.putDeadLetter((MQSDeadLetter)((Object)object), this.requestQueue);
                        }
                        s_logger.message("-> mQQueueManager.commit()...");
                        this.inputQueueManager.commit();
                        s_logger.message("<- mQQueueManager.commit().");
                    }
                }
            } while (!bl);
        }
        catch (MQException mQException) {
            if (mQException.reasonCode == 2033) {
                s_logger.message("MQSeries Completion Code " + mQException.completionCode + ", Reason Code " + mQException.reasonCode + ", Description: " + "No message available in the MQSeries queue.");
                s_logger.errorException(mQException);
                s_logger.flowExit("getRequest(MQMessage)1");
                return false;
            }
            throw mQException;
        }
        catch (IOException iOException) {
            s_logger.message("IOException thrown in mQSTransport.getRequest().");
            s_logger.errorException(iOException);
            throw new BusException(iOException);
        }
        this.stripRFH(mQMessage);
        s_logger.flowExit("getRequest(MQMessage)2");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putDeadLetter(MQSDeadLetter mQSDeadLetter, MQQueue mQQueue) throws MQException {
        s_logger.flowEntry("putDeadLetter(MQSDeadLetter,MQQueue)");
        try {
            s_logger.message("-> mQQueueManager.accessQueue()...");
            this.deadLetterQueue = this.inputQueueManager.accessQueue(this.deadLetterQueueName, 8208, "", "", "");
            s_logger.message("<- mQQueueManager.accessQueue().\n*> Creating new com.ibm.mq.MQPutMessageOptions()...");
            MQPutMessageOptions mQPutMessageOptions = new MQPutMessageOptions();
            s_logger.message("<* Created new com.ibm.mq.MQPutMessageOptions.\n-> mQQueue.put()...");
            mQPutMessageOptions.options = 8226;
            this.deadLetterQueue.put((MQMessage)mQSDeadLetter, mQPutMessageOptions);
            s_logger.message("<- mQQueue.put().");
        }
        finally {
            if (this.deadLetterQueue != null) {
                s_logger.message("-> mQQueue.close()...");
                this.deadLetterQueue.close();
                s_logger.message("<- mQQueue.close().");
            }
            s_logger.flowExit("putDeadLetter(MQSDeadLetter,MQQueue)");
        }
    }

    private void stripRFH(MQMessage mQMessage) throws BusException {
        s_logger.flowEntry("stripRFH(MQMessage)");
        try {
            s_logger.message("-> mQMessage.getDataLength()...");
            if (mQMessage.getDataLength() > 3) {
                s_logger.message("<- mQMessage.getDataLength().\n-> mQMessage.readByte()... (4x)");
                byte[] byArray = new byte[]{mQMessage.readByte(), mQMessage.readByte(), mQMessage.readByte(), mQMessage.readByte()};
                s_logger.message("<- mQMessage.readByte(). (4x)");
                String string = new String(byArray, "UTF8");
                if (string.equals(MQ_RFH_STRUC_ID)) {
                    s_logger.message("-> mQMessage.readInt()...");
                    int n = mQMessage.readInt4();
                    s_logger.message("<- mQMessage.readInt().\n-> mQMessage.readInt()...");
                    int n2 = mQMessage.readInt4();
                    s_logger.message("<- mQMessage.readInt().");
                    byte[] byArray2 = new byte[n2];
                    s_logger.message("-> mQMessage.setDataOffset()...");
                    mQMessage.setDataOffset(0);
                    s_logger.message("<- mQMessage.setDataOffset().\n-> mQMessage.readFully()...");
                    mQMessage.readFully(byArray2, 0, n2);
                    s_logger.message("<- mQMessage.readFully().");
                } else {
                    s_logger.message("-> mQMessage.setDataOffset()...");
                    mQMessage.setDataOffset(0);
                    s_logger.message("<- mQMessage.setDataOffset().");
                }
            }
        }
        catch (IOException iOException) {
            s_logger.message("IOException thrown in mQTransport.stripRFH().");
            s_logger.errorException(iOException);
            throw new BusException(iOException);
        }
        s_logger.flowExit("stripRFH(MQMessage)");
    }

    public String toString() {
        return this.getQueueManagerName();
    }

    void writeRFH(MQMessage mQMessage) throws IOException {
        s_logger.flowEntry("writeRFH(MQMessage)");
        if (this.mqRFH) {
            s_logger.message("-> mQMessage.write(byte[])...");
            mQMessage.write(MQ_RFH_STRUC_ID.getBytes("UTF8"));
            s_logger.message("<- mQMessage.write(byte[]).\n-> mQMessage.writeInt4()...");
            mQMessage.writeInt4(1);
            s_logger.message("<- mQMessage.writeInt4().\n-> mQMessage.writeInt4()...");
            mQMessage.writeInt4(this.mqRFHStrucLength);
            s_logger.message("<- mQMessage.writeInt4().\n-> mQMessage.writeInt4()...");
            mQMessage.writeInt4(273);
            s_logger.message("<- mQMessage.writeInt4().\n-> mQMessage.writeInt4()...");
            mQMessage.writeInt4(this.mqRFHCodedCharSetId);
            s_logger.message("<- mQMessage.writeInt4().\n-> mQMessage.write(byte[])...");
            mQMessage.write(this.mqRFHFormat.getBytes("UTF8"));
            s_logger.message("<- mQMessage.write(byte[]).");
            mQMessage.format = "MQRFH   ";
            mQMessage.characterSet = 1208;
            int n = 8 - this.mqRFHFormat.length();
            while (n > 0) {
                s_logger.message("-> mQMessage.write(char)...");
                mQMessage.write(32);
                s_logger.message("<- mQMessage.write(char).");
                --n;
            }
            s_logger.message("-> mQMessage.writeInt4()...");
            mQMessage.writeInt4(0);
            s_logger.message("<- mQMessage.writeInt4().\n-> mQMessage.write(byte[])...");
            mQMessage.write(this.mqRFHOptionBuffer.getBytes("UTF8"));
            s_logger.message("<- mQMessage.write(byte[]).");
        }
        s_logger.flowExit("writeRFH(MQMessage)");
    }
}

