/*
 * Decompiled with CFR 0.152.
 */
package com.baan.tech.b3.mqs;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.baan.tech.b3.mqs.IMQSConstants;
import com.eibus.exception.BusException;
import com.eibus.services.directory.URI;
import com.ibm.mq.MQC;
import java.util.Enumeration;
import java.util.Hashtable;

class MQSProperties
implements IMQSConstants {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.tech.b3.mqs", "MQSProperties");
    private static final Hashtable s_propsCache = new Hashtable();
    private static final int II_MQTRACE = 0;
    private static final int II_BINDING = 1;
    private static final int II_PORT = 2;
    private static final int II_CHARACTERSET = 3;
    private static final int II_CONVERSION = 4;
    private static final int II_WAITINTERVAL = 5;
    private static final int II_PERSISTENCE = 6;
    private static final int II_PRIORITY = 7;
    private static final int II_EXPIRYTIME = 8;
    private static final int II_REPORTOPTIONS = 9;
    private static final int II_MESSAGETYPE = 10;
    private static final int II_NR = 11;
    private static final String[] IKEYS = new String[]{"MQTraceOptions", "ConnectionType", "Port", "CharacterSet", "Conversion", "RequestQueueWaitInterval", "Persistence", "Priority", "Expiry", "ReportOptions", "MessageType"};
    private static final int[] IDEFS = new int[]{0, 2, 1414, 1208, 16384, 30000, 0, -1, -1, 0, 8};
    private static final int SI_CHANNEL = 0;
    private static final int SI_HOSTNAME = 1;
    private static final int SI_PASSWORD = 2;
    private static final int SI_TENTATIVEQMNAME = 3;
    private static final int SI_TENTATIVETARGETQMNAME = 4;
    private static final int SI_FORMAT = 5;
    private static final int SI_REQUESTQUEUENAME = 6;
    private static final int SI_TARGETQUEUENAME = 7;
    private static final int SI_REPORTQUEUENAME = 8;
    private static final int SI_APPLICATIONGROUPRFH = 9;
    private static final int SI_MESSAGETYPERFH = 10;
    private static final int SI_NR = 11;
    private static final String[] SKEYS = new String[]{"Channel", "Hostname", "Password", "LocalQueueManager", "RemoteQueueManager", "Format", "RequestQueue", "RemoteQueue", "ReportQueue", "ApplicationGroupRFH", "MessageTypeRFH"};
    private static final String[] SDEFS = new String[]{"BAAN.CLIENT", "localhost", IMQSConstants.VOIDSTR, " ", IMQSConstants.VOIDSTR, "MQSTR   ", "BAAN.REQUEST.QUEUE", IMQSConstants.VOIDSTR, "BAAN.REPORT.QUEUE", IMQSConstants.VOIDSTR, IMQSConstants.VOIDSTR};
    private static final int BI_MESSAGEIDENTIFIER = 0;
    private static final int BI_CORRELATIONIDENTIFIER = 1;
    private static final int BI_NR = 2;
    private static final String[] BKEYS = new String[]{"MessageIdentifier", "CorrelationIdentifier"};
    private static final byte[][] BDEFS = new byte[][]{MQC.MQMI_NONE, MQC.MQCI_NONE};
    private static int s_count = 0;
    private final int nr = MQSProperties.nextNr();
    final String targetQueueName;
    static final int targetQueueOpenOptions = 8208;
    static final int requestQueueOpenOptions = 8225;
    static final int targetQueuePutOptions = 8226;
    static final byte[] requestMsgId = MQC.MQMI_NONE;
    static final byte[] requestCorrelId = MQC.MQCI_NONE;
    static final int backoutQueueOpenOptions = 8208;
    final int persistence;
    final int priority;
    final int expiryTime;
    final int reportOptions;
    final int messageType;
    final byte[] messageIdentifier;
    final byte[] correlationIdentifier;
    static final int backoutQueuePutOptions = 8226;
    static final int deadLetterQueueOpenOptions = 8208;
    static final int deadLetterQueuePutOptions = 8226;
    static final int reportQueueOpenOptions = 8208;
    static final int reportQueuePutOptions = 8226;
    private static final int BASIC_RQGOPTIONS = 8195;
    final int requestQueueGetOptions;
    final int binding;
    final int mqTrace;
    final String channel;
    final String hostname;
    final int port;
    final String password;
    final String tentativeQueueManagerName;
    final String tentativeTargetQMName;
    final int characterSet;
    final int conversion;
    final String format;
    final String replyToQueueName;
    final int waitInterval;
    final String requestQueueName;
    final String reportQueueName;
    final String applicationGroupRFH;
    final String messageTypeRFH;
    private static final int POS_NEXT = 0;
    private static final int POS_LAST = 1;
    private static final int CH_EOF = -1;
    private static final int CH_ILLEGAL = -2;
    private static final int PS_KEY = 0;
    private static final int PS_VALUE = 1;
    private static final int PS_STRING = 0;
    private static final int PS_ANYSTRING = 1;
    private static final int PS_ESCAPE = 2;
    private static final int PS_SIMPLESTRING = 3;

    private static synchronized int nextNr() {
        return ++s_count;
    }

    private static Hashtable parseRemainder(String string) throws BusException {
        s_logger.flowEntry("parseRemainder(String)");
        char[] cArray = string.toCharArray();
        int[] nArray = new int[]{1, cArray.length};
        StringBuffer stringBuffer = new StringBuffer();
        Hashtable hashtable = new Hashtable();
        if (cArray.length == 0 || cArray[0] != '#') {
            stringBuffer.append("Expected '#' as first character");
        } else if (MQSProperties.parsePairSequence(cArray, nArray, stringBuffer, hashtable) && nArray[0] < nArray[1]) {
            stringBuffer.append("Unexpected characters (" + new String(cArray, nArray[0], nArray[1] - nArray[0]) + ") after 'pair sequence'");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.append(", while parsing 'remainder'. Parsing stopped at position " + (nArray[0] + 1) + ".");
            throw new BusException(stringBuffer.toString());
        }
        s_logger.flowExit("parseRemainder(String)");
        return hashtable;
    }

    private static boolean parsePairSequence(char[] cArray, int[] nArray, StringBuffer stringBuffer, Hashtable hashtable) {
        s_logger.flowEntry("parsePairSequence(char[],int[],StringBuffer,Hashtable)");
        while (true) {
            if (!MQSProperties.parsePair(cArray, nArray, stringBuffer, hashtable)) {
                stringBuffer.append(", while parsing 'pair sequence'");
                s_logger.flowExit("parsePairSequence(char[],int[],StringBuffer,Hashtable)1");
                return false;
            }
            if (nArray[0] >= nArray[1]) {
                s_logger.flowExit("parsePairSequence(char[],int[],StringBuffer,Hashtable)2");
                return true;
            }
            if (cArray[nArray[0]] != ',') {
                s_logger.flowExit("parsePairSequence(char[],int[],StringBuffer,Hashtable)3");
                return true;
            }
            nArray[0] = nArray[0] + 1;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static boolean parsePair(char[] var0, int[] var1_1, StringBuffer var2_2, Hashtable var3_3) {
        MQSProperties.s_logger.flowEntry("parsePair(char[],int[],StringBuffer,Hashtable)");
        var4_4 = 0;
        var5_5 = -2;
        var6_6 = null;
        var7_7 = MQSProperties.parseString(var0, var1_1, var2_2);
        if (var7_7 == null) {
            var2_2.append(", while parsing 'key'");
            MQSProperties.s_logger.flowExit("parsePair(char[],int[],StringBuffer,Hashtable)1");
            return false;
        }
        block4: while (true) {
            var5_5 = var1_1[0] >= var1_1[1] ? -1 : var0[var1_1[0]];
            var1_1[0] = var1_1[0] + 1;
            switch (var4_4) {
                case 0: {
                    if (MQSProperties.isWS(var5_5)) continue block4;
                    if (var5_5 == 61) {
                        var6_6 = MQSProperties.parseString(var0, var1_1, var2_2);
                        if (var6_6 == null) {
                            var2_2.append(", while parsing 'value'");
                            MQSProperties.s_logger.flowExit("parsePair(char[],int[],StringBuffer,Hashtable)2");
                            return false;
                        }
                        var4_4 = 1;
                        continue block4;
                    }
                    if (var3_3.put(var7_7, IMQSConstants.VOIDSTR) != null) {
                        var2_2.append("Key '" + var7_7 + "' defined more than once");
                        MQSProperties.s_logger.flowExit("parsePair(char[],int[],StringBuffer,Hashtable)3");
                        return false;
                    }
                    var1_1[0] = var1_1[0] - 1;
                    MQSProperties.s_logger.flowExit("parsePair(char[],int[],StringBuffer,Hashtable)4");
                    return true;
                }
                case 1: {
                    if (!MQSProperties.isWS(var5_5)) ** break;
                    continue block4;
                    if (var3_3.put(var7_7, var6_6) != null) {
                        var2_2.append("Key '" + var7_7 + "' defined more than once");
                        MQSProperties.s_logger.flowExit("parsePair(char[],int[],StringBuffer,Hashtable)5");
                        return false;
                    }
                    var1_1[0] = var1_1[0] - 1;
                    MQSProperties.s_logger.flowExit("parsePair(char[],int[],StringBuffer,Hashtable)6");
                    return true;
                }
            }
            break;
        }
        throw new RuntimeException("MQSProperties: unknown parsePair() state " + var4_4 + ".");
    }

    private static String parseString(char[] cArray, int[] nArray, StringBuffer stringBuffer) {
        s_logger.flowEntry("parseString()");
        int n = 0;
        int n2 = -2;
        StringBuffer stringBuffer2 = new StringBuffer();
        block6: while (true) {
            n2 = nArray[0] >= nArray[1] ? -1 : cArray[nArray[0]];
            nArray[0] = nArray[0] + 1;
            switch (n) {
                case 0: {
                    if (MQSProperties.isWS(n2)) continue block6;
                    if (n2 == 34) {
                        n = 1;
                        continue block6;
                    }
                    if (n2 == -1) {
                        stringBuffer.append("Unexpected end of text while parsing 'string'");
                        s_logger.flowExit("parseString()1");
                        return null;
                    }
                    if (n2 == 44 || n2 == 61) {
                        stringBuffer.append("Unexpected '" + (char)n2 + "' while parsing 'string'");
                        s_logger.flowExit("parseString()2");
                        return null;
                    }
                    n = 3;
                    stringBuffer2.append((char)n2);
                    continue block6;
                }
                case 1: {
                    if (n2 == 34) {
                        s_logger.flowExit("parseString()3");
                        return stringBuffer2.toString();
                    }
                    if (n2 == 92) {
                        n = 2;
                        continue block6;
                    }
                    if (n2 == -1) {
                        stringBuffer.append("Unexpected end of text while parsing 'any string'");
                        s_logger.flowExit("parseString()4");
                        return null;
                    }
                    stringBuffer2.append((char)n2);
                    continue block6;
                }
                case 2: {
                    if (n2 == 34) {
                        stringBuffer2.append('\"');
                        n = 1;
                        continue block6;
                    }
                    if (n2 == 92) {
                        stringBuffer2.append('\\');
                        n = 1;
                        continue block6;
                    }
                    stringBuffer.append("Unexpected character (" + MQSProperties.charToString(n2) + ") while parsing 'escape sequence'");
                    s_logger.flowExit("parseString()5");
                    return null;
                }
                case 3: {
                    if (MQSProperties.isWS(n2) || n2 == 61 || n2 == 44 || n2 == -1) {
                        nArray[0] = nArray[0] - 1;
                        s_logger.flowExit("parseString()5");
                        return stringBuffer2.toString();
                    }
                    stringBuffer2.append((char)n2);
                    continue block6;
                }
            }
            break;
        }
        throw new RuntimeException("MQSProperties: unknown parseString() state " + n + ".");
    }

    private static boolean isWS(int n) {
        s_logger.flowEntry("isWS(int)");
        if (n == 32 | n == 10 | n == 9 | n == 13) {
            s_logger.flowExit("isWS(int)1");
            return true;
        }
        s_logger.flowExit("isWS(int)2");
        return false;
    }

    private static String charToString(int n) {
        s_logger.flowEntry("charToString(int)");
        if (n < 0) {
            s_logger.flowExit("charToString(int)1");
            return String.valueOf(n);
        }
        s_logger.flowExit("charToString(int)2");
        return String.valueOf((char)n);
    }

    static MQSProperties getProperties(URI uRI) throws BusException {
        s_logger.flowEntry("getProperties(URI)");
        s_logger.message("getting properties for URI : " + uRI);
        MQSProperties mQSProperties = (MQSProperties)s_propsCache.get(uRI);
        if (mQSProperties == null) {
            mQSProperties = new MQSProperties(uRI);
            s_propsCache.put(uRI, mQSProperties);
        }
        s_logger.message("retrieved properties: " + mQSProperties);
        s_logger.flowExit("getProperties(URI)");
        return mQSProperties;
    }

    private MQSProperties(URI uRI) throws BusException {
        CharSequence charSequence;
        Object object;
        Object object2;
        s_logger.flowEntry("MQSProperties(URI)");
        s_logger.message("Creating new com.baan.tech.b3.mqs.MQSProperties(URI)" + this.nr + " from remainder '" + uRI.getRemainder() + "'");
        Hashtable hashtable = MQSProperties.parseRemainder(uRI.getRemainder());
        int n = 0;
        int[] nArray = new int[11];
        int n2 = 0;
        while (n2 < 11) {
            object2 = (String)hashtable.get(IKEYS[n2]);
            if (object2 == null) {
                nArray[n2] = IDEFS[n2];
            } else if (((String)object2).equals(IMQSConstants.VOIDSTR)) {
                nArray[n2] = IDEFS[n2];
                ++n;
            } else {
                try {
                    nArray[n2] = Integer.parseInt((String)object2);
                }
                catch (NumberFormatException numberFormatException) {
                    s_logger.message("NumberFormatException in MQSProperties(URI) constructor.");
                    s_logger.errorException(numberFormatException);
                    throw new BusException("For URI " + uRI + " value for key '" + IKEYS[n2] + "' should be an integer.");
                }
                ++n;
            }
            ++n2;
        }
        object2 = new String[11];
        int n3 = 0;
        while (n3 < 11) {
            object = (String)hashtable.get(SKEYS[n3]);
            if (object == null) {
                object2[n3] = SDEFS[n3];
            } else if (((String)object).equals(IMQSConstants.VOIDSTR)) {
                object2[n3] = SDEFS[n3];
                ++n;
            } else {
                object2[n3] = object;
                ++n;
            }
            ++n3;
        }
        object = new byte[2][];
        int n4 = 0;
        while (n4 < 2) {
            charSequence = (String)hashtable.get(BKEYS[n4]);
            if (charSequence == null) {
                object[n4] = BDEFS[n4];
            } else if (((String)charSequence).equals(IMQSConstants.VOIDSTR)) {
                object[n4] = BDEFS[n4];
                ++n;
            } else {
                object[n4] = ((String)charSequence).getBytes();
                ++n;
            }
            ++n4;
        }
        if (hashtable.size() > n) {
            charSequence = new StringBuffer("In URI " + uRI + " the following keywords " + "are not recognised: ");
            Enumeration enumeration2 = hashtable.keys();
            block5: while (enumeration2.hasMoreElements()) {
                String string = (String)enumeration2.nextElement();
                int n5 = 0;
                while (n5 < 11) {
                    if (string.equals(IKEYS[n5])) continue block5;
                    ++n5;
                }
                int n6 = 0;
                while (n6 < 11) {
                    if (string.equals(SKEYS[n6])) continue block5;
                    ++n6;
                }
                int n7 = 0;
                while (n7 < 2) {
                    if (string.equals(BKEYS[n7])) continue block5;
                    ++n7;
                }
                ((StringBuffer)charSequence).append("'" + string + "',");
            }
            ((StringBuffer)charSequence).setLength(((StringBuffer)charSequence).length() - 1);
            ((StringBuffer)charSequence).append(" .");
            throw new BusException(((StringBuffer)charSequence).toString());
        }
        this.mqTrace = nArray[0];
        this.binding = nArray[1];
        this.port = nArray[2];
        this.characterSet = nArray[3];
        this.conversion = nArray[4] == 0 ? 0 : 16384;
        this.requestQueueGetOptions = 8195 + this.conversion;
        this.waitInterval = nArray[5];
        this.persistence = nArray[6];
        this.priority = nArray[7];
        this.expiryTime = nArray[8];
        this.reportOptions = nArray[9];
        this.messageType = nArray[10];
        this.channel = object2[0];
        this.hostname = object2[1];
        this.password = object2[2];
        this.tentativeQueueManagerName = object2[3];
        this.tentativeTargetQMName = ((String)object2[4]).equals("*") ? IMQSConstants.VOIDSTR : (((String)object2[4]).equals(IMQSConstants.VOIDSTR) ? this.tentativeQueueManagerName : object2[4]);
        this.format = object2[5];
        this.requestQueueName = object2[6];
        this.replyToQueueName = this.requestQueueName;
        this.targetQueueName = ((String)object2[7]).equals(IMQSConstants.VOIDSTR) ? this.requestQueueName : object2[7];
        this.reportQueueName = object2[8];
        this.applicationGroupRFH = object2[9];
        this.messageTypeRFH = object2[10];
        this.messageIdentifier = (byte[])object[0];
        this.correlationIdentifier = (byte[])object[1];
        s_logger.message("Created new com.baan.tech.b3.mqs.MQSProperties" + this.nr + "(URI):\n" + "targetQueueName=" + this.targetQueueName + " \n" + "persistence=" + this.persistence + " \n" + "priority=" + this.priority + " \n" + "expiryTime=" + this.expiryTime + " \n" + "reportOptions=" + this.reportOptions + " \n" + "messageType=" + this.messageType + " \n" + "messageIdentifier=" + this.messageIdentifier + " \n" + "correlationIdentifier=" + this.correlationIdentifier + " \n" + "requestQueueGetOptions=" + this.requestQueueGetOptions + " \n" + "binding=" + this.binding + " \n" + "mqTrace=" + this.mqTrace + " \n" + "channel=" + this.channel + " \n" + "hostname=" + this.hostname + " \n" + "port=" + this.port + " \n" + "password=" + this.password + " \n" + "tentativeQueueManagerName=" + this.tentativeQueueManagerName + " \n" + "tentativeTargetQMName=" + this.tentativeTargetQMName + " \n" + "characterSet=" + this.characterSet + " \n" + "conversion=" + this.conversion + " \n" + "format=" + this.format + " \n" + "replyToQueueName=" + this.replyToQueueName + " \n" + "waitInterval=" + this.waitInterval + " \n" + "requestQueueName=" + this.requestQueueName + " \n" + "reportQueueName=" + this.reportQueueName + " \n" + "applicationGroupRFH=" + this.applicationGroupRFH + " \n" + "messageTypeRFH=" + this.messageTypeRFH + " \n");
        s_logger.flowExit("MQSProperties(URI)");
    }

    private MQSProperties(MQSProperties mQSProperties, String string) {
        s_logger.flowEntry("MQSProperties(MQSProperties,String)");
        this.mqTrace = mQSProperties.mqTrace;
        this.binding = mQSProperties.binding;
        this.port = mQSProperties.port;
        this.characterSet = mQSProperties.characterSet;
        this.conversion = mQSProperties.conversion;
        this.requestQueueGetOptions = mQSProperties.requestQueueGetOptions;
        this.waitInterval = mQSProperties.waitInterval;
        this.persistence = mQSProperties.persistence;
        this.priority = mQSProperties.priority;
        this.expiryTime = mQSProperties.expiryTime;
        this.reportOptions = mQSProperties.reportOptions;
        this.messageType = mQSProperties.messageType;
        this.channel = mQSProperties.channel;
        this.hostname = mQSProperties.hostname;
        this.password = mQSProperties.password;
        this.tentativeQueueManagerName = mQSProperties.tentativeQueueManagerName;
        this.tentativeTargetQMName = mQSProperties.tentativeTargetQMName;
        this.format = mQSProperties.format;
        this.replyToQueueName = this.requestQueueName = string;
        this.targetQueueName = mQSProperties.targetQueueName.equals(mQSProperties.requestQueueName) ? this.requestQueueName : mQSProperties.targetQueueName;
        this.reportQueueName = mQSProperties.reportQueueName;
        this.applicationGroupRFH = mQSProperties.applicationGroupRFH;
        this.messageTypeRFH = mQSProperties.messageTypeRFH;
        this.messageIdentifier = mQSProperties.messageIdentifier;
        this.correlationIdentifier = mQSProperties.correlationIdentifier;
        s_logger.flowExit("MQSProperties(MQSProperties,String)");
    }

    URI deriveURI(String string) throws BusException {
        s_logger.flowEntry("deriveURI(String)");
        MQSProperties mQSProperties = new MQSProperties(this, string);
        URI uRI = URI.createURI(mQSProperties.toURIString());
        s_propsCache.put(uRI, mQSProperties);
        s_logger.flowExit("deriveURI(String)");
        return uRI;
    }

    private String toURIString() {
        s_logger.flowEntry("toURIString()");
        int[] nArray = new int[]{this.mqTrace, this.binding, this.port, this.characterSet, this.conversion, this.waitInterval, this.persistence, this.priority, this.expiryTime, this.reportOptions, this.messageType};
        String[] stringArray = new String[]{this.channel, this.hostname, this.password, this.tentativeQueueManagerName, this.tentativeTargetQMName.equals(IMQSConstants.VOIDSTR) ? "*" : (this.tentativeTargetQMName.equals(this.tentativeQueueManagerName) ? IMQSConstants.VOIDSTR : this.tentativeTargetQMName), this.format, this.requestQueueName, this.targetQueueName.equals(this.requestQueueName) ? IMQSConstants.VOIDSTR : this.targetQueueName, this.reportQueueName, this.applicationGroupRFH, this.messageTypeRFH};
        byte[][] byArrayArray = new byte[][]{this.messageIdentifier, this.correlationIdentifier};
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n = 0;
        while (n < 11) {
            if (nArray[n] != IDEFS[n]) {
                hashtable.put(IKEYS[n], String.valueOf(nArray[n]));
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < 11) {
            if (!stringArray[n2].equals(SDEFS[n2])) {
                hashtable.put(SKEYS[n2], stringArray[n2]);
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < 2) {
            boolean bl;
            if (byArrayArray[n3].length == BDEFS[n3].length) {
                bl = true;
                int n4 = 0;
                while (n4 < byArrayArray[n3].length) {
                    if (byArrayArray[n3][n4] != BDEFS[n3][n4]) {
                        bl = false;
                    }
                    ++n4;
                }
            } else {
                bl = false;
            }
            if (!bl) {
                hashtable.put(BKEYS[n3], new String(byArrayArray[n3]));
            }
            ++n3;
        }
        StringBuffer stringBuffer = new StringBuffer("MQSeries://v1/#");
        Enumeration enumeration2 = hashtable.keys();
        while (enumeration2.hasMoreElements()) {
            String string = (String)enumeration2.nextElement();
            String string2 = (String)hashtable.get(string);
            string = MQSProperties.garbleIfNeeded(string);
            string2 = MQSProperties.garbleIfNeeded(string2);
            stringBuffer.append(string + "=" + string2 + ",");
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        s_logger.flowExit("toURIString()");
        return stringBuffer.toString();
    }

    private static String garbleIfNeeded(String string) {
        s_logger.flowEntry("garbleIfNeeded(String)");
        if (string.indexOf(32) + string.indexOf(61) + string.indexOf(44) != -3) {
            StringBuffer stringBuffer = new StringBuffer("\"");
            char[] cArray = string.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (cArray[n2] == '\\' || cArray[n2] == '\"') {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(cArray[n2]);
                ++n2;
            }
            stringBuffer.append('\"');
            s_logger.flowExit("garbleIfNeeded(String)1");
            return stringBuffer.toString();
        }
        s_logger.flowExit("garbleIfNeeded(String)2");
        return string;
    }

    private static String getProperty(Hashtable hashtable, String string, String string2) {
        s_logger.flowEntry("getProperty(Hashtable,String,String)");
        String string3 = (String)hashtable.get(string);
        if (string3 == null || string3.equals(IMQSConstants.VOIDSTR)) {
            s_logger.flowExit("getProperty(Hashtable,String,String)1");
            return string2;
        }
        s_logger.flowExit("getProperty(Hashtable,String,String)2");
        return string3;
    }

    private static int getProperty(Hashtable hashtable, String string, int n) {
        s_logger.flowEntry("getProperty(Hashtable,String,int)");
        String string2 = (String)hashtable.get(string);
        if (string2 == null || string2.equals(IMQSConstants.VOIDSTR)) {
            s_logger.flowExit("getProperty(Hashtable,String,int)1");
            return n;
        }
        s_logger.flowExit("getProperty(Hashtable,String,int)2");
        return Integer.parseInt(string2);
    }

    private static byte[] getProperty(Hashtable hashtable, String string, byte[] byArray) {
        s_logger.flowEntry("getProperty(Hashtable,String,byte[])");
        String string2 = (String)hashtable.get(string);
        if (string2 == null || string2.equals(IMQSConstants.VOIDSTR)) {
            s_logger.flowExit("getProperty(Hashtable,String,byte[])1");
            return byArray;
        }
        s_logger.flowExit("getProperty(Hashtable,String,byte[])2");
        return string2.getBytes();
    }
}

