/*
 * Decompiled with CFR 0.152.
 */
package com.baan.tech.b3.mqs;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.baan.tech.b3.mqs.IMQSConstants;
import com.baan.tech.b3.mqs.MQSDestination;
import com.baan.tech.b3.mqs.MQSTransport;
import com.baan.tech.b3.mqs.MessageReader;
import com.eibus.connection.BusListener;
import com.eibus.connection.IConnection;
import com.eibus.connection.Message;
import com.eibus.exception.BusException;
import com.eibus.services.directory.BusComponent;
import com.eibus.services.directory.ConnectionPoint;
import com.eibus.services.directory.URI;
import java.util.Enumeration;

public class MQSIConnection
implements IConnection,
IMQSConstants {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.tech.b3.mqs", "MQSIConnection");
    private static final int INITIAL = 0;
    private static final int NO_ID = 1;
    private static final int PRIMED = 2;
    private static final int CLOSED_NO_LISTENER = 3;
    private static final int OPEN_NO_LISTENER = 4;
    private static final int RUNNING = 5;
    private static final int INITIALIZE = 0;
    private static final int INSTALL = 1;
    private static final int OPEN = 2;
    private static final int CLOSE = 3;
    private static final String[] STATE_STRINGS = new String[]{"initial", "noID", "primed", "closedNoListener", "openNoListener", "running"};
    private static int s_count = 0;
    private int nr = MQSIConnection.next();
    private int state = 0;
    private BusListener listener = null;
    private MessageReader messageReader = null;
    private MQSTransport transport = null;

    public MQSIConnection() {
        s_logger.flowEntry("MQSIConnection()");
        s_logger.flowExit("MQSIConnection()");
    }

    public boolean isURIVariable(URI uRI) {
        String string = uRI.toString();
        string = string.toLowerCase();
        int n = string.indexOf("model");
        int n2 = string.indexOf("template");
        return n > 0 || n2 > 0;
    }

    private static ConnectionPoint extractMQSCPoint(BusComponent busComponent) throws BusException {
        s_logger.flowEntry("extractMQSCPoint(BusComponent)");
        ConnectionPoint connectionPoint = busComponent.getPreferredConnection();
        Enumeration enumeration2 = busComponent.getConnectionPoints();
        while (true) {
            URI uRI;
            if (connectionPoint != null && (uRI = connectionPoint.getURI()).getProtocol().equals("MQSeries") && uRI.getHost().equals("v1")) {
                s_logger.flowExit("extractMQSCPoint(BusComponent)");
                s_logger.message("extractMQSCPoint returns: " + connectionPoint);
                return connectionPoint;
            }
            if (!enumeration2.hasMoreElements()) break;
            connectionPoint = (ConnectionPoint)enumeration2.nextElement();
        }
        s_logger.flowExit("extractMQSCPoint(BusComponent)");
        s_logger.message("extractMQSCPoint returns: null");
        return null;
    }

    public void initialize(BusComponent busComponent) throws BusException {
        s_logger.flowEntry("initialize(BusComponent)");
        s_logger.message("current MQSIConnection: " + this);
        if (busComponent == null) {
            throw new BusException("Null argument not allowed for initialize().");
        }
        ConnectionPoint connectionPoint = MQSIConnection.extractMQSCPoint(busComponent);
        if (connectionPoint == null) {
            throw new BusException(this + " ... could not be initialized using " + busComponent + ". No appropriate ConnectionPoints found.");
        }
        this.initialize(connectionPoint);
        s_logger.flowExit("initialize(BusComponent)");
    }

    public void initialize(ConnectionPoint connectionPoint) throws BusException {
        s_logger.flowEntry("initialize(ConnectionPoint)");
        s_logger.message("current MQSIConnection: " + this);
        if (connectionPoint == null) {
            throw new BusException("Null argument not allowed for initialize().");
        }
        if (this.state != 0 && this.state != 1) {
            throw new BusException(this + " ... already initialized.");
        }
        this.transport = new MQSTransport(connectionPoint);
        this.messageReader = new MessageReader(this.transport);
        this.changeState(0);
        s_logger.flowExit("initialize(ConnectionPoint)");
    }

    public synchronized void installBusListener(BusListener busListener) throws BusException {
        s_logger.flowEntry("installBusListener(BusListener)");
        s_logger.message("current MQSIConnection: " + this);
        if (busListener == null) {
            throw new BusException("Null argument not allowed for installBusListener().");
        }
        this.listener = busListener;
        this.changeState(1);
        s_logger.message(busListener + " installed on " + this + ".");
        s_logger.flowExit("installBusListener(BusListener)");
    }

    public void open() throws BusException {
        s_logger.flowEntry("open()");
        s_logger.message("current MQSIConnection: " + this);
        this.changeState(2);
        s_logger.flowExit("open()");
    }

    public void close() throws BusException {
        s_logger.flowEntry("close()");
        s_logger.message("current MQSIConnection: " + this);
        this.changeState(3);
        s_logger.flowExit("close()");
    }

    public synchronized void send(Message message) throws BusException {
        Object object;
        s_logger.flowEntry("send(Message)");
        s_logger.message("current MQSIConnection: " + this);
        if (this.state != 5 && this.state != 4) {
            throw new BusException(this + " ... is not open; cannot send().");
        }
        URI uRI = message.getURI();
        if (uRI == null && (object = message.getReceiver()) != null) {
            uRI = MQSIConnection.extractMQSCPoint((BusComponent)object).getURI();
        }
        if (uRI == null) {
            throw new BusException("Cannot send message " + message + " through " + this + ". No valid receiver specified.");
        }
        object = this.transport.getDestination(uRI);
        ((MQSDestination)object).send(message);
        s_logger.message("Sent message " + message + " through " + this + ".");
        s_logger.flowExit("send(Message)");
    }

    public String toString() {
        return "MQSIConnection" + this.nr + "(in state: " + STATE_STRINGS[this.state] + ")";
    }

    private static synchronized int next() {
        return s_count++;
    }

    private synchronized void changeState(int n) throws BusException {
        s_logger.flowEntry("changeState(int)");
        s_logger.message("processing event of type " + n + " on " + this + "...");
        block0 : switch (n) {
            case 0: {
                switch (this.state) {
                    case 0: {
                        this.state = 3;
                        break block0;
                    }
                    case 1: {
                        this.passListener();
                        this.state = 2;
                        break block0;
                    }
                }
                throw new BusException(this + " ... has already been initialize()d; initialize() not possible.");
            }
            case 1: {
                switch (this.state) {
                    case 0: {
                        this.state = 1;
                        break;
                    }
                    case 3: {
                        this.state = 2;
                        break;
                    }
                    case 4: {
                        this.resumeReader();
                        this.state = 5;
                        break;
                    }
                }
                this.passListener();
                break;
            }
            case 2: {
                switch (this.state) {
                    case 2: {
                        this.resumeReader();
                        this.state = 5;
                        break block0;
                    }
                    case 3: {
                        this.state = 4;
                        break block0;
                    }
                }
                throw new BusException(this + " ... has not been initialized or is already open; open() not possible.");
            }
            case 3: {
                switch (this.state) {
                    case 5: {
                        this.suspendReader();
                        this.state = 2;
                        break block0;
                    }
                    case 4: {
                        this.state = 3;
                        break block0;
                    }
                }
                throw new BusException(this + " ... has not been opened; close() not possible.");
            }
            default: {
                throw new RuntimeException(this + " ... Unknown state change event: " + n);
            }
        }
        s_logger.flowExit("changeState(int)");
    }

    private void passListener() {
        s_logger.flowEntry("passListener()");
        s_logger.message("current MQSIConnection is: " + this);
        if (this.messageReader != null) {
            this.messageReader.setBusListener(this.listener);
            this.listener = null;
        }
        s_logger.flowExit("passListener()");
    }

    private void resumeReader() throws BusException {
        s_logger.flowEntry("resumeReader()");
        s_logger.message("current MQSIConnection is: " + this);
        this.messageReader.start();
        s_logger.flowExit("resumeReader()");
    }

    private void suspendReader() throws BusException {
        s_logger.flowEntry("suspendReader()");
        s_logger.message("current MQSIConnection is: " + this);
        this.messageReader.stop();
        s_logger.flowExit("suspendReader()");
    }
}

