/*
 * Decompiled with CFR 0.152.
 */
package com.baan.tech.b3.mqs;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.baan.tech.b3.mqs.IMQSConstants;
import com.baan.tech.b3.mqs.MQSProperties;
import com.baan.tech.b3.mqs.MQSTransport;
import com.eibus.connection.Message;
import com.eibus.exception.BusException;
import com.eibus.services.directory.URI;
import com.ibm.mq.MQException;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import java.io.IOException;

public class MQSDestination
implements IMQSConstants {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.tech.b3.mqs", "MQSDestination");
    private final MQSTransport transport;
    private final MQSProperties props;
    private final String targetQueueManagerName;
    private MQQueue targetQueue;

    public MQSDestination(MQSTransport mQSTransport, URI uRI) throws BusException, MQException {
        s_logger.flowEntry("MQSDestination(MQSTransport,URI)");
        this.transport = mQSTransport;
        this.props = MQSProperties.getProperties(uRI);
        this.targetQueueManagerName = this.props.tentativeTargetQMName;
        s_logger.message("-> mQQueueManager.accessQueue()...");
        this.targetQueue = this.transport.getOutputQueueManager().accessQueue(this.props.targetQueueName, 8208, this.targetQueueManagerName, "", "");
        s_logger.message("<- mQQueueManager.accessQueue().");
        s_logger.flowExit("MQSDestination(MQSTransport,URI)");
    }

    void close() throws MQException {
        s_logger.flowEntry("close()");
        MQQueueManager mQQueueManager = this.transport.getOutputQueueManager();
        if (mQQueueManager != null && this.targetQueue != null) {
            s_logger.message("-> mQQueue.close()...");
            this.targetQueue.close();
            s_logger.message("<- mQQueue.close().");
            this.targetQueue = null;
        }
        s_logger.flowExit("close()");
    }

    public void finalize() {
        s_logger.flowEntry("finalize()");
        try {
            this.close();
            super.finalize();
        }
        catch (MQException mQException) {
            s_logger.message(this.transport.getQueueManagerName() + "  threw an exception closing " + this.props.targetQueueName + " with reason code " + mQException.reasonCode);
            s_logger.errorException(mQException);
        }
        catch (Throwable throwable) {
            s_logger.message(this.transport.getQueueManagerName() + "  threw an exception " + throwable + " in the super class closing " + this.props.targetQueueName);
            s_logger.errorException(throwable);
        }
        s_logger.flowExit("finalize()");
    }

    public void send(Message message) throws BusException {
        block6: {
            s_logger.flowEntry("send(Message)");
            s_logger.message("*> Creating new com.ibm.mq.MQMessage...");
            MQMessage mQMessage = new MQMessage();
            s_logger.message("<* Created new com.ibm.mq.MQMessage.");
            mQMessage.correlationId = this.props.correlationIdentifier;
            mQMessage.messageId = this.props.messageIdentifier;
            mQMessage.expiry = this.props.expiryTime;
            mQMessage.format = this.transport.props.format;
            mQMessage.report = this.props.reportOptions;
            mQMessage.messageType = this.props.messageType;
            mQMessage.persistence = this.props.persistence;
            mQMessage.priority = this.props.priority;
            mQMessage.characterSet = this.transport.props.characterSet;
            mQMessage.replyToQueueManagerName = this.transport.getReplyToQueueManagerName();
            mQMessage.replyToQueueName = this.transport.props.replyToQueueName;
            try {
                this.transport.writeRFH(mQMessage);
                s_logger.message("-> mQMessage.write(byte[])...");
                mQMessage.write(message.getText());
                s_logger.message("<- mQMessage.write(byte[]).");
            }
            catch (IOException iOException) {
                s_logger.message("IOException thrown in mQSDestination.send().");
                s_logger.errorException(iOException);
                throw new BusException(iOException);
            }
            s_logger.message("*> Creating new com.ibm.mq.MQPutMessageOptions...");
            MQPutMessageOptions mQPutMessageOptions = new MQPutMessageOptions();
            s_logger.message("<* Created new com.ibm.mq.MQPutMessageOptions.");
            mQPutMessageOptions.options = 8226;
            try {
                s_logger.message("-> mQQueue.put()...");
                this.targetQueue.put(mQMessage, mQPutMessageOptions);
                s_logger.message("<- mQQueue.put().");
            }
            catch (MQException mQException) {
                s_logger.message("MQException thrown in mQSDestination.send(): put");
                s_logger.errorException(mQException);
                if (mQException.completionCode == 1) break block6;
                throw new BusException((Exception)((Object)mQException));
            }
        }
        try {
            s_logger.message("-> mQQueueManager.commit()...");
            this.transport.getOutputQueueManager().commit();
            s_logger.message("<- mQQueueManager.commit().");
        }
        catch (MQException mQException) {
            s_logger.message("MQException thrown in mQSDestination.send(): commit");
            s_logger.errorException(mQException);
            throw new BusException((Exception)((Object)mQException));
        }
        s_logger.flowExit("send(Message)");
    }
}

