/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owtools.ccf.ui.tree;

import com.baan.owtools.ccf.ui.tree.ConfigurationTreeNode;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeUtils {
    private TreeUtils() {
    }

    public static void insertNode(JTree jTree, MutableTreeNode mutableTreeNode, MutableTreeNode mutableTreeNode2) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)jTree.getModel();
        int n = 0;
        int n2 = mutableTreeNode.getChildCount() - 1;
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            TreeNode treeNode = mutableTreeNode.getChildAt(n3);
            if (TreeUtils.compareNodes(mutableTreeNode2, treeNode) < 0) {
                n2 = n3 - 1;
                continue;
            }
            n = n3 + 1;
        }
        defaultTreeModel.insertNodeInto(mutableTreeNode2, mutableTreeNode, n);
    }

    private static int compareNodes(TreeNode treeNode, TreeNode treeNode2) {
        int n;
        int n2 = ((ConfigurationTreeNode)treeNode).getType();
        if (n2 == (n = ((ConfigurationTreeNode)treeNode2).getType())) {
            return treeNode.toString().compareToIgnoreCase(treeNode2.toString());
        }
        return n - n2;
    }

    public static void selectNode(JTree jTree, TreeNode treeNode) {
        TreePath treePath = TreeUtils.getPath(treeNode);
        jTree.setSelectionPath(treePath);
        jTree.scrollPathToVisible(treePath);
    }

    public static TreePath getPath(TreeNode treeNode) {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        while (treeNode != null) {
            arrayList.add(treeNode);
            treeNode = treeNode.getParent();
        }
        Collections.reverse(arrayList);
        return new TreePath(arrayList.toArray());
    }

    public static TreeNode findChild(TreeNode treeNode, String string) {
        int n = 0;
        while (n < treeNode.getChildCount()) {
            TreeNode treeNode2 = treeNode.getChildAt(n);
            if (treeNode2.toString().equalsIgnoreCase(string)) {
                return treeNode2;
            }
            ++n;
        }
        return null;
    }

    public static void selectNode(JTree jTree, String[] stringArray) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)jTree.getModel();
        TreeNode treeNode = (TreeNode)defaultTreeModel.getRoot();
        int n = 1;
        while (n < stringArray.length) {
            if ((treeNode = TreeUtils.findChild(treeNode, stringArray[n])) == null) {
                return;
            }
            ++n;
        }
        TreeUtils.selectNode(jTree, treeNode);
    }

    public static ConfigurationTreeNode getNodeFromMouseEvent(JTree jTree, MouseEvent mouseEvent) {
        Object object;
        int n;
        int n2 = mouseEvent.getX();
        TreePath treePath = jTree.getPathForLocation(n2, n = mouseEvent.getY());
        if (treePath != null && (object = treePath.getLastPathComponent()) instanceof ConfigurationTreeNode) {
            return (ConfigurationTreeNode)object;
        }
        return null;
    }

    public static void makeVisible(JTree jTree, TreeNode treeNode) {
        TreePath treePath = TreeUtils.getPath(treeNode);
        jTree.scrollPathToVisible(treePath);
    }
}

