/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owtools.ccf.ui.tree;

import com.baan.owimpl.fw.ccf.AdapterClientContext;
import com.baan.owimpl.fw.ccf.BusComponentCategoryContext;
import com.baan.owimpl.fw.ccf.BusComponentContext;
import com.baan.owimpl.fw.ccf.ConfigurationContext;
import com.baan.owimpl.fw.ccf.IdentifierContext;
import com.baan.owimpl.fw.ccf.LoggingContext;
import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.baan.owimpl.fw.ccf.SOAPConnectorContext;
import com.baan.owimpl.fw.ccf.SmartContext;
import com.baan.owimpl.fw.ccf.XMLConnectorContext;
import com.baan.owtools.ccf.ui.tree.ConfigurationTreeNode;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class ConfigurationTreeModel
extends DefaultTreeModel {
    public ConfigurationTreeModel() {
        super(new DefaultMutableTreeNode("Configurations"));
        this.addConfigurationTypes();
    }

    private void addConfigurationTypes() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getRoot();
        try {
            ConfigurationContext[] configurationContextArray = new ConfigurationContext[]{BusComponentCategoryContext.getInstance(), BusComponentContext.getInstance(), LoggingContext.getInstance(), AdapterClientContext.getInstance(), XMLConnectorContext.getInstance(), SOAPConnectorContext.getInstance()};
            int n = 0;
            while (n < configurationContextArray.length) {
                ConfigurationContext configurationContext = configurationContextArray[n];
                Class clazz = configurationContext.getConfigurationClass();
                ConfigurationTreeNode configurationTreeNode = new ConfigurationTreeNode(configurationContext.toString(), configurationContext, 1);
                defaultMutableTreeNode.add(configurationTreeNode);
                if (configurationContext instanceof IdentifierContext) {
                    this.addIdentifier(configurationTreeNode);
                } else {
                    this.addSmart(configurationTreeNode);
                }
                ++n;
            }
        }
        catch (OWConfigurationException oWConfigurationException) {
            JOptionPane.showMessageDialog(null, oWConfigurationException.toString(), "Error", 0);
        }
    }

    private void addIdentifier(ConfigurationTreeNode configurationTreeNode) throws OWConfigurationException {
        IdentifierContext identifierContext = (IdentifierContext)configurationTreeNode.getDirectory();
        String[] stringArray = identifierContext.list();
        int n = 0;
        while (n < stringArray.length) {
            ConfigurationTreeNode configurationTreeNode2 = new ConfigurationTreeNode(stringArray[n], identifierContext, 12);
            configurationTreeNode.add(configurationTreeNode2);
            ++n;
        }
    }

    private void addSmart(ConfigurationTreeNode configurationTreeNode) throws OWConfigurationException {
        SmartContext smartContext = (SmartContext)configurationTreeNode.getDirectory();
        this.addApplications(smartContext, configurationTreeNode, null, null);
        this.addUsers(smartContext, configurationTreeNode, null);
        this.addMachines(smartContext, configurationTreeNode);
    }

    private void addApplications(SmartContext smartContext, ConfigurationTreeNode configurationTreeNode, String string, String string2) throws OWConfigurationException {
        String[] stringArray = smartContext.listApplications(string, string2);
        int n = 0;
        while (n < stringArray.length) {
            String string3 = stringArray[n];
            if (!string3.equals("_default_")) {
                ConfigurationTreeNode configurationTreeNode2 = new ConfigurationTreeNode(string3, smartContext, 23);
                configurationTreeNode.add(configurationTreeNode2);
            }
            ++n;
        }
    }

    private void addUsers(SmartContext smartContext, ConfigurationTreeNode configurationTreeNode, String string) throws OWConfigurationException {
        String[] stringArray = smartContext.listUsers(string);
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            if (!string2.equals("_default_")) {
                ConfigurationTreeNode configurationTreeNode2 = new ConfigurationTreeNode(string2, smartContext, 22);
                configurationTreeNode.add(configurationTreeNode2);
                this.addApplications(smartContext, configurationTreeNode2, string, string2);
            }
            ++n;
        }
    }

    private void addMachines(SmartContext smartContext, ConfigurationTreeNode configurationTreeNode) throws OWConfigurationException {
        String[] stringArray = smartContext.listMachines();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (!string.equals("_default_")) {
                ConfigurationTreeNode configurationTreeNode2 = new ConfigurationTreeNode(string, smartContext, 21);
                configurationTreeNode.add(configurationTreeNode2);
                this.addApplications(smartContext, configurationTreeNode2, string, null);
                this.addUsers(smartContext, configurationTreeNode2, string);
            }
            ++n;
        }
    }

    private void showAll(ConfigurationTreeNode configurationTreeNode, boolean bl) throws OWConfigurationException {
        SmartContext smartContext = (SmartContext)configurationTreeNode.getDirectory();
        String[] stringArray = smartContext.listMachines();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            ConfigurationTreeNode configurationTreeNode2 = null;
            if (string.equals("_default_") && !bl) {
                configurationTreeNode2 = configurationTreeNode;
            } else {
                configurationTreeNode2 = new ConfigurationTreeNode(string, smartContext, 21);
                configurationTreeNode.add(configurationTreeNode2);
            }
            String[] stringArray2 = smartContext.listUsers(string);
            int n2 = 0;
            while (n2 < stringArray2.length) {
                String string2 = stringArray2[n2];
                ConfigurationTreeNode configurationTreeNode3 = null;
                if (string2.equals("_default_") && !bl) {
                    configurationTreeNode3 = configurationTreeNode2;
                } else {
                    configurationTreeNode3 = new ConfigurationTreeNode(string2, smartContext, 22);
                    configurationTreeNode2.add(configurationTreeNode3);
                }
                String[] stringArray3 = smartContext.listApplications(string, string2);
                int n3 = 0;
                while (n3 < stringArray3.length) {
                    String string3 = stringArray3[n3];
                    ConfigurationTreeNode configurationTreeNode4 = null;
                    if (string3.equals("_default_") && !bl) {
                        configurationTreeNode4 = configurationTreeNode3;
                    } else {
                        configurationTreeNode4 = new ConfigurationTreeNode(string3, smartContext, 23);
                        configurationTreeNode3.add(configurationTreeNode4);
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }
}

