/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owtools.ccf.ui.grid;

import com.baan.owimpl.fw.ccf.BusComponentContext;
import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.baan.owimpl.fw.ccf.dt.SoapSite;
import com.jidesoft.combobox.AbstractComboBox;
import com.jidesoft.combobox.PopupPanel;
import com.jidesoft.grid.ContextSensitiveCellEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;

public class SitesCellEditor
extends ContextSensitiveCellEditor
implements TableCellEditor,
ItemListener {
    private SitesComboBox _comboBox = new SitesComboBox();
    static /* synthetic */ Class array$Lcom$baan$owimpl$fw$ccf$dt$SoapSite;

    public SitesCellEditor() {
        ((JComponent)((Object)this._comboBox)).setBorder(BorderFactory.createEmptyBorder());
    }

    public Object getCellEditorValue() {
        return this._comboBox.getSelectedItem();
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this._comboBox.setSelectedItem(object);
        this._comboBox.setForeground(jTable.getForeground());
        this._comboBox.setBackground(jTable.getBackground());
        this._comboBox.setFont(jTable.getFont());
        this._comboBox.setConverterContext(this.getConverterContext());
        this._comboBox.addItemListener(this);
        return this._comboBox;
    }

    public boolean stopCellEditing() {
        this._comboBox.setPopupVisible(false);
        return super.stopCellEditing();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this._comboBox.removeItemListener(this);
            this.stopCellEditing();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SitesPopupPanel
    extends PopupPanel
    implements ActionListener,
    ListSelectionListener {
        private static final String BASE_SITE_NAME = "NewSite";
        private static final String SELECT_BUSCOMPONENT = "<Select BusComponent>";
        JLabel jLabelSites = new JLabel("Sites:");
        DefaultListModel model = new DefaultListModel();
        JList jListSites = new JList(this.model);
        JScrollPane listScrollPane = new JScrollPane(this.jListSites);
        JButton jButtonAdd = new JButton("Add");
        JButton jButtonRemove = new JButton("Remove");
        JPanel jPanelDetails = new JPanel();
        JLabel jLabelSite = new JLabel("Site:");
        JLabel jLabelBusComponent = new JLabel("Bus Component:");
        JLabel jLabelUsername = new JLabel("User Name:");
        JLabel jLabelPassword = new JLabel("Password:");
        JTextField jFieldSite = new JTextField();
        JComboBox jComboBusComponent = new JComboBox();
        JTextField jFieldUsername = new JTextField();
        JPasswordField jFieldPassword = new JPasswordField();
        JButton jButtonUpdate = new JButton("Update");

        public SitesPopupPanel() {
            this.setTitle("Modify List of Sites");
            ((Container)((Object)this)).setLayout(null);
            ((JComponent)((Object)this)).setMinimumSize(new Dimension(360, 380));
            this.setPreferredSize(new Dimension(360, 380));
            ((Component)((Object)this)).setSize(360, 380);
            this.jLabelSites.setBounds(10, 10, 100, 20);
            ((Container)((Object)this)).add(this.jLabelSites);
            this.jListSites.setSelectionMode(0);
            this.jListSites.addListSelectionListener(this);
            this.listScrollPane.setBounds(10, 30, 200, 180);
            ((Container)((Object)this)).add(this.listScrollPane);
            this.jButtonAdd.setBounds(220, 30, 70, 24);
            this.jButtonAdd.addActionListener(this);
            ((Container)((Object)this)).add(this.jButtonAdd);
            this.jButtonRemove.setBounds(220, 60, 70, 24);
            this.jButtonRemove.addActionListener(this);
            ((Container)((Object)this)).add(this.jButtonRemove);
            this.jPanelDetails.setLayout(null);
            this.jPanelDetails.setBounds(10, 220, 350, 150);
            this.jPanelDetails.setBorder(BorderFactory.createTitledBorder("Site Details"));
            ((Container)((Object)this)).add(this.jPanelDetails);
            this.jLabelSite.setBounds(10, 15, 120, 20);
            this.jPanelDetails.add(this.jLabelSite);
            this.jFieldSite.setBounds(140, 15, 200, 20);
            this.jPanelDetails.add(this.jFieldSite);
            this.jLabelBusComponent.setBounds(10, 40, 120, 20);
            this.jPanelDetails.add(this.jLabelBusComponent);
            this.jComboBusComponent.setBounds(140, 40, 200, 20);
            this.jComboBusComponent.setEditable(false);
            this.jPanelDetails.add(this.jComboBusComponent);
            this.jLabelUsername.setBounds(10, 65, 120, 20);
            this.jPanelDetails.add(this.jLabelUsername);
            this.jFieldUsername.setBounds(140, 65, 200, 20);
            this.jPanelDetails.add(this.jFieldUsername);
            this.jLabelPassword.setBounds(10, 90, 120, 20);
            this.jPanelDetails.add(this.jLabelPassword);
            this.jFieldPassword.setBounds(140, 90, 200, 20);
            this.jPanelDetails.add(this.jFieldPassword);
            this.jButtonUpdate.setBounds(140, 115, 70, 24);
            this.jButtonUpdate.addActionListener(this);
            this.jPanelDetails.add(this.jButtonUpdate);
        }

        public void load() {
            this.updateBusComponents();
            if (this.model.size() > 0) {
                this.jListSites.setSelectedIndex(0);
            }
        }

        private void updateBusComponents() {
            try {
                String[] stringArray = BusComponentContext.getInstance().list();
                this.jComboBusComponent.removeAllItems();
                this.jComboBusComponent.addItem(SELECT_BUSCOMPONENT);
                int n = 0;
                while (n < stringArray.length) {
                    this.jComboBusComponent.addItem(stringArray[n]);
                    ++n;
                }
            }
            catch (OWConfigurationException oWConfigurationException) {}
        }

        private String getSiteName() {
            String string = BASE_SITE_NAME;
            int n = 2;
            while (this.nameInUse(string)) {
                string = BASE_SITE_NAME + n++;
            }
            return string;
        }

        private boolean nameInUse(String string) {
            boolean bl = false;
            Enumeration enumeration2 = this.model.elements();
            while (enumeration2.hasMoreElements()) {
                SoapSite soapSite = (SoapSite)enumeration2.nextElement();
                if (!soapSite.getName().equals(string)) continue;
                bl = true;
                break;
            }
            return bl;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            int n = this.jListSites.getSelectedIndex();
            if (n >= 0) {
                SoapSite soapSite = (SoapSite)this.model.getElementAt(n);
                this.jFieldSite.setText(soapSite.getName());
                String string = soapSite.getBusComponent();
                if (string.equals("")) {
                    string = SELECT_BUSCOMPONENT;
                }
                this.jComboBusComponent.setSelectedItem(string);
                this.jFieldUsername.setText(soapSite.getUsername());
                ((JTextComponent)this.jFieldPassword).setText(soapSite.getPassword());
            } else {
                this.jFieldSite.setText("");
                this.jComboBusComponent.setSelectedItem(SELECT_BUSCOMPONENT);
                this.jFieldUsername.setText("");
                ((JTextComponent)this.jFieldPassword).setText("");
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = this.jListSites.getSelectedIndex();
            if (actionEvent.getSource() == this.jButtonAdd) {
                String string = this.getSiteName();
                SoapSite soapSite = new SoapSite(string, SELECT_BUSCOMPONENT, "", "");
                this.model.addElement(soapSite);
                this.jListSites.setSelectedIndex(this.model.getSize() - 1);
                this.jFieldSite.setSelectionStart(0);
                this.jFieldSite.setSelectionEnd(soapSite.getName().length());
                this.jFieldSite.requestFocus();
            } else if (actionEvent.getSource() == this.jButtonRemove) {
                if (n >= 0) {
                    this.model.remove(n);
                    if (n >= this.model.getSize()) {
                        n = this.model.getSize() - 1;
                    }
                    this.jListSites.setSelectedIndex(n);
                }
            } else if (actionEvent.getSource() == this.jButtonUpdate && n >= 0) {
                String string = this.jFieldSite.getText();
                int n2 = 0;
                while (n2 < this.model.size()) {
                    SoapSite soapSite;
                    if (n2 != n && string.equals((soapSite = (SoapSite)this.model.getElementAt(n2)).getName())) {
                        JOptionPane.showMessageDialog((Component)((Object)this), "The Site name '" + string + "' already exists", "Cannot Update Site", 0);
                        return;
                    }
                    ++n2;
                }
                int n3 = this.jComboBusComponent.getSelectedIndex();
                if (n3 == -1 || n3 == 0) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Select a BusComponent", "Cannot Update Site", 0);
                    return;
                }
                String string2 = (String)this.jComboBusComponent.getSelectedItem();
                if (string2.equals("<none>")) {
                    string2 = "";
                }
                SoapSite soapSite = new SoapSite(string, string2, this.jFieldUsername.getText(), new String(this.jFieldPassword.getPassword()));
                this.model.setElementAt(soapSite, n);
            }
        }

        public Object getSelectedObject() {
            SoapSite[] soapSiteArray = new SoapSite[this.model.getSize()];
            int n = 0;
            while (n < this.model.getSize()) {
                soapSiteArray[n] = (SoapSite)this.model.getElementAt(n);
                ++n;
            }
            return soapSiteArray;
        }

        public void setSelectedObject(Object object) {
            if (object instanceof SoapSite[]) {
                SoapSite[] soapSiteArray = (SoapSite[])object;
                this.model.clear();
                int n = 0;
                while (n < soapSiteArray.length) {
                    this.model.addElement(soapSiteArray[n]);
                    ++n;
                }
            }
        }
    }

    private class SitesComboBox
    extends AbstractComboBox
    implements PopupMenuListener {
        private SitesPopupPanel m_panel = null;

        public SitesComboBox() {
            super(1);
            this.initComponent();
            this.setEditable(false);
            this.setBackground(SystemColor.window);
            this.addPopupMenuListener(this);
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            if (this.m_panel != null) {
                this.m_panel.load();
            }
        }

        public PopupPanel createPopupComponent() {
            this.m_panel = new SitesPopupPanel();
            return this.m_panel;
        }

        public AbstractComboBox.EditorComponent createEditorComponent() {
            return new SitesEditorComponent(array$Lcom$baan$owimpl$fw$ccf$dt$SoapSite == null ? (array$Lcom$baan$owimpl$fw$ccf$dt$SoapSite = SitesCellEditor.class$("[Lcom.baan.owimpl.fw.ccf.dt.SoapSite;")) : array$Lcom$baan$owimpl$fw$ccf$dt$SoapSite);
        }

        class SitesEditorComponent
        extends AbstractComboBox.DefaultTextFieldEditorComponent {
            public SitesEditorComponent(Class clazz) {
                super((AbstractComboBox)SitesComboBox.this, clazz);
                ((Container)((Object)this)).setLayout(new BorderLayout(2, 2));
                ((JComponent)((Object)this)).setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
                this._textField = new JTextField();
                this.registerKeys(this._textField);
                this._textField.setFont(((Component)((Object)SitesComboBox.this)).getFont());
                this._textField.setBorder(BorderFactory.createEmptyBorder());
                ((Container)((Object)this)).add(this._textField, "Center");
                this.setBackground(this._textField.getBackground());
            }
        }
    }
}

