/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owtools.ccf.ui.grid;

import com.baan.owimpl.fw.ccf.LoggingConfiguration;
import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.baan.owimpl.fw.ccf.dt.LogCategories;
import com.baan.owimpl.fw.ccf.dt.LogLevelEnum;
import com.baan.owtools.ccf.ui.IContextHelp;
import com.baan.owtools.ccf.ui.grid.ConfigurationProperties;
import com.baan.owtools.ccf.ui.grid.EnumConverter;
import com.baan.owtools.ccf.ui.grid.LogCategoriesCellEditor;
import com.baan.owtools.ccf.ui.grid.LogCategoriesConverter;
import com.jidesoft.converter.ObjectConverter;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.grid.CellEditorManager;
import com.jidesoft.grid.ListComboBoxCellEditor;
import com.jidesoft.grid.Property;
import javax.swing.CellEditor;
import javax.swing.JOptionPane;

public class LoggingConfigurationProperties
extends ConfigurationProperties {
    private static final String HELP_LEVEL = "Specifies which level (severity) of messages must be logged.";
    private static final String HELP_CATEGORIES = "Specifies which software components should log. In case of level Error all Categores are automatically enabled";
    private static final String HELP_FILENAME = "Specifies the path to the log file. If this value is empty the default logfile will be: <user.home>/.owlog/<user.name>.log";
    private static final String HELP_LOGPERPROCESS = "Enables logging per process, causing each process to log in a separate log file.";
    private LoggingConfiguration m_config;
    private CategoriesProperty m_categoriesProperty;
    private boolean isNotLevelError = false;
    static /* synthetic */ Class class$com$baan$owimpl$fw$ccf$dt$LogLevelEnum;
    static /* synthetic */ Class class$com$baan$owimpl$fw$ccf$dt$LogCategories;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;

    public LoggingConfigurationProperties(LoggingConfiguration loggingConfiguration) {
        this.m_config = loggingConfiguration;
        this.addProperty(new ConfigurationProperties.TypeProperty(this.m_config));
        this.addProperty(new ConfigurationProperties.MachineProperty(this.m_config));
        this.addProperty(new ConfigurationProperties.UserProperty(this.m_config));
        this.addProperty(new ConfigurationProperties.ApplicationProperty(this.m_config));
        this.addProperty(new ConfigurationProperties.ModificationDateProperty(this.m_config));
        this.addProperty(new ConfigurationProperties.ModificationUserProperty(this.m_config));
        this.addProperty(new LevelProperty());
        this.m_categoriesProperty = new CategoriesProperty();
        this.addProperty(this.m_categoriesProperty);
        this.addProperty(new FileNameProperty());
        this.addProperty(new LogPerProcessProperty());
    }

    private void store() {
        try {
            this.m_config.store();
            this.refresh();
        }
        catch (OWConfigurationException oWConfigurationException) {
            JOptionPane.showMessageDialog(null, oWConfigurationException.toString(), "Update Failed", 0);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        CellEditorManager.registerEditor((Class)(class$com$baan$owimpl$fw$ccf$dt$LogLevelEnum == null ? (class$com$baan$owimpl$fw$ccf$dt$LogLevelEnum = LoggingConfigurationProperties.class$("com.baan.owimpl.fw.ccf.dt.LogLevelEnum")) : class$com$baan$owimpl$fw$ccf$dt$LogLevelEnum), (CellEditor)((Object)new LogLevelCellEditor()));
        ObjectConverterManager.registerConverter((Class)(class$com$baan$owimpl$fw$ccf$dt$LogLevelEnum == null ? (class$com$baan$owimpl$fw$ccf$dt$LogLevelEnum = LoggingConfigurationProperties.class$("com.baan.owimpl.fw.ccf.dt.LogLevelEnum")) : class$com$baan$owimpl$fw$ccf$dt$LogLevelEnum), (ObjectConverter)new EnumConverter(class$com$baan$owimpl$fw$ccf$dt$LogLevelEnum == null ? (class$com$baan$owimpl$fw$ccf$dt$LogLevelEnum = LoggingConfigurationProperties.class$("com.baan.owimpl.fw.ccf.dt.LogLevelEnum")) : class$com$baan$owimpl$fw$ccf$dt$LogLevelEnum));
        CellEditorManager.registerEditor((Class)(class$com$baan$owimpl$fw$ccf$dt$LogCategories == null ? (class$com$baan$owimpl$fw$ccf$dt$LogCategories = LoggingConfigurationProperties.class$("com.baan.owimpl.fw.ccf.dt.LogCategories")) : class$com$baan$owimpl$fw$ccf$dt$LogCategories), (CellEditor)new LogCategoriesCellEditor());
        ObjectConverterManager.registerConverter((Class)(class$com$baan$owimpl$fw$ccf$dt$LogCategories == null ? (class$com$baan$owimpl$fw$ccf$dt$LogCategories = LoggingConfigurationProperties.class$("com.baan.owimpl.fw.ccf.dt.LogCategories")) : class$com$baan$owimpl$fw$ccf$dt$LogCategories), (ObjectConverter)new LogCategoriesConverter());
    }

    public static class LogLevelCellEditor
    extends ListComboBoxCellEditor {
        public LogLevelCellEditor() {
            super(new Object[]{LogLevelEnum.ERROR, LogLevelEnum.INFO, LogLevelEnum.FLOW}, class$com$baan$owimpl$fw$ccf$dt$LogLevelEnum == null ? (class$com$baan$owimpl$fw$ccf$dt$LogLevelEnum = LoggingConfigurationProperties.class$("com.baan.owimpl.fw.ccf.dt.LogLevelEnum")) : class$com$baan$owimpl$fw$ccf$dt$LogLevelEnum);
        }
    }

    private class LogPerProcessProperty
    extends Property
    implements IContextHelp {
        private Object m_value;

        public LogPerProcessProperty() {
            super("Log per Process", LoggingConfigurationProperties.HELP_LOGPERPROCESS, class$java$lang$Boolean == null ? (class$java$lang$Boolean = LoggingConfigurationProperties.class$("java.lang.Boolean")) : class$java$lang$Boolean, "General");
        }

        public void setValue(Object object) {
            if (object != null && !object.equals(this.m_value)) {
                LoggingConfigurationProperties.this.m_config.setPerProcess((Boolean)object);
                LoggingConfigurationProperties.this.store();
            }
        }

        public Object getValue() {
            this.m_value = new Boolean(LoggingConfigurationProperties.this.m_config.getPerProcess());
            return this.m_value;
        }

        public boolean hasValue() {
            return true;
        }

        public String getHelpTopic() {
            return "ccf_logging_logperprocess";
        }
    }

    private class FileNameProperty
    extends Property
    implements IContextHelp {
        private Object m_value;

        public FileNameProperty() {
            super("File Name", LoggingConfigurationProperties.HELP_FILENAME, class$java$lang$String == null ? (class$java$lang$String = LoggingConfigurationProperties.class$("java.lang.String")) : class$java$lang$String, "General");
        }

        public void setValue(Object object) {
            if (object != null && !object.equals(this.m_value)) {
                LoggingConfigurationProperties.this.m_config.setFileName((String)object);
                LoggingConfigurationProperties.this.store();
            }
        }

        public Object getValue() {
            this.m_value = LoggingConfigurationProperties.this.m_config.getFileName();
            return this.m_value;
        }

        public boolean hasValue() {
            return true;
        }

        public String getHelpTopic() {
            return "ccf_logging_filename";
        }
    }

    private class CategoriesProperty
    extends Property
    implements IContextHelp {
        private Object m_value;

        public CategoriesProperty() {
            super("Categories", LoggingConfigurationProperties.HELP_CATEGORIES, class$com$baan$owimpl$fw$ccf$dt$LogCategories == null ? (class$com$baan$owimpl$fw$ccf$dt$LogCategories = LoggingConfigurationProperties.class$("com.baan.owimpl.fw.ccf.dt.LogCategories")) : class$com$baan$owimpl$fw$ccf$dt$LogCategories, "General");
        }

        public void setValue(Object object) {
            if (LoggingConfigurationProperties.this.isNotLevelError && object != null && object instanceof LogCategories && !object.equals(this.m_value)) {
                LoggingConfigurationProperties.this.m_config.setCategories((LogCategories)object);
                LoggingConfigurationProperties.this.store();
            }
        }

        public Object getValue() {
            if (LoggingConfigurationProperties.this.isNotLevelError) {
                this.m_value = LoggingConfigurationProperties.this.m_config.getCategories();
                return this.m_value;
            }
            return "<all>";
        }

        public boolean hasValue() {
            return true;
        }

        public String getHelpTopic() {
            return "ccf_logging_categories";
        }
    }

    private class LevelProperty
    extends Property
    implements IContextHelp {
        private Object m_value;

        public LevelProperty() {
            super("Log Level", LoggingConfigurationProperties.HELP_LEVEL, class$com$baan$owimpl$fw$ccf$dt$LogLevelEnum == null ? (class$com$baan$owimpl$fw$ccf$dt$LogLevelEnum = LoggingConfigurationProperties.class$("com.baan.owimpl.fw.ccf.dt.LogLevelEnum")) : class$com$baan$owimpl$fw$ccf$dt$LogLevelEnum, "General");
        }

        public void setValue(Object object) {
            if (object != null && object instanceof LogLevelEnum && !object.equals(this.m_value)) {
                LoggingConfigurationProperties.this.m_config.setLevel((LogLevelEnum)object);
                LoggingConfigurationProperties.this.store();
            }
        }

        public Object getValue() {
            this.updateProperties();
            this.m_value = LoggingConfigurationProperties.this.m_config.getLevel();
            return this.m_value;
        }

        public boolean hasValue() {
            return true;
        }

        public String getHelpTopic() {
            return "ccf_logging_level";
        }

        private void updateProperties() {
            LogLevelEnum logLevelEnum = LoggingConfigurationProperties.this.m_config.getLevel();
            LoggingConfigurationProperties.this.isNotLevelError = logLevelEnum != LogLevelEnum.ERROR;
            LoggingConfigurationProperties.this.m_categoriesProperty.setEditable(LoggingConfigurationProperties.this.isNotLevelError);
        }
    }
}

