/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owtools.ccf.ui.grid;

import com.baan.owimpl.fw.ccf.AdapterClientConfiguration;
import com.baan.owimpl.fw.ccf.BusComponentCategoryConfiguration;
import com.baan.owimpl.fw.ccf.BusComponentConfiguration;
import com.baan.owimpl.fw.ccf.Configuration;
import com.baan.owimpl.fw.ccf.IdentifierConfiguration;
import com.baan.owimpl.fw.ccf.LoggingConfiguration;
import com.baan.owimpl.fw.ccf.SOAPConnectorConfiguration;
import com.baan.owimpl.fw.ccf.SmartConfiguration;
import com.baan.owimpl.fw.ccf.XMLConnectorConfiguration;
import com.baan.owtools.ccf.ui.IContextHelp;
import com.baan.owtools.ccf.ui.grid.BusComponentCellEditor;
import com.baan.owtools.ccf.ui.grid.PasswordFieldCellEditor;
import com.jidesoft.grid.CellEditorManager;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.ExpandableRow;
import com.jidesoft.grid.Property;
import com.jidesoft.grid.PropertyTable;
import com.jidesoft.grid.PropertyTableModel;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import javax.swing.CellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ConfigurationProperties {
    private static final String HELP_TYPE = "This read-only property contains the configuration type.";
    private static final String HELP_IDENTIFIER = "This read-only property contains the unique identifier name of the configuration. For example the name of a BusComponent.";
    private static final String HELP_MACHINE = "This read-only property contains the machine name of the configuration. This means that this configuration is only used on this machine. The configuration with value <default> is used on all unlisted machines.";
    private static final String HELP_USER = "This read-only property contains the user name of the configuration. This means that this configuration is only used by this user. The configuration with value <default> is used by all unlisted users.";
    private static final String HELP_APPLICATION = "This read-only property contains the application name of the configuration. This means that this configuration is only used by this application. The configuration with value <default> is used by all unlisted applications.";
    private static final String HELP_MODIFICATION_DATE = "This read-only property contains the last modification date of the configuration.";
    private static final String HELP_MODIFICATION_USER = "This read-only property contains the user that made the last modification of the configuration.";
    private List m_list = new ArrayList();
    protected PropertyTable m_table = null;
    static Hashtable s_preferences;
    static /* synthetic */ Class class$java$lang$String;

    public void show(PropertyTable propertyTable) {
        this.m_table = propertyTable;
        PropertyTableModel propertyTableModel = new PropertyTableModel(this.m_list);
        propertyTable.setModel((TableModel)propertyTableModel);
        propertyTable.expandFirstLevel();
        this.restoreSettings();
        if (propertyTableModel.getProperties().size() > 0) {
            this.m_table.setSelectedProperty(propertyTableModel.getPropertyAt(0));
        }
    }

    public void refresh() {
        if (this.m_table != null) {
            this.m_table.repaint();
        }
    }

    public void addProperty(Property property) {
        this.m_list.add(property);
    }

    public void saveSettings() {
        if (this.m_table != null) {
            PropertyTableModel propertyTableModel = (PropertyTableModel)this.m_table.getModel();
            int n = propertyTableModel.getOrder();
            s_preferences.put("order", new Integer(n));
            TableColumnModel tableColumnModel = this.m_table.getColumnModel();
            TableColumn tableColumn = tableColumnModel.getColumn(0);
            int n2 = tableColumn.getWidth();
            s_preferences.put("widthName", new Integer(n2));
            tableColumn = tableColumnModel.getColumn(1);
            n2 = tableColumn.getWidth();
            s_preferences.put("widthValue", new Integer(n2));
            if (n == 0) {
                ArrayList<String> arrayList = new ArrayList<String>();
                int n3 = 0;
                while (n3 < propertyTableModel.getRowCount()) {
                    ExpandableRow expandableRow;
                    if (propertyTableModel.isCategoryRow(n3) && !(expandableRow = (ExpandableRow)propertyTableModel.getRowAt(n3)).isExpanded()) {
                        Property property = propertyTableModel.getPropertyAt(n3);
                        String string = property.getName();
                        arrayList.add(string);
                    }
                    ++n3;
                }
                s_preferences.put("collapsed", arrayList);
            }
        }
    }

    protected void restoreSettings() {
        if (this.m_table != null) {
            TableColumn tableColumn;
            Object object;
            Object object2;
            Integer n = (Integer)s_preferences.get("order");
            if (n != null) {
                object2 = (PropertyTableModel)this.m_table.getModel();
                object2.setOrder(n.intValue());
            }
            if ((object2 = (Integer)s_preferences.get("widthName")) != null) {
                object = this.m_table.getColumnModel();
                tableColumn = object.getColumn(0);
                tableColumn.setPreferredWidth((Integer)object2);
            }
            if ((object2 = (Integer)s_preferences.get("widthValue")) != null) {
                object = this.m_table.getColumnModel();
                tableColumn = object.getColumn(1);
                tableColumn.setPreferredWidth((Integer)object2);
            }
            if ((object = (ArrayList)s_preferences.get("collapsed")) != null) {
                tableColumn = (PropertyTableModel)this.m_table.getModel();
                int n2 = 0;
                while (n2 < tableColumn.getRowCount()) {
                    Property property;
                    String string;
                    if (tableColumn.isCategoryRow(n2) && ((ArrayList)object).contains(string = (property = tableColumn.getPropertyAt(n2)).getName())) {
                        this.m_table.expandRow(n2, false);
                    }
                    ++n2;
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        CellEditorManager.registerEditor((Class)(class$java$lang$String == null ? (class$java$lang$String = ConfigurationProperties.class$("java.lang.String")) : class$java$lang$String), (CellEditor)((Object)new BusComponentCellEditor()), (EditorContext)BusComponentCellEditor.CONTEXT);
        CellEditorManager.registerEditor((Class)(class$java$lang$String == null ? (class$java$lang$String = ConfigurationProperties.class$("java.lang.String")) : class$java$lang$String), (CellEditor)new PasswordFieldCellEditor(), (EditorContext)PasswordFieldCellEditor.CONTEXT);
        s_preferences = new Hashtable();
    }

    protected class ApplicationProperty
    extends Property
    implements IContextHelp {
        private SmartConfiguration m_config;

        public ApplicationProperty(SmartConfiguration smartConfiguration) {
            super("Application", ConfigurationProperties.HELP_APPLICATION, class$java$lang$String == null ? (class$java$lang$String = ConfigurationProperties.class$("java.lang.String")) : class$java$lang$String, "Info");
            this.m_config = smartConfiguration;
            this.setEditable(false);
        }

        public void setValue(Object object) {
        }

        public Object getValue() {
            String string = this.m_config.getApplication();
            if (string.equals("_default_")) {
                string = "<default>";
            }
            return string;
        }

        public boolean hasValue() {
            return true;
        }

        public String getHelpTopic() {
            return "ccf_property_application";
        }
    }

    protected class UserProperty
    extends Property
    implements IContextHelp {
        private SmartConfiguration m_config;

        public UserProperty(SmartConfiguration smartConfiguration) {
            super("User", ConfigurationProperties.HELP_USER, class$java$lang$String == null ? (class$java$lang$String = ConfigurationProperties.class$("java.lang.String")) : class$java$lang$String, "Info");
            this.m_config = smartConfiguration;
            this.setEditable(false);
        }

        public void setValue(Object object) {
        }

        public Object getValue() {
            String string = this.m_config.getUser();
            if (string.equals("_default_")) {
                string = "<default>";
            }
            return string;
        }

        public boolean hasValue() {
            return true;
        }

        public String getHelpTopic() {
            return "ccf_property_user";
        }
    }

    protected class MachineProperty
    extends Property
    implements IContextHelp {
        private SmartConfiguration m_config;

        public MachineProperty(SmartConfiguration smartConfiguration) {
            super("Machine", ConfigurationProperties.HELP_MACHINE, class$java$lang$String == null ? (class$java$lang$String = ConfigurationProperties.class$("java.lang.String")) : class$java$lang$String, "Info");
            this.m_config = smartConfiguration;
            this.setEditable(false);
        }

        public void setValue(Object object) {
        }

        public Object getValue() {
            String string = this.m_config.getMachine();
            if (string.equals("_default_")) {
                string = "<default>";
            }
            return string;
        }

        public boolean hasValue() {
            return true;
        }

        public String getHelpTopic() {
            return "ccf_property_machine";
        }
    }

    protected class IdentifierProperty
    extends Property
    implements IContextHelp {
        private IdentifierConfiguration m_config;

        public IdentifierProperty(IdentifierConfiguration identifierConfiguration) {
            super("Identifier", ConfigurationProperties.HELP_IDENTIFIER, class$java$lang$String == null ? (class$java$lang$String = ConfigurationProperties.class$("java.lang.String")) : class$java$lang$String, "Info");
            this.m_config = identifierConfiguration;
            this.setEditable(false);
        }

        public void setValue(Object object) {
        }

        public Object getValue() {
            return this.m_config.getIdentifier();
        }

        public boolean hasValue() {
            return true;
        }

        public String getHelpTopic() {
            return "ccf_property_identifier";
        }
    }

    protected class ModificationUserProperty
    extends Property
    implements IContextHelp {
        private Configuration m_config;

        public ModificationUserProperty(Configuration configuration) {
            super("Modified by", ConfigurationProperties.HELP_MODIFICATION_USER, class$java$lang$String == null ? (class$java$lang$String = ConfigurationProperties.class$("java.lang.String")) : class$java$lang$String, "Info");
            this.m_config = configuration;
            this.setEditable(false);
        }

        public void setValue(Object object) {
        }

        public Object getValue() {
            return this.m_config.getModificationUser();
        }

        public boolean hasValue() {
            return true;
        }

        public String getHelpTopic() {
            return "ccf_property_modificationuser";
        }
    }

    protected class ModificationDateProperty
    extends Property
    implements IContextHelp {
        private Configuration m_config;

        public ModificationDateProperty(Configuration configuration) {
            super("Last Modified", ConfigurationProperties.HELP_MODIFICATION_DATE, class$java$lang$String == null ? (class$java$lang$String = ConfigurationProperties.class$("java.lang.String")) : class$java$lang$String, "Info");
            this.m_config = configuration;
            this.setEditable(false);
        }

        public void setValue(Object object) {
        }

        public Object getValue() {
            Date date = this.m_config.getModificationDate();
            return DateFormat.getDateTimeInstance().format(date);
        }

        public boolean hasValue() {
            return true;
        }

        public String getHelpTopic() {
            return "ccf_property_modificationdate";
        }
    }

    protected class TypeProperty
    extends Property
    implements IContextHelp {
        private Configuration m_config;

        public TypeProperty(Configuration configuration) {
            super("Type", ConfigurationProperties.HELP_TYPE, class$java$lang$String == null ? (class$java$lang$String = ConfigurationProperties.class$("java.lang.String")) : class$java$lang$String, "Info");
            this.m_config = configuration;
            this.setEditable(false);
        }

        public void setValue(Object object) {
        }

        public Object getValue() {
            String string = "";
            if (this.m_config instanceof BusComponentConfiguration) {
                string = "BusComponent Configuration";
            } else if (this.m_config instanceof BusComponentCategoryConfiguration) {
                string = "BusComponent Category Configuration";
            } else if (this.m_config instanceof LoggingConfiguration) {
                string = "Logging Configuration";
            } else if (this.m_config instanceof AdapterClientConfiguration) {
                string = "Adapter Client Configuration";
            } else if (this.m_config instanceof XMLConnectorConfiguration) {
                string = "XML Connector Configuration";
            } else if (this.m_config instanceof SOAPConnectorConfiguration) {
                string = "SOAP Connector Configuration";
            }
            return string;
        }

        public boolean hasValue() {
            return true;
        }

        public String getHelpTopic() {
            return "ccf_property_type";
        }
    }
}

