/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owtools.ccf.ui.grid;

import com.baan.owimpl.fw.ccf.BusComponentConfiguration;
import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.baan.owtools.ccf.ui.IContextHelp;
import com.baan.owtools.ccf.ui.grid.BusComponentCategoriesCellEditor;
import com.baan.owtools.ccf.ui.grid.BusComponentCellEditor;
import com.baan.owtools.ccf.ui.grid.CCFStringArrayCellEditor;
import com.baan.owtools.ccf.ui.grid.ConfigurationProperties;
import com.baan.owtools.ccf.ui.grid.PasswordFieldCellEditor;
import com.baan.owtools.ccf.ui.grid.ServiceRefCellEditor;
import com.jidesoft.grid.CellEditorManager;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.ListComboBoxCellEditor;
import com.jidesoft.grid.Property;
import java.lang.reflect.Constructor;
import javax.swing.CellEditor;
import javax.swing.JOptionPane;

public class BusComponentConfigurationProperties
extends ConfigurationProperties {
    private static final EditorContext CONTEXT_CATEGORIES = new EditorContext("CategoriesCellEditor");
    private static final EditorContext CONTEXT_CONNECTIONPOINTS = new EditorContext("ConnectionPointsCellEditor");
    private static final String HELP_DESCRIPTION = "This property is used to describe the BusComponent.";
    private static final String HELP_OWNER = "This property is used to identify the owner or user of the BusComponent.";
    private static final String HELP_ADMINISTRATOR = "This property is used to identify the administrator of a BusComponent.";
    private static final String HELP_COMPANYNUMBER = "The company number is used by a SSA BaanERP/BaanIV server. The server runs in the company that you entered. Leave empty to use the default company number (that is the company number of the user who started the server).";
    private static final String HELP_CONNECTIONPOINTS = "A connection point is used to configure the transport for this BusComponent. Each BusComponent must at least have one connection point.";
    private static final String HELP_CATEGORIES = "This property is used to set one or more categories for the BusComponent. For BusComponents that represent SSA ERP or SSA BaanIV servers, you must define a category named 'BaanERP'.";
    private static final String HELP_DEFAULTUSERSESSION = "Enabling this property (and filling a correct username/password combination) gives you the possibility to use features like security, activation and pooling without having to code the UserSession logic.";
    private static final String HELP_USERNAME = "The user name for the default user session.";
    private static final String HELP_PASSWORD = "The password for the default user session.";
    private static final String HELP_ACTIVATIONTYPE = "This property specifies the type of the activation service.";
    private static final String HELP_ACTIVATIONSERVICEREFERENCE = "The service reference identifies how a backend must be started for the specified activation type. It contains all the required parameters and options to start the backend.";
    private static final String HELP_ACTIVATIONPOOLINGPOLICY = "The pooling policy defines how the activation service deals with connection pooling.";
    private static final String HELP_ACTIVATIONMAXREFERENCES = "The maximum number of references (managers) per connection.";
    private static final String HELP_ACTIVATIONMAXCONNECTIONS = "The maximum number of connections to create.";
    private static final String HELP_ACTIVATIONKEEPALIVETIME = "Keep alive time in seconds before releasing the connection (when the number of references becomes 0).";
    private static final String HELP_ACTIVATIONPOOLINGSERVICE = "Specify a BusComponent to enable APS. This can be used to solve more complex activation and pooling problems, for example to make local activations remote or to enable pooling across multiple client processes.";
    private static final String HELP_ACTIVATIONSERVERTIMEOUT = "The server timeout in minutes. Backends use this timeout to stop when no request has been handled within the timeout value.";
    private BusComponentConfiguration m_config;
    private UsernameProperty m_usernameProperty;
    private PasswordProperty m_passwordProperty;
    private ActivationServiceReferenceProperty m_serviceReferenceProperty;
    private ActivationPoolingPolicyProperty m_poolingPolicyProperty;
    private ActivationMaxReferencesProperty m_maxReferencesProperty;
    private ActivationMaxConnectionsProperty m_maxConnectionsProperty;
    private ActivationPoolingServiceProperty m_poolingServiceProperty;
    private ActivationKeepAliveTimeProperty m_keepAliveTimeProperty;
    private ActivationServerTimeoutProperty m_serverTimeoutProperty;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;

    public BusComponentConfigurationProperties(BusComponentConfiguration busComponentConfiguration) {
        this.m_config = busComponentConfiguration;
        this.addProperty(new ConfigurationProperties.TypeProperty(this, this.m_config));
        this.addProperty(new ConfigurationProperties.IdentifierProperty(this, this.m_config));
        this.addProperty(new ConfigurationProperties.ModificationDateProperty(this, this.m_config));
        this.addProperty(new ConfigurationProperties.ModificationUserProperty(this, this.m_config));
        this.addProperty(new DescriptionProperty());
        this.addProperty(new ConnectionPointsProperty());
        this.addProperty(new OwnerProperty());
        this.addProperty(new AdministratorProperty());
        this.addProperty(new CompanyNumberProperty());
        this.addProperty(new CategoriesProperty());
        this.addProperty(new DefaultUserSessionProperty());
        this.m_usernameProperty = new UsernameProperty();
        this.addProperty(this.m_usernameProperty);
        this.m_passwordProperty = new PasswordProperty();
        this.addProperty(this.m_passwordProperty);
        this.addProperty(new ActivationTypeProperty());
        this.m_serviceReferenceProperty = new ActivationServiceReferenceProperty();
        this.addProperty(this.m_serviceReferenceProperty);
        this.m_poolingPolicyProperty = new ActivationPoolingPolicyProperty();
        this.addProperty(this.m_poolingPolicyProperty);
        this.m_maxReferencesProperty = new ActivationMaxReferencesProperty();
        this.addProperty(this.m_maxReferencesProperty);
        this.m_maxConnectionsProperty = new ActivationMaxConnectionsProperty();
        this.addProperty(this.m_maxConnectionsProperty);
        this.m_keepAliveTimeProperty = new ActivationKeepAliveTimeProperty();
        this.addProperty(this.m_keepAliveTimeProperty);
        this.m_poolingServiceProperty = new ActivationPoolingServiceProperty();
        this.addProperty(this.m_poolingServiceProperty);
        this.m_serverTimeoutProperty = new ActivationServerTimeoutProperty();
        this.addProperty(this.m_serverTimeoutProperty);
        this.addProperty(new GenericProperty("Environment Control Library", class$java$lang$String == null ? (class$java$lang$String = BusComponentConfigurationProperties.class$("java.lang.String")) : class$java$lang$String, "Describes the iSeries based Library List (i.e. path on the iSeries) for SSA\u00ae ERPlx.", "SSA\u00ae ERPlx", "ccf_buscomponent_erplx_env_ctrl_lib", "erplx_env_ctrl_lib"));
        this.addProperty(new GenericProperty("WebTop URI", class$java$lang$String == null ? (class$java$lang$String = BusComponentConfigurationProperties.class$("java.lang.String")) : class$java$lang$String, "Describes the URI where the WebTop for SSA\u00ae ERPlx can be reached.", "SSA\u00ae ERPlx", "ccf_buscomponent_erplx_webtop_uri", "erplx_webtop_uri"));
        this.addProperty(new GenericProperty("Screen Scraping Engine's Classpath", class$java$lang$String == null ? (class$java$lang$String = BusComponentConfigurationProperties.class$("java.lang.String")) : class$java$lang$String, "Path to all classes, properties and process instructions needed for using the screen scraping engine at runtime.", "SSA\u00ae ERPlx", "ccf_buscomponent_erplx_xmg_classpath", "erplx_xmg_classpath"));
        this.addProperty(new GenericProperty("WMS System Id", class$java$lang$String == null ? (class$java$lang$String = BusComponentConfigurationProperties.class$("java.lang.String")) : class$java$lang$String, "WMS System Id, which is basically a logical alias for the customer's warehouse instance.", "WMS", "ccf_buscomponent_wms_system_id", "wms_system_id"));
        this.addProperty(new GenericProperty("Event Publishing Polling Frequency", class$java$lang$Integer == null ? (class$java$lang$Integer = BusComponentConfigurationProperties.class$("java.lang.Integer")) : class$java$lang$Integer, "This identifies the frequency of the event publishing polling activity in milliseconds.", "Event Management", "ccf_buscomponent_events_polling_frequency", "events_polling_frequency"));
        this.addProperty(new GenericProperty("JDBC Driver Name", class$java$lang$String == null ? (class$java$lang$String = BusComponentConfigurationProperties.class$("java.lang.String")) : class$java$lang$String, "This identifies the used JDBC Driver. For example: net.sourceforge.jtds.jdbc.Driver .", "JDBC", "ccf_buscomponent_jdbc_driver_name", "jdbc_driver_name"));
        this.addProperty(new GenericProperty("JDBC Database URL", class$java$lang$String == null ? (class$java$lang$String = BusComponentConfigurationProperties.class$("java.lang.String")) : class$java$lang$String, "Database url. For example: jdbc:jtds:sqlserver://localhost:1433;TDS=8.0 .", "JDBC", "ccf_buscomponent_jdbc_database_url", "jdbc_database_url"));
        this.addProperty(new GenericProperty("JDBC Database User", class$java$lang$String == null ? (class$java$lang$String = BusComponentConfigurationProperties.class$("java.lang.String")) : class$java$lang$String, "The database user on whose behalf the connection is being made.", "JDBC", "ccf_buscomponent_jdbc_user", "jdbc_user"));
        this.addProperty(new HiddenGenericProperty("JDBC User's Password", class$java$lang$String == null ? (class$java$lang$String = BusComponentConfigurationProperties.class$("java.lang.String")) : class$java$lang$String, "The user's password.", "JDBC", "ccf_buscomponent_jdbc_password", "jdbc_password"));
        this.addProperty(new BusComponentProperty("Error Handler BusComponent", class$java$lang$String == null ? (class$java$lang$String = BusComponentConfigurationProperties.class$("java.lang.String")) : class$java$lang$String, "BusComponent to which the error events are sent in case of an error during processing of an event. If not set errors are only logged.", "Event Management", "ccf_buscomponent_error_handler_buscomponent", "error_handler_buscomponent"));
        this.addProperty(new GenericProperty("Persistent Queue Path", class$java$lang$String == null ? (class$java$lang$String = BusComponentConfigurationProperties.class$("java.lang.String")) : class$java$lang$String, "Local path for creating a persistent event queue. If not set the persistent queue is disabled.", "Event Management", "ccf_buscomponent_persistent_queue_path", "persistent_queue_path"));
    }

    private void store() {
        try {
            this.m_config.store();
            this.refresh();
        }
        catch (OWConfigurationException oWConfigurationException) {
            JOptionPane.showMessageDialog(null, oWConfigurationException.toString(), "Update Failed", 0);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        CellEditorManager.registerEditor((Class)(array$Ljava$lang$String == null ? (array$Ljava$lang$String = BusComponentConfigurationProperties.class$("[Ljava.lang.String;")) : array$Ljava$lang$String), (CellEditor)new BusComponentCategoriesCellEditor(), (EditorContext)CONTEXT_CATEGORIES);
        CellEditorManager.registerEditor((Class)(array$Ljava$lang$String == null ? (array$Ljava$lang$String = BusComponentConfigurationProperties.class$("[Ljava.lang.String;")) : array$Ljava$lang$String), (CellEditor)new CCFStringArrayCellEditor("Modify list of connection points"), (EditorContext)CONTEXT_CONNECTIONPOINTS);
        CellEditorManager.registerEditor((Class)(class$java$lang$String == null ? (class$java$lang$String = BusComponentConfigurationProperties.class$("java.lang.String")) : class$java$lang$String), (CellEditor)((Object)new ActivationTypeCellEditor()), (EditorContext)ActivationTypeCellEditor.CONTEXT);
        CellEditorManager.registerEditor((Class)(class$java$lang$String == null ? (class$java$lang$String = BusComponentConfigurationProperties.class$("java.lang.String")) : class$java$lang$String), (CellEditor)((Object)new ActivationPoolingPolicyCellEditor()), (EditorContext)ActivationPoolingPolicyCellEditor.CONTEXT);
        CellEditorManager.registerEditor((Class)(class$java$lang$String == null ? (class$java$lang$String = BusComponentConfigurationProperties.class$("java.lang.String")) : class$java$lang$String), (CellEditor)new ServiceRefCellEditor(ServiceRefCellEditor.CONTEXT_ASM), (EditorContext)ServiceRefCellEditor.CONTEXT_ASM);
        CellEditorManager.registerEditor((Class)(class$java$lang$String == null ? (class$java$lang$String = BusComponentConfigurationProperties.class$("java.lang.String")) : class$java$lang$String), (CellEditor)new ServiceRefCellEditor(ServiceRefCellEditor.CONTEXT_EXECBAAN), (EditorContext)ServiceRefCellEditor.CONTEXT_EXECBAAN);
        CellEditorManager.registerEditor((Class)(class$java$lang$String == null ? (class$java$lang$String = BusComponentConfigurationProperties.class$("java.lang.String")) : class$java$lang$String), (CellEditor)new ServiceRefCellEditor(ServiceRefCellEditor.CONTEXT_EXECCMD), (EditorContext)ServiceRefCellEditor.CONTEXT_EXECCMD);
        CellEditorManager.registerEditor((Class)(class$java$lang$String == null ? (class$java$lang$String = BusComponentConfigurationProperties.class$("java.lang.String")) : class$java$lang$String), (CellEditor)new ServiceRefCellEditor(ServiceRefCellEditor.CONTEXT_INPROC), (EditorContext)ServiceRefCellEditor.CONTEXT_INPROC);
        CellEditorManager.registerEditor((Class)(class$java$lang$String == null ? (class$java$lang$String = BusComponentConfigurationProperties.class$("java.lang.String")) : class$java$lang$String), (CellEditor)new ServiceRefCellEditor(ServiceRefCellEditor.CONTEXT_EXECLX), (EditorContext)ServiceRefCellEditor.CONTEXT_EXECLX);
    }

    public static class ActivationPoolingPolicyCellEditor
    extends ListComboBoxCellEditor {
        public static final EditorContext CONTEXT = new EditorContext("ActivationPoolingPolicyContext");

        public ActivationPoolingPolicyCellEditor() {
            super(new Object[]{"shared", "limitedshared", "limitedconnection"});
        }
    }

    public static class ActivationTypeCellEditor
    extends ListComboBoxCellEditor {
        public static final EditorContext CONTEXT = new EditorContext("ActivationTypeContext");

        public ActivationTypeCellEditor() {
            super(new Object[]{"Activation Disabled", "asm", "execbaan", "execcmd", "inproc", "execlx"});
        }
    }

    private class ActivationServerTimeoutProperty
    extends Property
    implements IContextHelp {
        private Object m_value;

        public ActivationServerTimeoutProperty() {
            super("Server Timeout", BusComponentConfigurationProperties.HELP_ACTIVATIONSERVERTIMEOUT, class$java$lang$Integer == null ? (class$java$lang$Integer = BusComponentConfigurationProperties.class$("java.lang.Integer")) : class$java$lang$Integer, "Activation");
        }

        public void setValue(Object object) {
            if (object != null) {
                if (!object.equals(this.m_value)) {
                    int n = (Integer)object;
                    if (n >= 0) {
                        BusComponentConfigurationProperties.this.m_config.setActivationServerTimeout(n);
                        BusComponentConfigurationProperties.this.store();
                    } else {
                        JOptionPane.showMessageDialog(null, "Server Timeout must be a non-negative number.", "Error", 0);
                    }
                }
            } else {
                JOptionPane.showMessageDialog(null, "Server Timeout must be a non-negative number.", "Error", 0);
            }
        }

        public Object getValue() {
            this.m_value = new Integer(BusComponentConfigurationProperties.this.m_config.getActivationServerTimeout());
            return this.m_value;
        }

        public boolean hasValue() {
            return true;
        }

        public String getHelpTopic() {
            return "ccf_buscomponent_activationservertimeout";
        }
    }

    private class ActivationPoolingServiceProperty
    extends Property
    implements IContextHelp {
        private Object m_value;

        public ActivationPoolingServiceProperty() {
            super("Pooling Service", BusComponentConfigurationProperties.HELP_ACTIVATIONPOOLINGSERVICE, class$java$lang$String == null ? (class$java$lang$String = BusComponentConfigurationProperties.class$("java.lang.String")) : class$java$lang$String, "Activation");
            this.setEditorContext(BusComponentCellEditor.CONTEXT);
        }

        public void setValue(Object object) {
            if (object != null && !object.equals(this.m_value)) {
                if (object.equals("<none>")) {
                    object = "";
                }
                BusComponentConfigurationProperties.this.m_config.setActivationPoolingService((String)object);
                BusComponentConfigurationProperties.this.store();
            }
        }

        public Object getValue() {
            this.m_value = BusComponentConfigurationProperties.this.m_config.getActivationPoolingService();
            if (this.m_value == null || this.m_value.equals("")) {
                this.m_value = "<none>";
            }
            return this.m_value;
        }

        public boolean hasValue() {
            return true;
        }

        public String getHelpTopic() {
            return "ccf_buscomponent_activationpoolingservice";
        }
    }

    private class ActivationKeepAliveTimeProperty
    extends Property
    implements IContextHelp {
        private Object m_value;

        public ActivationKeepAliveTimeProperty() {
            super("Keep Alive Time", BusComponentConfigurationProperties.HELP_ACTIVATIONKEEPALIVETIME, class$java$lang$Integer == null ? (class$java$lang$Integer = BusComponentConfigurationProperties.class$("java.lang.Integer")) : class$java$lang$Integer, "Activation");
        }

        public void setValue(Object object) {
            if (object != null) {
                if (!object.equals(this.m_value)) {
                    int n = (Integer)object;
                    if (n >= 0) {
                        BusComponentConfigurationProperties.this.m_config.setActivationKeepAliveTime(n);
                        BusComponentConfigurationProperties.this.store();
                    } else {
                        JOptionPane.showMessageDialog(null, "Keep Alive Time must be a non-negative number.", "Error", 0);
                    }
                }
            } else {
                JOptionPane.showMessageDialog(null, "Keep Alive Time must be a non-negative number.", "Error", 0);
            }
        }

        public Object getValue() {
            this.m_value = new Integer(BusComponentConfigurationProperties.this.m_config.getActivationKeepAliveTime());
            return this.m_value;
        }

        public boolean hasValue() {
            return true;
        }

        public String getHelpTopic() {
            return "ccf_buscomponent_activationkeepalivetime";
        }
    }

    private class ActivationMaxConnectionsProperty
    extends Property
    implements IContextHelp {
        private Object m_value;

        public ActivationMaxConnectionsProperty() {
            super("Max Connections", BusComponentConfigurationProperties.HELP_ACTIVATIONMAXCONNECTIONS, class$java$lang$Integer == null ? (class$java$lang$Integer = BusComponentConfigurationProperties.class$("java.lang.Integer")) : class$java$lang$Integer, "Activation");
        }

        public void setValue(Object object) {
            if (object != null) {
                if (!object.equals(this.m_value)) {
                    int n = (Integer)object;
                    if (n > 0) {
                        BusComponentConfigurationProperties.this.m_config.setActivationMaxConnections(n);
                        BusComponentConfigurationProperties.this.store();
                    } else {
                        JOptionPane.showMessageDialog(null, "Max Connections must be a positive number.", "Error", 0);
                    }
                }
            } else {
                JOptionPane.showMessageDialog(null, "Max Connections must be a positive number.", "Error", 0);
            }
        }

        public Object getValue() {
            this.m_value = new Integer(BusComponentConfigurationProperties.this.m_config.getActivationMaxConnections());
            return this.m_value;
        }

        public boolean hasValue() {
            return true;
        }

        public String getHelpTopic() {
            return "ccf_buscomponent_activationmaxconnections";
        }
    }

    private class ActivationMaxReferencesProperty
    extends Property
    implements IContextHelp {
        private Object m_value;

        public ActivationMaxReferencesProperty() {
            super("Max References", BusComponentConfigurationProperties.HELP_ACTIVATIONMAXREFERENCES, class$java$lang$Integer == null ? (class$java$lang$Integer = BusComponentConfigurationProperties.class$("java.lang.Integer")) : class$java$lang$Integer, "Activation");
        }

        public void setValue(Object object) {
            if (object != null) {
                if (!object.equals(this.m_value)) {
                    int n = (Integer)object;
                    if (n > 0) {
                        BusComponentConfigurationProperties.this.m_config.setActivationMaxReferences(n);
                        BusComponentConfigurationProperties.this.store();
                    } else {
                        JOptionPane.showMessageDialog(null, "Max References must be a positive number.", "Error", 0);
                    }
                }
            } else {
                JOptionPane.showMessageDialog(null, "Max References must be a positive number.", "Error", 0);
            }
        }

        public Object getValue() {
            this.m_value = new Integer(BusComponentConfigurationProperties.this.m_config.getActivationMaxReferences());
            return this.m_value;
        }

        public boolean hasValue() {
            return true;
        }

        public String getHelpTopic() {
            return "ccf_buscomponent_activationmaxreferences";
        }
    }

    private class ActivationPoolingPolicyProperty
    extends Property
    implements IContextHelp {
        private Object m_value;

        public ActivationPoolingPolicyProperty() {
            super("Pooling Policy", BusComponentConfigurationProperties.HELP_ACTIVATIONPOOLINGPOLICY, class$java$lang$String == null ? (class$java$lang$String = BusComponentConfigurationProperties.class$("java.lang.String")) : class$java$lang$String, "Activation");
            this.setEditorContext(ActivationPoolingPolicyCellEditor.CONTEXT);
        }

        public void setValue(Object object) {
            if (object != null && !object.equals(this.m_value) && (object.equals("shared") || object.equals("limitedshared") || object.equals("limitedconnection"))) {
                BusComponentConfigurationProperties.this.m_config.setActivationPoolingPolicy((String)object);
                BusComponentConfigurationProperties.this.store();
            }
        }

        public Object getValue() {
            this.updateProperties();
            this.m_value = BusComponentConfigurationProperties.this.m_config.getActivationPoolingPolicy();
            return this.m_value;
        }

        public boolean hasValue() {
            return true;
        }

        public String getHelpTopic() {
            return "ccf_buscomponent_activationpoolingpolicy";
        }

        private void updateProperties() {
            String string = BusComponentConfigurationProperties.this.m_config.getActivationType();
            boolean bl = string.length() > 0;
            String string2 = BusComponentConfigurationProperties.this.m_config.getActivationPoolingPolicy();
            if (bl && string2.equals("limitedshared")) {
                BusComponentConfigurationProperties.this.m_maxReferencesProperty.setEditable(true);
                BusComponentConfigurationProperties.this.m_maxConnectionsProperty.setEditable(false);
                BusComponentConfigurationProperties.this.m_keepAliveTimeProperty.setEditable(false);
            } else if (bl && string2.equals("limitedconnection")) {
                BusComponentConfigurationProperties.this.m_maxReferencesProperty.setEditable(true);
                BusComponentConfigurationProperties.this.m_maxConnectionsProperty.setEditable(true);
                BusComponentConfigurationProperties.this.m_keepAliveTimeProperty.setEditable(true);
            } else {
                BusComponentConfigurationProperties.this.m_maxReferencesProperty.setEditable(false);
                BusComponentConfigurationProperties.this.m_maxConnectionsProperty.setEditable(false);
                BusComponentConfigurationProperties.this.m_keepAliveTimeProperty.setEditable(false);
            }
        }
    }

    private class ActivationServiceReferenceProperty
    extends Property
    implements IContextHelp {
        private Object m_value;

        public ActivationServiceReferenceProperty() {
            super("Service Reference", BusComponentConfigurationProperties.HELP_ACTIVATIONSERVICEREFERENCE, class$java$lang$String == null ? (class$java$lang$String = BusComponentConfigurationProperties.class$("java.lang.String")) : class$java$lang$String, "Activation");
            String string = BusComponentConfigurationProperties.this.m_config.getActivationType();
            if (string.equalsIgnoreCase("asm")) {
                this.setEditorContext(ServiceRefCellEditor.CONTEXT_ASM);
            } else if (string.equalsIgnoreCase("execbaan")) {
                this.setEditorContext(ServiceRefCellEditor.CONTEXT_EXECBAAN);
            } else if (string.equalsIgnoreCase("execcmd")) {
                this.setEditorContext(ServiceRefCellEditor.CONTEXT_EXECCMD);
            } else if (string.equalsIgnoreCase("inproc")) {
                this.setEditorContext(ServiceRefCellEditor.CONTEXT_INPROC);
            } else if (string.equalsIgnoreCase("execlx")) {
                this.setEditorContext(ServiceRefCellEditor.CONTEXT_EXECLX);
            } else {
                this.setEditorContext(null);
            }
        }

        public void setValue(Object object) {
            if (object != null && !object.equals(this.m_value)) {
                BusComponentConfigurationProperties.this.m_config.setActivationServiceReference((String)object);
                BusComponentConfigurationProperties.this.store();
            }
        }

        public Object getValue() {
            this.m_value = BusComponentConfigurationProperties.this.m_config.getActivationServiceReference();
            return this.m_value;
        }

        public boolean hasValue() {
            return true;
        }

        public String getHelpTopic() {
            return "ccf_buscomponent_activationservicereference";
        }
    }

    private class ActivationTypeProperty
    extends Property
    implements IContextHelp {
        private String m_type;

        public ActivationTypeProperty() {
            super("Type", BusComponentConfigurationProperties.HELP_ACTIVATIONTYPE, class$java$lang$String == null ? (class$java$lang$String = BusComponentConfigurationProperties.class$("java.lang.String")) : class$java$lang$String, "Activation");
            this.setEditorContext(ActivationTypeCellEditor.CONTEXT);
        }

        public void setValue(Object object) {
            if (object != null && !object.equals(this.m_type)) {
                String string = (String)object;
                if (string.equals("Activation Disabled")) {
                    string = "";
                }
                if (string.equals("") || string.equals("asm") || string.equals("execbaan") || string.equals("execcmd") || string.equals("inproc") || string.equals("execlx")) {
                    BusComponentConfigurationProperties.this.m_config.setActivationType(string);
                    BusComponentConfigurationProperties.this.m_config.setActivationServiceReference("");
                    BusComponentConfigurationProperties.this.store();
                    if (string.length() > 0) {
                        this.updateProperties();
                        JOptionPane.showMessageDialog(null, "The Activation Type is changed,\nyou must also change the Service Reference.", "Warning", 2);
                        BusComponentConfigurationProperties.this.m_table.setSelectedProperty((Property)BusComponentConfigurationProperties.this.m_serviceReferenceProperty);
                    }
                }
            }
        }

        public Object getValue() {
            this.updateProperties();
            this.m_type = BusComponentConfigurationProperties.this.m_config.getActivationType();
            if (this.m_type.equals("")) {
                this.m_type = "Activation Disabled";
            }
            return this.m_type;
        }

        public boolean hasValue() {
            return true;
        }

        public String getHelpTopic() {
            return "ccf_buscomponent_activationtype";
        }

        private void updateProperties() {
            String string = BusComponentConfigurationProperties.this.m_config.getActivationType();
            boolean bl = string.length() > 0;
            BusComponentConfigurationProperties.this.m_serviceReferenceProperty.setEditable(bl);
            BusComponentConfigurationProperties.this.m_poolingPolicyProperty.setEditable(bl);
            BusComponentConfigurationProperties.this.m_maxReferencesProperty.setEditable(bl);
            BusComponentConfigurationProperties.this.m_maxConnectionsProperty.setEditable(bl);
            BusComponentConfigurationProperties.this.m_poolingServiceProperty.setEditable(bl);
            BusComponentConfigurationProperties.this.m_keepAliveTimeProperty.setEditable(bl);
            BusComponentConfigurationProperties.this.m_serverTimeoutProperty.setEditable(bl);
            if (string.equalsIgnoreCase("asm")) {
                BusComponentConfigurationProperties.this.m_serviceReferenceProperty.setEditorContext(ServiceRefCellEditor.CONTEXT_ASM);
            } else if (string.equalsIgnoreCase("execbaan")) {
                BusComponentConfigurationProperties.this.m_serviceReferenceProperty.setEditorContext(ServiceRefCellEditor.CONTEXT_EXECBAAN);
            } else if (string.equalsIgnoreCase("execcmd")) {
                BusComponentConfigurationProperties.this.m_serviceReferenceProperty.setEditorContext(ServiceRefCellEditor.CONTEXT_EXECCMD);
            } else if (string.equalsIgnoreCase("inproc")) {
                BusComponentConfigurationProperties.this.m_serviceReferenceProperty.setEditorContext(ServiceRefCellEditor.CONTEXT_INPROC);
            } else if (string.equalsIgnoreCase("execlx")) {
                BusComponentConfigurationProperties.this.m_serviceReferenceProperty.setEditorContext(ServiceRefCellEditor.CONTEXT_EXECLX);
            } else {
                BusComponentConfigurationProperties.this.m_serviceReferenceProperty.setEditorContext(null);
            }
        }
    }

    private class PasswordProperty
    extends Property
    implements IContextHelp {
        private static final String s_default = "*******";

        public PasswordProperty() {
            super("Password", BusComponentConfigurationProperties.HELP_PASSWORD, class$java$lang$String == null ? (class$java$lang$String = BusComponentConfigurationProperties.class$("java.lang.String")) : class$java$lang$String, "Default User Session");
            this.setEditorContext(PasswordFieldCellEditor.CONTEXT);
        }

        public void setValue(Object object) {
            if (!s_default.equals(object)) {
                BusComponentConfigurationProperties.this.m_config.setPassword((String)object, false);
                BusComponentConfigurationProperties.this.store();
            }
        }

        public Object getValue() {
            return s_default;
        }

        public boolean hasValue() {
            return true;
        }

        public String getHelpTopic() {
            return "ccf_buscomponent_password";
        }
    }

    private class UsernameProperty
    extends Property
    implements IContextHelp {
        private Object m_value;

        public UsernameProperty() {
            super("Username", BusComponentConfigurationProperties.HELP_USERNAME, class$java$lang$String == null ? (class$java$lang$String = BusComponentConfigurationProperties.class$("java.lang.String")) : class$java$lang$String, "Default User Session");
        }

        public void setValue(Object object) {
            if (object != null && !object.equals(this.m_value)) {
                BusComponentConfigurationProperties.this.m_config.setUsername((String)object, false);
                BusComponentConfigurationProperties.this.store();
            }
        }

        public Object getValue() {
            this.m_value = BusComponentConfigurationProperties.this.m_config.getUsername();
            return this.m_value;
        }

        public boolean hasValue() {
            return true;
        }

        public String getHelpTopic() {
            return "ccf_buscomponent_username";
        }
    }

    private class DefaultUserSessionProperty
    extends Property
    implements IContextHelp {
        private Object m_value;

        public DefaultUserSessionProperty() {
            super("Enabled", BusComponentConfigurationProperties.HELP_DEFAULTUSERSESSION, class$java$lang$Boolean == null ? (class$java$lang$Boolean = BusComponentConfigurationProperties.class$("java.lang.Boolean")) : class$java$lang$Boolean, "Default User Session");
        }

        public void setValue(Object object) {
            if (object != null && !object.equals(this.m_value)) {
                BusComponentConfigurationProperties.this.m_config.setDefaultUserSession((Boolean)object);
                BusComponentConfigurationProperties.this.store();
            }
        }

        public Object getValue() {
            this.updateProperties();
            this.m_value = new Boolean(BusComponentConfigurationProperties.this.m_config.hasDefaultUserSession());
            return this.m_value;
        }

        public boolean hasValue() {
            return true;
        }

        public String getHelpTopic() {
            return "ccf_buscomponent_defaultusersession";
        }

        private void updateProperties() {
            boolean bl = BusComponentConfigurationProperties.this.m_config.hasDefaultUserSession();
            BusComponentConfigurationProperties.this.m_usernameProperty.setEditable(bl);
            BusComponentConfigurationProperties.this.m_passwordProperty.setEditable(bl);
        }
    }

    private class CategoriesProperty
    extends Property
    implements IContextHelp {
        private Object m_value;

        public CategoriesProperty() {
            super("Categories", BusComponentConfigurationProperties.HELP_CATEGORIES, array$Ljava$lang$String == null ? (array$Ljava$lang$String = BusComponentConfigurationProperties.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, "General");
            this.setEditorContext(CONTEXT_CATEGORIES);
        }

        public void setValue(Object object) {
            if (object != null && object.getClass().isArray() && !object.equals(this.m_value)) {
                BusComponentConfigurationProperties.this.m_config.setCategories((String[])object);
                BusComponentConfigurationProperties.this.store();
            }
        }

        public Object getValue() {
            this.m_value = BusComponentConfigurationProperties.this.m_config.getCategories();
            return this.m_value;
        }

        public boolean hasValue() {
            return true;
        }

        public String getHelpTopic() {
            return "ccf_buscomponent_categories";
        }
    }

    private class ConnectionPointsProperty
    extends Property
    implements IContextHelp {
        private Object m_value;

        public ConnectionPointsProperty() {
            super("Connection Points", BusComponentConfigurationProperties.HELP_CONNECTIONPOINTS, array$Ljava$lang$String == null ? (array$Ljava$lang$String = BusComponentConfigurationProperties.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, "General");
            this.setEditorContext(CONTEXT_CONNECTIONPOINTS);
        }

        public void setValue(Object object) {
            block2: {
                if (object == null || !object.getClass().isArray() || object.equals(this.m_value)) break block2;
                try {
                    BusComponentConfigurationProperties.this.m_config.setConnectionPoints((String[])object);
                    BusComponentConfigurationProperties.this.store();
                }
                catch (OWConfigurationException oWConfigurationException) {
                    JOptionPane.showMessageDialog(null, oWConfigurationException.getMessage(), "Error", 0);
                }
            }
        }

        public Object getValue() {
            this.m_value = BusComponentConfigurationProperties.this.m_config.getConnectionPoints();
            return this.m_value;
        }

        public boolean hasValue() {
            return true;
        }

        public String getHelpTopic() {
            return "ccf_buscomponent_connectionpoints";
        }
    }

    private class CompanyNumberProperty
    extends Property
    implements IContextHelp {
        private Object m_value;

        public CompanyNumberProperty() {
            super("Company Number", BusComponentConfigurationProperties.HELP_COMPANYNUMBER, class$java$lang$Integer == null ? (class$java$lang$Integer = BusComponentConfigurationProperties.class$("java.lang.Integer")) : class$java$lang$Integer, "SSA\u00ae ERP(ln)");
        }

        public void setValue(Object object) {
            if (object != null) {
                if (!object.equals(this.m_value)) {
                    int n = (Integer)object;
                    if (n >= 0 && n <= 999) {
                        BusComponentConfigurationProperties.this.m_config.setCompanyNumber(n);
                        BusComponentConfigurationProperties.this.store();
                    } else {
                        JOptionPane.showMessageDialog(null, "The company number must be in the range 0-999 or leave empty to use the default company\nnumber (that is the company number of the user who started the server).", "Error", 0);
                    }
                }
            } else if (this.m_value != null) {
                BusComponentConfigurationProperties.this.m_config.setCompanyNumber(-1);
                BusComponentConfigurationProperties.this.store();
            }
        }

        public Object getValue() {
            int n = BusComponentConfigurationProperties.this.m_config.getCompanyNumber();
            this.m_value = n >= 0 ? new Integer(n) : null;
            return this.m_value;
        }

        public boolean hasValue() {
            return true;
        }

        public String getHelpTopic() {
            return "ccf_buscomponent_companynumber";
        }
    }

    private class AdministratorProperty
    extends Property
    implements IContextHelp {
        private Object m_value;

        public AdministratorProperty() {
            super("Administrator", BusComponentConfigurationProperties.HELP_ADMINISTRATOR, class$java$lang$String == null ? (class$java$lang$String = BusComponentConfigurationProperties.class$("java.lang.String")) : class$java$lang$String, "General");
        }

        public void setValue(Object object) {
            if (object != null && !object.equals(this.m_value)) {
                BusComponentConfigurationProperties.this.m_config.setAdministrator((String)object);
                BusComponentConfigurationProperties.this.store();
            }
        }

        public Object getValue() {
            this.m_value = BusComponentConfigurationProperties.this.m_config.getAdministrator();
            return this.m_value;
        }

        public boolean hasValue() {
            return true;
        }

        public String getHelpTopic() {
            return "ccf_buscomponent_administrator";
        }
    }

    private class OwnerProperty
    extends Property
    implements IContextHelp {
        private Object m_value;

        public OwnerProperty() {
            super("Owner", BusComponentConfigurationProperties.HELP_OWNER, class$java$lang$String == null ? (class$java$lang$String = BusComponentConfigurationProperties.class$("java.lang.String")) : class$java$lang$String, "General");
        }

        public void setValue(Object object) {
            if (object != null && !object.equals(this.m_value)) {
                BusComponentConfigurationProperties.this.m_config.setOwner((String)object);
                BusComponentConfigurationProperties.this.store();
            }
        }

        public Object getValue() {
            this.m_value = BusComponentConfigurationProperties.this.m_config.getOwner();
            return this.m_value;
        }

        public boolean hasValue() {
            return true;
        }

        public String getHelpTopic() {
            return "ccf_buscomponent_owner";
        }
    }

    private class DescriptionProperty
    extends Property
    implements IContextHelp {
        private Object m_value;

        public DescriptionProperty() {
            super("Description", BusComponentConfigurationProperties.HELP_DESCRIPTION, class$java$lang$String == null ? (class$java$lang$String = BusComponentConfigurationProperties.class$("java.lang.String")) : class$java$lang$String, "General");
        }

        public void setValue(Object object) {
            if (object != null && !object.equals(this.m_value)) {
                BusComponentConfigurationProperties.this.m_config.setDescription((String)object);
                BusComponentConfigurationProperties.this.store();
            }
        }

        public Object getValue() {
            this.m_value = BusComponentConfigurationProperties.this.m_config.getDescription();
            return this.m_value;
        }

        public boolean hasValue() {
            return true;
        }

        public String getHelpTopic() {
            return "ccf_buscomponent_description";
        }
    }

    private class GenericProperty
    extends Property
    implements IContextHelp {
        private Object m_value;
        private String m_helpTopic;
        private String m_ldapId;
        private Class m_class;

        public GenericProperty(String string, Class clazz, String string2, String string3, String string4, String string5) {
            super(string, string2, clazz, string3);
            this.m_helpTopic = string4;
            this.m_ldapId = string5;
            this.m_class = clazz;
        }

        public void setValue(Object object) {
            String string = "";
            if (object != null) {
                string = object.toString();
            }
            if (object == null && this.m_value != null || object != null && !object.equals(this.m_value)) {
                BusComponentConfigurationProperties.this.m_config.setValue(this.m_ldapId, string);
                BusComponentConfigurationProperties.this.store();
            }
        }

        public Object getValue() {
            String string = BusComponentConfigurationProperties.this.m_config.getValue(this.m_ldapId);
            if (string == null) {
                this.m_value = null;
                return null;
            }
            try {
                Constructor constructor = this.m_class.getConstructor(class$java$lang$String == null ? (class$java$lang$String = BusComponentConfigurationProperties.class$("java.lang.String")) : class$java$lang$String);
                this.m_value = constructor.newInstance(string);
            }
            catch (Exception exception) {
                this.m_value = null;
            }
            return this.m_value;
        }

        public boolean hasValue() {
            return true;
        }

        public String getHelpTopic() {
            return this.m_helpTopic;
        }
    }

    private class HiddenGenericProperty
    extends GenericProperty
    implements IContextHelp {
        private static final String s_default = "*******";

        public HiddenGenericProperty(String string, Class clazz, String string2, String string3, String string4, String string5) {
            super(string, clazz, string2, string3, string4, string5);
        }

        public Object getValue() {
            return s_default;
        }

        public void setValue(Object object) {
            if (!s_default.equals(object)) {
                super.setValue(object);
            }
        }
    }

    private class BusComponentProperty
    extends GenericProperty
    implements IContextHelp {
        private static final String s_none = "";

        public BusComponentProperty(String string, Class clazz, String string2, String string3, String string4, String string5) {
            super(string, clazz, string2, string3, string4, string5);
            this.setEditorContext(BusComponentCellEditor.CONTEXT);
        }

        public void setValue(Object object) {
            if (object == null || object.equals("<none>")) {
                object = s_none;
            }
            super.setValue(object);
        }

        public Object getValue() {
            Object object = super.getValue();
            if (object == null || object.equals(s_none)) {
                object = "<none>";
            }
            return object;
        }
    }
}

