/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owtools.ccf.ui.grid;

import com.baan.owimpl.fw.ccf.AdapterClientConfiguration;
import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.baan.owtools.ccf.ui.IContextHelp;
import com.baan.owtools.ccf.ui.grid.BusComponentCellEditor;
import com.baan.owtools.ccf.ui.grid.ConfigurationProperties;
import com.jidesoft.grid.CellEditorManager;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.ListComboBoxCellEditor;
import com.jidesoft.grid.Property;
import javax.swing.CellEditor;
import javax.swing.JOptionPane;

public class AdapterClientConfigurationProperties
extends ConfigurationProperties {
    private static final String HELP_ITERATORSIZE = "The iterator size is the number of elements that are received in one fetch.";
    private static final String HELP_TIMEOUT = "The time in milliseconds to wait for an answer before the client Adapter times out when performing a request to another Adapter. Setting this value to 0 indicates no timeout.";
    private static final String HELP_CLIENTBUSCOMPONENT = "This property is used to identify local clients. Leave this field empty for anonymous clients.";
    private static final String HELP_DEFAULTBACKEND = "The default backend is the backend that a manager will connect to when you make a call with that manager.";
    private AdapterClientConfiguration m_config;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public AdapterClientConfigurationProperties(AdapterClientConfiguration adapterClientConfiguration) {
        this.m_config = adapterClientConfiguration;
        this.addProperty(new ConfigurationProperties.TypeProperty(this, this.m_config));
        this.addProperty(new ConfigurationProperties.MachineProperty(this, this.m_config));
        this.addProperty(new ConfigurationProperties.UserProperty(this, this.m_config));
        this.addProperty(new ConfigurationProperties.ApplicationProperty(this, this.m_config));
        this.addProperty(new ConfigurationProperties.ModificationDateProperty(this, this.m_config));
        this.addProperty(new ConfigurationProperties.ModificationUserProperty(this, this.m_config));
        this.addProperty(new IteratorSizeProperty());
        this.addProperty(new TimeoutProperty());
        this.addProperty(new ClientBusComponentProperty());
        this.addProperty(new DefaultBackendProperty());
    }

    private void store() {
        try {
            this.m_config.store();
            this.refresh();
        }
        catch (OWConfigurationException oWConfigurationException) {
            JOptionPane.showMessageDialog(null, oWConfigurationException.toString(), "Update Failed", 0);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        CellEditorManager.registerEditor((Class)(class$java$lang$String == null ? (class$java$lang$String = AdapterClientConfigurationProperties.class$("java.lang.String")) : class$java$lang$String), (CellEditor)((Object)new ProtocolCellEditor()), (EditorContext)ProtocolCellEditor.CONTEXT);
    }

    public static class ProtocolCellEditor
    extends ListComboBoxCellEditor {
        public static final EditorContext CONTEXT = new EditorContext("ProtocolContext");

        public ProtocolCellEditor() {
            super(new Object[]{"socket", "mqseries", "msmq"});
        }
    }

    private class NumberParsersProperty
    extends Property
    implements IContextHelp {
        public NumberParsersProperty() {
            super("Number of XML Parsers", "", class$java$lang$Integer == null ? (class$java$lang$Integer = AdapterClientConfigurationProperties.class$("java.lang.Integer")) : class$java$lang$Integer, "Advanced");
        }

        public void setValue(Object object) {
            if (object != null) {
                AdapterClientConfigurationProperties.this.m_config.setNumberOfParsers((Integer)object);
                AdapterClientConfigurationProperties.this.store();
            }
        }

        public Object getValue() {
            return new Integer(AdapterClientConfigurationProperties.this.m_config.getNumberOfParsers());
        }

        public boolean hasValue() {
            return true;
        }

        public String getHelpTopic() {
            return "ccf_adapterclient_numberparsers";
        }
    }

    private class MaxReadersProperty
    extends Property
    implements IContextHelp {
        public MaxReadersProperty() {
            super("Maximum number of readers", "", class$java$lang$Integer == null ? (class$java$lang$Integer = AdapterClientConfigurationProperties.class$("java.lang.Integer")) : class$java$lang$Integer, "Advanced");
        }

        public void setValue(Object object) {
            if (object != null) {
                AdapterClientConfigurationProperties.this.m_config.setMaxReaders((Integer)object);
                AdapterClientConfigurationProperties.this.store();
            }
        }

        public Object getValue() {
            return new Integer(AdapterClientConfigurationProperties.this.m_config.getMaxReaders());
        }

        public boolean hasValue() {
            return true;
        }

        public String getHelpTopic() {
            return "ccf_adapterclient_maxreaders";
        }
    }

    private class DefaultProtocolProperty
    extends Property
    implements IContextHelp {
        public DefaultProtocolProperty() {
            super("Default Protocol", "", class$java$lang$String == null ? (class$java$lang$String = AdapterClientConfigurationProperties.class$("java.lang.String")) : class$java$lang$String, "Advanced");
            this.setEditorContext(ProtocolCellEditor.CONTEXT);
        }

        public void setValue(Object object) {
            AdapterClientConfigurationProperties.this.m_config.setDefaultProtocol((String)object);
            AdapterClientConfigurationProperties.this.store();
        }

        public Object getValue() {
            return AdapterClientConfigurationProperties.this.m_config.getDefaultProtocol();
        }

        public boolean hasValue() {
            return true;
        }

        public String getHelpTopic() {
            return "ccf_adapterclient_defaultprotocol";
        }
    }

    private class DefaultBackendProperty
    extends Property
    implements IContextHelp {
        private Object m_value;

        public DefaultBackendProperty() {
            super("Default Backend", AdapterClientConfigurationProperties.HELP_DEFAULTBACKEND, class$java$lang$String == null ? (class$java$lang$String = AdapterClientConfigurationProperties.class$("java.lang.String")) : class$java$lang$String, "General");
            this.setEditorContext(BusComponentCellEditor.CONTEXT);
        }

        public void setValue(Object object) {
            if (object != null && !object.equals(this.m_value)) {
                if (object.equals("<none>")) {
                    object = "";
                }
                AdapterClientConfigurationProperties.this.m_config.setDefaultBackend((String)object);
                AdapterClientConfigurationProperties.this.store();
            }
        }

        public Object getValue() {
            this.m_value = AdapterClientConfigurationProperties.this.m_config.getDefaultBackend();
            if (this.m_value.equals("")) {
                this.m_value = "<none>";
            }
            return this.m_value;
        }

        public boolean hasValue() {
            return true;
        }

        public String getHelpTopic() {
            return "ccf_adapterclient_defaultbackend";
        }
    }

    private class ClientBusComponentProperty
    extends Property
    implements IContextHelp {
        private Object m_value;

        public ClientBusComponentProperty() {
            super("Client BusComponent", AdapterClientConfigurationProperties.HELP_CLIENTBUSCOMPONENT, class$java$lang$String == null ? (class$java$lang$String = AdapterClientConfigurationProperties.class$("java.lang.String")) : class$java$lang$String, "General");
            this.setEditorContext(BusComponentCellEditor.CONTEXT);
        }

        public void setValue(Object object) {
            if (object != null && !object.equals(this.m_value)) {
                if (object.equals("<none>")) {
                    object = "";
                }
                AdapterClientConfigurationProperties.this.m_config.setClientBusComponent((String)object);
                AdapterClientConfigurationProperties.this.store();
            }
        }

        public Object getValue() {
            this.m_value = AdapterClientConfigurationProperties.this.m_config.getClientBusComponent();
            if (this.m_value.equals("")) {
                this.m_value = "<none>";
            }
            return this.m_value;
        }

        public boolean hasValue() {
            return true;
        }

        public String getHelpTopic() {
            return "ccf_adapterclient_clientbuscomponent";
        }
    }

    private class TimeoutProperty
    extends Property
    implements IContextHelp {
        private Object m_value;

        public TimeoutProperty() {
            super("Timeout", AdapterClientConfigurationProperties.HELP_TIMEOUT, class$java$lang$Integer == null ? (class$java$lang$Integer = AdapterClientConfigurationProperties.class$("java.lang.Integer")) : class$java$lang$Integer, "General");
        }

        public void setValue(Object object) {
            if (object != null) {
                if (!object.equals(this.m_value)) {
                    int n = (Integer)object;
                    if (n >= 0) {
                        AdapterClientConfigurationProperties.this.m_config.setTimeout(n);
                        AdapterClientConfigurationProperties.this.store();
                    } else {
                        JOptionPane.showMessageDialog(null, "Timeout must be a non-negative number.", "Error", 0);
                    }
                }
            } else {
                JOptionPane.showMessageDialog(null, "Timeout must be a non-negative number.", "Error", 0);
            }
        }

        public Object getValue() {
            this.m_value = new Integer(AdapterClientConfigurationProperties.this.m_config.getTimeout());
            return this.m_value;
        }

        public boolean hasValue() {
            return true;
        }

        public String getHelpTopic() {
            return "ccf_adapterclient_timeout";
        }
    }

    private class IteratorSizeProperty
    extends Property
    implements IContextHelp {
        private Object m_value;

        public IteratorSizeProperty() {
            super("Iterator Size", AdapterClientConfigurationProperties.HELP_ITERATORSIZE, class$java$lang$Integer == null ? (class$java$lang$Integer = AdapterClientConfigurationProperties.class$("java.lang.Integer")) : class$java$lang$Integer, "General");
        }

        public void setValue(Object object) {
            if (object != null) {
                if (!object.equals(this.m_value)) {
                    int n = (Integer)object;
                    if (n > 0) {
                        AdapterClientConfigurationProperties.this.m_config.setIteratorSize(n);
                        AdapterClientConfigurationProperties.this.store();
                    } else {
                        JOptionPane.showMessageDialog(null, "Iterator Size must be a positive number.", "Error", 0);
                    }
                }
            } else {
                JOptionPane.showMessageDialog(null, "Iterator Size must be a positive number.", "Error", 0);
            }
        }

        public Object getValue() {
            this.m_value = new Integer(AdapterClientConfigurationProperties.this.m_config.getIteratorSize());
            return this.m_value;
        }

        public boolean hasValue() {
            return true;
        }

        public String getHelpTopic() {
            return "ccf_adapterclient_iteratorsize";
        }
    }
}

