/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owtools.ccf.ui;

import com.baan.owimpl.fw.ccf.AdapterClientContext;
import com.baan.owimpl.fw.ccf.BusComponentCategoryContext;
import com.baan.owimpl.fw.ccf.BusComponentContext;
import com.baan.owimpl.fw.ccf.IdentifierContext;
import com.baan.owimpl.fw.ccf.LoggingContext;
import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.baan.owimpl.fw.ccf.SOAPConnectorContext;
import com.baan.owimpl.fw.ccf.SmartContext;
import com.baan.owimpl.fw.ccf.XMLConnectorContext;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.baan.owtools.ccf.ui.ConfigBrowser;
import com.baan.owtools.ccf.ui.actions.RefreshAction;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ImportDialog
extends JDialog {
    private static final ILogger s_logger = LoggerFactory.createLogger(class$com$baan$owtools$ccf$ui$ImportDialog == null ? (class$com$baan$owtools$ccf$ui$ImportDialog = ImportDialog.class$("com.baan.owtools.ccf.ui.ImportDialog")) : class$com$baan$owtools$ccf$ui$ImportDialog);
    private static final String HELP_TOPIC = "ccf_import";
    private static final String FILE_SEPERATOR = System.getProperty("file.separator");
    public XMLFilter XML_FILTER = new XMLFilter();
    private JButton Button_browse = new JButton();
    private JButton Button_exit = new JButton();
    private JButton Button_Import = new JButton();
    private JLabel Label_filename = new JLabel();
    private JProgressBar progressBar = new JProgressBar();
    private JTextField Text_filename = new JTextField();
    private JCheckBox CheckBox_overwrite = new JCheckBox();
    private JButton jButtonHelp = new JButton();
    private ConfigBrowser m_frame;
    private static String m_filename = "";
    private RefreshAction m_refreshAction;
    static /* synthetic */ Class class$com$baan$owtools$ccf$ui$ImportDialog;

    public ImportDialog(JFrame jFrame, RefreshAction refreshAction) {
        super((Frame)jFrame, true);
        this.m_refreshAction = refreshAction;
        Container container = this.getContentPane();
        this.setFont(new Font("Dialog", 0, 11));
        container.setLayout(null);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ImportDialog.this.exitForm();
            }
        });
        this.m_frame = (ConfigBrowser)jFrame;
        this.m_frame.setHelpTopic(HELP_TOPIC);
        this.jButtonHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImportDialog.this.m_frame.showHelp(ImportDialog.this);
            }
        });
        this.jButtonHelp.setSize(80, 22);
        this.jButtonHelp.setLocation(365, 100);
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.setMnemonic('H');
        this.jButtonHelp.setFont(this.getFont());
        this.getContentPane().add(this.jButtonHelp);
        this.Label_filename.setText("File name:");
        this.Label_filename.setLocation(10, 10);
        this.Label_filename.setFont(this.getFont());
        this.Label_filename.setSize(100, 22);
        this.Label_filename.setToolTipText("The Local File to use");
        container.add(this.Label_filename);
        this.Text_filename.setLocation(100, 10);
        this.Text_filename.setSize(260, 22);
        this.Text_filename.setFont(this.getFont());
        this.Text_filename.setToolTipText("Configuration storage file");
        this.Text_filename.setText(m_filename);
        container.add(this.Text_filename);
        this.Button_browse.setFont(this.getFont());
        this.Button_browse.setMnemonic('B');
        this.Button_browse.setText("Browse...");
        this.Button_browse.setFont(this.getFont());
        this.Button_browse.setLocation(367, 10);
        this.Button_browse.setSize(80, 22);
        this.Button_browse.setToolTipText("Browse for configuration storage file");
        this.Button_browse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImportDialog.this.Button_browseActionPerformed(actionEvent);
            }
        });
        container.add(this.Button_browse);
        this.Button_exit.setSize(80, 22);
        this.Button_exit.setLocation(275, 100);
        this.Button_exit.setMnemonic('C');
        this.Button_exit.setText("Cancel");
        this.Button_exit.setFont(this.getFont());
        container.add(this.Button_exit);
        this.Button_exit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImportDialog.this.exitForm();
            }
        });
        this.Button_Import.setSize(80, 22);
        this.Button_Import.setLocation(185, 100);
        this.Button_Import.setMnemonic('I');
        this.Button_Import.setText("Import");
        this.Button_Import.setFont(this.getFont());
        this.Button_Import.setToolTipText("Start Importing Configurations using Storage File");
        container.add(this.Button_Import);
        this.getRootPane().setDefaultButton(this.Button_Import);
        this.Button_Import.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImportDialog.this.executeImport();
            }
        });
        this.CheckBox_overwrite.setText("Overwrite Configurations");
        this.CheckBox_overwrite.setLocation(100, 42);
        this.CheckBox_overwrite.setSize(200, 20);
        this.CheckBox_overwrite.setToolTipText("Import overwrite all existing objects");
        container.add(this.CheckBox_overwrite);
        this.progressBar.setSize(436, 15);
        this.progressBar.setLocation(10, 72);
        container.add(this.progressBar);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImportDialog.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(keyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", abstractAction);
        this.setTitle("Import Configurations");
        int n = 162;
        int n2 = 463;
        int n3 = jFrame.getSize().height / 2;
        int n4 = jFrame.getSize().width / 2;
        int n5 = n / 2;
        int n6 = n2 / 2;
        ((Component)this).setLocation(jFrame.getLocation().x + n4 - n6, jFrame.getLocation().y + n3 - n5);
        this.setResizable(false);
        ((Component)this).setSize(n2, n);
    }

    private void Button_browseActionPerformed(ActionEvent actionEvent) {
        String string = this.Text_filename.getText();
        int n = string.lastIndexOf(FILE_SEPERATOR);
        if (n > 0) {
            string = string.substring(0, n);
        }
        JFileChooser jFileChooser = new JFileChooser(string);
        jFileChooser.addChoosableFileFilter(this.XML_FILTER);
        jFileChooser.setMultiSelectionEnabled(false);
        int n2 = jFileChooser.showDialog(this, "Select file");
        if (n2 == 0) {
            File file2 = jFileChooser.getSelectedFile();
            String string2 = file2.getAbsolutePath();
            if (!string2.endsWith("." + "xml")) {
                string2 = string2 + "." + "xml";
            }
            this.Text_filename.setText(string2);
        }
    }

    private void executeImport() {
        m_filename = this.Text_filename.getText();
        File file2 = new File(m_filename);
        if (!this.XML_FILTER.accept(file2)) {
            JOptionPane.showMessageDialog(this, "Only an XML File can be used as Configuration Storage File", "Configuration storage file", 0);
            return;
        }
        if (file2.exists() && !file2.canRead()) {
            JOptionPane.showMessageDialog(this, "File cannot be read.\nMake file readable, or select different file", "Configuration storage file", 0);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        new importThread(this, file2, this.progressBar).start();
    }

    private void readIdentifierContextConfigurations(NodeList nodeList) throws OWConfigurationException {
        boolean bl = this.CheckBox_overwrite.isSelected();
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element = (Element)nodeList.item(n);
            String string = element.getAttribute("Id");
            String string2 = element.getAttribute("Type");
            String string3 = element.getFirstChild().getNodeValue();
            IdentifierContext identifierContext = this.getIdentifierContext(string2);
            if (identifierContext != null) {
                s_logger.message("Import Identifier Configuration " + (n + 1) + "/" + nodeList.getLength() + " (" + identifierContext.toString() + ") with id  " + string + ", overwrite = " + bl);
                identifierContext._import(string, string3, bl);
            }
            this.progressBar.setValue(this.progressBar.getValue() + 1);
            ++n;
        }
    }

    private void readSmartContextConfigurations(NodeList nodeList) throws OWConfigurationException {
        boolean bl = this.CheckBox_overwrite.isSelected();
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element = (Element)nodeList.item(n);
            String string = element.getAttribute("Machine");
            String string2 = element.getAttribute("User");
            String string3 = element.getAttribute("Application");
            String string4 = element.getAttribute("Type");
            String string5 = element.getFirstChild().getNodeValue();
            SmartContext smartContext = this.getSmartContext(string4);
            if (smartContext != null) {
                s_logger.message("Import Smart Configuration " + (n + 1) + "/" + nodeList.getLength() + " (" + smartContext.toString() + ") for " + string + ", " + string2 + ", " + string3 + ", overwrite = " + bl);
                smartContext._import(string, string2, string3, string5, bl);
            }
            this.progressBar.setValue(this.progressBar.getValue() + 1);
            ++n;
        }
    }

    private IdentifierContext getIdentifierContext(String string) throws OWConfigurationException {
        if (string.equals("BusComponent")) {
            return BusComponentContext.getInstance();
        }
        if (string.equals("BusComponent Category") || string.equals("BusComponentCategory")) {
            return BusComponentCategoryContext.getInstance();
        }
        try {
            Class<?> clazz = Class.forName(string);
            Method method = clazz.getMethod("getInstance", new Class[0]);
            return (IdentifierContext)method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            s_logger.message("Can't get identifier context from " + string);
            return null;
        }
    }

    private SmartContext getSmartContext(String string) throws OWConfigurationException {
        if (string.equals("Logging")) {
            return LoggingContext.getInstance();
        }
        if (string.equals("Adapter Client")) {
            return AdapterClientContext.getInstance();
        }
        if (string.equals("Connector for XML")) {
            return XMLConnectorContext.getInstance();
        }
        if (string.equals("Connector for SOAP") || string.equals("Web Services")) {
            return SOAPConnectorContext.getInstance();
        }
        try {
            Class<?> clazz = Class.forName(string);
            Method method = clazz.getMethod("getInstance", new Class[0]);
            return (SmartContext)method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            s_logger.message("Can't get smart context from " + string);
            return null;
        }
    }

    private void exitForm() {
        this.dispose();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class XMLFilter
    extends FileFilter {
        public static final String XML = "xml";

        public boolean accept(File file2) {
            if (file2.isDirectory()) {
                return true;
            }
            String string = this.getExtension(file2);
            return string != null && string.equals(XML);
        }

        public String getExtension(File file2) {
            String string = null;
            String string2 = file2.getName();
            int n = string2.lastIndexOf(46);
            if (n > 0 && n < string2.length() - 1) {
                string = string2.substring(n + 1).toLowerCase();
            }
            return string;
        }

        public String getDescription() {
            return "Configuration Storage XML Files";
        }
    }

    private class importThread
    extends Thread {
        private JDialog m_me;
        private File file;
        private JProgressBar m_progressBar;
        int nrObjects = 0;

        public importThread(JDialog jDialog, File file2, JProgressBar jProgressBar) {
            this.m_me = jDialog;
            this.file = file2;
            this.m_progressBar = jProgressBar;
        }

        public void run() {
            boolean bl = false;
            String string = "";
            try {
                s_logger.message("importing Configurations from file '" + m_filename + "'");
                Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.file);
                Element element = (Element)document.getFirstChild();
                Element element2 = (Element)element.getElementsByTagName("ExportData").item(0);
                Element element3 = (Element)element.getElementsByTagName("ConfigurationData").item(0);
                if (element.getNodeName().equals("CentralConfigExport")) {
                    Element element4 = (Element)element2.getElementsByTagName("Date").item(0);
                    String string2 = element4.getFirstChild().getNodeValue();
                    Element element5 = (Element)element2.getElementsByTagName("Name").item(0);
                    String string3 = element5.getFirstChild().getNodeValue();
                    Element element6 = (Element)element2.getElementsByTagName("Version").item(0);
                    String string4 = element6.getFirstChild().getNodeValue();
                    s_logger.message("Configurations file, Version=" + string4 + ", Date=" + string2 + ", User=" + string3);
                    int n = Integer.parseInt(string4);
                    int n2 = Integer.parseInt("4");
                    if (n > n2) {
                        throw new OWConfigurationException("Unsupported import file version");
                    }
                    NodeList nodeList = element3.getElementsByTagName("IdentifierContext");
                    NodeList nodeList2 = element3.getElementsByTagName("SmartContext");
                    this.nrObjects = nodeList.getLength() + nodeList2.getLength();
                    this.m_progressBar.setMinimum(0);
                    this.m_progressBar.setMaximum(this.nrObjects);
                    this.m_progressBar.setValue(0);
                    ImportDialog.this.readIdentifierContextConfigurations(nodeList);
                    ImportDialog.this.readSmartContextConfigurations(nodeList2);
                    bl = true;
                } else {
                    string = "Specified file '" + m_filename + "' is not a valid configurations file.";
                    s_logger.errorMessage(string);
                }
            }
            catch (IOException iOException) {
                ImportDialog.this.setCursor(Cursor.getDefaultCursor());
                string = "Error reading Configurations file '" + m_filename + "', " + iOException.toString();
                s_logger.errorMessage(string);
            }
            catch (OWConfigurationException oWConfigurationException) {
                ImportDialog.this.setCursor(Cursor.getDefaultCursor());
                string = "Error Loading from file, writing to directory: " + oWConfigurationException.toString();
                s_logger.errorMessage(string);
            }
            catch (Exception exception) {
                ImportDialog.this.setCursor(Cursor.getDefaultCursor());
                string = "Error in importing from file '" + m_filename + "'; " + exception.toString();
                s_logger.errorMessage(string);
            }
            ImportDialog.this.setCursor(Cursor.getDefaultCursor());
            if (bl) {
                if (ImportDialog.this.CheckBox_overwrite.isSelected()) {
                    s_logger.message(this.nrObjects + " Configurations from file '" + m_filename + "' have been imported.");
                    JOptionPane.showMessageDialog(this.m_me, this.nrObjects + " Configurations from file:\n'" + m_filename + "'\nhave been imported", "Import Configurations", 1);
                } else {
                    s_logger.message("Configurations from file '" + m_filename + "' have been processed.");
                    JOptionPane.showMessageDialog(this.m_me, "Configurations from file:\n'" + m_filename + "'\nhave been processed", "Import Configurations", 1);
                }
                ImportDialog.this.m_refreshAction.actionPerformed(null);
            } else {
                s_logger.errorMessage("Failed to import all Configurations from file '" + m_filename + "'");
                JOptionPane.showMessageDialog(this.m_me, "Import Failed\n" + string, "Import Configurations", 0);
            }
            ImportDialog.this.exitForm();
        }
    }
}

