/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owtools.ccf.ui;

import com.baan.owimpl.fw.ccf.AdapterClientContext;
import com.baan.owimpl.fw.ccf.BusComponentCategoryContext;
import com.baan.owimpl.fw.ccf.BusComponentContext;
import com.baan.owimpl.fw.ccf.IdentifierContext;
import com.baan.owimpl.fw.ccf.LoggingContext;
import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.baan.owimpl.fw.ccf.SOAPConnectorContext;
import com.baan.owimpl.fw.ccf.SmartContext;
import com.baan.owimpl.fw.ccf.XMLConnectorContext;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.baan.owtools.ccf.ui.ConfigBrowser;
import com.eibus.xml.util.NiceW3CDOMWriter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExportDialog
extends JDialog {
    private static final ILogger s_logger = LoggerFactory.createLogger(class$com$baan$owtools$ccf$ui$ExportDialog == null ? (class$com$baan$owtools$ccf$ui$ExportDialog = ExportDialog.class$("com.baan.owtools.ccf.ui.ExportDialog")) : class$com$baan$owtools$ccf$ui$ExportDialog);
    private static final String HELP_TOPIC = "ccf_export";
    private static final String FILE_SEPERATOR = System.getProperty("file.separator");
    public static final String EXPORT_FILE_ROOT_TAG = "CentralConfigExport";
    public static final String EXPORT_EXPORT_DATA_TAG = "ExportData";
    public static final String EXPORT_IDENTIFIERCONTEXT_TAG = "IdentifierContext";
    public static final String EXPORT_SMARTCONTEXT_TAG = "SmartContext";
    public static final String EXPORT_CONFIGURATION_DATA_TAG = "ConfigurationData";
    public static final String EXPORT_DATE_TAG = "Date";
    public static final String EXPORT_NAME_TAG = "Name";
    public static final String EXPORT_VERSION_TAG = "Version";
    public static final String EXPORT_TYPE_TAG = "Type";
    public static final String EXPORT_ID_TAG = "Id";
    public static final String EXPORT_MACHINE_TAG = "Machine";
    public static final String EXPORT_USER_TAG = "User";
    public static final String EXPORT_APPLICATION_TAG = "Application";
    public static final String EXPORT_VERSION = "4";
    public XMLFilter XML_FILTER = new XMLFilter();
    private JButton Button_browse = new JButton();
    private JButton Button_exit = new JButton();
    private JButton Button_Export = new JButton();
    private JLabel Label_filename = new JLabel();
    private JProgressBar progressBar = new JProgressBar();
    private JTextField Text_filename = new JTextField();
    private JButton jButtonHelp = new JButton();
    private JCheckBox jCB_BusComponentCategories = new JCheckBox();
    private JCheckBox jCB_BusComponents = new JCheckBox();
    private JCheckBox jCB_Logging = new JCheckBox();
    private JCheckBox jCB_AdapterClient = new JCheckBox();
    private JCheckBox jCB_XMLConnector = new JCheckBox();
    private JCheckBox jCB_SOAPConnector = new JCheckBox();
    private ConfigBrowser m_frame;
    private static String m_filename = "";
    static /* synthetic */ Class class$com$baan$owtools$ccf$ui$ExportDialog;

    public ExportDialog(JFrame jFrame) {
        super((Frame)jFrame, true);
        Container container = this.getContentPane();
        this.setFont(new Font("Dialog", 0, 11));
        container.setLayout(null);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ExportDialog.this.exitForm();
            }
        });
        this.m_frame = (ConfigBrowser)jFrame;
        this.m_frame.setHelpTopic(HELP_TOPIC);
        this.jButtonHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExportDialog.this.m_frame.showHelp(ExportDialog.this);
            }
        });
        this.jButtonHelp.setSize(80, 22);
        this.jButtonHelp.setLocation(365, 200);
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.setMnemonic('H');
        this.jButtonHelp.setFont(this.getFont());
        this.getContentPane().add(this.jButtonHelp);
        this.Label_filename.setText("File name:");
        this.Label_filename.setLocation(10, 10);
        this.Label_filename.setFont(this.getFont());
        this.Label_filename.setSize(100, 22);
        this.Label_filename.setToolTipText("The Local File to use");
        container.add(this.Label_filename);
        this.Text_filename.setLocation(100, 10);
        this.Text_filename.setSize(260, 22);
        this.Text_filename.setFont(this.getFont());
        this.Text_filename.setToolTipText("Configuration storage file");
        this.Text_filename.setText(m_filename);
        container.add(this.Text_filename);
        this.Button_browse.setFont(this.getFont());
        this.Button_browse.setMnemonic('B');
        this.Button_browse.setText("Browse...");
        this.Button_browse.setFont(this.getFont());
        this.Button_browse.setLocation(367, 10);
        this.Button_browse.setSize(80, 22);
        this.Button_browse.setToolTipText("Browse for configuration storage file");
        this.Button_browse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExportDialog.this.Button_browseActionPerformed(actionEvent);
            }
        });
        container.add(this.Button_browse);
        this.Button_exit.setSize(80, 22);
        this.Button_exit.setLocation(275, 200);
        this.Button_exit.setMnemonic('C');
        this.Button_exit.setText("Cancel");
        this.Button_exit.setFont(this.getFont());
        container.add(this.Button_exit);
        this.Button_exit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExportDialog.this.exitForm();
            }
        });
        this.Button_Export.setSize(80, 22);
        this.Button_Export.setLocation(185, 200);
        this.Button_Export.setText("Export");
        this.Button_Export.setMnemonic('E');
        this.Button_Export.setFont(this.getFont());
        this.Button_Export.setToolTipText("Start Exporting Configurations using Storage File");
        container.add(this.Button_Export);
        this.getRootPane().setDefaultButton(this.Button_Export);
        this.Button_Export.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExportDialog.this.executeExport();
            }
        });
        this.progressBar.setSize(436, 15);
        this.progressBar.setLocation(10, 172);
        container.add(this.progressBar);
        this.jCB_BusComponentCategories.setText("BusComponent Categories");
        this.jCB_BusComponentCategories.setLocation(100, 42);
        this.jCB_BusComponentCategories.setSize(220, 20);
        this.jCB_BusComponentCategories.setToolTipText("Export BusComponent Category Configuration");
        this.jCB_BusComponentCategories.setSelected(true);
        container.add(this.jCB_BusComponentCategories);
        this.jCB_BusComponents.setText("BusComponents");
        this.jCB_BusComponents.setLocation(100, 62);
        this.jCB_BusComponents.setSize(120, 20);
        this.jCB_BusComponents.setToolTipText("Export BusComponent Configuration");
        this.jCB_BusComponents.setSelected(true);
        container.add(this.jCB_BusComponents);
        this.jCB_Logging.setText("Logging");
        this.jCB_Logging.setLocation(100, 82);
        this.jCB_Logging.setSize(120, 20);
        this.jCB_Logging.setToolTipText("Export Logging Configuration");
        this.jCB_Logging.setSelected(true);
        container.add(this.jCB_Logging);
        this.jCB_AdapterClient.setText("Adapter Client");
        this.jCB_AdapterClient.setLocation(100, 102);
        this.jCB_AdapterClient.setSize(120, 20);
        this.jCB_AdapterClient.setToolTipText("Export Adapter Client Configuration");
        this.jCB_AdapterClient.setSelected(true);
        container.add(this.jCB_AdapterClient);
        this.jCB_XMLConnector.setText("Connector for XML");
        this.jCB_XMLConnector.setLocation(100, 122);
        this.jCB_XMLConnector.setSize(130, 20);
        this.jCB_XMLConnector.setToolTipText("Export Connector for XML Configuration");
        this.jCB_XMLConnector.setSelected(true);
        container.add(this.jCB_XMLConnector);
        this.jCB_SOAPConnector.setText("Connector for SOAP");
        this.jCB_SOAPConnector.setLocation(100, 142);
        this.jCB_SOAPConnector.setSize(150, 20);
        this.jCB_SOAPConnector.setToolTipText("Export Connector for SOAP Configuration");
        this.jCB_SOAPConnector.setSelected(true);
        container.add(this.jCB_SOAPConnector);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExportDialog.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(keyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", abstractAction);
        this.setTitle("Export Configurations");
        int n = 262;
        int n2 = 463;
        int n3 = jFrame.getSize().height / 2;
        int n4 = jFrame.getSize().width / 2;
        int n5 = n / 2;
        int n6 = n2 / 2;
        ((Component)this).setLocation(jFrame.getLocation().x + n4 - n6, jFrame.getLocation().y + n3 - n5);
        this.setResizable(false);
        ((Component)this).setSize(n2, n);
    }

    private void Button_browseActionPerformed(ActionEvent actionEvent) {
        String string = this.Text_filename.getText();
        int n = string.lastIndexOf(FILE_SEPERATOR);
        if (n > 0) {
            string = string.substring(0, n);
        }
        JFileChooser jFileChooser = new JFileChooser(string);
        jFileChooser.addChoosableFileFilter(this.XML_FILTER);
        jFileChooser.setMultiSelectionEnabled(false);
        int n2 = jFileChooser.showDialog(this, "Select file");
        if (n2 == 0) {
            File file2 = jFileChooser.getSelectedFile();
            String string2 = file2.getAbsolutePath();
            if (!string2.endsWith("." + "xml")) {
                string2 = string2 + "." + "xml";
            }
            this.Text_filename.setText(string2);
        }
    }

    private void executeExport() {
        m_filename = this.Text_filename.getText();
        File file2 = new File(m_filename);
        if (!this.XML_FILTER.accept(file2)) {
            JOptionPane.showMessageDialog(this, "Only an XML File can be used as Configuration Storage File", "Configuration storage file", 0);
            return;
        }
        if (file2.exists()) {
            if (!file2.canWrite()) {
                JOptionPane.showMessageDialog(this, "File cannot be written.\nMake file writable, or select different file", "Configuration storage file", 0);
                return;
            }
            int n = JOptionPane.showConfirmDialog(this, "File already exists.\nDo you want to overwrite it?", "Configuration storage file", 0);
            if (n != 0) {
                return;
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        new exportThread(this, file2, this.progressBar).start();
    }

    private void writeIdentifierContext(Document document, Element element, IdentifierContext identifierContext) throws IOException, OWConfigurationException {
        s_logger.message("Export all " + identifierContext.toString());
        String[] stringArray = identifierContext.list();
        int n = 0;
        while (n < stringArray.length) {
            Element element2 = document.createElement(EXPORT_IDENTIFIERCONTEXT_TAG);
            element.appendChild(element2);
            element2.setAttribute(EXPORT_TYPE_TAG, identifierContext.getClass().getName());
            element2.setAttribute(EXPORT_ID_TAG, stringArray[n]);
            s_logger.message("Export " + identifierContext.toString() + " with id " + stringArray[n]);
            String string = identifierContext.export(stringArray[n]);
            element2.appendChild(document.createTextNode(string));
            ++n;
        }
    }

    private void writeSmartContext(Document document, Element element, SmartContext smartContext) throws IOException, OWConfigurationException {
        String[] stringArray = smartContext.listMachines();
        int n = 0;
        while (n < stringArray.length) {
            String[] stringArray2 = smartContext.listUsers(stringArray[n]);
            int n2 = 0;
            while (n2 < stringArray2.length) {
                String[] stringArray3 = smartContext.listApplications(stringArray[n], stringArray2[n2]);
                int n3 = 0;
                while (n3 < stringArray3.length) {
                    Element element2 = document.createElement(EXPORT_SMARTCONTEXT_TAG);
                    element.appendChild(element2);
                    element2.setAttribute(EXPORT_TYPE_TAG, smartContext.getClass().getName());
                    element2.setAttribute(EXPORT_MACHINE_TAG, stringArray[n]);
                    element2.setAttribute(EXPORT_USER_TAG, stringArray2[n2]);
                    element2.setAttribute(EXPORT_APPLICATION_TAG, stringArray3[n3]);
                    s_logger.message("Export " + smartContext.toString() + " with id " + stringArray[n] + ", " + stringArray2[n2] + ", " + stringArray3[n3]);
                    String string = smartContext.export(stringArray[n], stringArray2[n2], stringArray3[n3]);
                    element2.appendChild(document.createTextNode(string));
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }

    private void exitForm() {
        this.dispose();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class XMLFilter
    extends FileFilter {
        public static final String XML = "xml";

        public boolean accept(File file2) {
            if (file2.isDirectory()) {
                return true;
            }
            String string = this.getExtension(file2);
            return string != null && string.equals(XML);
        }

        public String getExtension(File file2) {
            String string = null;
            String string2 = file2.getName();
            int n = string2.lastIndexOf(46);
            if (n > 0 && n < string2.length() - 1) {
                string = string2.substring(n + 1).toLowerCase();
            }
            return string;
        }

        public String getDescription() {
            return "Configuration Storage XML Files";
        }
    }

    private class exportThread
    extends Thread {
        private JDialog m_me;
        private File file;
        private JProgressBar m_progressBar;

        public exportThread(JDialog jDialog, File file2, JProgressBar jProgressBar) {
            this.m_me = jDialog;
            this.file = file2;
            this.m_progressBar = jProgressBar;
        }

        public void run() {
            boolean bl = false;
            try {
                DocumentImpl documentImpl = new DocumentImpl();
                Element element = documentImpl.createElement(ExportDialog.EXPORT_FILE_ROOT_TAG);
                documentImpl.appendChild(element);
                Element element2 = documentImpl.createElement(ExportDialog.EXPORT_EXPORT_DATA_TAG);
                element.appendChild(element2);
                Element element3 = documentImpl.createElement(ExportDialog.EXPORT_DATE_TAG);
                Date date = new Date();
                element3.appendChild(documentImpl.createTextNode(date.toString()));
                Element element4 = documentImpl.createElement(ExportDialog.EXPORT_NAME_TAG);
                String string = System.getProperty("user.name");
                element4.appendChild(documentImpl.createTextNode(string));
                Element element5 = documentImpl.createElement(ExportDialog.EXPORT_VERSION_TAG);
                element5.appendChild(documentImpl.createTextNode(ExportDialog.EXPORT_VERSION));
                element2.appendChild(element5);
                element2.appendChild(element3);
                element2.appendChild(element4);
                Element element6 = documentImpl.createElement(ExportDialog.EXPORT_CONFIGURATION_DATA_TAG);
                element.appendChild(element6);
                ExportDialog.this.progressBar.setMaximum(6);
                ExportDialog.this.progressBar.setMinimum(0);
                ExportDialog.this.progressBar.setValue(0);
                if (ExportDialog.this.jCB_BusComponentCategories.isSelected()) {
                    ExportDialog.this.writeIdentifierContext((Document)documentImpl, element6, BusComponentCategoryContext.getInstance());
                }
                ExportDialog.this.progressBar.setValue(ExportDialog.this.progressBar.getValue() + 1);
                if (ExportDialog.this.jCB_BusComponents.isSelected()) {
                    ExportDialog.this.writeIdentifierContext((Document)documentImpl, element6, BusComponentContext.getInstance());
                }
                ExportDialog.this.progressBar.setValue(ExportDialog.this.progressBar.getValue() + 1);
                if (ExportDialog.this.jCB_Logging.isSelected()) {
                    ExportDialog.this.writeSmartContext((Document)documentImpl, element6, LoggingContext.getInstance());
                }
                ExportDialog.this.progressBar.setValue(ExportDialog.this.progressBar.getValue() + 1);
                if (ExportDialog.this.jCB_AdapterClient.isSelected()) {
                    ExportDialog.this.writeSmartContext((Document)documentImpl, element6, AdapterClientContext.getInstance());
                }
                ExportDialog.this.progressBar.setValue(ExportDialog.this.progressBar.getValue() + 1);
                if (ExportDialog.this.jCB_XMLConnector.isSelected()) {
                    ExportDialog.this.writeSmartContext((Document)documentImpl, element6, XMLConnectorContext.getInstance());
                }
                ExportDialog.this.progressBar.setValue(ExportDialog.this.progressBar.getValue() + 1);
                if (ExportDialog.this.jCB_SOAPConnector.isSelected()) {
                    ExportDialog.this.writeSmartContext((Document)documentImpl, element6, SOAPConnectorContext.getInstance());
                }
                ExportDialog.this.progressBar.setValue(ExportDialog.this.progressBar.getValue() + 1);
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.file));
                NiceW3CDOMWriter niceW3CDOMWriter = new NiceW3CDOMWriter(element, 0, 4);
                bufferedWriter.write(niceW3CDOMWriter.toString());
                bufferedWriter.close();
                s_logger.message("Configurations exported, Version=4, Date=" + date.toString() + ", User=" + string);
                bl = true;
            }
            catch (IOException iOException) {
                ExportDialog.this.setCursor(Cursor.getDefaultCursor());
                JOptionPane.showMessageDialog(this.m_me, "Error Saving Configuration: " + iOException.getMessage(), "Export Configurations", 0);
            }
            catch (OWConfigurationException oWConfigurationException) {
                ExportDialog.this.setCursor(Cursor.getDefaultCursor());
                JOptionPane.showMessageDialog(this.m_me, "Error Saving Configuration: " + oWConfigurationException, "Export Configurations", 0);
            }
            this.m_me.setCursor(Cursor.getDefaultCursor());
            if (bl) {
                JOptionPane.showMessageDialog(this.m_me, "Selected Configurations have been exported to file:\n'" + m_filename + "'", "Export Configurations", 1);
            } else {
                JOptionPane.showMessageDialog(this.m_me, "Export Failed", "Export Configurations", 0);
            }
            ExportDialog.this.exitForm();
        }
    }
}

