/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owtools.ccf.ui;

import com.baan.owimpl.fw.ccf.AdapterClientContext;
import com.baan.owimpl.fw.ccf.ConfigurationContext;
import com.baan.owimpl.fw.ccf.IdentifierContext;
import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.baan.owimpl.fw.ccf.SmartContext;
import com.baan.owimpl.fw.ccf.impl.DirectoryURL;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.baan.owtools.ccf.DirectoryList;
import com.baan.owtools.ccf.ui.ChangeDirectoryDialog;
import com.baan.owtools.ccf.ui.IContextHelp;
import com.baan.owtools.ccf.ui.LoginDialog;
import com.baan.owtools.ccf.ui.SplashScreen;
import com.baan.owtools.ccf.ui.actions.AboutAction;
import com.baan.owtools.ccf.ui.actions.AddApplicationAction;
import com.baan.owtools.ccf.ui.actions.AddIdentifierAction;
import com.baan.owtools.ccf.ui.actions.AddMachineAction;
import com.baan.owtools.ccf.ui.actions.AddUserAction;
import com.baan.owtools.ccf.ui.actions.ChangeDirectoryAction;
import com.baan.owtools.ccf.ui.actions.CopyIdentifierAction;
import com.baan.owtools.ccf.ui.actions.ExportAction;
import com.baan.owtools.ccf.ui.actions.HelpAction;
import com.baan.owtools.ccf.ui.actions.ImportAction;
import com.baan.owtools.ccf.ui.actions.MigrateAction;
import com.baan.owtools.ccf.ui.actions.RefreshAction;
import com.baan.owtools.ccf.ui.actions.RemoveAction;
import com.baan.owtools.ccf.ui.actions.SearchAction;
import com.baan.owtools.ccf.ui.actions.SynchCategoriesAction;
import com.baan.owtools.ccf.ui.grid.ConfigurationProperties;
import com.baan.owtools.ccf.ui.tree.ConfigurationTreeModel;
import com.baan.owtools.ccf.ui.tree.ConfigurationTreeNode;
import com.baan.owtools.ccf.ui.tree.TreeUtils;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.grid.CellEditorManager;
import com.jidesoft.grid.CellRendererManager;
import com.jidesoft.grid.Property;
import com.jidesoft.grid.PropertyPane;
import com.jidesoft.grid.PropertyTable;
import com.jidesoft.grid.PropertyTableModel;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.utils.Lm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.ArrayList;
import javax.accessibility.Accessible;
import javax.help.BadIDException;
import javax.help.DefaultHelpBroker;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class ConfigBrowser
extends JFrame {
    private static final String DEFAULT_HELP_TOPIC = "ccf_intro";
    private HelpSet m_hs = null;
    private HelpBroker m_hb = null;
    private boolean m_readOnly = false;
    private JSplitPane splitMain;
    private JScrollPane scrollTree;
    private JTree treeConfigurations;
    private JPanel panelProperties;
    private PropertyTable propTable;
    private PropertyPane propPane;
    private MouseHandler mouseHandler;
    private ChangeDirectoryAction changeDirectoryAction;
    private AddIdentifierAction addIdentifierAction;
    private CopyIdentifierAction copyIdentifierAction;
    private AddMachineAction addMachineAction;
    private AddUserAction addUserAction;
    private AddApplicationAction addApplicationAction;
    private RemoveAction removeAction;
    private RefreshAction refreshAction;
    private SearchAction searchAction;
    private MigrateAction migrateAction;
    private SynchCategoriesAction synchCategoriesAction;
    private ImportAction importAction;
    private ExportAction exportAction;
    private HelpAction helpAction;
    private AboutAction aboutAction;
    private JMenuBar menuBar;
    private JPopupMenu smartPopup;
    private JPopupMenu identifierPopup;
    private JToolBar toolBar;
    private ConfigurationProperties m_displayedProperties = null;

    public static void main(String[] stringArray) {
        Object object;
        try {
            object = System.getProperty("java.version");
            int n = ((String)object).indexOf(".");
            int n2 = Integer.parseInt(((String)object).substring(0, n));
            int n3 = ((String)object).indexOf(".", ++n);
            int n4 = n3 >= 0 ? Integer.parseInt(((String)object).substring(n, n3)) : Integer.parseInt(((String)object).substring(n));
            if (n2 == 1 && n4 < 4) {
                throw new Exception("Invalid version");
            }
        }
        catch (Throwable throwable) {
            ILogger iLogger = LoggerFactory.createLogger("com.baan.owtools.ccf.ui", "ConfigBrowser");
            String string = "Central Configuration Console requires Java version 1.4 or higher.";
            iLogger.errorMessage(string);
            JOptionPane.showMessageDialog(null, string, "Error", 0);
            LoggerFactory.exit(1);
        }
        object = new ConfigBrowser(true);
        if (DirectoryURL.get() == null) {
            new ChangeDirectoryDialog((JFrame)object).show();
        }
    }

    public ConfigBrowser(boolean bl) {
        Accessible accessible;
        String string;
        SplashScreen splashScreen = new SplashScreen();
        if (bl) {
            splashScreen.showSplash();
        }
        Lm.verifyLicense((String)"SSA Global", (String)"CCF", (String)"nF3SNK94CXqWCV4MgPAPxqzNM9f1wJc");
        try {
            string = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        LookAndFeelFactory.installJideExtension();
        ObjectConverterManager.initDefaultConverter();
        CellEditorManager.initDefaultEditor();
        CellRendererManager.initDefaultRenderer();
        try {
            this.createHelpSet();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(splashScreen, "Error loading online help files, help not available.", "Help Warning", 2);
        }
        string = DirectoryURL.get();
        if (string != null && string.toLowerCase().startsWith("ldap:")) {
            accessible = new LoginDialog((Frame)splashScreen, this, string);
            ((Dialog)accessible).show();
        }
        this.setTitle();
        accessible = new ImageIcon(this.getClass().getResource("/com/baan/owtools/ccf/ui/images/app16.gif"));
        ((Frame)this).setIconImage(((ImageIcon)accessible).getImage());
        this.addWindowListener(new WindowClosingHandler());
        this.addComponentListener(new ResizeHandler());
        Container container = this.getContentPane();
        this.treeConfigurations = new JTree(new ConfigurationTreeModel());
        this.treeConfigurations.setFont(new Font("Dialog", 0, 12));
        this.treeConfigurations.setRootVisible(false);
        this.treeConfigurations.setShowsRootHandles(true);
        this.treeConfigurations.getSelectionModel().setSelectionMode(1);
        this.treeConfigurations.setCellRenderer(new ConfigurationTreeRenderer());
        this.treeConfigurations.addMouseListener(new PopupListener());
        ToolTipManager.sharedInstance().registerComponent(this.treeConfigurations);
        this.treeConfigurations.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)ConfigBrowser.this.treeConfigurations.getLastSelectedPathComponent();
                if (defaultMutableTreeNode != null && defaultMutableTreeNode instanceof ConfigurationTreeNode) {
                    ConfigBrowser.this.nodeSelected((ConfigurationTreeNode)defaultMutableTreeNode);
                }
            }
        });
        this.scrollTree = new JScrollPane();
        this.scrollTree.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.scrollTree.setViewportView(this.treeConfigurations);
        this.scrollTree.setMinimumSize(new Dimension(150, 150));
        Font font = UIManager.getFont("Table.font");
        PropertyTableModel propertyTableModel = new PropertyTableModel(new ArrayList());
        this.propTable = new PropertyTable((TableModel)propertyTableModel);
        this.propTable.setEnabled(!this.m_readOnly);
        this.propTable.setFont(font);
        this.propPane = new PropertyPane(this.propTable);
        this.propPane.setFont(font);
        this.propTable.addFocusListener(new FocusHandler());
        ListSelectionModel listSelectionModel = this.propTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                Property property = ConfigBrowser.this.propTable.getSelectedProperty();
                ConfigBrowser.this.propertySelected(property);
            }
        });
        this.panelProperties = new JPanel(){

            public final boolean isFocusCycleRoot() {
                return true;
            }

            public final Container getFocusCycleRootAncestor() {
                return null;
            }
        };
        this.panelProperties.setLayout(new BorderLayout());
        this.panelProperties.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.panelProperties.setMinimumSize(new Dimension(150, 150));
        this.panelProperties.add((Component)this.propPane, "Center");
        this.splitMain = new JSplitPane(1);
        this.splitMain.setLeftComponent(this.scrollTree);
        this.splitMain.setRightComponent(this.panelProperties);
        this.splitMain.setDividerLocation(250);
        container.add((Component)this.splitMain, "Center");
        JLabel jLabel = new JLabel(" ");
        jLabel.setBorder(BorderFactory.createEtchedBorder(1));
        container.add((Component)jLabel, "South");
        container.setBackground(jLabel.getBackground());
        this.toolBar = new JToolBar();
        this.toolBar.setRollover(true);
        container.add((Component)this.toolBar, "North");
        this.menuBar = new JMenuBar();
        this.menuBar.setFont(new Font("Dialog", 0, 12));
        this.setJMenuBar(this.menuBar);
        this.smartPopup = new JPopupMenu();
        this.identifierPopup = new JPopupMenu();
        this.mouseHandler = new MouseHandler(jLabel);
        this.changeDirectoryAction = new ChangeDirectoryAction(this);
        this.addIdentifierAction = new AddIdentifierAction(this, this.treeConfigurations, "Configuration");
        this.copyIdentifierAction = new CopyIdentifierAction(this.treeConfigurations, "Configuration");
        this.addMachineAction = new AddMachineAction(this.treeConfigurations);
        this.addUserAction = new AddUserAction(this.treeConfigurations);
        this.addApplicationAction = new AddApplicationAction(this.treeConfigurations);
        this.removeAction = new RemoveAction(this.treeConfigurations);
        this.refreshAction = new RefreshAction(this.treeConfigurations);
        this.searchAction = new SearchAction(this, this.treeConfigurations);
        this.migrateAction = new MigrateAction(this.treeConfigurations, this.refreshAction);
        this.synchCategoriesAction = new SynchCategoriesAction(this.treeConfigurations, this.refreshAction);
        this.importAction = new ImportAction(this, this.refreshAction);
        this.exportAction = new ExportAction(this);
        this.helpAction = new HelpAction(this);
        this.aboutAction = new AboutAction(this);
        this.migrateAction.setEnabled(!this.m_readOnly);
        this.synchCategoriesAction.setEnabled(!this.m_readOnly);
        this.importAction.setEnabled(!this.m_readOnly);
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic('F');
        this.menuBar.add(jMenu);
        JMenuItem jMenuItem = jMenu.add(this.changeDirectoryAction);
        jMenuItem.addMouseListener(this.mouseHandler);
        jMenu.addSeparator();
        JMenuItem jMenuItem2 = jMenu.add(this.importAction);
        jMenuItem2.addMouseListener(this.mouseHandler);
        JMenuItem jMenuItem3 = jMenu.add(this.exportAction);
        jMenuItem3.addMouseListener(this.mouseHandler);
        jMenu.addSeparator();
        JMenuItem jMenuItem4 = new JMenuItem("Exit");
        jMenuItem4.setMnemonic('x');
        jMenu.add(jMenuItem4);
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        JMenu jMenu2 = new JMenu("View");
        jMenu2.setMnemonic('V');
        this.menuBar.add(jMenu2);
        JMenuItem jMenuItem5 = jMenu2.add(this.refreshAction);
        jMenuItem5.addMouseListener(this.mouseHandler);
        JButton jButton = this.toolBar.add(this.refreshAction);
        jButton.addMouseListener(this.mouseHandler);
        this.toolBar.addSeparator();
        JMenu jMenu3 = new JMenu("Configurations");
        jMenu3.setMnemonic('C');
        this.menuBar.add(jMenu3);
        JMenuItem jMenuItem6 = jMenu3.add(this.addIdentifierAction);
        jMenuItem6.addMouseListener(this.mouseHandler);
        jMenuItem6 = this.identifierPopup.add(this.addIdentifierAction);
        JButton jButton2 = this.toolBar.add(this.addIdentifierAction);
        jMenuItem6.addMouseListener(this.mouseHandler);
        JMenuItem jMenuItem7 = jMenu3.add(this.copyIdentifierAction);
        jMenuItem7.addMouseListener(this.mouseHandler);
        jMenuItem7 = this.identifierPopup.add(this.copyIdentifierAction);
        JButton jButton3 = this.toolBar.add(this.copyIdentifierAction);
        jMenuItem7.addMouseListener(this.mouseHandler);
        this.toolBar.addSeparator();
        jMenu3.addSeparator();
        JMenuItem jMenuItem8 = jMenu3.add(this.addMachineAction);
        jMenuItem8.addMouseListener(this.mouseHandler);
        jMenuItem8 = this.smartPopup.add(this.addMachineAction);
        jMenuItem8.addMouseListener(this.mouseHandler);
        JButton jButton4 = this.toolBar.add(this.addMachineAction);
        jButton4.addMouseListener(this.mouseHandler);
        JMenuItem jMenuItem9 = jMenu3.add(this.addUserAction);
        jMenuItem9.addMouseListener(this.mouseHandler);
        jMenuItem9 = this.smartPopup.add(this.addUserAction);
        jMenuItem9.addMouseListener(this.mouseHandler);
        JButton jButton5 = this.toolBar.add(this.addUserAction);
        jButton5.addMouseListener(this.mouseHandler);
        JMenuItem jMenuItem10 = jMenu3.add(this.addApplicationAction);
        jMenuItem10.addMouseListener(this.mouseHandler);
        jMenuItem10 = this.smartPopup.add(this.addApplicationAction);
        jMenuItem10.addMouseListener(this.mouseHandler);
        JButton jButton6 = this.toolBar.add(this.addApplicationAction);
        jButton6.addMouseListener(this.mouseHandler);
        jMenu3.addSeparator();
        this.identifierPopup.addSeparator();
        this.smartPopup.addSeparator();
        this.toolBar.addSeparator();
        JMenuItem jMenuItem11 = jMenu3.add(this.removeAction);
        jMenuItem11.addMouseListener(this.mouseHandler);
        jMenuItem11 = this.identifierPopup.add(this.removeAction);
        jMenuItem11.addMouseListener(this.mouseHandler);
        jMenuItem11 = this.smartPopup.add(this.removeAction);
        jMenuItem11.addMouseListener(this.mouseHandler);
        JButton jButton7 = this.toolBar.add(this.removeAction);
        jButton7.addMouseListener(this.mouseHandler);
        JMenuItem jMenuItem12 = jMenu3.add(this.searchAction);
        jMenuItem12.addMouseListener(this.mouseHandler);
        jMenuItem12 = this.smartPopup.add(this.searchAction);
        jMenuItem12.addMouseListener(this.mouseHandler);
        JButton jButton8 = this.toolBar.add(this.searchAction);
        jButton8.addMouseListener(this.mouseHandler);
        JMenu jMenu4 = new JMenu("Tools");
        jMenu4.setMnemonic('T');
        this.menuBar.add(jMenu4);
        JMenuItem jMenuItem13 = jMenu4.add(this.migrateAction);
        jMenuItem13.addMouseListener(this.mouseHandler);
        JMenuItem jMenuItem14 = jMenu4.add(this.synchCategoriesAction);
        jMenuItem14.addMouseListener(this.mouseHandler);
        JMenu jMenu5 = new JMenu("Help");
        jMenu5.setMnemonic('H');
        this.menuBar.add(jMenu5);
        JMenuItem jMenuItem15 = jMenu5.add(this.helpAction);
        jMenuItem15.addMouseListener(this.mouseHandler);
        jMenu5.addSeparator();
        JMenuItem jMenuItem16 = jMenu5.add(this.aboutAction);
        jMenuItem16.addMouseListener(this.mouseHandler);
        this.resetState();
        ((Component)this).setBounds(100, 100, 760, 600);
        this.setDefaultCloseOperation(3);
        this.show();
        this.treeConfigurations.setSelectionRow(0);
        this.treeConfigurations.requestFocus();
        splashScreen.hideSplash();
    }

    private void createHelpSet() throws Exception {
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL uRL = HelpSet.findHelpSet((ClassLoader)classLoader, (String)"adapter_helpset.hs");
        this.m_hs = new HelpSet(classLoader, uRL);
        this.m_hb = this.m_hs.createHelpBroker();
        this.setHelpTopic(DEFAULT_HELP_TOPIC);
    }

    public void setHelpTopic(String string) {
        block2: {
            if (this.m_hb == null || this.m_hs == null) break block2;
            try {
                this.m_hb.setCurrentID(string);
                this.m_hb.enableHelpKey((Component)this.getRootPane(), string, this.m_hs);
            }
            catch (BadIDException badIDException) {
                this.m_hb.setCurrentID(DEFAULT_HELP_TOPIC);
                this.m_hb.enableHelpKey((Component)this.getRootPane(), DEFAULT_HELP_TOPIC, this.m_hs);
            }
        }
    }

    public void showHelp() {
        this.showHelp(this);
    }

    public void showHelp(Window window) {
        if (this.m_hb != null) {
            ((DefaultHelpBroker)this.m_hb).setActivationWindow(window);
            this.m_hb.setDisplayed(true);
        }
    }

    public void refresh() {
        this.refreshAction.actionPerformed(null);
    }

    public void directoryChanged() {
        this.setTitle();
        this.refresh();
        this.propTable.setEnabled(!this.m_readOnly);
        this.migrateAction.setEnabled(!this.m_readOnly);
        this.synchCategoriesAction.setEnabled(!this.m_readOnly);
        this.importAction.setEnabled(!this.m_readOnly);
        ConfigurationProperties configurationProperties = new ConfigurationProperties();
        configurationProperties.show(this.propTable);
    }

    public void setTitle() {
        String string = DirectoryURL.get();
        if (string == null) {
            string = "Directory URL not set";
        }
        String string2 = "Central Configuration Console - " + string;
        this.setTitle(string2);
        try {
            AdapterClientContext adapterClientContext = AdapterClientContext.getInstance();
            this.m_readOnly = adapterClientContext.isReadOnly();
            if (this.m_readOnly) {
                string2 = string2 + " [Read Only]";
            }
            AdapterClientContext.reset();
            this.setTitle(string2);
            DirectoryList.getInstance().add(string);
        }
        catch (OWConfigurationException oWConfigurationException) {
            string2 = string2 + " [Error]";
            this.setTitle(string2);
        }
    }

    private void resetState() {
        this.addIdentifierAction.setEnabled(false);
        this.copyIdentifierAction.setEnabled(false);
        this.addMachineAction.setEnabled(false);
        this.addUserAction.setEnabled(false);
        this.addApplicationAction.setEnabled(false);
        this.removeAction.setEnabled(false);
        this.searchAction.setEnabled(false);
        this.setHelpTopic(DEFAULT_HELP_TOPIC);
    }

    private void nodeSelected(ConfigurationTreeNode configurationTreeNode) {
        try {
            this.resetState();
            this.removeAction.setEnabled(!this.m_readOnly);
            ConfigurationContext configurationContext = configurationTreeNode.getDirectory();
            if (configurationContext instanceof IdentifierContext) {
                this.addIdentifierAction.setEnabled(!this.m_readOnly);
                if (configurationTreeNode.getType() == 12) {
                    this.copyIdentifierAction.setEnabled(!this.m_readOnly);
                }
            } else if (configurationContext instanceof SmartContext) {
                this.searchAction.setEnabled(true);
                switch (configurationTreeNode.getType()) {
                    case 1: {
                        this.addMachineAction.setEnabled(!this.m_readOnly);
                    }
                    case 21: {
                        this.addUserAction.setEnabled(!this.m_readOnly);
                    }
                    case 22: {
                        this.addApplicationAction.setEnabled(!this.m_readOnly);
                    }
                }
            }
            if (this.m_displayedProperties != null) {
                this.m_displayedProperties.saveSettings();
            }
            this.m_displayedProperties = configurationTreeNode.showProperties(this.propTable);
            TreeUtils.makeVisible(this.treeConfigurations, configurationTreeNode);
            this.setHelpTopic(configurationTreeNode.getHelpTopic());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString(), "Error", 0);
        }
    }

    private void propertySelected(Property property) {
        if (property != null) {
            if (property instanceof IContextHelp) {
                IContextHelp iContextHelp = (IContextHelp)property;
                this.setHelpTopic(iContextHelp.getHelpTopic());
            } else {
                ConfigurationTreeNode configurationTreeNode = (ConfigurationTreeNode)this.treeConfigurations.getLastSelectedPathComponent();
                if (configurationTreeNode != null) {
                    this.setHelpTopic(configurationTreeNode.getHelpTopic());
                } else {
                    this.setHelpTopic(DEFAULT_HELP_TOPIC);
                }
            }
        }
    }

    private class WindowClosingHandler
    extends WindowAdapter {
        private WindowClosingHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            ConfigBrowser.this.propTable.editCellAt(0, 0);
        }
    }

    private class ResizeHandler
    extends ComponentAdapter {
        private static final int MIN_WIDTH = 400;
        private static final int MIN_HEIGHT = 250;

        private ResizeHandler() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            int n = ConfigBrowser.this.getWidth();
            int n2 = ConfigBrowser.this.getHeight();
            if (n < 400 || n2 < 250) {
                ((Component)ConfigBrowser.this).setSize(Math.max(n, 400), Math.max(n2, 250));
            }
        }
    }

    private class FocusHandler
    extends FocusAdapter {
        private FocusHandler() {
        }

        public void focusGained(FocusEvent focusEvent) {
            ConfigBrowser.this.removeAction.setEnabled(false);
        }

        public void focusLost(FocusEvent focusEvent) {
            ConfigurationTreeNode configurationTreeNode = (ConfigurationTreeNode)ConfigBrowser.this.treeConfigurations.getLastSelectedPathComponent();
            ConfigBrowser.this.removeAction.setEnabled(!ConfigBrowser.this.m_readOnly && configurationTreeNode != null);
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private JLabel label;

        public MouseHandler(JLabel jLabel) {
            this.setLabel(jLabel);
        }

        public void setLabel(JLabel jLabel) {
            this.label = jLabel;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            AbstractButton abstractButton;
            Action action;
            if (mouseEvent.getSource() instanceof AbstractButton && (action = (abstractButton = (AbstractButton)mouseEvent.getSource()).getAction()) != null) {
                String string = (String)action.getValue("LongDescription");
                this.label.setText(string);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.label.setText(" ");
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            ConfigurationTreeNode configurationTreeNode;
            if (SwingUtilities.isRightMouseButton(mouseEvent) && (configurationTreeNode = TreeUtils.getNodeFromMouseEvent(ConfigBrowser.this.treeConfigurations, mouseEvent)) != null) {
                TreeUtils.selectNode(ConfigBrowser.this.treeConfigurations, configurationTreeNode);
            }
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            block5: {
                ConfigurationTreeNode configurationTreeNode;
                if (!mouseEvent.isPopupTrigger() || (configurationTreeNode = TreeUtils.getNodeFromMouseEvent(ConfigBrowser.this.treeConfigurations, mouseEvent)) == null) break block5;
                try {
                    ConfigurationContext configurationContext = configurationTreeNode.getDirectory();
                    if (configurationContext instanceof SmartContext) {
                        ConfigBrowser.this.smartPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    } else if (configurationContext instanceof IdentifierContext) {
                        ConfigBrowser.this.identifierPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    private class ConfigurationTreeRenderer
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object instanceof ConfigurationTreeNode) {
                ConfigurationTreeNode configurationTreeNode = (ConfigurationTreeNode)object;
                this.setIcon(configurationTreeNode.getIcon());
                this.setToolTipText(configurationTreeNode.getToolTipText());
            }
            return this;
        }
    }
}

