/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owtools.ccf.ui;

import com.baan.owimpl.fw.ccf.IdentifierContext;
import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.baan.owtools.ccf.ui.ConfigBrowser;
import com.eibus.services.directory.URI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;

public class AddBusComponentDialog
extends JDialog {
    private static final String HELP_TOPIC = "ccf_addbuscomponent";
    private static final String DEFAULT_CONNECTION_POINT = "bidisocket://<server>:7912";
    JLabel jLabel1 = new JLabel();
    JTextField jTextFieldIdentifier = new JTextField();
    JLabel jLabel2 = new JLabel();
    JTextField jTextFieldConnectionPoint = new JTextField();
    JCheckBox jCheckBoxBaanERP = new JCheckBox();
    JPanel jPanel1 = new JPanel();
    TitledBorder titledBorder2;
    JLabel jLabel3 = new JLabel();
    JTextField jTextFieldCompanyNumber = new JTextField();
    JButton jButtonOK = new JButton();
    JButton jButtonCancel = new JButton();
    JButton jButtonHelp = new JButton();
    private ConfigBrowser m_frame;
    private IdentifierContext m_ctx;
    private boolean m_result = false;
    private String m_identifier;
    private String m_connectionPoint;
    private boolean m_ERP;
    private int m_companyNumber = -1;

    public AddBusComponentDialog(ConfigBrowser configBrowser, IdentifierContext identifierContext) {
        this.setFont(new Font("Dialog", 0, 11));
        this.m_frame = configBrowser;
        this.m_ctx = identifierContext;
        this.jbInit();
        this.m_frame.setHelpTopic(HELP_TOPIC);
        Point point = this.m_frame.getLocation();
        point.x += 30;
        point.y += 30;
        ((Component)this).setLocation(point);
        ((Component)this).setSize(435, 225);
    }

    private void jbInit() {
        this.titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), "SSA ERP / Baan IV BusComponent");
        this.getContentPane().setLayout(null);
        this.jLabel1.setFont(this.getFont());
        this.jLabel1.setText("Identifier:");
        this.jLabel1.setBounds(new Rectangle(10, 10, 100, 20));
        this.jTextFieldIdentifier.setFont(this.getFont());
        this.jTextFieldIdentifier.setText("");
        this.jTextFieldIdentifier.setBounds(new Rectangle(120, 10, 300, 20));
        this.jLabel2.setFont(this.getFont());
        this.jLabel2.setText("Connection Point:");
        this.jLabel2.setBounds(new Rectangle(10, 35, 100, 20));
        this.jTextFieldConnectionPoint.setFont(this.getFont());
        this.jTextFieldConnectionPoint.setText(DEFAULT_CONNECTION_POINT);
        this.jTextFieldConnectionPoint.setBounds(new Rectangle(120, 35, 300, 20));
        this.jPanel1.setFont(this.getFont());
        this.jPanel1.setBorder(this.titledBorder2);
        this.jPanel1.setBounds(new Rectangle(10, 70, 410, 90));
        this.jPanel1.setLayout(null);
        this.jCheckBoxBaanERP.setFont(this.getFont());
        this.jCheckBoxBaanERP.setText("This is a SSA ERP / BaanIV BusComponent");
        this.jCheckBoxBaanERP.setBounds(new Rectangle(10, 25, 390, 20));
        this.jCheckBoxBaanERP.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddBusComponentDialog.this.jCheckBoxBaanERP_actionPerformed(actionEvent);
            }
        });
        this.jLabel3.setFont(this.getFont());
        this.jLabel3.setText("Company Number:");
        this.jLabel3.setBounds(new Rectangle(10, 55, 160, 20));
        this.jTextFieldCompanyNumber.setFont(this.getFont());
        this.jTextFieldCompanyNumber.setText("");
        this.jTextFieldCompanyNumber.setEnabled(false);
        this.jTextFieldCompanyNumber.setBackground(SystemColor.control);
        this.jTextFieldCompanyNumber.setBounds(new Rectangle(160, 55, 115, 20));
        this.jButtonOK.setFont(this.getFont());
        this.jButtonOK.setBounds(new Rectangle(170, 165, 70, 22));
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddBusComponentDialog.this.jButtonOKActionPerformed(actionEvent);
            }
        });
        this.jButtonCancel.setFont(this.getFont());
        this.jButtonCancel.setBounds(new Rectangle(255, 165, 70, 22));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddBusComponentDialog.this.jButtonCancelActionPerformed(actionEvent);
            }
        });
        this.jButtonHelp.setFont(this.getFont());
        this.jButtonHelp.setBounds(new Rectangle(340, 165, 70, 22));
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddBusComponentDialog.this.m_frame.showHelp(AddBusComponentDialog.this);
            }
        });
        this.jPanel1.add((Component)this.jCheckBoxBaanERP, null);
        this.jPanel1.add((Component)this.jLabel3, null);
        this.jPanel1.add((Component)this.jTextFieldCompanyNumber, null);
        this.getContentPane().add((Component)this.jLabel1, null);
        this.getContentPane().add((Component)this.jTextFieldIdentifier, null);
        this.getContentPane().add((Component)this.jLabel2, null);
        this.getContentPane().add((Component)this.jTextFieldConnectionPoint, null);
        this.getContentPane().add((Component)this.jPanel1, null);
        this.getContentPane().add((Component)this.jButtonOK, null);
        this.getContentPane().add((Component)this.jButtonCancel, null);
        this.getContentPane().add((Component)this.jButtonHelp, null);
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.setTitle("Add BusComponent");
        this.setModal(true);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AddBusComponentDialog.this.exitForm(windowEvent);
            }
        });
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddBusComponentDialog.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(keyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", abstractAction);
    }

    private void jCheckBoxBaanERP_actionPerformed(ActionEvent actionEvent) {
        boolean bl = this.jCheckBoxBaanERP.isSelected();
        this.jTextFieldCompanyNumber.setEnabled(bl);
        this.jTextFieldCompanyNumber.setBackground(bl ? SystemColor.window : SystemColor.control);
    }

    private void jButtonOKActionPerformed(ActionEvent actionEvent) {
        this.m_identifier = this.jTextFieldIdentifier.getText();
        if (this.m_identifier.length() == 0) {
            JOptionPane.showMessageDialog(this, "You must specify an identifier", "Input Error", 0);
            this.jTextFieldIdentifier.requestFocus();
            return;
        }
        try {
            this.m_ctx.getConfiguration(this.m_identifier);
            JOptionPane.showMessageDialog(this, "The identifier " + this.m_identifier + " already exists", "Input Error", 0);
            this.jTextFieldIdentifier.requestFocus();
            this.jTextFieldIdentifier.setSelectionStart(0);
            this.jTextFieldIdentifier.setSelectionEnd(this.m_identifier.length());
            return;
        }
        catch (OWConfigurationException oWConfigurationException) {
            block10: {
                Object object;
                this.m_connectionPoint = this.jTextFieldConnectionPoint.getText();
                if (this.m_connectionPoint.equals(DEFAULT_CONNECTION_POINT)) {
                    JOptionPane.showMessageDialog(this, "You must specify a valid connection point", "Input Error", 0);
                    this.jTextFieldConnectionPoint.requestFocus();
                    this.jTextFieldConnectionPoint.setSelectionStart(0);
                    this.jTextFieldConnectionPoint.setSelectionEnd(this.m_connectionPoint.length());
                    return;
                }
                try {
                    object = URI.createTransportURI(this.m_connectionPoint);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this, "Invalid connection point: " + exception.getMessage(), "Input Error", 0);
                    this.jTextFieldConnectionPoint.requestFocus();
                    this.jTextFieldConnectionPoint.setSelectionStart(0);
                    this.jTextFieldConnectionPoint.setSelectionEnd(this.m_connectionPoint.length());
                    return;
                }
                this.m_ERP = this.jCheckBoxBaanERP.isSelected();
                object = this.jTextFieldCompanyNumber.getText();
                if (((String)object).length() > 0) {
                    try {
                        this.m_companyNumber = Integer.parseInt((String)object);
                        if (this.m_companyNumber < -1 || this.m_companyNumber > 999) {
                            throw new Exception("Invalid number");
                        }
                        break block10;
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(this, "Company Number must be numeric in the range 0 - 999", "Input Error", 0);
                        this.jTextFieldCompanyNumber.requestFocus();
                        this.jTextFieldCompanyNumber.setSelectionStart(0);
                        this.jTextFieldCompanyNumber.setSelectionEnd(((String)object).length());
                        return;
                    }
                }
                this.m_companyNumber = -1;
            }
            this.m_result = true;
            this.dispose();
            return;
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    private void exitForm(WindowEvent windowEvent) {
        this.dispose();
    }

    public boolean getResult() {
        return this.m_result;
    }

    public String getIdentifier() {
        return this.m_identifier;
    }

    public String getConnectionPoint() {
        return this.m_connectionPoint;
    }

    public boolean isERP() {
        return this.m_ERP;
    }

    public int getCompanyNumber() {
        return this.m_companyNumber;
    }
}

