/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owtools.ccf.migrator;

import com.baan.owimpl.fw.ccf.BusComponentConfiguration;
import com.baan.owimpl.fw.ccf.BusComponentContext;
import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.baan.owtools.ccf.migrator.MigratorResultDialog;
import com.baan.owtools.ccf.migrator.OverwriteDialog;
import com.eibus.services.directory.Activation;
import com.eibus.services.directory.AttributeNotSpecifiedException;
import com.eibus.services.directory.BusComponent;
import com.eibus.services.directory.ConnectionPoint;
import com.eibus.services.directory.Directory;
import com.eibus.services.directory.DirectoryException;
import com.eibus.services.directory.DirectoryServiceProvider;
import com.eibus.services.directory.MalformedURIException;
import com.eibus.services.runtime.BusProperties;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import javax.help.BadIDException;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MigratorFrame
extends JFrame {
    private static final ILogger s_logger = LoggerFactory.createLogger(class$com$baan$owtools$ccf$migrator$MigratorFrame == null ? (class$com$baan$owtools$ccf$migrator$MigratorFrame = MigratorFrame.class$("com.baan.owtools.ccf.migrator.MigratorFrame")) : class$com$baan$owtools$ccf$migrator$MigratorFrame);
    private static final String DEFAULT_HELP_TOPIC = "ccf_migrator";
    private JPanel panelMain;
    private JPanel panelDirectory;
    private JPanel panelConnection;
    private JLabel labelURL;
    private JTextField textURL;
    private JLabel labelRoot;
    private JTextField textRoot;
    private JLabel labelURL2;
    private JTextField textNewURL;
    private JPanel panelConnectButtons;
    private JButton buttonLoad;
    private JPanel panelComponents;
    private JScrollPane scrollList;
    private JList listComponents;
    private DefaultListModel listModel;
    private JPanel panelSelectButtons;
    private JButton buttonDeselect;
    private JButton buttonSelect;
    private JPanel panelCommands;
    private JProgressBar progressBar;
    private JButton buttonMigrate;
    private JButton buttonClose;
    private JButton buttonHelp;
    private HelpSet hs = null;
    private HelpBroker hb = null;
    private Directory m_oldDirectory = null;
    private BusComponentContext m_newDirectory = null;
    private int m_overwriteState;
    private boolean m_refresh = false;
    static /* synthetic */ Class class$com$baan$owtools$ccf$migrator$MigratorFrame;

    public MigratorFrame() {
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/com/baan/owtools/ccf/ui/images/app16.gif"));
        ((Frame)this).setIconImage(imageIcon.getImage());
        try {
            this.createHelpSet();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Error loading online help files, help not available.", "Help Error", 0);
        }
        try {
            this.m_newDirectory = BusComponentContext.getInstance();
        }
        catch (OWConfigurationException oWConfigurationException) {
            s_logger.errorException(oWConfigurationException);
            JOptionPane.showMessageDialog(null, oWConfigurationException);
        }
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.panelMain = new JPanel();
        this.panelMain.setLayout(new BorderLayout());
        container.add(this.panelMain);
        this.panelConnection = new JPanel();
        this.panelConnection.setBorder(new TitledBorder(new EtchedBorder(), "Directory", 0, 0, null, null));
        this.panelConnection.setLayout(new BorderLayout());
        this.panelMain.add((Component)this.panelConnection, "North");
        this.panelDirectory = new JPanel();
        this.panelDirectory.setLayout(new GridBagLayout());
        this.panelConnection.add((Component)this.panelDirectory, "Center");
        this.labelURL = new JLabel("From URL:");
        this.panelDirectory.add((Component)this.labelURL, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.textURL = new JTextField();
        this.textURL.setText(BusProperties.getProperty("bus.services.directory.ServerURL"));
        this.panelDirectory.add((Component)this.textURL, new GridBagConstraints(1, 0, 1, 1, 0.9, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.labelRoot = new JLabel("From Root:");
        this.panelDirectory.add((Component)this.labelRoot, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.textRoot = new JTextField();
        this.textRoot.setText(BusProperties.getProperty("bus.services.directory.Root"));
        this.panelDirectory.add((Component)this.textRoot, new GridBagConstraints(1, 1, 1, 1, 0.9, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.labelURL2 = new JLabel("To URL:");
        this.panelDirectory.add((Component)this.labelURL2, new GridBagConstraints(0, 2, 1, 1, 0.1, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.textNewURL = new JTextField();
        this.textNewURL.setText(this.m_newDirectory != null ? this.m_newDirectory.getURL() : "failed to retrieve new URL");
        this.textNewURL.setEditable(false);
        this.panelDirectory.add((Component)this.textNewURL, new GridBagConstraints(1, 2, 1, 1, 0.9, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.panelConnectButtons = new JPanel();
        this.panelConnectButtons.setLayout(new BoxLayout(this.panelConnectButtons, 1));
        this.panelConnectButtons.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.buttonLoad = new JButton("Load");
        this.panelConnectButtons.add(this.buttonLoad);
        this.buttonLoad.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MigratorFrame.this.connect();
            }
        });
        this.panelConnection.add((Component)this.panelConnectButtons, "East");
        this.panelComponents = new JPanel();
        this.panelComponents.setBorder(new TitledBorder(new EtchedBorder(), "Bus Components", 0, 0, null, null));
        this.panelComponents.setLayout(new BorderLayout());
        this.panelMain.add((Component)this.panelComponents, "Center");
        this.scrollList = new JScrollPane();
        this.panelComponents.add((Component)this.scrollList, "Center");
        this.listModel = new DefaultListModel();
        this.listComponents = new JList(this.listModel);
        this.listComponents.setSelectionMode(2);
        this.listComponents.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                MigratorFrame.this.progressBar.setValue(0);
                MigratorFrame.this.buttonMigrate.setEnabled(MigratorFrame.this.m_newDirectory != null && MigratorFrame.this.listComponents.getSelectedIndices().length > 0);
            }
        });
        this.scrollList.setViewportView(this.listComponents);
        this.panelSelectButtons = new JPanel();
        this.panelSelectButtons.setLayout(new BoxLayout(this.panelSelectButtons, 1));
        this.panelSelectButtons.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.panelComponents.add((Component)this.panelSelectButtons, "East");
        this.buttonSelect = new JButton("Select All");
        this.buttonSelect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MigratorFrame.this.listComponents.getSelectionModel().setSelectionInterval(0, MigratorFrame.this.listModel.size() - 1);
            }
        });
        this.panelSelectButtons.add(this.buttonSelect);
        this.panelSelectButtons.add(Box.createRigidArea(new Dimension(0, 5)));
        this.buttonDeselect = new JButton("Deselect All");
        this.buttonDeselect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MigratorFrame.this.listComponents.getSelectionModel().clearSelection();
            }
        });
        this.panelSelectButtons.add(this.buttonDeselect);
        this.buttonSelect.setMinimumSize(this.buttonDeselect.getMinimumSize());
        this.buttonSelect.setPreferredSize(this.buttonDeselect.getPreferredSize());
        this.buttonSelect.setMaximumSize(this.buttonDeselect.getMaximumSize());
        this.panelCommands = new JPanel();
        this.panelCommands.setLayout(new BoxLayout(this.panelCommands, 0));
        this.panelCommands.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.panelMain.add((Component)this.panelCommands, "South");
        this.panelCommands.add(Box.createRigidArea(new Dimension(5, 0)));
        this.progressBar = new JProgressBar();
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.progressBar.setMinimum(0);
        this.panelCommands.add(this.progressBar);
        this.panelCommands.add(Box.createRigidArea(new Dimension(10, 0)));
        this.buttonMigrate = new JButton("Migrate");
        this.buttonMigrate.setEnabled(false);
        this.buttonMigrate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MigratorFrame.this.migrate();
            }
        });
        this.panelCommands.add(this.buttonMigrate);
        this.panelCommands.add(Box.createRigidArea(new Dimension(5, 0)));
        this.buttonClose = new JButton("Close");
        this.buttonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                switch (MigratorFrame.this.getDefaultCloseOperation()) {
                    case 3: {
                        System.exit(0);
                        break;
                    }
                    case 1: {
                        MigratorFrame.this.hide();
                        break;
                    }
                    case 2: {
                        MigratorFrame.this.dispose();
                        break;
                    }
                }
            }
        });
        this.panelCommands.add(this.buttonClose);
        if (this.hb != null && this.hs != null) {
            this.panelCommands.add(Box.createRigidArea(new Dimension(5, 0)));
            this.buttonHelp = new JButton("Help");
            this.hb.enableHelpOnButton((Component)this.buttonHelp, DEFAULT_HELP_TOPIC, this.hs);
            this.panelCommands.add(this.buttonHelp);
        }
        this.panelCommands.add(Box.createRigidArea(new Dimension(3, 0)));
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                MigratorFrame.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(keyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", abstractAction);
    }

    private void createHelpSet() throws Exception {
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL uRL = HelpSet.findHelpSet((ClassLoader)classLoader, (String)"adapter_helpset.hs");
        this.hs = new HelpSet(classLoader, uRL);
        this.hb = this.hs.createHelpBroker();
        this.setHelpTopic(DEFAULT_HELP_TOPIC);
    }

    public void setHelpTopic(String string) {
        try {
            this.hb.setCurrentID(string);
            this.hb.enableHelpKey((Component)this.getRootPane(), string, this.hs);
        }
        catch (BadIDException badIDException) {
            this.hb.setCurrentID(DEFAULT_HELP_TOPIC);
            this.hb.enableHelpKey((Component)this.getRootPane(), DEFAULT_HELP_TOPIC, this.hs);
        }
    }

    public boolean mustRefresh() {
        return this.m_refresh;
    }

    public void resetRefresh() {
        this.m_refresh = false;
    }

    private void connect() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.listModel.clear();
            this.m_oldDirectory = DirectoryServiceProvider.getOldDirectoryService(this.textURL.getText(), this.textRoot.getText());
            Enumeration enumeration2 = this.m_oldDirectory.findAllBusComponents(0);
            ArrayList<BusComponent> arrayList = new ArrayList<BusComponent>();
            while (enumeration2.hasMoreElements()) {
                BusComponent busComponent = (BusComponent)enumeration2.nextElement();
                arrayList.add(busComponent);
            }
            Collections.sort(arrayList, new BusComponentComparator());
            int n = 0;
            while (n < arrayList.size()) {
                this.listModel.addElement(arrayList.get(n));
                ++n;
            }
        }
        catch (DirectoryException directoryException) {
            JOptionPane.showMessageDialog(null, directoryException);
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void migrate() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.buttonMigrate.setEnabled(false);
        final ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < this.listModel.size()) {
            if (this.listComponents.isSelectedIndex(n)) {
                arrayList.add(this.listModel.elementAt(n));
            }
            ++n;
        }
        this.progressBar.setMaximum(arrayList.size());
        this.m_overwriteState = 2;
        Thread thread = new Thread(new Runnable(){

            public void run() {
                Object object;
                ArrayList<Object> arrayList3 = new ArrayList<Object>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                int n = 0;
                while (n < arrayList.size()) {
                    object = (BusComponent)arrayList.get(n);
                    try {
                        if (MigratorFrame.this.migrate((BusComponent)object)) {
                            arrayList3.add(object);
                            MigratorFrame.this.m_refresh = true;
                        } else {
                            arrayList2.add(object + " : BusComponent already exists, not overwritten.");
                        }
                    }
                    catch (OWConfigurationException oWConfigurationException) {
                        s_logger.errorException(oWConfigurationException);
                        arrayList2.add(object + " : " + oWConfigurationException.getMessage());
                    }
                    MigratorFrame.this.progressBar.setValue(n);
                    ++n;
                }
                MigratorFrame.this.progressBar.setValue(arrayList.size());
                object = "Migration ";
                object = arrayList2.size() == 0 ? (String)object + "succeeded." : (arrayList3.size() == 0 ? (String)object + "failed." : (String)object + "partially succeeded.");
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(arrayList3.size() + " BusComponents successfully migrated.\n");
                if (arrayList2.size() > 0) {
                    stringBuffer.append("Failed to migrate " + arrayList2.size() + " BusComponents.\n\n");
                    stringBuffer.append("The following BusComponents failed to migrate:\n");
                    int n2 = 0;
                    while (n2 < arrayList2.size()) {
                        stringBuffer.append(arrayList2.get(n2));
                        stringBuffer.append("\n");
                        ++n2;
                    }
                }
                MigratorResultDialog migratorResultDialog = new MigratorResultDialog((Frame)MigratorFrame.this, (String)object, stringBuffer.toString());
                migratorResultDialog.setLocationRelativeTo(MigratorFrame.this);
                migratorResultDialog.show();
                MigratorFrame.this.buttonMigrate.setEnabled(true);
            }
        });
        this.setCursor(Cursor.getDefaultCursor());
        thread.start();
    }

    private boolean migrate(BusComponent busComponent) throws OWConfigurationException {
        int n;
        Object object;
        Object object2;
        Object object3;
        String string;
        BusComponentConfiguration busComponentConfiguration = null;
        String string2 = MigratorFrame.convertIdentifier(busComponent.getIdentifier());
        try {
            busComponentConfiguration = this.m_newDirectory.create(string2);
        }
        catch (OWConfigurationException oWConfigurationException) {
            string = oWConfigurationException.getMessage().toLowerCase();
            if (string.indexOf("already exist") >= 0) {
                if (this.m_overwriteState != 3 && this.m_overwriteState != 4) {
                    object3 = new OverwriteDialog((Frame)this, string2);
                    this.m_overwriteState = ((OverwriteDialog)object3).getResult();
                }
                if (this.m_overwriteState == 1 || this.m_overwriteState == 3) {
                    this.m_newDirectory.removeConfiguration(string2);
                    busComponentConfiguration = this.m_newDirectory.create(string2);
                }
                return false;
            }
            throw oWConfigurationException;
        }
        String string3 = "";
        try {
            string3 = busComponent.getDescription();
        }
        catch (AttributeNotSpecifiedException attributeNotSpecifiedException) {
            // empty catch block
        }
        busComponentConfiguration.setDescription(string3);
        string = busComponent.getOwnerID();
        if (string.startsWith("uid=")) {
            string = string.substring(4);
        }
        busComponentConfiguration.setOwner(string);
        object3 = "";
        try {
            object3 = busComponent.getAdministratorID();
            if (((String)object3).startsWith("uid=")) {
                object3 = ((String)object3).substring(4);
            }
        }
        catch (AttributeNotSpecifiedException attributeNotSpecifiedException) {
            // empty catch block
        }
        busComponentConfiguration.setAdministrator((String)object3);
        busComponentConfiguration.setDefaultUserSession(busComponent.getDefaultUserSession() != null);
        String string4 = busComponent.getCryptedUsername();
        if (string4 != null) {
            busComponentConfiguration.setUsername(string4, true);
        }
        String string5 = busComponent.getCryptedPassword();
        if (string4 != null) {
            busComponentConfiguration.setPassword(string5, true);
        }
        int n2 = -1;
        try {
            n2 = busComponent.getCompanyNumber();
        }
        catch (AttributeNotSpecifiedException attributeNotSpecifiedException) {
            // empty catch block
        }
        busComponentConfiguration.setCompanyNumber(n2);
        Activation activation = null;
        try {
            activation = busComponent.getActivation();
        }
        catch (AttributeNotSpecifiedException attributeNotSpecifiedException) {
            // empty catch block
        }
        if (activation != null) {
            busComponentConfiguration.setActivationType(activation.getType());
            busComponentConfiguration.setActivationServiceReference(activation.getServiceReference());
            object2 = activation.getAPSBusComponent();
            if (object2 != null) {
                object2 = MigratorFrame.convertIdentifier((String)object2);
            }
            busComponentConfiguration.setActivationPoolingService((String)object2);
            object = activation.getPolicy();
            int n3 = activation.getMaxReferences();
            int n4 = activation.getMaxConnections();
            n = activation.getKeepAliveTime();
            busComponentConfiguration.setActivationPoolingPolicy((String)object);
            busComponentConfiguration.setActivationMaxReferences(n3);
            busComponentConfiguration.setActivationMaxConnections(n4);
            busComponentConfiguration.setActivationKeepAliveTime(n);
            int n5 = 720;
            try {
                n5 = Integer.parseInt(activation.getServerTimeout());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            busComponentConfiguration.setActivationServerTimeout(n5);
        } else {
            busComponentConfiguration.setActivationType("");
        }
        try {
            object2 = busComponent.getCategories();
            object = new ArrayList();
            while (object2.hasMoreElements()) {
                String string6 = (String)object2.nextElement();
                ((ArrayList)object).add(string6);
            }
            busComponentConfiguration.setCategories(((ArrayList)object).toArray(new String[0]));
        }
        catch (AttributeNotSpecifiedException attributeNotSpecifiedException) {
            // empty catch block
        }
        object2 = busComponent.getConnectionPoints();
        object = new ArrayList();
        while (object2.hasMoreElements()) {
            ConnectionPoint connectionPoint = (ConnectionPoint)object2.nextElement();
            try {
                String string7 = connectionPoint.getURI().toString();
                n = 0;
                try {
                    n = connectionPoint.isPreferredConnection() ? 1 : 0;
                }
                catch (AttributeNotSpecifiedException attributeNotSpecifiedException) {
                    // empty catch block
                }
                if (n != 0) {
                    ((ArrayList)object).add(0, string7);
                    continue;
                }
                ((ArrayList)object).add(string7);
            }
            catch (MalformedURIException malformedURIException) {
                // empty catch block
            }
        }
        busComponentConfiguration.setConnectionPoints(((ArrayList)object).toArray(new String[0]));
        busComponentConfiguration.store();
        return true;
    }

    private static String convertIdentifier(String string) {
        int n;
        if (string.startsWith("cn=")) {
            string = string.substring(3);
        }
        if ((n = string.indexOf(44)) > 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class BusComponentComparator
    implements Comparator {
        private BusComponentComparator() {
        }

        public int compare(Object object, Object object2) {
            BusComponent busComponent = (BusComponent)object;
            BusComponent busComponent2 = (BusComponent)object2;
            return busComponent.getIdentifier().compareTo(busComponent2.getIdentifier());
        }
    }
}

