/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owtools.ccf;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.JHelp;
import javax.help.TextHelpModel;
import javax.swing.JFrame;
import javax.swing.UIManager;

public class HelpLauncher
extends JFrame {
    private static final String HELPSET = "adapter_helpset.hs";
    private static final String DEFAULT_TITLE = "SSA Integration";
    private HelpSet hs;
    private HelpBroker hb;
    private JHelp jh;
    private static JFrame frame;

    public HelpLauncher() {
        this.initComponents();
    }

    public void launch() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL uRL = HelpSet.findHelpSet((ClassLoader)classLoader, (String)HELPSET);
        try {
            this.hs = new HelpSet(classLoader, uRL);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            System.exit(0);
        }
        this.jh = new JHelp(this.hs);
        this.createFrame();
        ((Component)frame).setVisible(true);
    }

    protected JFrame createFrame() {
        TextHelpModel textHelpModel = this.jh.getModel();
        HelpSet helpSet = textHelpModel.getHelpSet();
        String string = helpSet.getTitle();
        if (string == null || string.equals("")) {
            this.setTitle(DEFAULT_TITLE);
        } else {
            this.setTitle(string);
        }
        if (frame == null) {
            WindowAdapter windowAdapter = new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }

                public void windowClosed(WindowEvent windowEvent) {
                    System.exit(0);
                }
            };
            frame = new JFrame(this.getTitle());
            frame.addWindowListener(windowAdapter);
            frame.getContentPane().add((Component)this.jh);
        } else {
            frame.setTitle(this.getTitle());
        }
        frame.pack();
        return frame;
    }

    private void initComponents() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                HelpLauncher.this.exitForm(windowEvent);
            }
        });
        this.pack();
    }

    private void exitForm(WindowEvent windowEvent) {
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        System.setProperty("swing.noxp", "true");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        HelpLauncher helpLauncher = new HelpLauncher();
        helpLauncher.launch();
    }
}

