/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owtools.ccf;

import com.baan.b3impl.about.AdapterComponentInfo;
import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.baan.owimpl.fw.ccf.impl.DirectoryURL;

public class DirectoryURLEditor {
    static /* synthetic */ Class class$com$baan$owtools$ccf$DirectoryURLEditor;

    static void displayCurrentURL(String string) {
        if (string == null) {
            System.out.println("The configuration directory URL is currently not set.");
        } else {
            System.out.println("The current setting for the configuration directory URL is:");
            System.out.println(string);
            System.out.println();
        }
    }

    static void displayUsage(int n) {
        System.out.println();
        System.out.println("Usage: java " + (class$com$baan$owtools$ccf$DirectoryURLEditor == null ? (class$com$baan$owtools$ccf$DirectoryURLEditor = DirectoryURLEditor.class$("com.baan.owtools.ccf.DirectoryURLEditor")) : class$com$baan$owtools$ccf$DirectoryURLEditor).getName() + " [\"configuration directory URL\"]");
        System.out.println(" No arguments will show the current configuration.");
        System.out.println(" The URL should start with ldap, file or http.");
        System.out.println();
        System.out.println("URL Examples:");
        System.out.println(" ldap://ldapserver/o=ssaglobal.com");
        System.out.println(" ldap://ldapserver/dc=domain,dc=com");
        System.out.println(" http://webserver/path/config.xml");
        System.out.println(" \"file:///C:\\Documents and Settings\\All Users\\config.xml\" ");
        System.out.println();
        System.exit(n);
    }

    public static void main(String[] stringArray) {
        System.out.println("Directory URL Editor");
        System.out.println(new AdapterComponentInfo().getCopyrightMessage());
        System.out.println();
        String string = DirectoryURL.get();
        switch (stringArray.length) {
            case 0: {
                DirectoryURLEditor.displayCurrentURL(string);
                break;
            }
            case 1: {
                if (stringArray[0].startsWith("-") || stringArray[0].startsWith("?")) {
                    System.err.println("Incorrect Argument.");
                    DirectoryURLEditor.displayUsage(2);
                }
                try {
                    DirectoryURLEditor.displayCurrentURL(string);
                    DirectoryURL.set(stringArray[0]);
                    if (DirectoryURL.get() == null) {
                        System.err.println("Failed to set the URL.");
                        System.out.println("Hint: Check if the directory where the owconfig.properties file is located is also mentioned in the classpath.");
                        DirectoryURLEditor.displayUsage(3);
                        break;
                    }
                    System.out.println("The value has been changed to:");
                    System.out.println(DirectoryURL.get());
                    System.out.println();
                }
                catch (OWConfigurationException oWConfigurationException) {
                    System.err.println("Failed to set the URL: " + oWConfigurationException.getMessage());
                    DirectoryURLEditor.displayUsage(1);
                }
                break;
            }
            default: {
                System.err.println("Too many arguments.");
                System.out.println("Hint: use \" \" around arguments that contain spaces.");
                DirectoryURLEditor.displayUsage(2);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

