/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owtools.ccf;

import com.baan.b3impl.about.AdapterComponentInfo;
import com.baan.owimpl.fw.ccf.AdapterClientContext;
import com.baan.owimpl.fw.ccf.BusComponentCategoryContext;
import com.baan.owimpl.fw.ccf.BusComponentContext;
import com.baan.owimpl.fw.ccf.ConfigurationContext;
import com.baan.owimpl.fw.ccf.IdentifierConfiguration;
import com.baan.owimpl.fw.ccf.IdentifierContext;
import com.baan.owimpl.fw.ccf.LoggingContext;
import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.baan.owimpl.fw.ccf.SOAPConnectorContext;
import com.baan.owimpl.fw.ccf.SmartConfiguration;
import com.baan.owimpl.fw.ccf.SmartContext;
import com.baan.owimpl.fw.ccf.XMLConnectorContext;
import com.baan.owimpl.fw.ccf.dt.LogCategories;
import com.baan.owimpl.fw.ccf.dt.LogLevelEnum;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.baan.owtools.ccf.ui.ConfigBrowser;
import com.eibus.services.activation.utils.SplitString;
import com.eibus.tools.cmdline.CommandLine;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class AdminConsole {
    private static final String ARG_TYPE = "type";
    private static final String ARG_ACTION = "action";
    private static final String ARG_ID = "id";
    private static final String ARG_MACHINE = "machine";
    private static final String ARG_USER = "user";
    private static final String ARG_APPLICATION = "application";
    private static final String ARG_CURRENT = "current";
    private static final String ARG_DEFAULTING = "defaulting";
    private static final String ARG_SET = "set";
    private static final String ARG_USERNAME = "login";
    private static final String ARG_PASSWORD = "password";
    private static final String[] s_flags;
    private static final String[] s_flarg;
    private static final String[] s_arg;
    private static final String DEFAULT = "_default_";
    private ConfigurationContext m_directory = null;
    private String m_type = null;
    private String m_action = null;
    private String m_id = null;
    private String m_machine = null;
    private String m_user = null;
    private String m_application = null;
    private boolean m_current = false;
    private boolean m_defaulting = false;
    private String m_property = null;
    private String m_value = null;
    private String m_username = null;
    private String m_password = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$com$baan$owimpl$fw$ccf$dt$LogLevelEnum;
    static /* synthetic */ Class class$com$baan$owimpl$fw$ccf$dt$LogCategories;
    static /* synthetic */ Class class$com$baan$owtools$ccf$AdminConsole;

    private AdminConsole(String[] stringArray) {
        System.out.println("Central Configuration Console");
        System.out.println(new AdapterComponentInfo().getCopyrightMessage());
        System.out.println();
        try {
            CommandLine commandLine = new CommandLine(stringArray, s_flags, s_flarg, s_arg);
            CommandLine.ParseResult parseResult = commandLine.parseResult();
            if (parseResult.hasOption(ARG_USERNAME)) {
                this.m_username = parseResult.getOptionArgument(ARG_USERNAME);
                this.m_password = parseResult.getOptionArgument(ARG_PASSWORD);
                ConfigurationContext.setAuthenticationInfo(this.m_username, this.m_password);
            }
            if (!parseResult.hasOption(ARG_TYPE)) {
                throw new CommandLine.ParseException("-type is a mandatory argument");
            }
            this.m_type = parseResult.getOptionArgument(ARG_TYPE);
            if (this.m_type.equalsIgnoreCase("BusComponent")) {
                this.m_directory = BusComponentContext.getInstance();
            } else if (this.m_type.equalsIgnoreCase("BusComponentCategory")) {
                this.m_directory = BusComponentCategoryContext.getInstance();
            } else if (this.m_type.equalsIgnoreCase("Logging")) {
                this.m_directory = LoggingContext.getInstance();
            } else if (this.m_type.equalsIgnoreCase("AdapterClient")) {
                this.m_directory = AdapterClientContext.getInstance();
            } else if (this.m_type.equalsIgnoreCase("XMLConnector")) {
                this.m_directory = XMLConnectorContext.getInstance();
            } else if (this.m_type.equalsIgnoreCase("WebServices")) {
                this.m_directory = SOAPConnectorContext.getInstance();
            } else {
                throw new CommandLine.ParseException("type must be BusComponent, BusComponentCategory, Logging, AdapterClient, XMLConnector or WebServices");
            }
            if (!parseResult.hasOption(ARG_ACTION)) {
                throw new CommandLine.ParseException("-action is a mandatory argument");
            }
            this.m_action = parseResult.getOptionArgument(ARG_ACTION);
            if (!(this.m_action.equals("list") || this.m_action.equals("view") || this.m_action.equals("add") || this.m_action.equals("delete") || this.m_action.equals("update"))) {
                throw new CommandLine.ParseException("action must be list, view, add, delete or update");
            }
            if (this.m_action.equals("list")) {
                return;
            }
            if (this.m_directory instanceof IdentifierContext) {
                if (!parseResult.hasOption(ARG_ID)) {
                    throw new CommandLine.ParseException("id is mandatory for " + this.m_type + " configurations");
                }
                this.m_id = parseResult.getOptionArgument(ARG_ID);
            } else {
                if (parseResult.hasOption(ARG_MACHINE)) {
                    this.m_machine = parseResult.getOptionArgument(ARG_MACHINE);
                }
                if (parseResult.hasOption(ARG_USER)) {
                    this.m_user = parseResult.getOptionArgument(ARG_USER);
                }
                if (parseResult.hasOption(ARG_APPLICATION)) {
                    this.m_application = parseResult.getOptionArgument(ARG_APPLICATION);
                }
                this.m_defaulting = parseResult.hasOption(ARG_DEFAULTING);
                this.m_current = parseResult.hasOption(ARG_CURRENT);
                if (this.m_current && (this.m_machine != null || this.m_user != null || this.m_application != null)) {
                    throw new CommandLine.ParseException("machine,user,application cannot be specified in combination with current");
                }
            }
            if (this.m_action.equals("update")) {
                if (!parseResult.hasOption(ARG_SET)) {
                    throw new CommandLine.ParseException("set is mandatory for update action");
                }
                String string = parseResult.getOptionArgument(ARG_SET);
                int n = string.indexOf(61);
                if (n <= 0) {
                    throw new CommandLine.ParseException("Invalid set syntax, must be <property>=<value>");
                }
                this.m_property = string.substring(0, n);
                this.m_value = string.substring(n + 1);
            }
        }
        catch (OWConfigurationException oWConfigurationException) {
            AdminConsole.error(oWConfigurationException);
            System.exit(2);
        }
        catch (Exception exception) {
            AdminConsole.error(exception);
            AdminConsole.usage();
            System.exit(1);
        }
    }

    public void execute() {
        try {
            if (this.m_directory != null) {
                System.out.println("Directory URL: " + this.m_directory.getURL());
                System.out.println("Configuration type: " + this.m_type + " (" + this.m_directory.getConfigurationClass().getName() + ")");
                System.out.println();
            }
            this.getClass().getMethod(this.m_action, null).invoke((Object)this, null);
        }
        catch (InvocationTargetException invocationTargetException) {
            AdminConsole.error(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            AdminConsole.error(exception);
        }
    }

    public void list() throws Exception {
        int n = 0;
        if (this.m_directory instanceof IdentifierContext) {
            String[] stringArray = ((IdentifierContext)this.m_directory).list();
            int n2 = 0;
            while (n2 < stringArray.length) {
                System.out.println(stringArray[n2]);
                ++n2;
            }
            n = stringArray.length;
        } else if (this.m_directory instanceof SmartContext) {
            SmartContext smartContext = (SmartContext)this.m_directory;
            String[] stringArray = smartContext.listMachines();
            int n3 = 0;
            while (n3 < stringArray.length) {
                String string = stringArray[n3];
                String[] stringArray2 = smartContext.listUsers(string);
                int n4 = 0;
                while (n4 < stringArray2.length) {
                    String string2 = stringArray2[n4];
                    String[] stringArray3 = smartContext.listApplications(string, string2);
                    int n5 = 0;
                    while (n5 < stringArray3.length) {
                        String string3 = stringArray3[n5];
                        System.out.println(string + " - " + string2 + " - " + string3);
                        ++n;
                        ++n5;
                    }
                    ++n4;
                }
                ++n3;
            }
        } else {
            throw new Exception("Internal error: unknown configuration " + this.m_directory.getClass().getName());
        }
        System.out.println();
        System.out.println("Number of configurations: " + n);
    }

    public void view() throws Exception {
        if (this.m_directory instanceof IdentifierContext) {
            IdentifierConfiguration identifierConfiguration = ((IdentifierContext)this.m_directory).getConfiguration(this.m_id);
            identifierConfiguration.print(System.out);
        } else if (this.m_directory instanceof SmartContext) {
            SmartConfiguration smartConfiguration = this.findSmartConfiguration();
            smartConfiguration.print(System.out);
        } else {
            throw new Exception("Internal error: unknown configuration " + this.m_directory.getClass().getName());
        }
    }

    public void add() throws Exception {
        if (this.m_directory instanceof IdentifierContext) {
            IdentifierConfiguration identifierConfiguration = ((IdentifierContext)this.m_directory).createConfiguration(this.m_id);
            identifierConfiguration.print(System.out);
        } else if (this.m_directory instanceof SmartContext) {
            SmartConfiguration smartConfiguration = ((SmartContext)this.m_directory).createConfiguration(this.m_machine, this.m_user, this.m_application);
            smartConfiguration.print(System.out);
        } else {
            throw new Exception("Internal error: unknown configuration " + this.m_directory.getClass().getName());
        }
        System.out.println();
        System.out.println("Configuration created");
    }

    public void delete() throws Exception {
        if (this.m_directory instanceof IdentifierContext) {
            System.out.println("Removing " + this.m_id);
            ((IdentifierContext)this.m_directory).removeConfiguration(this.m_id);
        } else if (this.m_directory instanceof SmartContext) {
            System.out.println("Removing " + (this.m_machine != null ? this.m_machine : DEFAULT) + " - " + (this.m_user != null ? this.m_user : DEFAULT) + " - " + (this.m_application != null ? this.m_application : DEFAULT));
            if (this.hasChildren()) {
                throw new Exception("This configuration has child configurations and cannot be removed");
            }
            ((SmartContext)this.m_directory).removeConfiguration(this.m_machine, this.m_user, this.m_application);
        } else {
            throw new Exception("Internal error: unknown configuration " + this.m_directory.getClass().getName());
        }
        System.out.println("Configuration removed");
    }

    public void update() throws Exception {
        if (this.m_directory instanceof IdentifierContext) {
            IdentifierConfiguration identifierConfiguration = ((IdentifierContext)this.m_directory).getConfiguration(this.m_id);
            this.update(identifierConfiguration);
            identifierConfiguration.store();
        } else if (this.m_directory instanceof SmartContext) {
            SmartConfiguration smartConfiguration = this.findSmartConfiguration();
            this.update(smartConfiguration);
            smartConfiguration.store();
        } else {
            throw new Exception("Internal error: unknown configuration " + this.m_directory.getClass().getName());
        }
        System.out.println("Configuration updated");
    }

    private void update(Object object) throws Exception {
        System.out.println("Updating " + object);
        System.out.println("Property = " + this.m_property);
        System.out.println("Value    = " + this.m_value);
        String string = ARG_SET + this.m_property;
        Method[] methodArray = object.getClass().getMethods();
        Method method = null;
        int n = 0;
        while (n < methodArray.length) {
            if (methodArray[n].getName().equals(string)) {
                method = methodArray[n];
                break;
            }
            ++n;
        }
        if (method == null) {
            throw new Exception("Property " + this.m_property + " cannot be set, its name is incorrect");
        }
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length != 1) {
            throw new Exception("Property " + this.m_property + " cannot be set, its name is incorrect");
        }
        Class<?> clazz = classArray[0];
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = AdminConsole.class$("java.lang.String")) : class$java$lang$String)) {
            method.invoke(object, this.m_value);
            return;
        }
        if (clazz == Integer.TYPE) {
            Integer n2 = new Integer(this.m_value);
            method.invoke(object, n2);
            return;
        }
        if (clazz == Boolean.TYPE) {
            Boolean bl = new Boolean(this.m_value);
            method.invoke(object, bl);
            return;
        }
        if (clazz == (array$Ljava$lang$String == null ? (array$Ljava$lang$String = AdminConsole.class$("[Ljava.lang.String;")) : array$Ljava$lang$String)) {
            String[] stringArray = new SplitString(this.m_value, ";").getParts();
            method.invoke(object, new Object[]{stringArray});
            return;
        }
        if (clazz == (class$com$baan$owimpl$fw$ccf$dt$LogLevelEnum == null ? (class$com$baan$owimpl$fw$ccf$dt$LogLevelEnum = AdminConsole.class$("com.baan.owimpl.fw.ccf.dt.LogLevelEnum")) : class$com$baan$owimpl$fw$ccf$dt$LogLevelEnum)) {
            LogLevelEnum logLevelEnum = LogLevelEnum.getEnum(Integer.parseInt(this.m_value));
            method.invoke(object, logLevelEnum);
            return;
        }
        if (clazz == (class$com$baan$owimpl$fw$ccf$dt$LogCategories == null ? (class$com$baan$owimpl$fw$ccf$dt$LogCategories = AdminConsole.class$("com.baan.owimpl.fw.ccf.dt.LogCategories")) : class$com$baan$owimpl$fw$ccf$dt$LogCategories)) {
            LogCategories logCategories = new LogCategories(Integer.parseInt(this.m_value));
            method.invoke(object, logCategories);
            return;
        }
        throw new Exception("Property cannot be set, type is not supported");
    }

    private SmartConfiguration findSmartConfiguration() throws OWConfigurationException {
        SmartContext smartContext = (SmartContext)this.m_directory;
        if (this.m_defaulting) {
            if (this.m_current) {
                return smartContext.searchConfiguration();
            }
            return smartContext.searchConfiguration(this.m_machine, this.m_user, this.m_application);
        }
        if (this.m_current) {
            return smartContext.getConfiguration();
        }
        return smartContext.getConfiguration(this.m_machine, this.m_user, this.m_application);
    }

    private boolean hasChildren() throws OWConfigurationException {
        SmartContext smartContext = (SmartContext)this.m_directory;
        if (this.m_application == null) {
            String[] stringArray = smartContext.listApplications(this.m_machine, this.m_user);
            if (stringArray.length > 1) {
                return true;
            }
            if (this.m_user == null) {
                stringArray = smartContext.listUsers(this.m_machine);
                if (stringArray.length > 1) {
                    return true;
                }
                if (this.m_machine == null && (stringArray = smartContext.listMachines()).length > 1) {
                    return true;
                }
            }
        }
        return false;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            ConfigBrowser.main(stringArray);
        } else {
            AdminConsole adminConsole = new AdminConsole(stringArray);
            adminConsole.execute();
        }
    }

    public static void error(Throwable throwable) {
        String string = throwable.getMessage();
        System.out.println("Error: " + (string != null ? string : throwable.toString()));
    }

    public static void usage() {
        System.out.println();
        System.out.println("Usage: " + (class$com$baan$owtools$ccf$AdminConsole == null ? (class$com$baan$owtools$ccf$AdminConsole = AdminConsole.class$("com.baan.owtools.ccf.AdminConsole")) : class$com$baan$owtools$ccf$AdminConsole).getName());
        System.out.println("\t-type BusComponent|BusComponentCategory|Logging|AdapterClient|XMLConnector|WebServices");
        System.out.println("\t-action list|view|add|delete|update");
        System.out.println("\t[-id <id>] | [-machine <machine>] [-user <user>] [-application <application>] | [-current]");
        System.out.println("\t[-set <property>=<value>] [-defaulting]");
        System.out.println("\t[-login <username> -password <password>]");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        LoggerFactory.setApplicationName(LoggerFactory.APP_CC_CONSOLE);
        s_flags = new String[]{ARG_DEFAULTING, ARG_CURRENT};
        s_flarg = new String[0];
        s_arg = new String[]{ARG_USERNAME, ARG_PASSWORD, ARG_TYPE, ARG_ACTION, ARG_ID, ARG_MACHINE, ARG_USER, ARG_APPLICATION, ARG_SET};
    }
}

