/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owtools;

import com.baan.b3.boi1.BoiException;
import com.baan.b3.boi1.BoiToolkit;
import com.baan.b3.boi1.IBackend;
import com.baan.b3.legacydirectory.DirectoryException;
import com.baan.b3.legacydirectory.DirectoryToolkit;
import com.baan.b3impl.about.AdapterComponentInfo;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.tools.cmdline.CommandLine;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Calendar;
import java.util.Date;

public class BackendControl {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.owtools", "BackendControl");
    private static final String ARGUMENT_BC = "busc";
    private static final String ARGUMENT_ACTION = "action";
    private static final String ACTION_PING = "ping";
    private static final String ACTION_STOP = "deactivate";
    private static final String ACTION_P_STAT = "stats";
    private static final String ACTION_P_TYPE = "type";
    private static final String ACTION_P_RESET = "reset";
    private static final String ACTION_P_FINDRUNNING = "findRunning";
    private static final String ACTION_P_ALL = "all";
    private static final String MENU_HELP1 = "help";
    private static final String MENU_HELP2 = "?";
    private static final String MENU_HELP3 = "h";
    private static final String MENU_QUIT1 = "exit";
    private static final String MENU_QUIT2 = "quit";
    private static final String VARIABLE_NOTE = "Note : Works only for Backends running a non variable BusComponent.";
    private static final int EXIT_ERROR = 1;
    private static final int EXIT_OK = 0;
    private static final int BC_PER_THREAD = 12;
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String TOOL_USAGE = NEWLINE + "java " + (class$com$baan$owtools$BackendControl == null ? (class$com$baan$owtools$BackendControl = BackendControl.class$("com.baan.owtools.BackendControl")) : class$com$baan$owtools$BackendControl).getName() + " -" + "busc" + " <buscomponentID> [-" + "action" + " <action type>] | -" + "findRunning" + NEWLINE + NEWLINE + "options:" + NEWLINE + "  -" + "busc" + "         Perform action on Backend specified by buscomponentID" + NEWLINE + "  -" + "action" + "       Optional argument for -" + "busc" + ", when not specified interactive mode is entered" + NEWLINE + "  -" + "findRunning" + "  Look for running Backends" + NEWLINE + NEWLINE + "action types:" + NEWLINE + "  " + "ping" + "        Pings the backend" + NEWLINE + "  " + "deactivate" + "  Tries to stop the backend" + NEWLINE + "  " + "stats" + "       Prints the statistics of the backend" + NEWLINE + "  " + "type" + "        Prints the type of the backend" + NEWLINE + "  " + "all" + "         Prints all information from backend" + NEWLINE + "  " + "reset" + "       Resets all backend statistics" + NEWLINE + NEWLINE + "Note : Works only for Backends running a non variable BusComponent." + NEWLINE + NEWLINE;
    private static final String MENU_USAGE = NEWLINE + "Menu Commands:" + NEWLINE + "  " + "exit" + "," + "quit" + "   Stops this tool" + NEWLINE + "  " + "ping" + "        Pings the backend" + NEWLINE + "  " + "deactivate" + "  Tries to stop the backend" + NEWLINE + "  " + "stats" + "       Prints the statistics of the backend" + NEWLINE + "  " + "type" + "        Prints the type of the backend" + NEWLINE + "  " + "all" + "         Prints all information from backend" + NEWLINE + "  " + "reset" + "       Resets all backend statistics" + NEWLINE + "  " + "help" + "," + "?" + "," + "h" + "    Prints this help" + NEWLINE + NEWLINE;
    private IBackend m_backend = null;
    private static BackendControl m_BackendControl = null;
    private String m_buscomponentid = null;
    private long m_timeout;
    private boolean m_interactive = false;
    public static int ready = 0;
    static /* synthetic */ Class class$com$baan$owtools$BackendControl;

    private BackendControl(String string, boolean bl) {
        this.m_buscomponentid = string;
        this.m_backend = BoiToolkit.getDefaultToolkit().createBackend(string);
        this.m_interactive = bl;
        try {
            this.m_timeout = this.m_backend.getTimeout();
        }
        catch (Exception exception) {}
    }

    private void doPing() {
        try {
            int n = (int)this.m_backend.ping();
            System.out.println();
            if (!this.m_interactive) {
                System.out.println("Pinging Backend '" + this.m_buscomponentid + "' took " + n + " ms.");
            } else {
                System.out.println("Pinging took " + n + " ms.");
            }
            System.out.println();
            this.CheckStop(false);
        }
        catch (BoiException boiException) {
            System.out.println("Error pinging '" + this.m_buscomponentid + "' (timeout= " + this.m_timeout + " ms.) : " + boiException.toString());
            this.CheckStop(true);
        }
    }

    private void doReset() {
        try {
            this.m_backend.reset();
            System.out.println();
            if (!this.m_interactive) {
                System.out.println("Resetting statistics Backend '" + this.m_buscomponentid + "'");
            } else {
                System.out.println("Resetting statistics");
            }
            System.out.println();
            this.CheckStop(false);
        }
        catch (BoiException boiException) {
            System.out.println("Error Resetting statistics '" + this.m_buscomponentid + "' (timeout= " + this.m_timeout + " ms.) : " + boiException.toString());
            this.CheckStop(true);
        }
    }

    private void doType() {
        try {
            String string = this.m_backend.getType();
            System.out.println();
            if (!this.m_interactive) {
                System.out.println("Backend running '" + this.m_buscomponentid + "' = " + string);
            } else {
                System.out.println("Backend type = " + string);
            }
            System.out.println();
            this.CheckStop(false);
        }
        catch (BoiException boiException) {
            System.out.println("Error getting type for '" + this.m_buscomponentid + "' (timeout= " + this.m_timeout + " ms.) : " + boiException.toString());
            this.CheckStop(true);
        }
    }

    private void doDeactivate() {
        try {
            this.m_backend.deactivate();
            System.out.println();
            System.out.println("Send to stop Backend '" + this.m_buscomponentid + "'");
            System.out.println();
            this.CheckStop(false);
        }
        catch (BoiException boiException) {
            System.out.println("Error sending stop signal to '" + this.m_buscomponentid + "' (timeout= " + this.m_timeout + " ms.) : " + boiException.toString());
            this.CheckStop(true);
        }
    }

    private void doStats() {
        try {
            IBackend.Statistics statistics = this.m_backend.statistics();
            System.out.println();
            if (!this.m_interactive) {
                System.out.println("Statistics for Backend running '" + this.m_buscomponentid + "'");
            } else {
                System.out.println("Statistics:");
            }
            System.out.println("  # Total calls    = " + statistics.Total);
            System.out.println("  # function calls = " + statistics.Function);
            System.out.println("  # query calls    = " + statistics.Query);
            System.out.println("  # update calls   = " + statistics.Update);
            System.out.println("  # control calls  = " + statistics.Control);
            System.out.println("  # app. errors    = " + statistics.ApplicationErrors);
            System.out.println("  # bus errors     = " + statistics.BusErrors);
            System.out.println("  # fatal errors   = " + statistics.FatalErrors);
            System.out.println();
            long l = statistics.getProcessingTime();
            System.out.println("  Processing time  = " + l + " ms. " + this.printTime(l));
            long l2 = statistics.getRunningTime();
            System.out.println("  Running time     = " + l2 + " ms. " + this.printTime(l2));
            System.out.println("  Load (average)   = " + this.printIdle(l, l2) + " %");
            System.out.println();
            this.CheckStop(false);
        }
        catch (BoiException boiException) {
            System.out.println("Error getting statistics '" + this.m_buscomponentid + "' (timeout= " + this.m_timeout + " ms.) : " + boiException.toString());
            this.CheckStop(true);
        }
    }

    private String printIdle(long l, long l2) {
        if (l2 == 0L) {
            return "100";
        }
        double d = (double)l / (double)l2;
        double d2 = 100.0 * d;
        int n = (int)d2;
        return "" + n;
    }

    private String printTime(long l) {
        Date date = new Date(l);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int n = calendar.get(13);
        int n2 = calendar.get(12);
        int n3 = calendar.get(11) - 1;
        int n4 = calendar.get(6) - 1;
        if (n4 > 1) {
            return "" + n4 + " days, " + this.digit(n3) + ":" + this.digit(n2) + ":" + this.digit(n) + " (h:m:s)";
        }
        return "" + this.digit(n3) + ":" + this.digit(n2) + ":" + this.digit(n) + " (h:m:s)";
    }

    private String digit(int n) {
        String string = "" + n;
        if (string.length() == 1) {
            string = "0" + string;
        }
        return string;
    }

    private void doAll() {
        boolean bl = this.m_interactive;
        this.m_interactive = true;
        System.out.println();
        System.out.println("Getting info from Backend running '" + this.m_buscomponentid + "'");
        this.doType();
        this.doStats();
        this.doPing();
        this.m_interactive = bl;
    }

    private void close() {
        this.m_backend.close();
    }

    private void CheckStop(boolean bl) {
        if (!this.m_interactive) {
            this.m_backend.close();
            if (bl) {
                System.exit(1);
            } else {
                System.exit(0);
            }
        }
    }

    private void startInteractiveMode() {
        new Interactive(this, this.m_buscomponentid).start();
    }

    private static void processAction(String string) {
        if (ACTION_PING.equalsIgnoreCase(string)) {
            m_BackendControl.doPing();
        } else if (ACTION_STOP.equalsIgnoreCase(string)) {
            m_BackendControl.doDeactivate();
        } else if (ACTION_P_STAT.equalsIgnoreCase(string)) {
            m_BackendControl.doStats();
        } else if (ACTION_P_TYPE.equalsIgnoreCase(string)) {
            m_BackendControl.doType();
        } else if (ACTION_P_ALL.equalsIgnoreCase(string)) {
            m_BackendControl.doAll();
        } else if (ACTION_P_RESET.equalsIgnoreCase(string)) {
            m_BackendControl.doReset();
        } else if (BackendControl.m_BackendControl.m_interactive) {
            System.out.println("unknown command '" + string + "'");
        } else {
            System.out.println("unknown action type '" + string + "'");
            m_BackendControl.CheckStop(true);
        }
    }

    public static void main(String[] stringArray) {
        LoggerFactory.setApplicationName(LoggerFactory.APP_BACKEND_CONTROL);
        System.out.println("Backend Control Tool");
        System.out.println(new AdapterComponentInfo().getCopyrightMessage());
        System.out.println();
        String[] stringArray2 = new String[]{ACTION_P_FINDRUNNING};
        String[] stringArray3 = new String[]{};
        String[] stringArray4 = new String[]{ARGUMENT_BC, ARGUMENT_ACTION};
        CommandLine.ParseResult parseResult = null;
        CommandLine commandLine = null;
        try {
            String string;
            commandLine = new CommandLine(stringArray, stringArray2, stringArray3, stringArray4);
            parseResult = commandLine.parseResult();
            if (parseResult.hasOption(ACTION_P_FINDRUNNING)) {
                new BackendControl("", true).findRunningBackends();
                System.exit(0);
            }
            if (!parseResult.hasOption(ARGUMENT_BC) && !parseResult.hasOption(ARGUMENT_ACTION)) {
                System.out.println(TOOL_USAGE);
                System.exit(1);
            } else if (!parseResult.hasOption(ARGUMENT_BC) && parseResult.hasOption(ARGUMENT_ACTION)) {
                System.out.println("Error, the BusComponent is not optional");
                System.out.println(TOOL_USAGE);
                System.exit(1);
            } else if (parseResult.hasOption(ARGUMENT_BC) && !parseResult.hasOption(ARGUMENT_ACTION)) {
                System.out.println("Entering interactive mode . . .");
                System.out.println();
                string = parseResult.getOptionArgument(ARGUMENT_BC);
                m_BackendControl = new BackendControl(string, true);
                m_BackendControl.startInteractiveMode();
            }
            if (parseResult.hasOption(ARGUMENT_BC) && parseResult.hasOption(ARGUMENT_ACTION)) {
                string = parseResult.getOptionArgument(ARGUMENT_ACTION);
                String string2 = parseResult.getOptionArgument(ARGUMENT_BC);
                m_BackendControl = new BackendControl(string2, false);
                BackendControl.processAction(string);
                m_BackendControl.close();
            }
        }
        catch (CommandLine.ParseException parseException) {
            System.out.println("invalid argument(s): " + NEWLINE + parseException);
            System.exit(1);
        }
    }

    private void findRunningBackends() {
        try {
            System.out.print("Looking up all BusComponents from directory, ");
            String[] stringArray = DirectoryToolkit.getDefaultToolkit().listAllBusComponentIds();
            int n = stringArray.length;
            int n2 = n / 12 + 1;
            System.out.println("found " + n + " BusComponents");
            System.out.println("Looking for running Backends (Using " + n2 + " Threads)");
            System.out.println(VARIABLE_NOTE);
            System.out.println("");
            System.out.println("BusComponentID                           - Backend Type (version)");
            System.out.println("-----------------------------------------------------------------------------");
            Thread[] threadArray = new Thread[n2];
            int n3 = 0;
            while (n3 < n2) {
                threadArray[n3] = new findRunning(n3 * 12, (n3 + 1) * 12 - 1, stringArray);
                threadArray[n3].start();
                ++n3;
            }
            int n4 = 0;
            while (n4 < n2) {
                threadArray[n4].join();
                ++n4;
            }
            System.out.println("\r                                  ");
            System.out.println("done");
            System.out.println();
        }
        catch (DirectoryException directoryException) {
            System.out.println();
            System.out.println("Error Accessing Directory: " + directoryException.getMessage());
            System.out.println();
        }
        catch (InterruptedException interruptedException) {}
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class findRunning
    extends Thread {
        private String[] m_allBCs;
        private int m_start;
        private int m_stop;

        findRunning(int n, int n2, String[] stringArray) {
            this.m_start = n;
            this.m_stop = n2;
            this.m_allBCs = stringArray;
        }

        public void check(String string) {
            IBackend iBackend = BoiToolkit.getDefaultToolkit().createBackend(string);
            try {
                iBackend.setTimeout(4000L);
                long l = iBackend.ping();
                String string2 = iBackend.getType();
                string = string + "                                         ";
                System.out.println("\r" + string.substring(0, 40) + " - " + string2);
            }
            catch (BoiException boiException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            iBackend.close();
        }

        public String getPercentage() {
            return "" + ++ready + "/" + this.m_allBCs.length;
        }

        public void run() {
            int n = this.m_start;
            while (n <= this.m_stop) {
                if (n < this.m_allBCs.length) {
                    String string = this.m_allBCs[n];
                    this.check(string);
                    System.out.print("\rsearching (" + this.getPercentage() + ")...");
                }
                ++n;
            }
        }
    }

    private class Interactive
    extends Thread {
        private BackendControl m_bc;
        private String m_busComponent;

        private Interactive(BackendControl backendControl2, String string) {
            this.m_bc = backendControl2;
            this.m_busComponent = string.length() > 50 ? string.substring(0, 49) + "..." : string;
        }

        public void run() {
            while (true) {
                System.out.print(" " + this.m_busComponent + " >> ");
                String string = this.getInputChar();
                if (string == null || string.length() == 0) continue;
                if (string.equals(BackendControl.MENU_HELP1) || string.equals(BackendControl.MENU_HELP2) || string.equals(BackendControl.MENU_HELP3)) {
                    System.out.println(MENU_USAGE);
                    continue;
                }
                if (string.equals(BackendControl.MENU_QUIT1) || string.equals(BackendControl.MENU_QUIT2)) break;
                BackendControl.processAction(string);
            }
            this.m_bc.close();
            System.out.println(NEWLINE + "bye!");
        }

        public String getInputChar() {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                String string = bufferedReader.readLine();
                return string;
            }
            catch (IOException iOException) {
                return null;
            }
        }
    }
}

