/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.xmlconnector.wsdlgen;

import com.baan.ow.xmlconnector.IMetadataGenerator;
import com.baan.owimpl.xmlconnector.util.dom2.XMLHelper;
import com.baan.owimpl.xmlconnector.wsdlgen.BOAttributes;
import com.baan.owimpl.xmlconnector.wsdlgen.IWSDLComponent;
import com.baan.owimpl.xmlconnector.wsdlgen.Message;
import com.baan.owimpl.xmlconnector.wsdlgen.MessageFault;
import com.baan.owimpl.xmlconnector.wsdlgen.NameSpaceGenerator;
import com.baan.owimpl.xmlconnector.wsdlgen.PortType;
import com.baan.owimpl.xmlconnector.wsdlgen.TagDefinitions;
import com.baan.owimpl.xmlconnector.wsdlgen.Type;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Definition
extends TagDefinitions
implements IWSDLComponent {
    private Vector wsdl = new Vector();
    private String m_name;
    private String[] m_methods;
    private Hashtable m_nameSpaces = new Hashtable();
    private IMetadataGenerator m_gen;

    public Definition(IMetadataGenerator iMetadataGenerator) {
        this.m_gen = iMetadataGenerator;
    }

    public void create(BOAttributes bOAttributes) throws Exception {
        this.m_name = bOAttributes.getName();
        this.m_methods = bOAttributes.getMethods();
        this.fillNamespaces(bOAttributes);
        this.setType();
        this.setMessage();
        this.setPortType();
        int n = 0;
        while (n < this.wsdl.size()) {
            ((IWSDLComponent)this.wsdl.elementAt(n)).create(bOAttributes);
            ++n;
        }
    }

    public Node toXML() throws ParserConfigurationException {
        Document document = this.xmlhelp.createDocument();
        Element element = this.xmlhelp.createElementNode(document, "definitions", this.m_name, "", document.getDocumentElement());
        this.setNamespaceAttributes(element);
        int n = 0;
        while (n < this.wsdl.size()) {
            Node node = ((IWSDLComponent)this.wsdl.elementAt(n)).toXML();
            if (node != null) {
                element.appendChild(document.importNode(node, true));
            }
            ++n;
        }
        this.xmlhelp.createElement(document, "service", element);
        this.xmlhelp.createElement(document, "binding", element);
        return element;
    }

    private Node getPortTypeNode(Node node) throws Exception {
        Node node2 = null;
        node2 = new XMLHelper().getNode(node, "portType");
        return node2;
    }

    private void setPortType() {
        PortType portType = new PortType();
        this.wsdl.addElement(portType);
    }

    private void setType() {
        Type type = new Type(this.m_gen, this.m_name);
        this.wsdl.addElement(type);
    }

    private void setMessage() {
        int n = 0;
        while (n < this.m_methods.length) {
            Message message = new Message(this.m_methods[n], "Request", this.m_name);
            this.wsdl.addElement(message);
            message = new Message(this.m_methods[n], "Response", this.m_name);
            this.wsdl.addElement(message);
            MessageFault messageFault = new MessageFault(this.m_methods[n], this.m_name);
            this.wsdl.addElement(messageFault);
            ++n;
        }
    }

    private void fillNamespaces(BOAttributes bOAttributes) {
        NameSpaceGenerator nameSpaceGenerator = new NameSpaceGenerator();
        this.m_nameSpaces.put("xmlns", "http://schemas.xmlsoap.org/wsdl/");
        this.m_nameSpaces.put("xmlns:wsdlns", nameSpaceGenerator.getTargetNamespace(bOAttributes.getName()));
        this.m_nameSpaces.put("targetNamespace", nameSpaceGenerator.getTargetNamespace(bOAttributes.getName()));
        int n = 0;
        while (n < this.m_methods.length) {
            if (!this.m_methods[n].equals("Synchronize") || this.xmlhelp.isSynchronizeMethod(this.xmlhelp.getManagerMetadata(bOAttributes.getName()))) {
                this.m_nameSpaces.put("xmlns:tns" + this.m_methods[n].toLowerCase(), nameSpaceGenerator.getMethodNamespace(bOAttributes.getName(), this.m_methods[n]));
            }
            ++n;
        }
    }

    private void setNamespaceAttributes(Element element) {
        Enumeration enumeration2 = this.m_nameSpaces.keys();
        while (enumeration2.hasMoreElements()) {
            String string = (String)enumeration2.nextElement();
            element.setAttribute(string, this.m_nameSpaces.get(string).toString());
        }
    }
}

