/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.xmlconnector.util.dom2;

import com.baan.b3.boi1.metadata.IBusinessObjectMetadata;
import com.baan.b3.boi1.metadata.IManagerMetadata;
import com.baan.b3.boi1.metadata.MetadataUtil;
import com.baan.ow.xmlconnector.dispatcher.FaultException;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.baan.owimpl.xmlconnector.dispatcher.GenericRequestException;
import com.baan.owimpl.xmlconnector.util.BusinessObjectLocator;
import java.io.ByteArrayInputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLHelper {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.owimpl.xmlconnector.dispatcher", "XMLConnectorDispatcher");

    public Node getNode(Node node, String string) {
        Node node2 = null;
        try {
            Element element = (Element)node;
            NodeList nodeList = element.getElementsByTagNameNS("*", string);
            if (nodeList.getLength() < 1) {
                NodeList nodeList2 = node.getChildNodes();
                int n = nodeList2.getLength();
                int n2 = 0;
                while (n2 < n) {
                    if (nodeList2.item(n2).getNodeType() != 3 && (node2 = this.getNode(nodeList2.item(n2), string)) != null) {
                        return node2;
                    }
                    ++n2;
                }
            } else {
                node2 = nodeList.item(0);
            }
        }
        catch (Exception exception) {
            return node2;
        }
        return node2;
    }

    public Node getNodeWithoutNS(Node node, String string) {
        Node node2 = null;
        try {
            Element element = (Element)node;
            NodeList nodeList = element.getElementsByTagName(string);
            if (nodeList.getLength() < 1) {
                NodeList nodeList2 = node.getChildNodes();
                int n = nodeList2.getLength();
                int n2 = 0;
                while (n2 < n) {
                    if (nodeList2.item(n2).getNodeType() != 3 && (node2 = this.getNode(nodeList2.item(n2), string)) != null) {
                        return node2;
                    }
                    ++n2;
                }
            } else {
                node2 = nodeList.item(0);
            }
        }
        catch (Exception exception) {
            return node2;
        }
        return node2;
    }

    public String getNodeValue(Node node, String string) {
        try {
            Node node2 = this.getNode((Element)node, string);
            Text text = (Text)node2.getFirstChild();
            if (text == null) {
                return "";
            }
            return text.getNodeValue();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getNodeValue(Node node) {
        String string = new String("");
        Node node2 = node.getFirstChild();
        if (this.verifyNodeType(node2, (short)3)) {
            Text text = (Text)node2;
            string = text.getNodeValue();
        }
        return string;
    }

    public NodeList getNodeListWithoutNS(Node node, String string) {
        NodeList nodeList = ((Element)node).getElementsByTagName(string);
        if (nodeList.getLength() != 0) {
            return nodeList;
        }
        Object var4_4 = null;
        NodeList nodeList2 = node.getChildNodes();
        int n = 0;
        while (n < nodeList2.getLength()) {
            NodeList nodeList3;
            int n2 = nodeList2.getLength();
            Node node2 = nodeList2.item(n);
            String string2 = nodeList2.item(n).getNodeName();
            if (node2.getNodeType() != 3 && (nodeList3 = this.getNodeListWithoutNS(node2, string)) != null && nodeList3.getLength() != 0) {
                return nodeList3;
            }
            ++n;
        }
        return null;
    }

    private boolean verifyNodeType(Node node, short s) {
        if (node != null) {
            return node.getNodeType() == s;
        }
        return false;
    }

    public Element createElement(Document document, String string, Element element) {
        Element element2 = document.createElement(string);
        if (element != null) {
            return (Element)element.appendChild(element2);
        }
        document.appendChild(element2);
        return element2;
    }

    public Element createElementNode(Document document, String string, String string2, String string3, Element element) {
        Element element2 = document.createElement(string);
        element2.setAttribute("name", string2);
        if (!string3.equals("")) {
            element2.setAttribute("type", string3);
        }
        if (element != null) {
            element.appendChild(element2);
        } else {
            document.appendChild(element2);
        }
        return element2;
    }

    public Element createElementNode(Document document, String string, String string2, String string3, Element element, Element element2) {
        Element element3 = document.createElement(string);
        element3.setAttribute("name", string2);
        if (!string3.equals("")) {
            element3.setAttribute("type", string3);
        }
        if (element != null) {
            element.insertBefore(element3, element2);
        }
        return element3;
    }

    public Document createDocument() {
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
        }
        catch (Exception exception) {
            System.out.println("Error while creating document");
        }
        return document;
    }

    public Element createTextNode(Document document, String string, String string2, Element element) {
        Element element2 = document.createElement(string);
        element2.appendChild(document.createTextNode(string2));
        element.appendChild(element2);
        return element2;
    }

    public Element createTextNodeBefore(Document document, String string, String string2, Element element, Element element2) {
        Element element3 = document.createElement(string);
        element3.appendChild(document.createTextNode(string2));
        element.insertBefore(element3, element2);
        return element3;
    }

    public Document StringToDocument(String string) throws GenericRequestException {
        Document document = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF8"));
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(byteArrayInputStream);
            return document;
        }
        catch (Exception exception) {
            s_logger.errorMessage(this.getClass().getName());
            s_logger.errorException(exception);
            throw new GenericRequestException("Request, '" + string + "' is not a valid XML document, " + exception.getMessage(), "");
        }
    }

    public void createFailureDoc(Document document, String string, String string2, Element element) {
        this.createTextNode(document, "errorMessage", string, element);
        this.createTextNode(document, "errorLevel", string2, element);
    }

    public boolean isSynchronizeMethod(IManagerMetadata iManagerMetadata) {
        Vector<IBusinessObjectMetadata> vector = new Vector<IBusinessObjectMetadata>();
        IBusinessObjectMetadata[] iBusinessObjectMetadataArray = iManagerMetadata.getManagedObjects();
        int n = 0;
        while (n < iBusinessObjectMetadataArray.length) {
            if (!iBusinessObjectMetadataArray[n].isReadOnly()) {
                vector.addElement(iBusinessObjectMetadataArray[n]);
            }
            ++n;
        }
        return vector.size() >= 1;
    }

    public IManagerMetadata getManagerMetadata(String string) {
        try {
            BusinessObjectLocator businessObjectLocator = new BusinessObjectLocator();
            return MetadataUtil.getManagerMetadata(businessObjectLocator.getBusinessObjectManager(string));
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
            return null;
        }
    }

    public String getFullyQualifiedName(String string, boolean bl) {
        try {
            BusinessObjectLocator businessObjectLocator = new BusinessObjectLocator();
            String string2 = MetadataUtil.getManagerMetadata(businessObjectLocator.getBusinessObjectManager(string)).getTypeName();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
            int n = stringTokenizer.countTokens();
            String[] stringArray = new String[n];
            int n2 = 0;
            String string3 = "";
            String string4 = "";
            String string5 = "";
            if (n > 1) {
                while (stringTokenizer.hasMoreTokens()) {
                    String string6 = stringTokenizer.nextToken();
                    if (n2 == 0) {
                        string4 = string6;
                    } else if (n2 == 1) {
                        string5 = string6;
                    } else if (n2 != n - 1) {
                        string3 = string3 + "/" + string6;
                    }
                    ++n2;
                }
                string3 = string5 + "." + string4 + string3;
                if (bl) {
                    return "http://" + string3 + "/" + string.toLowerCase();
                }
                return "http://" + string3 + "/" + string;
            }
            if (bl) {
                return "http://" + string.toLowerCase();
            }
            return "http://" + string;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String retrieveObject(String string) throws FaultException {
        if (string == null) {
            Element element = this.constructFaultNode("Client.BAC-UnknownMessage", "Unknown message format cannot be handled by Dispatcher.", "http://www.baan.com/basis/bac/disp/Dispatcher", false);
            throw new FaultException(element);
        }
        return string.substring(string.lastIndexOf("/") + 1, string.length());
    }

    public Element constructFaultNode(String string, String string2, String string3, boolean bl) {
        Document document = this.createDocument();
        Element element = this.createElement(document, "ExecuteFault", null);
        this.createTextNode(document, "faultcode", string, element);
        this.createTextNode(document, "faultstring", string2, element);
        this.createTextNode(document, "actor", string3, element);
        if (!bl) {
            this.createElement(document, "detail", element);
        }
        return element;
    }

    public Element retriveSubTree(Element element) throws GenericRequestException {
        NodeList nodeList = element.getChildNodes();
        Element element2 = null;
        int n = 0;
        int n2 = 0;
        while (n2 < nodeList.getLength()) {
            if (nodeList.item(n2).getNodeName().equals("ObjectMethodRequest")) {
                element2 = (Element)nodeList.item(n2);
                ++n;
            }
            ++n2;
        }
        if (n > 1) {
            throw new GenericRequestException("Only single instance of element, ObjectMethodRequest allowed", "Client.BAC-UnknownMessage");
        }
        if (n == 0) {
            throw new GenericRequestException("Element, ObjectMethodRequest not found", "Client.BAC-UnknownMessage");
        }
        return element2;
    }

    public void setOccurance(Element element, String string, String string2) {
        element.setAttribute("maxOccurs", string);
        element.setAttribute("minOccurs", string2);
    }
}

