/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.xmlconnector.util.dom2;

import com.baan.b3.Info;
import com.baan.b3.boi1.BoiToolkit;
import com.baan.b3.boi1.IUserInfo;
import com.baan.b3.boi1.IUserSession;
import com.baan.b3.boi1.metadata.IManagerMetadata;
import com.baan.b3.boi1.metadata.IManagerMethodMetadata;
import com.baan.b3.dom.Document;
import com.baan.ow.xmlconnector.dispatcher.AuthenticationException;
import com.baan.ow.xmlconnector.dispatcher.FaultException;
import com.baan.owimpl.xmlconnector.dispatcher.GenericRequestException;
import com.baan.owimpl.xmlconnector.dispatcher.Runtime;
import com.baan.owimpl.xmlconnector.error.StatusHandler;
import com.baan.owimpl.xmlconnector.exception.ManagerNotFoundException;
import com.baan.owimpl.xmlconnector.util.BusinessObjectLocator;
import com.baan.owimpl.xmlconnector.util.dom2.XMLHelper;
import com.eibus.xml.util.DOMWriter;
import java.util.Hashtable;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DispatcherValidator {
    private static String FAULT_CODE_UNKNOWN_METHOD = "Client.BAC-UnknownMethod";
    private static String FAULT_CODE_UNKNOWN_OBJECT = "Client.BAC-UnknownObject";
    private static String REQUEST = "Request";
    private static String OBJECT = "Object";
    private static String METHOD = "Method";
    private static String OBJ_METH_REQ = "ObjectMethodRequest";
    private static String IN_PREFIX = "PREFIX";
    private static String IN_URI = "URI";
    private static String GET_OBJ_META = "GetObjectMetaData";
    private static String LIST_OBJ = "ListObjects";
    private static String REPOSITORY = "Repository";
    private static String SYNCHRONIZE = "Synchronize";
    private static String QL_NAME_REP = "http://www.baan.com/basis/bac/rep/Repository";

    public boolean parseRequest(Element element, Hashtable hashtable) throws FaultException {
        XMLHelper xMLHelper = new XMLHelper();
        String string = "";
        String string2 = "";
        if (!element.getLocalName().equals(REQUEST + "Msg")) {
            return false;
        }
        String string3 = element.getNamespaceURI();
        if (string3 != null) {
            if (!string3.equals("http://www.baan.com/basis/bac/disp")) {
                return false;
            }
        } else {
            return false;
        }
        if (!element.hasChildNodes()) {
            return false;
        }
        NodeList nodeList = element.getChildNodes();
        String string4 = "";
        int n = 0;
        while (n < nodeList.getLength()) {
            string4 = nodeList.item(n).getLocalName();
            if (!(string4 == null || string4.equals("#text") || string4.equals("Object") || string4.equals(METHOD) || string4.equals(OBJ_METH_REQ))) {
                return false;
            }
            if (string4 != null && !string4.equals("#text")) {
                if (string4.equals(METHOD)) {
                    string2 = xMLHelper.getNodeValue(nodeList.item(n));
                    if (string2.equals("")) {
                        throw new FaultException(xMLHelper.constructFaultNode(FAULT_CODE_UNKNOWN_METHOD, "Method " + string2 + " is unknown for object " + string + ".", "http://www.baan.com/basis/bac/disp/Dispatcher", false));
                    }
                    hashtable.put(METHOD, string2);
                }
                if (string4.equals(OBJECT)) {
                    string = xMLHelper.getNodeValue(nodeList.item(n));
                    if (string.equals("")) {
                        throw new FaultException(xMLHelper.constructFaultNode(FAULT_CODE_UNKNOWN_OBJECT, "Object tag is not found OR Object tag is empty OR Document is not in valid DOM2 format.", "http://www.baan.com/basis/bac/disp/Dispatcher", false));
                    }
                    hashtable.put(OBJECT, string);
                    if (!this.validateObject(string, hashtable)) {
                        throw new FaultException(xMLHelper.constructFaultNode(FAULT_CODE_UNKNOWN_OBJECT, "Object " + string + " is unknown.", "http://www.baan.com/basis/bac/disp/Dispatcher", false));
                    }
                }
                if (string4.equals(OBJ_METH_REQ)) {
                    Object object;
                    if (!this.validateMethod(string, string2, hashtable)) {
                        object = xMLHelper.constructFaultNode(FAULT_CODE_UNKNOWN_METHOD, "Method " + string2 + " is unknown for object " + string + ".", "http://www.baan.com/basis/bac/disp/Dispatcher", false);
                        throw new FaultException((Element)object);
                    }
                    if (nodeList.item(n).hasChildNodes()) {
                        object = nodeList.item(n).getChildNodes();
                        int n2 = 0;
                        while (n2 < object.getLength()) {
                            String string5 = object.item(n2).getLocalName();
                            if (string5 != null && !string5.equals("#text")) {
                                String string6;
                                if (!string5.equals(string2 + REQUEST) && !string5.equals("BAC" + string2 + REQUEST)) {
                                    return false;
                                }
                                String string7 = object.item(n2).getNamespaceURI();
                                if (string7 != null) {
                                    hashtable.put(IN_URI, string7);
                                }
                                if ((string6 = object.item(n2).getPrefix()) != null) {
                                    hashtable.put(IN_PREFIX, string6);
                                }
                            }
                            ++n2;
                        }
                    } else {
                        return false;
                    }
                }
            }
            ++n;
        }
        if (!this.checkOccurance(element, OBJECT)) {
            return false;
        }
        if (!this.checkOccurance(element, METHOD)) {
            return false;
        }
        return this.checkOccurance(element, OBJ_METH_REQ);
    }

    private boolean checkOccurance(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        int n2 = 0;
        while (n2 < nodeList.getLength()) {
            if (nodeList.item(n2) != null && nodeList.item(n2).getNodeType() != 3 && nodeList.item(n2).getNodeName().equals(string)) {
                ++n;
            }
            ++n2;
        }
        return n == true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean validateObject(String string, Hashtable hashtable) throws FaultException, GenericRequestException {
        String string2 = "";
        XMLHelper xMLHelper = new XMLHelper();
        try {
            string2 = xMLHelper.retrieveObject(string);
            if (string2.equals(REPOSITORY)) {
                if (!string.equals(QL_NAME_REP)) return false;
                return true;
            }
            BusinessObjectLocator businessObjectLocator = new BusinessObjectLocator();
            String string3 = businessObjectLocator.getBusinessObjectManager(string2);
            if (string3 == null) {
                return false;
            }
            if (xMLHelper.getManagerMetadata(string2) == null) {
                return false;
            }
            try {
                xMLHelper.getManagerMetadata(string2).getTypeName();
                if (string.equals(xMLHelper.getFullyQualifiedName(string2, false))) return true;
                return false;
            }
            catch (RuntimeException runtimeException) {
                throw new ManagerNotFoundException("The repository is corrupt. Could not find the manager class for BusinessObject, " + string + ". DetailMessage : " + runtimeException.getMessage());
            }
            catch (Exception exception) {
                throw new ManagerNotFoundException("The repository is corrupt. Could not find the manager class for BusinessObject, " + string + ". DetailMessage : " + exception.getMessage());
            }
        }
        catch (Exception exception) {
            Document document = new StatusHandler().createFailureDoc(exception);
            String string4 = new DOMWriter(document).toString();
            org.w3c.dom.Document document2 = xMLHelper.StringToDocument(string4);
            new Runtime().throwAppropriateException(document2, "Execution of request failed", hashtable);
            return false;
        }
    }

    private boolean validateMethod(String string, String string2, Hashtable hashtable) throws FaultException, GenericRequestException {
        block7: {
            XMLHelper xMLHelper = new XMLHelper();
            try {
                String string3 = xMLHelper.retrieveObject(string);
                if (string3.equals(REPOSITORY)) {
                    return string2.equals(LIST_OBJ) || string2.equals(GET_OBJ_META);
                }
                if (string2.equals(SYNCHRONIZE)) {
                    return true;
                }
                IManagerMetadata iManagerMetadata = xMLHelper.getManagerMetadata(string3);
                if (iManagerMetadata != null) {
                    IManagerMethodMetadata[] iManagerMethodMetadataArray = iManagerMetadata.getMethods2();
                    int n = 0;
                    while (n < iManagerMethodMetadataArray.length) {
                        if (iManagerMethodMetadataArray[n].getName().equals(string2)) {
                            return true;
                        }
                        ++n;
                    }
                    break block7;
                }
                return false;
            }
            catch (Exception exception) {
                Document document = new StatusHandler().createFailureDoc(exception);
                String string4 = new DOMWriter(document).toString();
                org.w3c.dom.Document document2 = xMLHelper.StringToDocument(string4);
                new Runtime().throwAppropriateException(document2, "Execution of request failed", hashtable);
            }
        }
        return false;
    }

    public IUserSession checkBackend(String string, String string2, String string3) throws GenericRequestException, AuthenticationException {
        IUserSession iUserSession = null;
        if (string == null && ((string = Info.getDefaultBackendId()) == null || string.equals(""))) {
            throw new GenericRequestException("Default Backend is not configured.", "Server.BAC-ConnectionError");
        }
        if (string2 != null && string3 != null) {
            BoiToolkit boiToolkit = BoiToolkit.getDefaultToolkit();
            IUserInfo iUserInfo = boiToolkit.createUserInfo();
            iUserInfo.setUsername(string2);
            iUserInfo.setPassword(string3);
            iUserSession = boiToolkit.createUserSession(iUserInfo);
        }
        return iUserSession;
    }

    public IUserSession checkBackend2(String string, String string2) throws GenericRequestException, AuthenticationException {
        IUserSession iUserSession = null;
        if (string != null && string2 != null) {
            BoiToolkit boiToolkit = BoiToolkit.getDefaultToolkit();
            IUserInfo iUserInfo = boiToolkit.createUserInfo();
            iUserInfo.setUsername(string);
            iUserInfo.setPassword(string2);
            iUserSession = boiToolkit.createUserSession(iUserInfo);
        }
        return iUserSession;
    }
}

