/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.xmlconnector.util;

import com.baan.b3.dom.Element;
import com.baan.b3.dom.Node;
import com.baan.b3.dom.NodeList;
import com.baan.b3.dom.Text;
import com.baan.owimpl.xmlconnector.exception.RequestParserException;

public class XMLReader {
    private static final String COPYRIGHT = "Copyright (c) 2001-2002 Baan Company";

    public String getNodeValue(Node node, String string) throws Exception {
        try {
            Node node2 = this.getNode((Element)node, string);
            Text text = (Text)node2.getFirstChild();
            if (text == null) {
                return "";
            }
            return text.getNodeValue();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public NodeList getNodeList(Node node, String string) {
        NodeList nodeList = ((Element)node).getElementsByTagName(string);
        if (nodeList.getLength() != 0) {
            return nodeList;
        }
        Object var4_4 = null;
        NodeList nodeList2 = node.getChildNodes();
        int n = 0;
        while (n < nodeList2.getLength()) {
            NodeList nodeList3;
            Node node2 = nodeList2.item(n);
            if (node2.getNodeType() != 3 && (nodeList3 = this.getNodeList(node2, string)) != null && nodeList3.getLength() != 0) {
                return nodeList3;
            }
            ++n;
        }
        return null;
    }

    public String[] getNodeValues(Node node, String string) {
        NodeList nodeList = this.getNodeList(node, string);
        if (nodeList != null && nodeList.getLength() != 0) {
            String[] stringArray = new String[nodeList.getLength()];
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node2 = nodeList.item(n);
                Node node3 = node2.getFirstChild();
                stringArray[n] = node3 != null ? node3.getNodeValue() : "";
                ++n;
            }
            return stringArray;
        }
        return null;
    }

    public Node getNode(Element element, String string) throws RequestParserException {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() > 1) {
            throw new RequestParserException("Invalid request document, check tag " + string);
        }
        return nodeList.item(0);
    }

    public Node getNode(Node node, String string) throws RequestParserException {
        Element element = (Element)node;
        NodeList nodeList = element.getElementsByTagName(string);
        Node node2 = null;
        if (nodeList.getLength() > 1) {
            throw new RequestParserException("Invalid Response document, check tag " + string);
        }
        if (nodeList.getLength() < 1) {
            NodeList nodeList2 = node.getChildNodes();
            int n = nodeList2.getLength();
            int n2 = 0;
            while (n2 < n) {
                if (nodeList2.item(n2).getNodeType() != 3 && (node2 = this.getNode(nodeList2.item(n2), string)) != null) {
                    return node2;
                }
                ++n2;
            }
        } else {
            return nodeList.item(0);
        }
        return node2;
    }

    public String getAttributeValue(Node node, String string) {
        try {
            return node.getAttributes().getNamedItem(string).getNodeValue();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Node getAttributeNode(Node node, String string) {
        try {
            return node.getAttributes().getNamedItem(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean hasElement(Node node) {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n).getNodeType() != 3) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

