/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.xmlconnector.util;

import com.baan.b3.Info;
import com.baan.b3.dom.Document;
import com.baan.b3.dom.Element;
import com.baan.b3.dom.Node;
import com.baan.b3.dom.NodeList;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.baan.owimpl.xmlconnector.exception.RequestParserException;

public class RequestParser {
    private static final String COPYRIGHT = "Copyright (c) 2001-2002 Baan Company";
    private static final String NEW_LINE = "\n";
    private static final String SPACE = " ";
    private static final String TAB = "\t";
    private static final String EMPTY = "";
    private static final String OBJECT_NAME = "ObjectName";
    private static final String METHOD_NAME = "MethodName";
    private static final String COMPONENT_NAME = "ComponentName";
    private static final String PARAMETERS = "Parameters";
    private static final String FORMAT = "Format";
    private static final String REQUEST = "Request";
    private static final String UNCONDITIONALFLAG = "Unconditional";
    private static final String SYNCHRONIZE = "Synchronize";
    private static final String CONTROLAREA = "ControlArea";
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.owimpl.xmlconnector.dispatcher", "XMLConnectorDispatcher");

    public void parseRequestDocument(Document document, StringBuffer stringBuffer, StringBuffer stringBuffer2, StringBuffer stringBuffer3) throws RequestParserException, Exception {
        Element element = null;
        element = (Element)document.getFirstChild();
        try {
            this.checkRootNode(element, true);
            this.checkRootNodeForAttribute(element);
            stringBuffer2.append(this.parseTag(OBJECT_NAME, element));
            stringBuffer.append(this.parseTag(METHOD_NAME, element));
            stringBuffer3.append(this.getFormatName(document));
        }
        catch (Exception exception) {
            s_logger.errorMessage(this.getClass().getName());
            s_logger.errorException(exception);
            throw exception;
        }
    }

    public NodeList parseRequestDocument(Document document, StringBuffer stringBuffer, StringBuffer stringBuffer2, StringBuffer stringBuffer3, NodeList nodeList) throws RequestParserException, Exception {
        Element element = null;
        element = (Element)document.getFirstChild();
        try {
            this.checkRootNode(element, false);
            this.checkRootNodeForAttribute(element);
            stringBuffer2.append(this.parseTag(OBJECT_NAME, element));
            stringBuffer.append(this.parseTag(METHOD_NAME, element));
            stringBuffer3.append(this.parseComponentNameTag(COMPONENT_NAME, element));
            this.parseTagForSynchronize(UNCONDITIONALFLAG, element, stringBuffer.toString());
            nodeList = element.getElementsByTagName(PARAMETERS);
            if (nodeList.getLength() < 1) {
                throw new RequestParserException("Parameter Tag is not found");
            }
            if (nodeList.getLength() > 1 && !stringBuffer.toString().toUpperCase().startsWith("ADD")) {
                throw new RequestParserException("Request can not have more than one Parameter Tag");
            }
            int n = 0;
            while (n < nodeList.getLength()) {
                this.checkTextNode(nodeList.item(n));
                ++n;
            }
            return nodeList;
        }
        catch (Exception exception) {
            s_logger.errorMessage(this.getClass().getName());
            s_logger.errorException(exception);
            throw exception;
        }
    }

    private String parseTag(String string, Element element) throws Exception {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() < 1) {
            throw new RequestParserException(string + " Tag is missing");
        }
        if (nodeList.getLength() > 1) {
            throw new RequestParserException("Request can not have more than one " + string + " Tag");
        }
        if (nodeList.item(0).getFirstChild() == null) {
            throw new RequestParserException("Request can not have empty " + string + " Tag");
        }
        return this.getNodeValue(nodeList.item(0));
    }

    private void parseTagForSynchronize(String string, Element element, String string2) throws Exception {
        NodeList nodeList = element.getElementsByTagName(string);
        if (string2.equals(SYNCHRONIZE)) {
            if (nodeList.getLength() > 1) {
                throw new RequestParserException("Request can not have more than one " + string + " Tag");
            }
        } else if (nodeList.getLength() != 0) {
            throw new RequestParserException("Invalid Request Tag : " + string);
        }
    }

    private String parseComponentNameTag(String string, Element element) throws Exception {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() < 1) {
            throw new RequestParserException(string + " Tag is missing");
        }
        if (nodeList.getLength() > 1) {
            throw new RequestParserException("Request can not have more than one " + string + " Tag");
        }
        if (nodeList.item(0).getFirstChild() == null) {
            String string2 = Info.getDefaultBackendId();
            if (!string2.equals(EMPTY)) {
                return string2;
            }
            throw new RequestParserException("Request can have empty " + string + " Tag, only if a 'Default Backend' is specified in the Adapter Configuration. Please specify a component Name.");
        }
        return this.getNodeValue(nodeList.item(0));
    }

    private void checkRootNode(Node node, boolean bl) throws Exception {
        if (!node.getNodeName().equals(REQUEST)) {
            throw new RequestParserException("Document should have the tag, Request as the Root Element");
        }
        NodeList nodeList = node.getChildNodes();
        String string = EMPTY;
        int n = 0;
        while (n < nodeList.getLength()) {
            string = nodeList.item(n).getNodeName();
            if (bl) {
                if (!(string == null || string.equals("#text") || string.equals(FORMAT) || string.equals(OBJECT_NAME) || string.equals(METHOD_NAME))) {
                    throw new RequestParserException("Invalid Request Tag : " + string);
                }
            } else if (!(string == null || string.equals("#text") || string.equals(COMPONENT_NAME) || string.equals(OBJECT_NAME) || string.equals(METHOD_NAME) || string.equals(PARAMETERS))) {
                if (!string.equals(UNCONDITIONALFLAG) && !string.equals(CONTROLAREA)) {
                    throw new RequestParserException("Invalid Request Tag : " + string);
                }
            }
            ++n;
        }
        this.checkTextNode(node);
    }

    private String getNodeValue(Node node) throws Exception {
        String string = EMPTY;
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n).getNodeType() != 3) {
                throw new RequestParserException("Request can not have MIX type of Element tag, check " + node.getNodeName() + " Tag");
            }
            String string2 = nodeList.item(n).getNodeValue();
            if (!string2.equals(EMPTY)) {
                string = string2;
            }
            ++n;
        }
        if (string.equals(EMPTY)) {
            throw new RequestParserException("Element tag " + node.getNodeName() + " can not have empty value");
        }
        return string;
    }

    public void checkTextNode(Node node) throws Exception {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n).getNodeType() == 3) {
                String string = nodeList.item(n).getNodeValue();
                int n2 = 0;
                while (n2 < string.length()) {
                    if (!(string.substring(n2, n2 + 1).equals(SPACE) || string.substring(n2, n2 + 1).equals(TAB) || string.substring(n2, n2 + 1).equals(NEW_LINE))) {
                        throw new RequestParserException("Element tag " + node.getNodeName() + " can not have MIX type");
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    public String getFormatName(Document document) throws Exception, RequestParserException {
        String string = EMPTY;
        Element element = (Element)document.getFirstChild();
        NodeList nodeList = element.getElementsByTagName(FORMAT);
        if (nodeList.getLength() < 1) {
            return "DTD";
        }
        if (nodeList.getLength() > 1) {
            throw new RequestParserException("Request can not have more than one Format Tag");
        }
        if (nodeList.item(0).getFirstChild() == null) {
            return "DTD";
        }
        try {
            string = this.getNodeValue(nodeList.item(0));
        }
        catch (Exception exception) {
            s_logger.errorMessage(this.getClass().getName());
            s_logger.errorException(exception);
            throw exception;
        }
        if (!string.equalsIgnoreCase("DTD") && !string.equalsIgnoreCase("XMLSchema")) {
            throw new RequestParserException("Format Tag is having invalid value");
        }
        return string;
    }

    private void checkRootNodeForAttribute(Node node) throws Exception {
        if (node.getAttributes().getLength() > 0) {
            throw new RequestParserException("Request Tag has illegal attribute.");
        }
        NodeList nodeList = node.getChildNodes();
        Node node2 = null;
        int n = 0;
        while (n < nodeList.getLength()) {
            node2 = nodeList.item(n);
            if (node2.getAttributes() != null && node2.getAttributes().getLength() > 0) {
                throw new RequestParserException("Invalid attribute in tag : " + node2.getNodeName());
            }
            ++n;
        }
    }
}

