/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.xmlconnector.util;

import com.baan.b3.boi1.metadata.IManagerMethodMetadata;
import com.baan.b3.dom.Element;
import com.baan.b3.xml.sax.SAXException;
import com.baan.b3.xml.sax.SAXParseException;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.baan.owimpl.xmlconnector.exception.InvalidXMLDocumentException;
import com.eibus.xml.dom.SAXDocument;
import com.eibus.xml.util.W3CDOMWriter;
import java.io.ByteArrayInputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.SimpleTimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class Conversions {
    private static final String COPYRIGHT = "Copyright (c) 2001-2002 Baan Company";
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.owimpl.xmlconnector.dispatcher", "XMLConnectorDispatcher");

    public com.baan.b3.dom.Document StringToDocument(String string) throws SAXParseException, SAXException, Exception {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF8"));
            SAXDocument sAXDocument = new SAXDocument();
            sAXDocument.load(byteArrayInputStream);
            return sAXDocument;
        }
        catch (Exception exception) {
            s_logger.errorMessage(this.getClass().getName() + " XML Connector could not load the request document, " + exception.getMessage());
            throw new InvalidXMLDocumentException("XML Connector could not load the request document, " + exception.getMessage());
        }
    }

    public Element createElement(com.baan.b3.dom.Document document, String string, String string2, Element element) {
        Element element2 = document.createElement(string);
        element2.appendChild(document.createTextNode(string2));
        element.appendChild(element2);
        return element2;
    }

    public IManagerMethodMetadata getMethodMd(String string, IManagerMethodMetadata[] iManagerMethodMetadataArray, StringBuffer stringBuffer) {
        int n = 0;
        while (n < iManagerMethodMetadataArray.length) {
            if (iManagerMethodMetadataArray[n].getName().trim().equals(string.trim())) {
                stringBuffer.append(iManagerMethodMetadataArray[n].getProgrammingModel().toString());
                return iManagerMethodMetadataArray[n];
            }
            ++n;
        }
        return null;
    }

    public String convertDateToString(String string) throws IllegalArgumentException {
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(0, "B3UTC");
        Calendar calendar = Calendar.getInstance(simpleTimeZone);
        calendar.set(1900, 0, 1, 0, 0, 0);
        Date date = calendar.getTime();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        simpleDateFormat.setTimeZone(simpleTimeZone);
        try {
            return simpleDateFormat.format(simpleDateFormat.parse(string));
        }
        catch (Exception exception) {
            s_logger.errorMessage(this.getClass().getName() + " Incorrect Date format.");
            throw new IllegalArgumentException("Incorrect Date format");
        }
    }

    public Document StringToDOM2Document(String string) throws Exception {
        Document document = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF8"));
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(byteArrayInputStream);
            return document;
        }
        catch (Exception exception) {
            s_logger.errorMessage(this.getClass().getName());
            throw new Exception(string + " XML Connector could not load the request document, " + exception.getMessage());
        }
    }

    public String DOM2DocumentToString(Document document) {
        String string = new W3CDOMWriter(document).toString();
        return string;
    }
}

