/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.xmlconnector.util;

import com.baan.b3.domain.Domain;
import com.baan.b3.domain.IBoiDescriptor;
import com.baan.b3.domain.IDomain;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.baan.owimpl.xmlconnector.configimpl.XMLConnectorProperty;
import com.baan.owimpl.xmlconnector.exception.BOINotFoundException;
import com.baan.owimpl.xmlconnector.exception.CorruptRepositoryException;
import com.baan.owimpl.xmlconnector.exception.FileException;
import com.baan.owimpl.xmlconnector.exception.ManagerNotFoundException;
import com.baan.owimpl.xmlconnector.exception.PropertiesUndefinedException;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;

public class BusinessObjectLocator {
    private static final String COPYRIGHT = "Copyright (c) 2001-2002 Baan Company";
    private static XMLConnectorProperty s_XMLConnectorProperty = null;
    private static int repositoryLength = 0;
    private static String m_repositoryName = "";
    private IBoiDescriptor boiHandle = null;
    private boolean repositoryFound = false;
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.owimpl.xmlconnector.dispatcher", "XMLConnectorDispatcher");

    public BusinessObjectLocator() throws PropertiesUndefinedException, Exception {
        try {
            s_XMLConnectorProperty = XMLConnectorProperty.getXMLConnectorProperty();
        }
        catch (Exception exception) {
            s_logger.errorMessage(this.getClass().getName());
            s_logger.errorException(exception);
            throw exception;
        }
        repositoryLength = s_XMLConnectorProperty.getRepositoryNames().length;
        if (repositoryLength <= 0) {
            throw new PropertiesUndefinedException("Domain Search Priorities are not Defined properly");
        }
    }

    public String getBusinessObjectManager(String string) throws BOINotFoundException, Exception {
        boolean bl = false;
        String string2 = "";
        String string3 = "";
        String[] stringArray = s_XMLConnectorProperty.getRepositoryNames();
        int n = 0;
        while (n < repositoryLength) {
            try {
                this.boiHandle = this.getBOIHandle(string, stringArray[n]);
            }
            catch (Exception exception) {
                s_logger.errorMessage(this.getClass().getName());
                s_logger.errorException(exception);
                throw exception;
            }
            if (this.boiHandle != null) {
                string2 = this.boiHandle.getManagerClass();
                if (string2.equals("") || string2 == null) {
                    bl = true;
                    string3 = stringArray[n];
                    break;
                }
                m_repositoryName = stringArray[n];
                return string2;
            }
            ++n;
        }
        if (bl) {
            throw new ManagerNotFoundException("Business Object Manager, " + string2 + " not found in " + string3 + ", Repository");
        }
        throw new BOINotFoundException();
    }

    public String getBOIManagerVersion(String string) throws Exception {
        try {
            String string2 = "";
            this.boiHandle = this.getBOIHandle(string, m_repositoryName);
            return this.boiHandle.getVersion();
        }
        catch (Exception exception) {
            s_logger.errorMessage(this.getClass().getName());
            s_logger.errorException(exception);
            throw exception;
        }
    }

    private IBoiDescriptor getBOIHandle(String string, String string2) throws Exception {
        IBoiDescriptor iBoiDescriptor;
        IDomain iDomain;
        block9: {
            iDomain = null;
            iBoiDescriptor = null;
            URL uRL = ClassLoader.getSystemResource(string2);
            if (uRL == null) {
                try {
                    iDomain = Domain.open(new File(string2).getAbsolutePath());
                    if (iDomain == null) {
                        throw new CorruptRepositoryException("Domain File " + string2 + " is corrupted");
                    }
                    break block9;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new FileException("Domain File " + string2 + " not Found");
                }
                catch (Exception exception) {
                    throw new CorruptRepositoryException("Domain File " + string2 + " is corrupted");
                }
            }
            try {
                iDomain = Domain.open(uRL);
            }
            catch (Exception exception) {
                throw new CorruptRepositoryException("Domain File " + string2 + " is corrupted");
            }
        }
        iBoiDescriptor = iDomain.getBoi(string);
        return iBoiDescriptor;
    }
}

