/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.xmlconnector.tools;

import com.baan.b3.boi1.BoiToolkit;
import com.baan.b3.boi1.IUserInfo;
import com.baan.b3.boi1.IUserSession;
import com.baan.b3.boi1.metadata.IManagerMetadata;
import com.baan.b3.boi1.metadata.IMethodMetadata;
import com.baan.b3.boi1.metadata.MetadataUtil;
import com.baan.b3.domain.Domain;
import com.baan.b3.domain.IBoiDescriptor;
import com.baan.b3.domain.IDomain;
import com.baan.ow.xmlconnector.IRequestProcessor;
import com.baan.ow.xmlconnector.XMLConnectorFactory;
import com.baan.owimpl.xmlconnector.configimpl.XMLConnectorProperty;
import com.baan.owimpl.xmlconnector.exception.FileException;
import com.baan.owimpl.xmlconnector.tools.ClientXMLC;
import com.baan.owimpl.xmlconnector.tools.GenerateXML;
import com.baan.owimpl.xmlconnector.tools.XMLCUtilityAbout;
import com.baan.owimpl.xmlconnector.util.FileIO;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.net.URL;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;

public class XMLConnectorUtility
extends JFrame {
    private static final String HELPSET = "adapter_helpset.hs";
    private static final String HELPTOPIC = "xmlconnector_utility";
    JPanel grpBox = new JPanel();
    Border border1;
    TitledBorder titledBorder1;
    JTabbedPane tabControl1 = new JTabbedPane();
    JPanel tabPanelGenerate = new JPanel();
    JPanel tabPanelExecute = new JPanel();
    JLabel lblRepFiles = new JLabel();
    JLabel lblBOIName = new JLabel();
    JLabel lblMethodName = new JLabel();
    JLabel label1 = new JLabel();
    JComboBox cmbRepFiles = new JComboBox();
    JComboBox cmbBOIName = new JComboBox();
    JComboBox cmbMethodName = new JComboBox();
    JTextField txtDestFolder = new JTextField();
    JButton cmdDestFolder = new JButton();
    JButton cmdAbout = new JButton();
    JButton cmdExit = new JButton();
    JButton cmdHelp = new JButton();
    JPanel groupBox4 = new JPanel();
    JPanel groupBox1 = new JPanel();
    Border border2;
    TitledBorder titledBorder2;
    JPanel groupBox2 = new JPanel();
    Border border3;
    TitledBorder titledBorder3;
    JRadioButton rdbXMLSchema = new JRadioButton();
    JRadioButton rdbDTD = new JRadioButton();
    JButton cmdGMD = new JButton();
    JButton cmdEVXMLMd = new JButton();
    JButton cmdGXML = new JButton();
    JButton cmdEVRequest = new JButton();
    ButtonGroup buttonGroup1 = new ButtonGroup();
    JPanel groupBox3 = new JPanel();
    JPanel grpASM = new JPanel();
    Border border4;
    TitledBorder titledBorder4;
    JCheckBox chkASM = new JCheckBox();
    JLabel lblUserName = new JLabel();
    JTextField txtUserName = new JTextField();
    JLabel lblPwd = new JLabel();
    JPasswordField txtPwd = new JPasswordField();
    JLabel label3 = new JLabel();
    JTextField txtRequestDoc = new JTextField();
    JButton cmdEVReqDoc = new JButton();
    JButton cmdExecute = new JButton();
    JButton cmdViewResults = new JButton();
    JButton cmdChooseReqDoc = new JButton();
    private HelpSet hs;
    private HelpBroker hb;
    private static final String sImageIcon = "/com/baan/owimpl/xmlconnector/tools/icon.gif";
    public static final String XML_SCHEMA = "XML Schema";
    public static final String XML_DTD = "DTD";
    public static final String METHOD_LIST = "MethodList";
    public static final String XML_EXT = ".xml";
    public static final String SCHEMA_EXT = ".xsd";
    public static final String DTD_EXT = ".dtd";
    public static final String REQUEST = "Request";
    public static final String RESPONSE = "Response";
    public static final String ERROR = "Error";
    public static final String UNDERSCORE = "_";
    public static final String WILDCARD = "*";
    public XMLFilter XML_FILTER = new XMLFilter();
    public DTDFilter DTD_FILTER = new DTDFilter();
    public XSDFilter XSD_FILTER = new XSDFilter();
    public static final String METADATA_FOLDER = "Metadata";
    public static final String INPUT_FOLDER = "Input";
    public static final String OUTPUT_FOLDER = "Output";
    public static final String BSHELL_OPEN_WITH = "rundll32.exe shell32.dll,OpenAs_RunDLL ";
    private IDomain m_repObj = null;
    private IMethodMetadata m_methodMd = null;
    private IManagerMetadata m_managerMd = null;
    private FileIO m_fileIO = null;
    private boolean m_OtherFileSelected = false;

    public XMLConnectorUtility() throws HeadlessException {
        try {
            this.jbInit();
            try {
                ((Frame)this).setIconImage(new ImageIcon(this.getClass().getResource(sImageIcon)).getImage());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.createHelpSet();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Error Creating Helpset, help not available.", "Help Error", 0);
            }
            int n = 409;
            int n2 = 432;
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n3 = (dimension.width - n) / 2;
            int n4 = (dimension.height - n2) / 2;
            ((Component)this).setBounds(n3, n4, n, n2);
            ((Component)this).setSize(n, n2);
            this.setResizable(false);
            this.initializeUI();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.border4 = BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140));
        this.titledBorder4 = new TitledBorder(this.border4, "Activation");
        this.getContentPane().setLayout(null);
        this.setFont(new Font("SansSerif", 0, 11));
        this.setTitle("Connector for XML Utility");
        this.border1 = BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140));
        this.titledBorder1 = new TitledBorder(this.border1, "Common");
        this.grpBox.setFont(new Font("SansSerif", 0, 11));
        this.grpBox.setBorder(this.titledBorder1);
        this.grpBox.setBounds(new Rectangle(8, 9, 388, 136));
        this.grpBox.setLayout(null);
        this.groupBox4.setBorder(BorderFactory.createEtchedBorder());
        this.groupBox4.setBounds(new Rectangle(2, 3, 376, 175));
        this.groupBox4.setLayout(null);
        this.groupBox3.setBorder(BorderFactory.createEtchedBorder());
        this.groupBox3.setBounds(new Rectangle(2, 3, 376, 175));
        this.groupBox3.setLayout(null);
        this.grpASM.setBorder(this.titledBorder4);
        this.grpASM.setBounds(new Rectangle(8, 14, 362, 72));
        this.grpASM.setLayout(null);
        this.chkASM.setToolTipText("Check this option to enable Activation functionality.");
        this.chkASM.setMnemonic('S');
        this.chkASM.setText("Activation");
        this.chkASM.setBounds(new Rectangle(21, 13, 162, 23));
        this.chkASM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XMLConnectorUtility.this.chkASM_actionPerformed(actionEvent);
            }
        });
        this.lblUserName.setDisplayedMnemonic('U');
        this.lblUserName.setText("User Name:");
        this.lblUserName.setBounds(new Rectangle(21, 40, 64, 16));
        this.txtUserName.setToolTipText("Enter user name.");
        this.txtUserName.setText("");
        this.txtUserName.setBounds(new Rectangle(99, 38, 80, 20));
        this.lblPwd.setDisplayedMnemonic('P');
        this.lblPwd.setText("Password:");
        this.lblPwd.setBounds(new Rectangle(195, 40, 56, 16));
        this.txtPwd.setToolTipText("Enter password.");
        ((JTextComponent)this.txtPwd).setText("");
        this.txtPwd.setBounds(new Rectangle(260, 38, 80, 20));
        this.label3.setText("Request Doc :");
        this.label3.setBounds(new Rectangle(16, 100, 72, 16));
        this.txtRequestDoc.setToolTipText("Contains path of the request document.");
        this.txtRequestDoc.setText("");
        this.txtRequestDoc.setBounds(new Rectangle(106, 100, 221, 20));
        this.cmdEVReqDoc.setBounds(new Rectangle(69, 132, 95, 23));
        this.cmdEVReqDoc.setToolTipText("Edit/View request document.");
        this.cmdEVReqDoc.setMargin(new Insets(0, 0, 0, 0));
        this.cmdEVReqDoc.setMnemonic('D');
        this.cmdEVReqDoc.setText("Edit/View Req");
        this.cmdEVReqDoc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XMLConnectorUtility.this.cmdEVReqDoc_actionPerformed(actionEvent);
            }
        });
        this.cmdExecute.setBounds(new Rectangle(173, 132, 104, 23));
        this.cmdExecute.setToolTipText("Execute request.");
        this.cmdExecute.setMargin(new Insets(0, 0, 0, 0));
        this.cmdExecute.setMnemonic('E');
        this.cmdExecute.setText("Execute Request");
        this.cmdExecute.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XMLConnectorUtility.this.cmdExecute_actionPerformed(actionEvent);
            }
        });
        this.cmdViewResults.setBounds(new Rectangle(285, 132, 75, 23));
        this.cmdViewResults.setToolTipText("View Results.");
        this.cmdViewResults.setMargin(new Insets(0, 0, 0, 0));
        this.cmdViewResults.setMnemonic('V');
        this.cmdViewResults.setText("View Results");
        this.cmdViewResults.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XMLConnectorUtility.this.cmdViewResults_actionPerformed(actionEvent);
            }
        });
        this.cmdChooseReqDoc.setBounds(new Rectangle(335, 100, 24, 23));
        this.cmdChooseReqDoc.setToolTipText("Choose request document.");
        this.cmdChooseReqDoc.setMargin(new Insets(0, 0, 0, 0));
        this.cmdChooseReqDoc.setText("...");
        this.cmdChooseReqDoc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XMLConnectorUtility.this.cmdChooseReqDoc_actionPerformed(actionEvent);
            }
        });
        this.cmdDestFolder.setToolTipText("Choose destination folder.");
        this.cmdDestFolder.setMargin(new Insets(0, 0, 0, 0));
        this.cmdDestFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XMLConnectorUtility.this.cmdDestFolder_actionPerformed(actionEvent);
            }
        });
        this.cmdAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XMLConnectorUtility.this.cmdAbout_actionPerformed(actionEvent);
            }
        });
        this.cmdExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XMLConnectorUtility.this.cmdExit_actionPerformed(actionEvent);
            }
        });
        this.cmdHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XMLConnectorUtility.this.cmdHelp_actionPerformed(actionEvent);
            }
        });
        this.cmdGMD.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XMLConnectorUtility.this.cmdGMD_actionPerformed(actionEvent);
            }
        });
        this.cmdEVXMLMd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XMLConnectorUtility.this.cmdEVXMLMd_actionPerformed(actionEvent);
            }
        });
        this.cmdGXML.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XMLConnectorUtility.this.cmdGXML_actionPerformed(actionEvent);
            }
        });
        this.cmdEVRequest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XMLConnectorUtility.this.cmdEVRequest_actionPerformed(actionEvent);
            }
        });
        this.cmbRepFiles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XMLConnectorUtility.this.cmbRepFiles_actionPerformed(actionEvent);
            }
        });
        this.cmbBOIName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XMLConnectorUtility.this.cmbBOIName_actionPerformed(actionEvent);
            }
        });
        this.cmbMethodName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XMLConnectorUtility.this.cmbMethodName_actionPerformed(actionEvent);
            }
        });
        this.rdbXMLSchema.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XMLConnectorUtility.this.rdbXMLSchema_actionPerformed(actionEvent);
            }
        });
        this.rdbDTD.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XMLConnectorUtility.this.rdbDTD_actionPerformed(actionEvent);
            }
        });
        this.tabPanelExecute.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                XMLConnectorUtility.this.tabPanelExecute_focusLost(focusEvent);
            }
        });
        this.cmbRepFiles.setToolTipText("This drop down contains list of repository files from dil.properties file.");
        this.cmbBOIName.setToolTipText("Contains the names of business objects from selected rep file.");
        this.cmbMethodName.setToolTipText("Contains the names of methods available for selected BOI.");
        this.txtDestFolder.setToolTipText("Destination folder.");
        this.rdbXMLSchema.setToolTipText("Choose this option to generate XML Schema.");
        this.rdbXMLSchema.setMnemonic('M');
        this.rdbDTD.setToolTipText("Choose this option to generate DTD.");
        this.rdbDTD.setMnemonic('D');
        this.cmdGMD.setToolTipText("Click here to generate metadata.");
        this.cmdGMD.setMnemonic('G');
        this.cmdEVXMLMd.setToolTipText("Edit/View metadate documents.");
        this.cmdEVXMLMd.setMnemonic('E');
        this.cmdGXML.setToolTipText("Click here to generate request document.");
        this.cmdGXML.setMnemonic('R');
        this.cmdEVRequest.setToolTipText("Edit/View Request document.");
        this.cmdEVRequest.setMnemonic('V');
        this.cmdAbout.setToolTipText("Displays Information about the tool.");
        this.cmdExit.setToolTipText("Click here to Exit.");
        this.cmdHelp.setToolTipText("Click here to view online help.");
        this.lblRepFiles.setDisplayedMnemonic('P');
        this.lblBOIName.setDisplayedMnemonic('B');
        this.lblMethodName.setDisplayedMnemonic('T');
        this.label1.setDisplayedMnemonic('F');
        this.getContentPane().add((Component)this.grpBox, null);
        this.lblRepFiles.setText("Repository Files:");
        this.lblRepFiles.setBounds(new Rectangle(16, 16, 80, 16));
        this.grpBox.add((Component)this.lblRepFiles, null);
        this.cmbRepFiles.setBounds(new Rectangle(115, 16, 256, 21));
        this.grpBox.add((Component)this.cmbRepFiles, null);
        this.lblBOIName.setText("BOI Name:");
        this.lblBOIName.setBounds(new Rectangle(16, 45, 56, 16));
        this.grpBox.add((Component)this.lblBOIName, null);
        this.cmbBOIName.setBounds(new Rectangle(115, 43, 256, 21));
        this.grpBox.add((Component)this.cmbBOIName, null);
        this.lblMethodName.setText("Method Name:");
        this.lblMethodName.setBounds(new Rectangle(16, 77, 80, 16));
        this.grpBox.add((Component)this.lblMethodName, null);
        this.cmbMethodName.setBounds(new Rectangle(115, 71, 256, 21));
        this.grpBox.add((Component)this.cmbMethodName, null);
        this.label1.setText("Destination Folder:");
        this.label1.setBounds(new Rectangle(16, 104, 96, 16));
        this.grpBox.add((Component)this.label1, null);
        this.txtDestFolder.setText("");
        this.txtDestFolder.setBounds(new Rectangle(115, 99, 224, 20));
        this.grpBox.add((Component)this.txtDestFolder, null);
        this.cmdDestFolder.setText("...");
        this.cmdDestFolder.setBounds(new Rectangle(347, 98, 24, 23));
        this.grpBox.add((Component)this.cmdDestFolder, null);
        this.tabControl1.setBounds(new Rectangle(6, 152, 391, 208));
        this.tabPanelGenerate.setLayout(null);
        this.tabControl1.add((Component)this.tabPanelGenerate, " Generate ");
        this.border2 = BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140));
        this.titledBorder2 = new TitledBorder(this.border2, METADATA_FOLDER);
        this.groupBox1.setBorder(this.titledBorder2);
        this.groupBox1.setBounds(new Rectangle(8, 14, 362, 72));
        this.groupBox1.setLayout(null);
        this.border3 = BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140));
        this.titledBorder3 = new TitledBorder(this.border3, "Request XML Document");
        this.groupBox2.setBorder(this.titledBorder3);
        this.groupBox2.setBounds(new Rectangle(8, 99, 361, 64));
        this.groupBox2.setLayout(null);
        this.rdbXMLSchema.setText(XML_SCHEMA);
        this.rdbXMLSchema.setBounds(new Rectangle(16, 16, 96, 16));
        this.rdbDTD.setText(XML_DTD);
        this.rdbDTD.setBounds(new Rectangle(16, 40, 88, 16));
        this.cmdGMD.setBounds(new Rectangle(180, 25, 80, 23));
        this.cmdGMD.setMargin(new Insets(0, 0, 0, 0));
        this.cmdGMD.setText("Gen Metadata");
        this.cmdEVXMLMd.setBounds(new Rectangle(273, 25, 80, 23));
        this.cmdEVXMLMd.setMargin(new Insets(0, 0, 0, 0));
        this.cmdEVXMLMd.setText("Edit/View ...");
        this.cmdGXML.setBounds(new Rectangle(169, 24, 90, 23));
        this.cmdGXML.setMargin(new Insets(0, 0, 0, 0));
        this.cmdGXML.setText("Gen Req Doc");
        this.cmdEVRequest.setBounds(new Rectangle(273, 24, 80, 23));
        this.cmdEVRequest.setMargin(new Insets(0, 0, 0, 0));
        this.cmdEVRequest.setText("Edit/View ...");
        this.tabPanelGenerate.add((Component)this.groupBox4, null);
        this.groupBox4.add((Component)this.groupBox1, null);
        this.groupBox1.add((Component)this.rdbXMLSchema, null);
        this.groupBox1.add((Component)this.rdbDTD, null);
        this.groupBox1.add((Component)this.cmdGMD, null);
        this.groupBox1.add((Component)this.cmdEVXMLMd, null);
        this.groupBox4.add((Component)this.groupBox2, null);
        this.groupBox2.add((Component)this.cmdGXML, null);
        this.groupBox2.add((Component)this.cmdEVRequest, null);
        this.tabPanelExecute.setLayout(null);
        this.tabControl1.add((Component)this.tabPanelExecute, " Execute ");
        this.tabPanelExecute.add((Component)this.groupBox3, null);
        this.getContentPane().add((Component)this.tabControl1, null);
        this.cmdAbout.setBounds(new Rectangle(156, 370, 75, 23));
        this.cmdAbout.setMnemonic('A');
        this.cmdAbout.setText("About");
        this.getContentPane().add((Component)this.cmdAbout, null);
        this.cmdExit.setBounds(new Rectangle(238, 370, 75, 23));
        this.cmdExit.setMnemonic('X');
        this.cmdExit.setText("Exit");
        this.getContentPane().add((Component)this.cmdExit, null);
        this.cmdHelp.setBounds(new Rectangle(321, 370, 75, 23));
        this.cmdHelp.setMnemonic('H');
        this.cmdHelp.setText("Help");
        this.getContentPane().add((Component)this.cmdHelp, null);
        this.buttonGroup1.add(this.rdbXMLSchema);
        this.buttonGroup1.add(this.rdbDTD);
        this.groupBox3.add((Component)this.grpASM, null);
        this.grpASM.add((Component)this.chkASM, null);
        this.grpASM.add((Component)this.lblUserName, null);
        this.grpASM.add((Component)this.txtUserName, null);
        this.grpASM.add((Component)this.lblPwd, null);
        this.grpASM.add((Component)this.txtPwd, null);
        this.groupBox3.add((Component)this.label3, null);
        this.groupBox3.add((Component)this.txtRequestDoc, null);
        this.groupBox3.add((Component)this.cmdEVReqDoc, null);
        this.groupBox3.add((Component)this.cmdExecute, null);
        this.groupBox3.add((Component)this.cmdViewResults, null);
        this.groupBox3.add((Component)this.cmdChooseReqDoc, null);
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        XMLConnectorUtility xMLConnectorUtility = new XMLConnectorUtility();
        xMLConnectorUtility.show();
    }

    private void createHelpSet() throws Exception {
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL uRL = HelpSet.findHelpSet((ClassLoader)classLoader, (String)HELPSET);
        this.hs = new HelpSet(classLoader, uRL);
        this.hb = this.hs.createHelpBroker();
        JRootPane jRootPane = this.getRootPane();
        this.hb.enableHelpKey((Component)jRootPane, HELPTOPIC, this.hs);
    }

    private void popUpMessage(String string) {
        JOptionPane.showMessageDialog(this, string, ERROR, 0);
    }

    void cmdAbout_actionPerformed(ActionEvent actionEvent) {
        this.cmdAbout_click(null, null);
    }

    void cmdExit_actionPerformed(ActionEvent actionEvent) {
        this.cmdExit_click(null, null);
    }

    void cmdHelp_actionPerformed(ActionEvent actionEvent) {
        try {
            this.hb.setCurrentID(HELPTOPIC);
            this.hb.setDisplayed(true);
        }
        catch (Exception exception) {}
    }

    void cmdDestFolder_actionPerformed(ActionEvent actionEvent) {
        this.cmdDestFolder_click(null, null);
    }

    void cmdGMD_actionPerformed(ActionEvent actionEvent) {
        this.cmdGMD_click(null, null);
    }

    void cmdEVXMLMd_actionPerformed(ActionEvent actionEvent) {
        this.cmdEVXMLMd_click(null, null);
    }

    void cmdGXML_actionPerformed(ActionEvent actionEvent) {
        this.cmdGXML_click(null, null);
    }

    void cmdEVRequest_actionPerformed(ActionEvent actionEvent) {
        this.cmdEVRequest_click(null, null);
    }

    void cmdChooseReqDoc_actionPerformed(ActionEvent actionEvent) {
        this.cmdChooseReqDoc_click(null, null);
    }

    void cmdEVReqDoc_actionPerformed(ActionEvent actionEvent) {
        this.cmdEVReqDoc_click(null, null);
    }

    void cmdExecute_actionPerformed(ActionEvent actionEvent) {
        this.cmdExecute_click(null, null);
    }

    void cmdViewResults_actionPerformed(ActionEvent actionEvent) {
        this.cmdViewResults_click(null, null);
    }

    void cmbRepFiles_actionPerformed(ActionEvent actionEvent) {
        this.cmbRepFiles_selectedIndexChanged(null, null);
    }

    void cmbBOIName_actionPerformed(ActionEvent actionEvent) {
        this.cmbBOIName_selectedIndexChanged(null, null);
    }

    void cmbMethodName_actionPerformed(ActionEvent actionEvent) {
        this.cmbMethodName_selectedIndexChanged(null, null);
    }

    void chkASM_actionPerformed(ActionEvent actionEvent) {
        this.chkASM_checkedChanged(null, null);
    }

    void rdbXMLSchema_actionPerformed(ActionEvent actionEvent) {
        this.rdbXMLSchema_checkedChanged(null, null);
    }

    void rdbDTD_actionPerformed(ActionEvent actionEvent) {
        this.rdbDTD_checkedChanged(null, null);
    }

    void tabPanelExecute_focusLost(FocusEvent focusEvent) {
        this.tabExe_leave(null, null);
    }

    private void initializeUI() {
        this.loadRepFiles();
        this.txtUserName.setEnabled(false);
        this.txtUserName.setBackground(SystemColor.control);
        this.txtPwd.setEnabled(false);
        this.txtPwd.setBackground(SystemColor.control);
        this.rdbXMLSchema.setSelected(true);
        this.cmdViewResults.setEnabled(false);
    }

    private void loadRepFiles() {
        block4: {
            try {
                String[] stringArray = null;
                XMLConnectorProperty xMLConnectorProperty = XMLConnectorProperty.getXMLConnectorProperty();
                stringArray = xMLConnectorProperty.getRepositoryNames();
                if (stringArray == null || stringArray.length <= 0) break block4;
                int n = 0;
                while (n < stringArray.length) {
                    this.cmbRepFiles.addItem(stringArray[n].trim());
                    ++n;
                }
            }
            catch (FileException fileException) {
                this.popUpMessage("File Not found: " + fileException.toString());
            }
            catch (Exception exception) {
                this.popUpMessage(exception.toString());
            }
        }
    }

    private void cmbRepFiles_selectedIndexChanged(Object object, Event event) {
        if (this.cmbRepFiles.getSelectedItem() == null) {
            return;
        }
        try {
            String string = this.cmbRepFiles.getSelectedItem().toString();
            this.clearAllData();
            URL uRL = ClassLoader.getSystemResource(this.cmbRepFiles.getSelectedItem().toString());
            if (uRL != null) {
                this.m_repObj = Domain.open(uRL);
                String[] stringArray = this.m_repObj.getBoiNames();
                this.sort(stringArray, 0, stringArray.length - 1);
                this.cmbBOIName.removeAllItems();
                int n = 0;
                while (n < stringArray.length) {
                    this.cmbBOIName.addItem(stringArray[n]);
                    ++n;
                }
            } else {
                this.popUpMessage("The repository file, " + string + " not found in the classpath");
            }
        }
        catch (Exception exception) {
            this.popUpMessage("Corrupt Repository File: " + exception.getMessage());
        }
    }

    private void clearAllData() {
        this.cmbBOIName.removeAllItems();
        this.cmbMethodName.removeAllItems();
        this.clearAllTextFields();
    }

    private void cmbBOIName_selectedIndexChanged(Object object, Event event) {
        CharSequence charSequence;
        if (this.cmbBOIName.getSelectedItem() == null) {
            return;
        }
        this.cmbMethodName.removeAllItems();
        this.clearAllTextFields();
        IBoiDescriptor iBoiDescriptor = this.m_repObj.getBoi(this.cmbBOIName.getSelectedItem().toString());
        if (iBoiDescriptor != null) {
            charSequence = iBoiDescriptor.getManagerClass();
            try {
                this.m_managerMd = MetadataUtil.getManagerMetadata((String)charSequence);
            }
            catch (Exception exception) {
                this.popUpMessage("Manager class not found in classpath: " + exception.toString());
                return;
            }
        }
        charSequence = new StringBuffer();
        String[] stringArray = new ClientXMLC().getMethodList(this.cmbBOIName.getSelectedItem().toString(), (StringBuffer)charSequence);
        if (stringArray != null) {
            this.sort(stringArray, 0, stringArray.length - 1);
            this.cmbMethodName.removeAllItems();
            int n = 0;
            while (n < stringArray.length) {
                this.cmbMethodName.addItem(stringArray[n]);
                ++n;
            }
        } else {
            this.popUpMessage("Error while retrieving the list of Methods: " + ((StringBuffer)charSequence).toString());
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void sort(String[] var1_1, int var2_2, int var3_3) {
        var4_4 = var2_2;
        var5_5 = var3_3;
        if (var4_4 >= var5_5) {
            return;
        }
        if (var4_4 == var5_5 - 1) {
            if (this.compareStrings(var1_1[var4_4], var1_1[var5_5]) > 0) {
                var6_6 = var1_1[var4_4];
                var1_1[var4_4] = var1_1[var5_5];
                var1_1[var5_5] = var6_6;
            }
            return;
        }
        var6_7 = var1_1[(var4_4 + var5_5) / 2];
        var1_1[(var4_4 + var5_5) / 2] = var1_1[var5_5];
        var1_1[var5_5] = var6_7;
        ** GOTO lbl25
        {
            ++var4_4;
            do {
                if (this.compareStrings(var1_1[var4_4], var6_7) <= 0 && var4_4 < var5_5) continue block0;
                while (this.compareStrings(var6_7, var1_1[var5_5]) <= 0 && var4_4 < var5_5) {
                    --var5_5;
                }
                if (var4_4 >= var5_5) continue;
                var7_8 = var1_1[var4_4];
                var1_1[var4_4] = var1_1[var5_5];
                var1_1[var5_5] = var7_8;
lbl25:
                // 3 sources

            } while (var4_4 < var5_5);
        }
        var1_1[var3_3] = var1_1[var5_5];
        var1_1[var5_5] = var6_7;
        this.sort(var1_1, var2_2, var4_4 - 1);
        this.sort(var1_1, var5_5 + 1, var3_3);
    }

    private int compareStrings(String string, String string2) {
        string = string.toLowerCase();
        string2 = string2.toLowerCase();
        return string.compareTo(string2);
    }

    private void cmbMethodName_selectedIndexChanged(Object object, Event event) {
        this.clearAllTextFields();
    }

    private void cmdExit_click(Object object, Event event) {
        this.dispose();
        System.exit(0);
    }

    private void chkASM_checkedChanged(Object object, Event event) {
        if (this.chkASM.isSelected()) {
            this.txtUserName.setEnabled(true);
            this.txtUserName.setBackground(SystemColor.window);
            this.txtPwd.setEnabled(true);
            this.txtPwd.setBackground(SystemColor.window);
        } else {
            this.txtUserName.setEnabled(false);
            this.txtUserName.setBackground(SystemColor.control);
            this.txtUserName.setText("");
            this.txtPwd.setEnabled(false);
            this.txtPwd.setBackground(SystemColor.control);
            ((JTextComponent)this.txtPwd).setText("");
        }
    }

    private void cmdDestFolder_click(Object object, Event event) {
        JFileChooser jFileChooser = new JFileChooser(this.txtDestFolder.getText());
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setDialogTitle("Select Destination Folder");
        int n = jFileChooser.showDialog(this, "Select");
        if (n == 0) {
            this.txtDestFolder.setText(jFileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void cmdGMD_click(Object object, Event event) {
        this.generateMetaData();
    }

    private void generateMetaData() {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.checkForMandatoryFields()) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        File file2 = new File(this.txtDestFolder.getText());
        if (!file2.exists()) {
            file2.mkdirs();
        }
        ClientXMLC clientXMLC = new ClientXMLC();
        if (this.rdbXMLSchema.isSelected()) {
            bl = clientXMLC.genSchema((String)this.cmbBOIName.getSelectedItem(), (String)this.cmbMethodName.getSelectedItem(), this.txtDestFolder.getText(), false, stringBuffer);
            if (!bl) {
                this.popUpMessage("Error encountered while generating metadata document, please check the error file.");
            }
        } else if (this.rdbDTD.isSelected() && !(bl = clientXMLC.genDTD((String)this.cmbBOIName.getSelectedItem(), (String)this.cmbMethodName.getSelectedItem(), this.txtDestFolder.getText()))) {
            this.popUpMessage("Error encountered while generating metadata document, please check the error file.");
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private boolean generateRequestXML() {
        try {
            String string;
            if (!this.checkForMandatoryFields()) {
                return false;
            }
            ClientXMLC clientXMLC = new ClientXMLC();
            GenerateXML generateXML = new GenerateXML();
            StringBuffer stringBuffer = null;
            StringBuffer stringBuffer2 = new StringBuffer();
            StringBuffer stringBuffer3 = new StringBuffer();
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (this.rdbDTD.isSelected()) {
                clientXMLC.genSchema((String)this.cmbBOIName.getSelectedItem(), (String)this.cmbMethodName.getSelectedItem(), this.txtDestFolder.getText(), true, stringBuffer3);
                stringBuffer = stringBuffer3;
            } else if (this.rdbXMLSchema.isSelected()) {
                string = this.txtDestFolder.getText() + File.separator + METADATA_FOLDER + File.separator + REQUEST + UNDERSCORE + this.cmbBOIName.getSelectedItem() + UNDERSCORE + this.cmbMethodName.getSelectedItem() + SCHEMA_EXT;
                stringBuffer = FileIO.readData(string);
                if (stringBuffer == null) {
                    this.popUpMessage("Metadata file not created. First create Metadata file.");
                    this.setCursor(Cursor.getDefaultCursor());
                    return false;
                }
            } else {
                this.popUpMessage("Please select either XML Schema or DTD ");
                this.setCursor(Cursor.getDefaultCursor());
                return false;
            }
            generateXML.generateXML(stringBuffer, stringBuffer2, this.cmbBOIName.getSelectedItem().toString(), this.cmbMethodName.getSelectedItem().toString());
            string = "";
            string = this.txtDestFolder.getText().endsWith(File.separator) ? this.txtDestFolder.getText() + INPUT_FOLDER : this.txtDestFolder.getText() + File.separator + INPUT_FOLDER;
            File file2 = new File(string);
            if (!file2.exists()) {
                file2.mkdirs();
            }
            string = string + File.separator + REQUEST + UNDERSCORE + this.cmbBOIName.getSelectedItem() + UNDERSCORE + this.cmbMethodName.getSelectedItem() + XML_EXT;
            FileIO.writeData(string, stringBuffer2, true);
            this.txtRequestDoc.setText(string);
            this.setCursor(Cursor.getDefaultCursor());
            return true;
        }
        catch (Exception exception) {
            this.popUpMessage(exception.toString());
            this.setCursor(Cursor.getDefaultCursor());
            return false;
        }
    }

    private void cmdExecute_click(Object object, Event event) {
        try {
            Object object2;
            Object object3;
            Object object4;
            if (!this.m_OtherFileSelected && !this.checkForMandatoryFields()) {
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            IRequestProcessor iRequestProcessor = XMLConnectorFactory.getProcessor();
            IUserSession iUserSession = null;
            StringBuffer stringBuffer = new StringBuffer("");
            StringBuffer stringBuffer2 = new StringBuffer("");
            if (this.chkASM.isSelected()) {
                object4 = BoiToolkit.getDefaultToolkit();
                object3 = ((BoiToolkit)object4).createUserInfo();
                if (this.txtUserName.getText().trim().equals("")) {
                    this.popUpMessage("If ASM is selected, User Name can not be blank");
                    this.setCursor(Cursor.getDefaultCursor());
                    return;
                }
                object2 = this.txtPwd.getPassword();
                object3.setPassword(new String((char[])object2));
                object3.setUsername(this.txtUserName.getText().trim());
                iUserSession = ((BoiToolkit)object4).createUserSession((IUserInfo)object3);
            }
            if ((object4 = FileIO.readData(this.txtRequestDoc.getText().trim())) == null) {
                this.popUpMessage("Please select valid input request file.");
                iRequestProcessor.close();
                this.setCursor(Cursor.getDefaultCursor());
                return;
            }
            object3 = "";
            object3 = UNDERSCORE + this.cmbBOIName.getSelectedItem() + UNDERSCORE + this.cmbMethodName.getSelectedItem();
            iRequestProcessor.execute(iUserSession, ((StringBuffer)object4).toString(), stringBuffer, stringBuffer2);
            if (!this.m_OtherFileSelected) {
                object2 = "";
                object2 = this.txtDestFolder.getText().trim().endsWith(File.separator) ? this.txtDestFolder.getText() + OUTPUT_FOLDER : this.txtDestFolder.getText() + File.separator + OUTPUT_FOLDER;
                File file2 = new File((String)object2);
                if (!file2.exists()) {
                    file2.mkdirs();
                }
                FileIO.writeData((String)object2 + File.separator + RESPONSE + (String)object3 + XML_EXT, stringBuffer, false);
                FileIO.writeData((String)object2 + File.separator + ERROR + (String)object3 + XML_EXT, stringBuffer2, false);
            } else {
                object2 = "";
                object2 = this.txtRequestDoc.getText();
                int n = this.txtRequestDoc.getText().lastIndexOf(File.separator);
                object2 = ((String)object2).substring(0, n);
                File file3 = new File((String)(object2 = (String)object2 + File.separator + OUTPUT_FOLDER));
                if (!file3.exists()) {
                    file3.mkdirs();
                }
                object3 = "";
                String string = "";
                Object object5 = "";
                object3 = this.txtRequestDoc.getText().substring(n + 1, this.txtRequestDoc.getText().length());
                if (((String)(object3 = ((String)object3).substring(0, ((String)object3).length() - 4))).startsWith(REQUEST)) {
                    object5 = ((String)object3).substring(REQUEST.length(), ((String)object3).length());
                    object3 = RESPONSE + (String)object5 + XML_EXT;
                    string = ERROR + (String)object5 + XML_EXT;
                } else if (((String)object3).endsWith(REQUEST)) {
                    object5 = ((String)object3).substring(0, ((String)object3).length() - REQUEST.length());
                    object3 = (String)object5 + RESPONSE + XML_EXT;
                    string = (String)object5 + ERROR + XML_EXT;
                } else {
                    object5 = object3;
                    object3 = (String)object5 + RESPONSE + XML_EXT;
                    string = (String)object5 + ERROR + XML_EXT;
                }
                FileIO.writeData((String)object2 + File.separator + (String)object3, stringBuffer, false);
                FileIO.writeData((String)object2 + File.separator + string, stringBuffer2, false);
            }
            iRequestProcessor.close();
            this.setCursor(Cursor.getDefaultCursor());
            this.cmdViewResults.setEnabled(true);
        }
        catch (Exception exception) {
            this.popUpMessage("Error during execution: " + exception.toString());
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void cmdEVXMLMd_click(Object object, Event event) {
        try {
            if (this.txtDestFolder.getText().trim().equals("")) {
                this.popUpMessage("Please enter destination folder");
                return;
            }
            String string = this.txtDestFolder.getText().endsWith(File.separator) ? this.txtDestFolder.getText() + METADATA_FOLDER : this.txtDestFolder.getText() + File.separator + METADATA_FOLDER;
            JFileChooser jFileChooser = new JFileChooser(string);
            if (this.rdbDTD.isSelected()) {
                jFileChooser.addChoosableFileFilter(this.DTD_FILTER);
            } else if (this.rdbXMLSchema.isSelected()) {
                jFileChooser.addChoosableFileFilter(this.XSD_FILTER);
            }
            jFileChooser.setMultiSelectionEnabled(false);
            int n = jFileChooser.showDialog(this, "Select file");
            if (n == 0) {
                File file2 = jFileChooser.getSelectedFile();
                String string2 = file2.getAbsolutePath();
                Runtime.getRuntime().exec("Notepad " + string2);
            }
        }
        catch (Exception exception) {
            this.popUpMessage("Error opening File");
        }
    }

    private void cmdAbout_click(Object object, Event event) {
        XMLCUtilityAbout xMLCUtilityAbout = new XMLCUtilityAbout(this);
        xMLCUtilityAbout.show();
    }

    private boolean checkForMandatoryFields() {
        if (this.cmbRepFiles.getSelectedItem() == null) {
            this.popUpMessage("Please select the Repository file Name.");
            return false;
        }
        if (this.cmbBOIName.getSelectedItem() == null) {
            this.popUpMessage("Please select the BOI Name.");
            return false;
        }
        if (this.cmbMethodName.getSelectedItem() == null) {
            this.popUpMessage("Please select the Method Name.");
            return false;
        }
        if (this.txtDestFolder.getText().trim().equals("")) {
            this.popUpMessage("Please choose the destination folder.");
            return false;
        }
        return true;
    }

    private void clearAllTextFields() {
        this.chkASM.setSelected(false);
        this.txtUserName.setText("");
        ((JTextComponent)this.txtPwd).setText("");
        this.txtRequestDoc.setText("");
        this.cmdViewResults.setEnabled(false);
    }

    private void cmdGXML_click(Object object, Event event) {
        if (this.generateRequestXML()) {
            this.tabControl1.setSelectedComponent(this.tabPanelExecute);
        }
    }

    private void cmdChooseReqDoc_click(Object object, Event event) {
        boolean bl = false;
        this.enableDisableCommonData(false);
        JFileChooser jFileChooser = new JFileChooser(this.txtDestFolder.getText());
        jFileChooser.addChoosableFileFilter(this.XML_FILTER);
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showDialog(this, "Select request file");
        if (n == 0) {
            File file2 = jFileChooser.getSelectedFile();
            String string = file2.getAbsolutePath();
            if (!string.endsWith(XML_EXT)) {
                string = string + "." + "xml";
            }
            this.txtRequestDoc.setText(string);
            this.m_OtherFileSelected = true;
        } else if (n == 1) {
            this.enableDisableCommonData(true);
        }
    }

    private void enableDisableCommonData(boolean bl) {
        this.cmbRepFiles.setEnabled(bl);
        this.cmbBOIName.setEnabled(bl);
        this.cmbMethodName.setEnabled(bl);
        this.txtDestFolder.setEnabled(bl);
        this.cmdDestFolder.setEnabled(bl);
    }

    private void cmdEVReqDoc_click(Object object, Event event) {
        block3: {
            try {
                if (!this.txtRequestDoc.getText().trim().equals("")) {
                    Runtime.getRuntime().exec("Notepad " + this.txtRequestDoc.getText());
                    break block3;
                }
                this.popUpMessage("Please select a Request document");
            }
            catch (Exception exception) {
                this.popUpMessage(exception.toString());
            }
        }
    }

    private void cmdViewResults_click(Object object, Event event) {
        try {
            String string = "";
            if (!this.m_OtherFileSelected) {
                string = this.txtDestFolder.getText().endsWith(File.separator) ? this.txtDestFolder.getText() + OUTPUT_FOLDER : this.txtDestFolder.getText() + File.separator + OUTPUT_FOLDER;
            } else {
                string = this.txtRequestDoc.getText();
                int n = string.lastIndexOf(File.separator);
                string = string.substring(0, n);
                string = string + File.separator + OUTPUT_FOLDER;
            }
            JFileChooser jFileChooser = new JFileChooser(string);
            jFileChooser.addChoosableFileFilter(this.XML_FILTER);
            jFileChooser.setMultiSelectionEnabled(false);
            int n = jFileChooser.showDialog(this, "Select file");
            if (n == 0) {
                File file2 = jFileChooser.getSelectedFile();
                String string2 = file2.getAbsolutePath();
                if (!string2.endsWith(XML_EXT)) {
                    string2 = string2 + "." + "xml";
                }
                Runtime.getRuntime().exec("Notepad " + string2);
            }
        }
        catch (Exception exception) {
            this.popUpMessage("Error opening File");
        }
    }

    private void rdbXMLSchema_checkedChanged(Object object, Event event) {
        if (this.rdbXMLSchema.isSelected()) {
            this.clearAllTextFields();
        }
    }

    private void rdbDTD_checkedChanged(Object object, Event event) {
        if (this.rdbDTD.isSelected()) {
            this.clearAllTextFields();
        }
    }

    private void tabExe_leave(Object object, Event event) {
        this.enableDisableCommonData(true);
        this.m_OtherFileSelected = false;
    }

    private void cmdEVRequest_click(Object object, Event event) {
        try {
            if (this.txtRequestDoc.getText().trim().equals("")) {
                this.popUpMessage("Please generate request document first, or select existing one");
                return;
            }
            int n = this.txtRequestDoc.getText().lastIndexOf(File.separator);
            String string = this.txtRequestDoc.getText().substring(0, n);
            JFileChooser jFileChooser = new JFileChooser(string);
            jFileChooser.addChoosableFileFilter(this.XML_FILTER);
            jFileChooser.setMultiSelectionEnabled(false);
            int n2 = jFileChooser.showDialog(this, "Select request file");
            if (n2 == 0) {
                File file2 = jFileChooser.getSelectedFile();
                String string2 = file2.getAbsolutePath();
                if (!string2.endsWith(XML_EXT)) {
                    string2 = string2 + "." + "xml";
                }
                Runtime.getRuntime().exec("Notepad " + string2);
            }
        }
        catch (Exception exception) {
            this.popUpMessage("Error opening File");
        }
    }

    private class XSDFilter
    extends FileFilter {
        private XSDFilter() {
        }

        public boolean accept(File file2) {
            if (file2.isDirectory()) {
                return true;
            }
            String string = this.getExtension(file2);
            return string != null && (string.equals("xsd") || string.equals("xml"));
        }

        public String getExtension(File file2) {
            String string = null;
            String string2 = file2.getName();
            int n = string2.lastIndexOf(46);
            if (n > 0 && n < string2.length() - 1) {
                string = string2.substring(n + 1).toLowerCase();
            }
            return string;
        }

        public String getDescription() {
            return "Configuration Storage XML Files";
        }
    }

    private class DTDFilter
    extends FileFilter {
        private DTDFilter() {
        }

        public boolean accept(File file2) {
            if (file2.isDirectory()) {
                return true;
            }
            String string = this.getExtension(file2);
            return string != null && (string.equals("dtd") || string.equals("xml"));
        }

        public String getExtension(File file2) {
            String string = null;
            String string2 = file2.getName();
            int n = string2.lastIndexOf(46);
            if (n > 0 && n < string2.length() - 1) {
                string = string2.substring(n + 1).toLowerCase();
            }
            return string;
        }

        public String getDescription() {
            return "Configuration Storage XML Files";
        }
    }

    private class XMLFilter
    extends FileFilter {
        public static final String XML = "xml";

        private XMLFilter() {
        }

        public boolean accept(File file2) {
            if (file2.isDirectory()) {
                return true;
            }
            String string = this.getExtension(file2);
            return string != null && string.equals(XML);
        }

        public String getExtension(File file2) {
            String string = null;
            String string2 = file2.getName();
            int n = string2.lastIndexOf(46);
            if (n > 0 && n < string2.length() - 1) {
                string = string2.substring(n + 1).toLowerCase();
            }
            return string;
        }

        public String getDescription() {
            return "Configuration Storage XML Files";
        }
    }
}

