/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.xmlconnector.process;

import com.baan.b3.dom.Element;
import com.baan.b3.dom.Node;
import com.baan.b3.dom.NodeList;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.baan.owimpl.xmlconnector.exception.InvalidParameterException;
import com.baan.owimpl.xmlconnector.preparedmetadata.IPreparedMetadata;
import com.baan.owimpl.xmlconnector.preparedmetadata.SchemaStructure;
import com.baan.owimpl.xmlconnector.util.RequestParser;
import com.baan.owimpl.xmlconnector.util.XMLReader;
import java.util.Vector;

public class Validator {
    private static final String COPYRIGHT = "Copyright (c) 2001-2002 Baan Company";
    protected static final String NAMESPACE = SchemaStructure.getNameSpace() + ":";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String MAX = "maxOccurs";
    private static final String INFINITY = "unbounded";
    private static final String COMPLEX_TYPE = "complexType";
    private static final String ATTRIBUTE = "attribute";
    private NodeList m_complexTagList = null;
    private XMLReader m_xmlReader = new XMLReader();
    private Vector m_XMLNode = new Vector();
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.owimpl.xmlconnector.process", "XMLConnectorProcess");

    public void checkValidity(NodeList nodeList, IPreparedMetadata iPreparedMetadata) throws Exception {
        Node node = iPreparedMetadata.getMethodParameterMetadata();
        this.m_complexTagList = ((Element)node).getElementsByTagName(NAMESPACE + COMPLEX_TYPE);
        this.fillXMLNodeElement();
        int n = 0;
        while (n < nodeList.getLength()) {
            try {
                this.checkValid(nodeList.item(n));
            }
            catch (Exception exception) {
                s_logger.errorMessage(this.getClass().getName());
                s_logger.errorException(exception);
                throw exception;
            }
            ++n;
        }
    }

    private void checkValid(Node node) throws Exception {
        NodeList nodeList = null;
        NodeList nodeList2 = null;
        boolean bl = false;
        RequestParser requestParser = new RequestParser();
        Vector<String> vector = new Vector<String>();
        String string = "";
        String string2 = "";
        int n = 0;
        while (n < this.m_complexTagList.getLength()) {
            string2 = this.m_xmlReader.getAttributeValue(this.m_complexTagList.item(n), NAME);
            if (string2.equalsIgnoreCase((string = node.getNodeName()) + TYPE)) {
                if (node.getAttributes().getLength() != 0) {
                    this.checkAttributeValidity(node, this.m_complexTagList.item(n).getChildNodes());
                }
                this.cardinalityCheck(string2, this.m_complexTagList.item(n), vector);
                requestParser.checkTextNode(node);
                vector.addElement(string2);
                nodeList2 = node.getChildNodes();
                nodeList = this.m_complexTagList.item(n).getFirstChild().getChildNodes();
                bl = true;
                break;
            }
            ++n;
        }
        if (this.m_XMLNode.contains(string)) {
            return;
        }
        if (bl) {
            int n2 = nodeList2.getLength();
            int n3 = 0;
            while (n3 < nodeList2.getLength()) {
                if (nodeList2.item(n3).getNodeType() == 1) {
                    bl = false;
                    int n4 = 0;
                    while (n4 < nodeList.getLength()) {
                        string2 = this.m_xmlReader.getAttributeValue(nodeList.item(n4), NAME);
                        if (string2.equals(string = nodeList2.item(n3).getNodeName())) {
                            this.cardinalityCheck(string2, nodeList.item(n4), vector);
                            vector.addElement(string);
                            if (this.m_xmlReader.hasElement(nodeList2.item(n3))) {
                                this.checkValid(nodeList2.item(n3));
                            }
                            bl = true;
                            break;
                        }
                        ++n4;
                    }
                    if (!bl) {
                        throw new InvalidParameterException("Invalid Parameter : " + string);
                    }
                }
                ++n3;
            }
        } else {
            throw new InvalidParameterException("Invalid Parameter : " + string);
        }
    }

    private void checkAttributeValidity(Node node, NodeList nodeList) throws InvalidParameterException {
        boolean bl = false;
        String string = null;
        int n = node.getAttributes().getLength();
        int n2 = 0;
        while (n2 < node.getAttributes().getLength()) {
            bl = false;
            string = node.getAttributes().item(n2).getNodeName();
            int n3 = nodeList.getLength();
            int n4 = 0;
            while (n4 < nodeList.getLength()) {
                String string2;
                if (nodeList.item(n4).getNodeName().equals(NAMESPACE + ATTRIBUTE) && string.equals(string2 = this.m_xmlReader.getAttributeValue(nodeList.item(n4), NAME))) {
                    bl = true;
                    break;
                }
                ++n4;
            }
            if (!bl) {
                throw new InvalidParameterException("Invalid Attribute : " + string + " for element : " + node.getNodeName());
            }
            ++n2;
        }
    }

    private void cardinalityCheck(String string, Node node, Vector vector) throws InvalidParameterException {
        String string2;
        if (vector.contains(string) && !(string2 = this.m_xmlReader.getAttributeValue(node, MAX)).equals(INFINITY)) {
            throw new InvalidParameterException("Invalid Parameter : " + string + " Only Single instance is allowed");
        }
    }

    private void fillXMLNodeElement() {
        Node node = null;
        int n = 0;
        while (n < this.m_complexTagList.getLength()) {
            node = this.m_complexTagList.item(n).getFirstChild();
            if (node != null) {
                NodeList nodeList = node.getChildNodes();
                int n2 = 0;
                while (n2 < nodeList.getLength()) {
                    if (this.m_xmlReader.getAttributeValue(nodeList.item(n2), TYPE).equals(NAMESPACE + "anyType")) {
                        this.m_XMLNode.addElement(this.m_xmlReader.getAttributeValue(nodeList.item(n2), NAME));
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }
}

