/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.xmlconnector.process;

import com.baan.b3.boi1.BusinessObject;
import com.baan.b3.boi1.BusinessObjectManager;
import com.baan.b3.boi1.Iterator;
import com.baan.b3.boi1.metadata.IBusinessObjectMetadata;
import com.baan.b3.boi1.metadata.IIteratorMetadata;
import com.baan.b3.boi1.metadata.IManagerMethodMetadata;
import com.baan.b3.boi1.metadata.IMethodMetadata;
import com.baan.b3.boi1.metadata.IParameterMetadata;
import com.baan.b3.dom.Document;
import com.baan.b3.dom.NodeList;
import com.baan.ow.xmlconnector.IXMLCIterator;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.baan.owimpl.xmlconnector.exception.MethodNotSupportedException;
import com.baan.owimpl.xmlconnector.preparedmetadata.IPreparedMetadata;
import com.baan.owimpl.xmlconnector.process.ProcessHandler;
import com.baan.owimpl.xmlconnector.process.XMLCIterator;

class ShowListExecution
extends ProcessHandler {
    private static final String COPYRIGHT = "Copyright (c) 2001-2002 Baan Company";
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.owimpl.xmlconnector.process", "XMLConnectorProcess");

    ShowListExecution() {
    }

    public Document invoke(BusinessObjectManager businessObjectManager, NodeList nodeList, IPreparedMetadata iPreparedMetadata, int n, boolean bl) throws Exception {
        try {
            this.processInitialization();
            IManagerMethodMetadata iManagerMethodMetadata = iPreparedMetadata.getMethodMetada();
            this.m_returnObject = this.getReturnObject(businessObjectManager, iPreparedMetadata, nodeList, iManagerMethodMetadata);
            if (this.m_returnObject == null) {
                return this.m_responseDocument;
            }
            IParameterMetadata iParameterMetadata = iManagerMethodMetadata.getReturnType();
            if (iParameterMetadata.getType() instanceof IBusinessObjectMetadata) {
                this.m_convertor.covertObjectToXML((BusinessObject)this.m_returnObject, this.m_rootNode);
            } else if (iParameterMetadata.getType() instanceof IIteratorMetadata) {
                Iterator iterator = (Iterator)this.m_returnObject;
                if (bl) {
                    iterator.setFetchSize(n);
                }
                if (!iterator.hasMoreElements()) {
                    return this.m_responseDocument;
                }
                this.m_convertor.setMethodName(iManagerMethodMetadata.getName());
                while (iterator.hasMoreElements()) {
                    this.m_convertor.covertObjectToXML(iterator.nextElement(), this.m_rootNode);
                }
            }
            iManagerMethodMetadata = null;
            iParameterMetadata = null;
        }
        catch (Exception exception) {
            s_logger.errorMessage(this.getClass().getName());
            s_logger.errorException(exception);
            throw exception;
        }
        this.m_rootNode = null;
        return this.m_responseDocument;
    }

    public IXMLCIterator invokeSync(BusinessObjectManager businessObjectManager, NodeList nodeList, IPreparedMetadata iPreparedMetadata, int n, boolean bl) throws Exception {
        XMLCIterator xMLCIterator = null;
        Iterator iterator = null;
        try {
            IManagerMethodMetadata iManagerMethodMetadata = iPreparedMetadata.getMethodMetada();
            this.m_returnObject = this.getReturnObject(businessObjectManager, iPreparedMetadata, nodeList, iManagerMethodMetadata);
            IParameterMetadata iParameterMetadata = iManagerMethodMetadata.getReturnType();
            if (iParameterMetadata.getType() instanceof IBusinessObjectMetadata) {
                throw new MethodNotSupportedException();
            }
            if (iParameterMetadata.getType() instanceof IIteratorMetadata) {
                iterator = (Iterator)this.m_returnObject;
                if (bl) {
                    iterator.setFetchSize(n);
                }
                xMLCIterator = new XMLCIterator();
                xMLCIterator.setIteratorObject(iterator);
            }
            iManagerMethodMetadata = null;
            iParameterMetadata = null;
        }
        catch (Exception exception) {
            s_logger.errorMessage(this.getClass().getName());
            s_logger.errorException(exception);
            throw exception;
        }
        return xMLCIterator;
    }

    protected Object getReturnObject(BusinessObjectManager businessObjectManager, IPreparedMetadata iPreparedMetadata, NodeList nodeList, IMethodMetadata iMethodMetadata) throws Exception {
        this.m_parameterMD = iMethodMetadata.getParameters();
        Object[] objectArray = new Object[this.m_parameterMD.length];
        objectArray = this.m_convertor.covertXMLToObject(nodeList.item(0), this.m_parameterMD);
        this.m_returnObject = iMethodMetadata.invokeWithStrings(businessObjectManager, objectArray);
        objectArray = null;
        return this.m_returnObject;
    }
}

