/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.xmlconnector.process;

import com.baan.b3.boi1.IUserSession;
import com.baan.ow.xmlconnector.IRequestProcessor;
import com.baan.ow.xmlconnector.IXMLCIterator;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.baan.owimpl.xmlconnector.error.StatusHandler;
import com.baan.owimpl.xmlconnector.exception.LicenseFailedException;
import com.baan.owimpl.xmlconnector.preparedmetadata.Definition;
import com.baan.owimpl.xmlconnector.preparedmetadata.XMLConnectorObject;
import com.baan.owimpl.xmlconnector.util.Conversions;
import com.eibus.services.licensing.ILicense;
import com.eibus.services.licensing.LicenseFactory;
import com.eibus.xml.dom.DocumentImpl;
import com.eibus.xml.util.DOMWriter;
import com.eibus.xml.util.NiceDOMWriter;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RequestProcessorImpl
implements IRequestProcessor {
    private static final String COPYRIGHT = "Copyright (c) 2001-2002 Baan Company";
    private Conversions m_conversion = new Conversions();
    private Vector m_ASMManagers = new Vector();
    private ILicense m_license = null;
    private boolean m_licenseFlag = true;
    private String m_licenseMessage = null;
    private XMLConnectorObject gatewayObject = null;
    private int m_adaptertimeout;
    private int m_adapterfetchsize;
    private boolean isOverRideTimeOut = false;
    private boolean isOverRideFetchSize = false;
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.owimpl.xmlconnector.process", "XMLConnectorProcess");

    protected RequestProcessorImpl() {
        Definition definition = new Definition();
        Definition.isOldInterface = false;
        try {
            this.m_license = LicenseFactory.createXMLConnectorLicense();
            s_logger.message("License : " + this.m_license.getWarningMessage());
        }
        catch (Exception exception) {
            s_logger.errorMessage("License : License check Failed");
            this.m_licenseFlag = false;
            this.m_licenseMessage = exception.getMessage();
        }
    }

    public boolean executeRequest(IUserSession iUserSession, String string, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        return this.execute(iUserSession, string, stringBuffer, stringBuffer2);
    }

    public boolean execute(IUserSession iUserSession, String string, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        StatusHandler statusHandler = new StatusHandler();
        DocumentImpl documentImpl = new DocumentImpl();
        documentImpl.appendChild(documentImpl.createElement("Response"));
        try {
            if (!this.m_licenseFlag) {
                throw new LicenseFailedException(this.m_licenseMessage);
            }
            if (this.m_license.getDaysLeft() < 0) {
                throw new LicenseFailedException(this.m_license.getWarningMessage());
            }
            com.baan.b3.dom.Document document = this.m_conversion.StringToDocument(string);
            String string2 = new NiceDOMWriter(document.getDocumentElement()).toString();
            s_logger.message("Input Request Document : " + string2);
            this.gatewayObject = new XMLConnectorObject(document, iUserSession, this.m_ASMManagers, this.m_adaptertimeout, this.isOverRideTimeOut);
            String string3 = this.gatewayObject.invoke(stringBuffer2, documentImpl, this.m_adapterfetchsize, this.isOverRideFetchSize);
            stringBuffer.append(string3);
            s_logger.message("Output Response Document : " + stringBuffer.toString());
            s_logger.message("Request Status : " + stringBuffer2.toString());
        }
        catch (Exception exception) {
            s_logger.errorMessage(this.getClass().getName());
            stringBuffer.append(new DOMWriter(documentImpl).toString());
            com.baan.b3.dom.Document document = statusHandler.createFailureDoc(exception);
            stringBuffer2.append(new DOMWriter(document).toString());
            String string4 = new NiceDOMWriter(document.getDocumentElement()).toString();
            s_logger.errorMessage("Error Document : " + string4);
            return false;
        }
        statusHandler = null;
        documentImpl = null;
        return true;
    }

    public boolean execute(IUserSession iUserSession, Document document, Document document2, Document document3) {
        boolean bl = false;
        Document document4 = null;
        Document document5 = null;
        Element element = null;
        Element element2 = null;
        try {
            Conversions conversions = new Conversions();
            String string = null;
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            string = conversions.DOM2DocumentToString(document);
            bl = this.execute(iUserSession, string, stringBuffer, stringBuffer2);
            document4 = conversions.StringToDOM2Document(stringBuffer.toString());
            document5 = conversions.StringToDOM2Document(stringBuffer2.toString());
            element = (Element)document2.importNode(document4.getDocumentElement(), true);
            element2 = (Element)document3.importNode(document5.getDocumentElement(), true);
            document2.appendChild(element);
            document3.appendChild(element2);
        }
        catch (Exception exception) {
            return false;
        }
        document4 = null;
        document5 = null;
        element = null;
        element2 = null;
        return true;
    }

    public boolean close() {
        try {
            this.m_license.release();
            if (this.gatewayObject != null) {
                return this.gatewayObject.closeAll(this.m_ASMManagers);
            }
            return true;
        }
        catch (Exception exception) {
            s_logger.errorMessage(exception.getLocalizedMessage());
            return false;
        }
    }

    public IXMLCIterator executeSync(IUserSession iUserSession, String string, StringBuffer stringBuffer) {
        StatusHandler statusHandler = new StatusHandler();
        IXMLCIterator iXMLCIterator = null;
        try {
            if (!this.m_licenseFlag) {
                throw new LicenseFailedException(this.m_licenseMessage);
            }
            if (this.m_license.getDaysLeft() < 0) {
                throw new LicenseFailedException(this.m_license.getWarningMessage());
            }
            com.baan.b3.dom.Document document = this.m_conversion.StringToDocument(string);
            String string2 = new NiceDOMWriter(document.getDocumentElement()).toString();
            s_logger.message("Input Request Document : " + string2);
            this.gatewayObject = new XMLConnectorObject(document, iUserSession, this.m_ASMManagers, this.m_adaptertimeout, this.isOverRideTimeOut);
            iXMLCIterator = this.gatewayObject.invokeSync(stringBuffer, this.m_adapterfetchsize, this.isOverRideFetchSize);
            s_logger.message("Request Status : " + stringBuffer.toString());
        }
        catch (Exception exception) {
            com.baan.b3.dom.Document document = statusHandler.createFailureDoc(exception);
            stringBuffer.append(new DOMWriter(document).toString());
            String string3 = new NiceDOMWriter(document.getDocumentElement()).toString();
            s_logger.message("Error Document : " + string3);
            return null;
        }
        return iXMLCIterator;
    }

    public IXMLCIterator executeSync(IUserSession iUserSession, Document document, Document document2) {
        boolean bl = false;
        Document document3 = null;
        Element element = null;
        IXMLCIterator iXMLCIterator = null;
        try {
            Conversions conversions = new Conversions();
            String string = null;
            StringBuffer stringBuffer = new StringBuffer();
            string = conversions.DOM2DocumentToString(document);
            iXMLCIterator = this.executeSync(iUserSession, string, stringBuffer);
            document3 = conversions.StringToDOM2Document(stringBuffer.toString());
            element = (Element)document2.importNode(document3.getDocumentElement(), true);
            document2.appendChild(element);
        }
        catch (Exception exception) {
            return null;
        }
        return iXMLCIterator;
    }

    public void setAdapterTimeOut(int n) {
        this.m_adaptertimeout = n;
        this.isOverRideTimeOut = true;
    }

    public void setAdapterFetchSize(int n) {
        this.m_adapterfetchsize = n;
        this.isOverRideFetchSize = true;
    }
}

