/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.xmlconnector.process;

import com.baan.b3.boi1.BusinessObject;
import com.baan.b3.boi1.metadata.IBusinessObjectMetadata;
import com.baan.b3.boi1.metadata.IMemberMetadata;
import com.baan.b3.boi1.metadata.IParameterMetadata;
import com.baan.b3.boi1.metadata.IPrimalMemberMetadata;
import com.baan.b3.boi1.metadata.IPrimalObjectMetadata;
import com.baan.b3.boi1.metadata.MetadataUtil;
import com.baan.b3.dom.Document;
import com.baan.b3.dom.Element;
import com.baan.b3.dom.Node;
import com.baan.b3.dom.NodeList;
import com.baan.b3.dom.Text;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.baan.owimpl.xmlconnector.exception.InvalidParameterException;
import com.baan.owimpl.xmlconnector.exception.RecordNotFoundException;
import com.baan.owimpl.xmlconnector.process.ObjectXMLConvertorForNetChange;
import com.baan.owimpl.xmlconnector.util.Conversions;
import com.baan.owimpl.xmlconnector.util.XMLReader;
import com.eibus.xml.util.DOMWriter;

public class ObjectXMLConvertor {
    private static final String COPYRIGHT = "Copyright (c) 2001-2002 Baan Company";
    protected XMLReader xmlReader = new XMLReader();
    private static final String XML_NODE = "org.w3c.dom.Node";
    private String m_methodName = null;
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.owimpl.xmlconnector.process", "XMLConnectorProcess");

    public Object[] covertXMLToObject(Node node, IParameterMetadata[] iParameterMetadataArray) throws Exception {
        Object[] objectArray = new Object[iParameterMetadataArray.length];
        try {
            int n = 0;
            while (n < iParameterMetadataArray.length) {
                Node node2;
                if (iParameterMetadataArray[n].getType() instanceof IPrimalObjectMetadata) {
                    objectArray[n] = iParameterMetadataArray[n].getType().getTypeName().equals(XML_NODE) ? ((node2 = this.getXMLNodeData(this.xmlReader.getNode(node, iParameterMetadataArray[n].getName()))) != null ? this.documentToString(node2) : "") : this.xmlReader.getNodeValue(node, iParameterMetadataArray[n].getName());
                } else {
                    objectArray[n] = (BusinessObject)((IBusinessObjectMetadata)iParameterMetadataArray[n].getType()).newInstance();
                    node2 = this.xmlReader.getNode((Element)node, iParameterMetadataArray[n].getName());
                    this.fillObjectFromXml((BusinessObject)objectArray[n], (IBusinessObjectMetadata)iParameterMetadataArray[n].getType(), node2);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            s_logger.errorMessage(this.getClass().getName());
            s_logger.errorException(exception);
            throw exception;
        }
        return objectArray;
    }

    public void covertObjectToXML(BusinessObject businessObject, Node node) throws Exception {
        Document document = node.getOwnerDocument();
        Element element = null;
        IBusinessObjectMetadata iBusinessObjectMetadata = null;
        try {
            int n;
            iBusinessObjectMetadata = this.createBusinessObjectMDInstance(businessObject);
            IMemberMetadata[] iMemberMetadataArray = iBusinessObjectMetadata.getMembers();
            if (this.m_methodName != null && this.m_methodName.indexOf("NETCHANGE") >= 0) {
                n = 0;
                while (n < iMemberMetadataArray.length) {
                    if (iMemberMetadataArray[n].isAttribute() && iMemberMetadataArray[n].getName().equalsIgnoreCase("ActionType") && !iMemberMetadataArray[n].getValue(businessObject).equals("")) {
                        new ObjectXMLConvertorForNetChange().covertObjectToXML(businessObject, node, "");
                        return;
                    }
                    ++n;
                }
            }
            element = document.createElement(iBusinessObjectMetadata.getXmlDataType());
            node.appendChild(element);
            n = 0;
            while (n < iMemberMetadataArray.length) {
                if (iMemberMetadataArray[n].getType() instanceof IPrimalObjectMetadata) {
                    IPrimalObjectMetadata iPrimalObjectMetadata = (IPrimalObjectMetadata)iMemberMetadataArray[n].getType();
                    String[] stringArray = null;
                    stringArray = this.getMemberValue(iPrimalObjectMetadata.getXmlDataType(), iMemberMetadataArray[n], businessObject);
                    this.setMemberValue(iMemberMetadataArray[n], stringArray, document, element);
                } else {
                    this.processBusinessObject(iMemberMetadataArray[n], businessObject, element);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            s_logger.errorMessage(this.getClass().getName());
            s_logger.errorException(exception);
            throw exception;
        }
    }

    protected IBusinessObjectMetadata createBusinessObjectMDInstance(BusinessObject businessObject) throws RecordNotFoundException {
        try {
            return MetadataUtil.getBusinessObjectMetadata(businessObject.getClass().getName());
        }
        catch (Exception exception) {
            s_logger.errorMessage(this.getClass().getName());
            s_logger.errorException(exception);
            throw new RecordNotFoundException("Record not found");
        }
    }

    protected String[] getMemberValue(String string, IMemberMetadata iMemberMetadata, BusinessObject businessObject) {
        if (iMemberMetadata.getCardinalityMax() == 1) {
            String[] stringArray = new String[1];
            if (string.equals("dateTime") || string.equals("xml.node") || string.equals("bin.base64")) {
                String string2;
                IPrimalMemberMetadata iPrimalMemberMetadata = (IPrimalMemberMetadata)iMemberMetadata;
                stringArray[0] = string2 = (String)iPrimalMemberMetadata.getValueToString(businessObject);
                return stringArray;
            }
            Object object = iMemberMetadata.getValue(businessObject);
            if (object != null) {
                stringArray[0] = object.toString();
                return stringArray;
            }
        } else {
            IPrimalMemberMetadata iPrimalMemberMetadata = (IPrimalMemberMetadata)iMemberMetadata;
            return (String[])iPrimalMemberMetadata.getValueToString(businessObject);
        }
        return null;
    }

    private void setMemberValue(IMemberMetadata iMemberMetadata, String[] stringArray, Document document, Element element) throws Exception {
        Element element2 = null;
        Text text = null;
        if (stringArray != null) {
            if (iMemberMetadata.isAttribute() && stringArray[0] != null) {
                element.setAttribute(iMemberMetadata.getName(), stringArray[0]);
            } else {
                int n = 0;
                while (n < stringArray.length) {
                    if (stringArray[n] != null) {
                        element2 = document.createElement(iMemberMetadata.getName());
                        String string = iMemberMetadata.getType().getTypeName();
                        if (iMemberMetadata.getType().getTypeName().equalsIgnoreCase(XML_NODE) && !stringArray[n].trim().equals("")) {
                            Conversions conversions = new Conversions();
                            element2.appendChild(conversions.StringToDocument(stringArray[n]).getDocumentElement());
                        } else {
                            text = document.createTextNode(stringArray[n]);
                            element2.appendChild(text);
                        }
                        element.appendChild(element2);
                    }
                    ++n;
                }
            }
        }
        element2 = null;
        text = null;
    }

    public void fillObjectFromXml(BusinessObject businessObject, IBusinessObjectMetadata iBusinessObjectMetadata, Node node) throws Exception {
        try {
            IMemberMetadata[] iMemberMetadataArray = iBusinessObjectMetadata.getMembers();
            if (node != null) {
                int n = 0;
                while (n < iMemberMetadataArray.length) {
                    Object object;
                    if (iMemberMetadataArray[n].isAttribute()) {
                        IPrimalMemberMetadata iPrimalMemberMetadata;
                        object = this.xmlReader.getAttributeValue(node, iMemberMetadataArray[n].getName());
                        if (object != null && !(iPrimalMemberMetadata = (IPrimalMemberMetadata)iMemberMetadataArray[n]).isReadOnly()) {
                            iPrimalMemberMetadata.setValueFromString(businessObject, object);
                        }
                    } else {
                        object = ((Element)node).getElementsByTagName(iMemberMetadataArray[n].getName());
                        if (object != null && object.getLength() != 0) {
                            if (object.getLength() == 1) {
                                this.memberFromXml(businessObject, iMemberMetadataArray[n], object.item(0));
                            } else {
                                this.multiMemberFromXml(businessObject, iMemberMetadataArray[n], node, object.getLength());
                            }
                        }
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            s_logger.errorMessage(this.getClass().getName());
            s_logger.errorException(exception);
            throw exception;
        }
    }

    protected void processBusinessObject(IMemberMetadata iMemberMetadata, BusinessObject businessObject, Element element) throws Exception {
        try {
            BusinessObject[] businessObjectArray = null;
            int n = iMemberMetadata.getCardinalityMax();
            if (n == 1) {
                BusinessObject businessObject2 = (BusinessObject)iMemberMetadata.getValue(businessObject);
                if (businessObject2 != null) {
                    this.covertObjectToXML(businessObject2, element);
                }
            } else {
                businessObjectArray = (BusinessObject[])iMemberMetadata.getValue(businessObject);
                if (businessObjectArray != null) {
                    int n2 = 0;
                    while (n2 < businessObjectArray.length) {
                        this.covertObjectToXML(businessObjectArray[n2], element);
                        ++n2;
                    }
                }
            }
        }
        catch (Exception exception) {
            s_logger.errorMessage(this.getClass().getName());
            s_logger.errorException(exception);
            throw exception;
        }
    }

    private void memberFromXml(BusinessObject businessObject, IMemberMetadata iMemberMetadata, Node node) throws InvalidParameterException {
        try {
            if (iMemberMetadata.getType() instanceof IPrimalObjectMetadata) {
                if (iMemberMetadata.getType().getTypeName().equals(XML_NODE)) {
                    String string = "";
                    IPrimalMemberMetadata iPrimalMemberMetadata = (IPrimalMemberMetadata)iMemberMetadata;
                    if (!iPrimalMemberMetadata.isReadOnly()) {
                        if (iPrimalMemberMetadata.getCardinalityMax() == 1) {
                            Node node2 = this.getXMLNodeData(node);
                            if (node2 != null) {
                                string = this.documentToString(node2);
                            }
                            iPrimalMemberMetadata.setValueFromString(businessObject, string);
                        } else {
                            NodeList nodeList = this.xmlReader.getNodeList(node.getParentNode(), node.getNodeName());
                            if (nodeList.getLength() > 0) {
                                String[] stringArray = new String[nodeList.getLength()];
                                int n = 0;
                                while (n < nodeList.getLength()) {
                                    Node node3 = this.getXMLNodeData(nodeList.item(n));
                                    if (node3 != null) {
                                        stringArray[n] = this.documentToString(node3);
                                    }
                                    ++n;
                                }
                                iPrimalMemberMetadata.setValueFromString(businessObject, stringArray);
                            }
                        }
                    }
                } else {
                    String string = this.xmlReader.getNodeValue(node.getParentNode(), node.getNodeName());
                    IPrimalMemberMetadata iPrimalMemberMetadata = (IPrimalMemberMetadata)iMemberMetadata;
                    if (!iPrimalMemberMetadata.isReadOnly()) {
                        if (iPrimalMemberMetadata.getCardinalityMax() == 1) {
                            Conversions conversions;
                            IPrimalObjectMetadata iPrimalObjectMetadata = (IPrimalObjectMetadata)iPrimalMemberMetadata.getType();
                            if (iPrimalObjectMetadata.getXmlDataType().equals("dateTime") && (string = (conversions = new Conversions()).convertDateToString(string)) == null) {
                                string = "";
                            }
                            iPrimalMemberMetadata.setValueFromString(businessObject, string);
                        } else {
                            String[] stringArray = this.xmlReader.getNodeValues(node.getParentNode(), node.getNodeName());
                            iPrimalMemberMetadata.setValueFromString(businessObject, stringArray);
                        }
                    }
                }
            } else {
                BusinessObject[] businessObjectArray = new BusinessObject[]{(BusinessObject)((IBusinessObjectMetadata)iMemberMetadata.getType()).newInstance()};
                if (iMemberMetadata.getCardinalityMax() == 1) {
                    iMemberMetadata.setValue(businessObject, businessObjectArray[0]);
                } else {
                    iMemberMetadata.setValue(businessObject, businessObjectArray);
                }
                IBusinessObjectMetadata iBusinessObjectMetadata = MetadataUtil.getBusinessObjectMetadata(iMemberMetadata.getType().getTypeName());
                this.fillObjectFromXml(businessObjectArray[0], iBusinessObjectMetadata, node);
            }
        }
        catch (Exception exception) {
            throw new InvalidParameterException(exception.getMessage());
        }
    }

    private Node getXMLNodeData(Node node) {
        if (node != null && node.hasChildNodes()) {
            int n = 0;
            while (n < node.getChildNodes().getLength()) {
                if (node.getChildNodes().item(n).getNodeType() == 1) {
                    return node.getChildNodes().item(n);
                }
                ++n;
            }
        }
        return null;
    }

    private void multiMemberFromXml(BusinessObject businessObject, IMemberMetadata iMemberMetadata, Node node, int n) throws InvalidParameterException {
        try {
            if (iMemberMetadata.getType() instanceof IPrimalObjectMetadata) {
                IPrimalMemberMetadata iPrimalMemberMetadata = (IPrimalMemberMetadata)iMemberMetadata;
                if (!iPrimalMemberMetadata.isReadOnly()) {
                    if (iMemberMetadata.getType().getTypeName().equals(XML_NODE)) {
                        NodeList nodeList = this.xmlReader.getNodeList(node, iMemberMetadata.getName());
                        if (nodeList.getLength() > 0) {
                            String[] stringArray = new String[nodeList.getLength()];
                            int n2 = 0;
                            while (n2 < nodeList.getLength()) {
                                Node node2 = this.getXMLNodeData(nodeList.item(n2));
                                if (node2 != null) {
                                    stringArray[n2] = this.documentToString(node2);
                                }
                                ++n2;
                            }
                            iPrimalMemberMetadata.setValueFromString(businessObject, stringArray);
                        }
                    } else {
                        NodeList nodeList = node.getChildNodes();
                        String[] stringArray = this.xmlReader.getNodeValues(node, iMemberMetadata.getName());
                        iPrimalMemberMetadata.setValueFromString(businessObject, stringArray);
                    }
                }
            } else {
                BusinessObject[] businessObjectArray = new BusinessObject[n];
                NodeList nodeList = this.xmlReader.getNodeList(node, iMemberMetadata.getName());
                int n3 = 0;
                while (n3 < n) {
                    businessObjectArray[n3] = (BusinessObject)((IBusinessObjectMetadata)iMemberMetadata.getType()).newInstance();
                    ++n3;
                }
                iMemberMetadata.setValue(businessObject, businessObjectArray);
                int n4 = 0;
                while (n4 < n) {
                    IBusinessObjectMetadata iBusinessObjectMetadata = MetadataUtil.getBusinessObjectMetadata(iMemberMetadata.getType().getTypeName());
                    this.fillObjectFromXml(businessObjectArray[n4], iBusinessObjectMetadata, nodeList.item(n4));
                    ++n4;
                }
            }
        }
        catch (Exception exception) {
            throw new InvalidParameterException("Parameter is not compatible with the Metadata. Detail Message : " + exception.getMessage());
        }
    }

    private String documentToString(Node node) {
        DOMWriter dOMWriter = new DOMWriter(node);
        return dOMWriter.toString();
    }

    public void setMethodName(String string) {
        this.m_methodName = string;
    }
}

