/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.xmlconnector.process;

import com.baan.b3.boi1.BusinessObject;
import com.baan.b3.boi1.BusinessObjectManager;
import com.baan.b3.boi1.metadata.IManagerMethodMetadata;
import com.baan.b3.dom.Document;
import com.baan.b3.dom.Node;
import com.baan.b3.dom.NodeList;
import com.baan.ow.xmlconnector.IXMLCIterator;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.baan.owimpl.xmlconnector.error.ErrorBuilder;
import com.baan.owimpl.xmlconnector.error.ErrorDocumentForDLL;
import com.baan.owimpl.xmlconnector.error.StatusHandler;
import com.baan.owimpl.xmlconnector.exception.DLLException;
import com.baan.owimpl.xmlconnector.exception.MethodNotSupportedException;
import com.baan.owimpl.xmlconnector.exception.RecordRetrievalFailedException;
import com.baan.owimpl.xmlconnector.preparedmetadata.IPreparedMetadata;
import com.baan.owimpl.xmlconnector.process.ObjectXMLConvertor;
import com.baan.owimpl.xmlconnector.process.ProcessHandler;

class DLLExecution
extends ProcessHandler {
    private static final String COPYRIGHT = "Copyright (c) 2001-2002 Baan Company";
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.owimpl.xmlconnector.process", "XMLConnectorProcess");

    DLLExecution() {
    }

    public Document invoke(BusinessObjectManager businessObjectManager, NodeList nodeList, IPreparedMetadata iPreparedMetadata, int n, boolean bl) throws Exception {
        try {
            this.processInitialization();
            IManagerMethodMetadata iManagerMethodMetadata = iPreparedMetadata.getMethodMetada();
            this.m_parameterMD = iManagerMethodMetadata.getParameters();
            Object[] objectArray = new Object[this.m_parameterMD.length];
            ObjectXMLConvertor objectXMLConvertor = new ObjectXMLConvertor();
            objectArray = objectXMLConvertor.covertXMLToObject(nodeList.item(0), this.m_parameterMD);
            this.m_returnObject = iManagerMethodMetadata.invokeWithStrings(businessObjectManager, objectArray);
            if (this.m_returnObject == null) {
                throw new RecordRetrievalFailedException("Record can not be retrieved");
            }
            objectXMLConvertor.covertObjectToXML((BusinessObject)this.m_returnObject, this.m_rootNode);
            StatusHandler statusHandler = new StatusHandler();
            Node node = statusHandler.getErrorDocumentNode(this.m_responseDocument);
            if (node != null) {
                ErrorDocumentForDLL errorDocumentForDLL = new ErrorDocumentForDLL();
                Document document = ((ErrorBuilder)errorDocumentForDLL).createErrorDocument(this.m_responseDocument, node);
                throw new DLLException(this.m_responseDocument, document);
            }
        }
        catch (Exception exception) {
            s_logger.errorMessage(this.getClass().getName());
            s_logger.errorException(exception);
            throw exception;
        }
        return this.m_responseDocument;
    }

    public IXMLCIterator invokeSync(BusinessObjectManager businessObjectManager, NodeList nodeList, IPreparedMetadata iPreparedMetadata, int n, boolean bl) throws Exception {
        throw new MethodNotSupportedException();
    }
}

