/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.xmlconnector.preparedmetadata;

import com.baan.b3.boi1.BusinessObjectManager;
import com.baan.b3.boi1.IUserSession;
import com.baan.b3.dom.Document;
import com.baan.b3.dom.Node;
import com.baan.b3.dom.NodeList;
import com.baan.ow.xmlconnector.IXMLCIterator;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.baan.owimpl.xmlconnector.error.StatusHandler;
import com.baan.owimpl.xmlconnector.exception.DLLException;
import com.baan.owimpl.xmlconnector.exception.ExceptionHandler;
import com.baan.owimpl.xmlconnector.exception.GWNetListException;
import com.baan.owimpl.xmlconnector.exception.MethodNotFoundException;
import com.baan.owimpl.xmlconnector.generator.GeneratorFactory;
import com.baan.owimpl.xmlconnector.generator.IGenerator;
import com.baan.owimpl.xmlconnector.preparedmetadata.IPreparedMetadata;
import com.baan.owimpl.xmlconnector.preparedmetadata.PreparedMetadataImpl;
import com.baan.owimpl.xmlconnector.process.ProcessHandler;
import com.baan.owimpl.xmlconnector.process.ProcessHandlerFactory;
import com.baan.owimpl.xmlconnector.process.Validator;
import com.baan.owimpl.xmlconnector.util.BusinessObjectLocator;
import com.baan.owimpl.xmlconnector.util.Conversions;
import com.baan.owimpl.xmlconnector.util.RequestParser;
import com.eibus.xml.util.DOMWriter;
import java.util.Vector;

public class XMLConnectorObject {
    private static final String COPYRIGHT = "Copyright (c) 2001-2002 Baan Company";
    private static final String NETLIST_MANAGER_PATH = "com.baan.owimpl.xmlconnector.process.netlist.GWNetlistManager";
    private String m_managerName = "";
    private String m_BOIVersion = "";
    private Node m_methodListNode = null;
    private IPreparedMetadata m_iPreparedMetadata = null;
    private IGenerator m_iGenerator = null;
    private StringBuffer m_methodName = new StringBuffer();
    private StringBuffer m_objectName = new StringBuffer();
    private StringBuffer m_componentName = new StringBuffer();
    private NodeList m_parameters = null;
    private Conversions m_conversion = new Conversions();
    private boolean validate = false;
    private BusinessObjectManager m_managerObject = null;
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.owimpl.xmlconnector.preparedmetadata", "XMLConnectorPreparedMetadata");

    public XMLConnectorObject(String string, String string2) throws Exception {
        try {
            this.m_methodName.append(string2);
            this.m_objectName.append(string);
            this.setManagerNameIncludingGWNetList();
            this.m_iPreparedMetadata = new PreparedMetadataImpl(this.m_managerName, string2, this.m_BOIVersion);
            if (string2.equals("")) {
                this.m_methodListNode = this.m_iPreparedMetadata.getMethodReturnValuesMetadata();
            } else {
                this.m_iGenerator = GeneratorFactory.getGenerator("DTD");
            }
        }
        catch (Exception exception) {
            s_logger.errorMessage(this.getClass().getName());
            s_logger.errorException(exception);
            throw exception;
        }
    }

    public XMLConnectorObject(String string, String string2, String string3) throws Exception {
        try {
            this.m_methodName.append(string2);
            this.m_objectName.append(string);
            this.setManagerName();
            this.m_iPreparedMetadata = new PreparedMetadataImpl(this.m_managerName, string2, this.m_BOIVersion);
            if (string2.equals("")) {
                this.m_methodListNode = this.m_iPreparedMetadata.getMethodReturnValuesMetadata();
            } else {
                this.m_iGenerator = GeneratorFactory.getGenerator(string3);
            }
        }
        catch (Exception exception) {
            s_logger.errorMessage(this.getClass().getName());
            s_logger.errorException(exception);
            throw exception;
        }
    }

    public XMLConnectorObject(Document document, IUserSession iUserSession, Vector vector, int n, boolean bl) throws Exception {
        try {
            RequestParser requestParser = new RequestParser();
            this.m_parameters = requestParser.parseRequestDocument(document, this.m_methodName, this.m_objectName, this.m_componentName, this.m_parameters);
            this.setManagerName();
            this.initialize(iUserSession, vector, n, bl);
        }
        catch (Exception exception) {
            s_logger.errorMessage(this.getClass().getName());
            s_logger.errorException(exception);
            throw exception;
        }
    }

    public XMLConnectorObject(Document document, IUserSession iUserSession, Vector vector, boolean bl, int n, boolean bl2) throws Exception {
        try {
            RequestParser requestParser = new RequestParser();
            this.m_parameters = requestParser.parseRequestDocument(document, this.m_methodName, this.m_objectName, this.m_componentName, this.m_parameters);
            this.setManagerNameIncludingGWNetList();
            this.initialize(iUserSession, vector, n, bl2);
        }
        catch (Exception exception) {
            s_logger.errorMessage(this.getClass().getName());
            s_logger.errorException(exception);
            throw exception;
        }
    }

    private void initialize(IUserSession iUserSession, Vector vector, int n, boolean bl) throws Exception {
        this.m_iPreparedMetadata = new PreparedMetadataImpl(this.m_managerName, this.m_methodName.toString(), this.m_BOIVersion);
        Validator validator = new Validator();
        validator.checkValidity(this.m_parameters, this.m_iPreparedMetadata);
        Class<?> clazz = Class.forName(this.m_managerName);
        this.m_managerObject = (BusinessObjectManager)clazz.newInstance();
        if (iUserSession != null) {
            iUserSession.addManager(this.m_managerObject);
        }
        vector.addElement(this.m_managerObject);
        this.m_managerObject.initialize(this.m_componentName.toString());
        if (bl) {
            this.m_managerObject.setTimeOut(n);
        }
    }

    public String getManagerName() {
        return this.m_managerName;
    }

    public String getBOIVersion() {
        return this.m_BOIVersion;
    }

    public String getRequestDocument() {
        return this.m_iGenerator.generateMetadata(this.m_iPreparedMetadata.getMethodParameterMetadata());
    }

    public String getResponseDocument() {
        return this.m_iGenerator.generateMetadata(this.m_iPreparedMetadata.getMethodReturnValuesMetadata());
    }

    public String getErrorDocument() {
        return this.m_iGenerator.generateMetadata(this.m_iPreparedMetadata.getMethodErrorMetadata());
    }

    private void setManagerNameIncludingGWNetList() throws Exception {
        if (this.m_methodName.toString().equals("GWNetList")) {
            this.m_managerName = NETLIST_MANAGER_PATH;
            this.m_BOIVersion = "B50c.1.w";
        } else {
            this.setManagerAndVersion();
        }
    }

    private void setManagerName() throws Exception {
        if (this.m_methodName.toString().equals("GWNetList")) {
            throw new MethodNotFoundException();
        }
        this.setManagerAndVersion();
    }

    private void setManagerAndVersion() throws Exception {
        BusinessObjectLocator businessObjectLocator = new BusinessObjectLocator();
        this.m_managerName = businessObjectLocator.getBusinessObjectManager(this.m_objectName.toString());
        this.m_BOIVersion = businessObjectLocator.getBOIManagerVersion(this.m_objectName.toString());
    }

    public Node getMethodList() {
        return this.m_methodListNode;
    }

    public String invoke(StringBuffer stringBuffer, Document document, int n, boolean bl) throws Exception {
        try {
            StatusHandler statusHandler = new StatusHandler();
            ProcessHandler processHandler = ProcessHandlerFactory.getProcessHandler(this.m_methodName.toString(), this.m_iPreparedMetadata);
            document = processHandler.invoke(this.m_managerObject, this.m_parameters, this.m_iPreparedMetadata, n, bl);
            stringBuffer.append(new DOMWriter(statusHandler.createSuccessDoc()).toString());
            statusHandler = null;
            processHandler = null;
        }
        catch (DLLException dLLException) {
            s_logger.errorMessage(this.getClass().getName());
            s_logger.errorException(dLLException);
            ExceptionHandler exceptionHandler = new ExceptionHandler();
            stringBuffer.append(new DOMWriter(exceptionHandler.getErrorDocument(dLLException)));
            return dLLException.getResponse();
        }
        catch (GWNetListException gWNetListException) {
            s_logger.errorMessage(this.getClass().getName());
            s_logger.errorException(gWNetListException);
            ExceptionHandler exceptionHandler = new ExceptionHandler();
            stringBuffer.append(new DOMWriter(exceptionHandler.getErrorDocument(gWNetListException)));
            return gWNetListException.getResponse();
        }
        catch (Exception exception) {
            s_logger.errorMessage(this.getClass().getName());
            s_logger.errorException(exception);
            ExceptionHandler exceptionHandler = new ExceptionHandler();
            stringBuffer.append(new DOMWriter(exceptionHandler.getErrorDocument(exception)));
        }
        this.m_iPreparedMetadata = null;
        this.m_methodName = null;
        this.m_managerObject = null;
        return new DOMWriter(document).toString();
    }

    public boolean closeAll(Vector vector) throws Exception {
        int n = 0;
        while (n < vector.size()) {
            try {
                s_logger.message("Closing manager");
                ((BusinessObjectManager)vector.elementAt(n)).close();
            }
            catch (NullPointerException nullPointerException) {
                s_logger.message("In NullPointerException exception of close");
                return true;
            }
            catch (Exception exception) {
                s_logger.message("In normal exception of close");
                s_logger.errorMessage(exception.getMessage());
                if (exception.getMessage() == "This manager is already closed") {
                    return true;
                }
                throw exception;
            }
            ++n;
        }
        return true;
    }

    public IXMLCIterator invokeSync(StringBuffer stringBuffer, int n, boolean bl) throws Exception {
        IXMLCIterator iXMLCIterator = null;
        try {
            StatusHandler statusHandler = new StatusHandler();
            ProcessHandler processHandler = ProcessHandlerFactory.getProcessHandler(this.m_methodName.toString(), this.m_iPreparedMetadata);
            iXMLCIterator = processHandler.invokeSync(this.m_managerObject, this.m_parameters, this.m_iPreparedMetadata, n, bl);
            stringBuffer.append(new DOMWriter(statusHandler.createSuccessDoc()).toString());
            statusHandler = null;
            processHandler = null;
        }
        catch (Exception exception) {
            s_logger.errorMessage(this.getClass().getName());
            s_logger.errorException(exception);
            ExceptionHandler exceptionHandler = new ExceptionHandler();
            stringBuffer.append(new DOMWriter(exceptionHandler.getErrorDocument(exception)));
        }
        return iXMLCIterator;
    }
}

