/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.xmlconnector.generator;

import com.baan.b3.dom.Document;
import com.baan.b3.dom.Node;
import com.baan.ow.xmlconnector.IMetadataGenerator;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.baan.owimpl.xmlconnector.error.StatusHandler;
import com.baan.owimpl.xmlconnector.exception.LicenseFailedException;
import com.baan.owimpl.xmlconnector.preparedmetadata.Definition;
import com.baan.owimpl.xmlconnector.preparedmetadata.XMLConnectorObject;
import com.baan.owimpl.xmlconnector.util.Conversions;
import com.baan.owimpl.xmlconnector.util.RequestParser;
import com.eibus.services.licensing.ILicense;
import com.eibus.services.licensing.LicenseFactory;
import com.eibus.xml.util.DOMWriter;

public class MetadataGeneratorImpl
implements IMetadataGenerator {
    private static final String COPYRIGHT = "Copyright (c) 2001-2002 Baan Company";
    private Document m_RED = null;
    private ILicense m_license = null;
    private String m_licenseMessage = null;
    private boolean m_licenseFlag = true;
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.owimpl.xmlconnector.generator", "XMLConnectorGenerator");

    protected MetadataGeneratorImpl() {
        Definition definition = new Definition();
        Definition.isOldInterface = false;
        try {
            s_logger.flowMessage("License : Checking License");
            this.m_license = LicenseFactory.createXMLConnectorLicense();
            s_logger.message("License : " + this.m_license.getWarningMessage());
        }
        catch (Exception exception) {
            s_logger.errorMessage("License : License check Failed");
            this.m_licenseMessage = exception.getMessage();
            this.m_licenseFlag = false;
        }
    }

    public boolean getMetadata(String string, StringBuffer stringBuffer, StringBuffer stringBuffer2, StringBuffer stringBuffer3, StringBuffer stringBuffer4) {
        Conversions conversions = new Conversions();
        RequestParser requestParser = new RequestParser();
        Document document = null;
        StringBuffer stringBuffer5 = new StringBuffer();
        StringBuffer stringBuffer6 = new StringBuffer();
        StringBuffer stringBuffer7 = new StringBuffer();
        try {
            if (!this.m_licenseFlag) {
                throw new LicenseFailedException(this.m_licenseMessage);
            }
            if (this.m_license.getDaysLeft() < 0) {
                throw new LicenseFailedException(this.m_license.getWarningMessage());
            }
            document = conversions.StringToDocument(string);
            requestParser.parseRequestDocument(document, stringBuffer5, stringBuffer6, stringBuffer7);
            s_logger.message("Input Request Document : " + string.toString());
            XMLConnectorObject xMLConnectorObject = new XMLConnectorObject(stringBuffer6.toString(), stringBuffer5.toString(), stringBuffer7.toString());
            if (stringBuffer5.toString().equals("GWNetList")) {
                stringBuffer.append(xMLConnectorObject.getRequestDocument());
                s_logger.message("Output Request Document : " + stringBuffer.toString());
                stringBuffer3.append(xMLConnectorObject.getErrorDocument());
                s_logger.message("Output Error Document : " + stringBuffer3.toString());
            } else {
                stringBuffer.append(xMLConnectorObject.getRequestDocument());
                s_logger.message("Output Request Document : " + stringBuffer.toString());
                stringBuffer2.append(xMLConnectorObject.getResponseDocument());
                s_logger.message("Output Response Document : " + stringBuffer2.toString());
                stringBuffer3.append(xMLConnectorObject.getErrorDocument());
                s_logger.message("Output Error Document : " + stringBuffer3.toString());
            }
            return true;
        }
        catch (Exception exception) {
            s_logger.errorMessage(this.getClass().getName());
            StatusHandler statusHandler = new StatusHandler();
            String string2 = new DOMWriter(statusHandler.createFailureDoc(exception)).toString();
            stringBuffer4.append(string2);
            s_logger.errorMessage("Error Document : " + string2);
            return false;
        }
    }

    public boolean getMethodList(String string, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        try {
            String string2 = "";
            String string3 = "";
            if (!this.m_licenseFlag) {
                throw new LicenseFailedException(this.m_licenseMessage);
            }
            if (this.m_license.getDaysLeft() < 0) {
                throw new LicenseFailedException(this.m_license.getWarningMessage());
            }
            s_logger.message("Input Request Document : " + string);
            XMLConnectorObject xMLConnectorObject = new XMLConnectorObject(string, string2, string3);
            Node node = xMLConnectorObject.getMethodList();
            Document document = (Document)node;
            stringBuffer.append(new DOMWriter(document).toString());
            s_logger.message("The supported Methods are: ");
            s_logger.message(stringBuffer.toString());
        }
        catch (Exception exception) {
            s_logger.errorMessage(this.getClass().getName());
            StatusHandler statusHandler = new StatusHandler();
            String string4 = new DOMWriter(statusHandler.createFailureDoc(exception)).toString();
            stringBuffer2.append(string4);
            s_logger.errorMessage("Error Document : " + string4);
            return false;
        }
        return true;
    }

    public boolean close() {
        try {
            this.m_license.release();
            return true;
        }
        catch (Exception exception) {
            s_logger.errorMessage(exception.getLocalizedMessage());
            return false;
        }
    }
}

