/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.xmlconnector.generator;

import com.baan.b3.dom.Document;
import com.baan.b3.dom.Element;
import com.baan.b3.dom.Node;
import com.baan.b3.dom.NodeList;
import com.baan.owimpl.xmlconnector.generator.IGenerator;
import com.baan.owimpl.xmlconnector.preparedmetadata.Definition;
import com.eibus.xml.dom.DocumentImpl;
import java.util.Vector;

class DTDGenerator
extends Definition
implements IGenerator {
    private static final String COPYRIGHT = "Copyright (c) 2001-2002 Baan Company";
    private static final String ELEMENT = "<!ELEMENT ";
    private static final String PCDATA = " (#PCDATA)>";
    private static final String CDATA = " CDATA";
    private static final String ATTRIBUTE = "<!ATTLIST  ";
    private static final String OR = "|";
    private static final String SEQUENCE = ",";
    private static final String ZERO_OR_MORE = "*";
    private static final String ONE_OR_MORE = "+";
    private static final String ZERO_OR_ONE = "?";
    private static final String MANDATORY = "";
    Document m_doc = new DocumentImpl();
    NodeList m_searchList = null;
    Element m_root = null;
    String m_seperator = "";
    String m_DTDString = "";
    String m_attributeString = "";
    Vector m_businessObjectVector = new Vector();

    DTDGenerator() {
    }

    public String generateMetadata(Node node) {
        this.process(node);
        return this.m_DTDString;
    }

    private void process(Node node) {
        this.m_DTDString = MANDATORY;
        this.m_attributeString = MANDATORY;
        this.m_businessObjectVector.removeAllElements();
        this.m_doc.appendChild(node);
        this.m_root = this.m_doc.getDocumentElement();
        this.m_searchList = this.m_root.getElementsByTagName(Definition.NAMESPACE + "complexType");
        if (this.m_searchList != null) {
            String string = this.getAttributeValue(this.m_searchList.item(0), "name");
            string = string.substring(0, string.length() - 4);
            this.m_businessObjectVector.addElement(string);
            this.m_DTDString = this.setMetadata(this.m_searchList.item(0), string);
        }
        this.m_DTDString = this.m_DTDString + this.m_attributeString;
    }

    private String setMetadata(Node node, String string) {
        String string2 = MANDATORY;
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n).hasChildNodes()) {
                this.m_seperator = nodeList.item(n).getNodeName().endsWith("sequence") ? SEQUENCE : OR;
                string2 = this.setElement(nodeList.item(n), this.m_seperator, string);
            } else {
                this.setAttribute(nodeList.item(n), string);
            }
            ++n;
        }
        return string2;
    }

    private String setElement(Node node, String string, String string2) {
        String string3 = MANDATORY;
        String string4 = MANDATORY;
        String string5 = MANDATORY;
        String string6 = MANDATORY;
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            string3 = this.getAttributeValue(nodeList.item(n), "name");
            string4 = this.setCardinality(nodeList.item(n));
            string5 = string5 + string3 + string4 + string;
            Node node2 = this.isComplexType(string3 + "type");
            if (node2 == null) {
                if (!this.m_businessObjectVector.contains(string3)) {
                    this.m_businessObjectVector.addElement(string3);
                    string6 = string6 + ELEMENT + string3 + PCDATA;
                }
            } else {
                String string7 = this.getAttributeValue(nodeList.item(n), "name");
                if (!this.m_businessObjectVector.contains(string7)) {
                    this.m_businessObjectVector.addElement(string7);
                    string6 = string6 + this.setMetadata(node2, string7);
                }
            }
            ++n;
        }
        string5 = ELEMENT + string2 + " (" + string5.substring(0, string5.length() - 1) + ")>";
        return string5 + string6;
    }

    private String setCardinality(Node node) {
        String string = MANDATORY;
        String string2 = MANDATORY;
        if (this.getAttributeNode(node, "minOccurs") != null) {
            string = this.getAttributeValue(node, "minOccurs");
        }
        if (this.getAttributeNode(node, "maxOccurs") != null) {
            string2 = this.getAttributeValue(node, "maxOccurs");
        }
        if (string2.equalsIgnoreCase("unbounded")) {
            if (string.equalsIgnoreCase("0")) {
                return ZERO_OR_MORE;
            }
            return ONE_OR_MORE;
        }
        if (string.equalsIgnoreCase("0")) {
            return ZERO_OR_ONE;
        }
        return MANDATORY;
    }

    private Node isComplexType(String string) {
        int n = 0;
        while (n < this.m_searchList.getLength()) {
            if (this.getAttributeNode(this.m_searchList.item(n), "name") != null && this.getAttributeValue(this.m_searchList.item(n), "name").equals(string)) {
                return this.m_searchList.item(n);
            }
            ++n;
        }
        return null;
    }

    private void setAttribute(Node node, String string) {
        if (this.getAttributeNode(node, "name") != null) {
            String string2 = this.getAttributeValue(node, "name");
            this.m_attributeString = this.m_attributeString + ATTRIBUTE + string + " " + string2 + CDATA + " #IMPLIED>";
        }
    }

    private String getAttributeValue(Node node, String string) {
        try {
            return node.getAttributes().getNamedItem(string).getNodeValue();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Node getAttributeNode(Node node, String string) {
        try {
            return node.getAttributes().getNamedItem(string);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

