/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.xmlconnector.exception;

import com.baan.b3.boi1.BoiApplicationException;
import com.baan.b3.boi1.BoiException;
import com.baan.b3.boi1.BoiSynchronizationException;
import com.baan.b3.boi1.IExceptionDescriptor;
import com.baan.b3.dom.Document;
import com.baan.owimpl.xmlconnector.error.ErrorBuilder;
import com.baan.owimpl.xmlconnector.error.ErrorDocument;
import com.baan.owimpl.xmlconnector.error.ErrorDocumentForSync;
import com.baan.owimpl.xmlconnector.exception.BOINotFoundException;
import com.baan.owimpl.xmlconnector.exception.CorruptRepositoryException;
import com.baan.owimpl.xmlconnector.exception.DLLException;
import com.baan.owimpl.xmlconnector.exception.EmptyBOIVersionException;
import com.baan.owimpl.xmlconnector.exception.FileException;
import com.baan.owimpl.xmlconnector.exception.GWNetListException;
import com.baan.owimpl.xmlconnector.exception.InvalidParameterException;
import com.baan.owimpl.xmlconnector.exception.InvalidXMLDocumentException;
import com.baan.owimpl.xmlconnector.exception.LicenseFailedException;
import com.baan.owimpl.xmlconnector.exception.ManagerNotFoundException;
import com.baan.owimpl.xmlconnector.exception.MethodNotFoundException;
import com.baan.owimpl.xmlconnector.exception.MethodNotSupportedException;
import com.baan.owimpl.xmlconnector.exception.NegativePriorityException;
import com.baan.owimpl.xmlconnector.exception.NullReturnTypeException;
import com.baan.owimpl.xmlconnector.exception.PropertiesUndefinedException;
import com.baan.owimpl.xmlconnector.exception.RecordNotFoundException;
import com.baan.owimpl.xmlconnector.exception.RecordRetrievalFailedException;
import com.baan.owimpl.xmlconnector.exception.RequestParserException;
import com.baan.owimpl.xmlconnector.exception.UnManagedObjectException;
import com.eibus.exception.ProgrammingRException;
import com.eibus.services.licensing.LicenseException;
import java.lang.reflect.InvocationTargetException;

public class ExceptionHandler {
    private static final String COPYRIGHT = "Copyright (c) 2001-2002 Baan Company";
    private static final String INFRASTRUCTURE = "infrastructure";
    private static final String APPLICATIONFAILURE = "applicationFailure";
    private static final String SYNTAX = "syntax";
    private static final String FATAL = "fatal";
    private static final String WARNING = "warning";
    private String m_exceptionMessage = "";
    private String m_errorLevel = "";
    private String m_errorSeverity = "";
    private String m_errorCode = "";
    private static final String ASM_AUTHENTICATION_ERROR_STRING = "ASM: '-4'";
    private static final String NONASM_AUTHENTICATION_ERROR_STRING = "username or password not correct";

    public Document getErrorDocument(Exception exception) {
        Object object;
        String string = "";
        if (exception instanceof BOINotFoundException) {
            this.setError(INFRASTRUCTURE, FATAL, "Business Object not found in Repositories", "XMLC_1501");
        } else if (exception instanceof FileException) {
            this.setError(INFRASTRUCTURE, FATAL, exception.getMessage(), "XMLC_4001");
        } else if (exception instanceof CorruptRepositoryException) {
            this.setError(INFRASTRUCTURE, FATAL, exception.getMessage(), "XMLC_2001");
        } else if (exception instanceof PropertiesUndefinedException) {
            this.setError(INFRASTRUCTURE, FATAL, exception.getMessage(), "XMLC_4004");
        } else if (exception instanceof InvalidParameterException) {
            this.setError(SYNTAX, WARNING, exception.getMessage(), "XMLC_1701");
        } else if (exception instanceof EmptyBOIVersionException) {
            this.setError(INFRASTRUCTURE, FATAL, exception.getMessage(), "XMLC_2002");
        } else if (exception instanceof NumberFormatException) {
            this.setError(SYNTAX, WARNING, exception.getMessage(), "XMLC_4005");
        } else if (exception instanceof IllegalArgumentException) {
            this.setError(SYNTAX, WARNING, "Illegal Argument is passed as an input : " + exception.getMessage(), "XMLC_1704");
        } else if (exception instanceof LicenseFailedException) {
            this.setError(INFRASTRUCTURE, FATAL, exception.getMessage(), "XMLC_4002");
        } else if (exception instanceof LicenseException) {
            this.setError(INFRASTRUCTURE, FATAL, exception.getMessage(), "XMLC_4002");
        } else if (exception instanceof ProgrammingRException) {
            this.setError(SYNTAX, WARNING, exception.getMessage(), "XMLC_1705");
        } else if (exception instanceof MethodNotFoundException) {
            this.setError(INFRASTRUCTURE, FATAL, exception.getMessage(), "XMLC_1001");
        } else if (exception instanceof ManagerNotFoundException) {
            this.setError(INFRASTRUCTURE, FATAL, exception.getMessage(), "XMLC_2003");
        } else if (exception instanceof RequestParserException) {
            this.setError(SYNTAX, WARNING, exception.getMessage(), "XMLC_1703");
        } else if (exception instanceof InvalidXMLDocumentException) {
            this.setError(SYNTAX, WARNING, exception.getMessage(), "XMLC_1702");
        } else if (exception instanceof UnManagedObjectException) {
            this.setError(INFRASTRUCTURE, FATAL, exception.getMessage(), "XMLC_3002");
        } else if (exception instanceof RecordRetrievalFailedException) {
            this.setError(APPLICATIONFAILURE, FATAL, exception.getMessage(), "XMLC_3503");
        } else {
            if (exception instanceof DLLException) {
                return ((DLLException)exception).getError();
            }
            if (exception instanceof GWNetListException) {
                return ((GWNetListException)exception).getError();
            }
            if (exception instanceof BoiSynchronizationException) {
                ErrorDocumentForSync errorDocumentForSync = new ErrorDocumentForSync();
                return ((ErrorBuilder)errorDocumentForSync).createErrorDocument(exception);
            }
            if (exception instanceof BoiApplicationException) {
                object = (BoiApplicationException)exception;
                IExceptionDescriptor[] iExceptionDescriptorArray = ((BoiException)object).getDescriptors();
                String[] stringArray = null;
                String string2 = "";
                string = exception.getLocalizedMessage();
                int n = 0;
                while (n < iExceptionDescriptorArray.length) {
                    stringArray = iExceptionDescriptorArray[n].getMessage();
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        string2 = string2 + "; " + stringArray[n2].toString();
                        ++n2;
                    }
                    ++n;
                }
                this.setError(APPLICATIONFAILURE, FATAL, string + string2, "XMLC_3503");
            } else if (exception instanceof BoiException) {
                object = exception.getMessage();
                if (((String)object).indexOf(ASM_AUTHENTICATION_ERROR_STRING) != -1 || ((String)object).indexOf(NONASM_AUTHENTICATION_ERROR_STRING) != -1) {
                    this.setError(INFRASTRUCTURE, "", (String)object, "XMLC_4701");
                } else {
                    this.setError(INFRASTRUCTURE, "", (String)object, "XMLC_4501");
                }
            } else if (exception instanceof RecordNotFoundException) {
                this.setError(INFRASTRUCTURE, "", exception.getMessage(), "XMLC_3504");
            } else if (exception instanceof NegativePriorityException) {
                this.setError(INFRASTRUCTURE, FATAL, exception.getMessage(), "XMLC_4003");
            } else if (exception instanceof InvocationTargetException) {
                object = ((InvocationTargetException)exception).getTargetException();
                if (object instanceof BoiException) {
                    BoiException boiException = (BoiException)object;
                    IExceptionDescriptor[] iExceptionDescriptorArray = boiException.getDescriptors();
                    if (iExceptionDescriptorArray.length > 0) {
                        int n = 0;
                        while (n < iExceptionDescriptorArray.length) {
                            String[] stringArray = iExceptionDescriptorArray[n].getMessage();
                            int n3 = 0;
                            while (n3 < stringArray.length) {
                                string = string + stringArray[n3];
                                if (n3 < stringArray.length) {
                                    string = string + " ";
                                }
                                ++n3;
                            }
                            ++n;
                        }
                    } else {
                        string = boiException.getMessage();
                    }
                } else {
                    string = "Invocation Target Exception";
                }
                this.setError(INFRASTRUCTURE, FATAL, string, "XMLC_4501");
            } else if (exception instanceof NullReturnTypeException) {
                this.setError(INFRASTRUCTURE, FATAL, string, "XMLC_3001");
            } else if (exception instanceof MethodNotSupportedException) {
                this.setError(INFRASTRUCTURE, FATAL, exception.getMessage(), "XMLC_1002");
            } else {
                this.setError("", FATAL, exception.getClass().toString(), "");
            }
        }
        object = new ErrorDocument();
        return ((ErrorBuilder)object).createErrorDocument(this.m_exceptionMessage, this.m_errorLevel, this.m_errorSeverity, this.m_errorCode);
    }

    private void setError(String string, String string2, String string3, String string4) {
        this.m_exceptionMessage = string3;
        this.m_errorLevel = string;
        this.m_errorSeverity = string2;
        this.m_errorCode = string4;
    }
}

