/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.xmlconnector.dispatcher;

import com.baan.b3.boi1.IUserSession;
import com.baan.ow.xmlconnector.dispatcher.FaultException;
import com.baan.ow.xmlconnector.dispatcher.IReply;
import com.baan.ow.xmlconnector.dispatcher.IRequest;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.baan.owimpl.xmlconnector.dispatcher.GenericRequestException;
import com.baan.owimpl.xmlconnector.dispatcher.Reply;
import com.baan.owimpl.xmlconnector.dispatcher.Repository;
import com.baan.owimpl.xmlconnector.dispatcher.Runtime;
import com.baan.owimpl.xmlconnector.util.dom2.DispatcherValidator;
import com.baan.owimpl.xmlconnector.util.dom2.XMLHelper;
import com.eibus.services.licensing.ILicense;
import com.eibus.services.licensing.LicenseFactory;
import com.eibus.xml.util.NiceW3CDOMWriter;
import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Request
implements IRequest {
    ILicense m_license = null;
    private Element m_reqElement = null;
    private String m_componentName = "";
    private IUserSession m_userSession = null;
    private IReply m_irep = null;
    private XMLHelper m_xmlhelp = new XMLHelper();
    private Hashtable m_namespaceHashTable = new Hashtable();
    private Runtime m_runtime = null;
    private static String OBJECT = "Object";
    private static String METHOD = "Method";
    private static String REPOSITORY = "Repository";
    private static String LIST_OBJECTS = "ListObjects";
    private static String GET_OBJECT_METADATA = "GetObjectMetaData";
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.owimpl.xmlconnector.dispatcher", "XMLConnectorDispatcher");

    public Request(Element element) {
        this.m_reqElement = element;
    }

    public Request(Element element, String string, IUserSession iUserSession) {
        this.m_reqElement = element;
        this.m_componentName = string;
        this.m_userSession = iUserSession;
    }

    public IReply execute() throws FaultException, GenericRequestException {
        String string;
        boolean bl = true;
        Object var2_2 = null;
        Document document = null;
        try {
            s_logger.flowMessage("Dispatcher-IRequest : Entered execute() method");
            String string2 = new NiceW3CDOMWriter(this.m_reqElement).toString();
            s_logger.message("Dispatcher-IRequest : Validating input document to IDispatcher : " + string2);
            try {
                if (!new DispatcherValidator().parseRequest(this.m_reqElement, this.m_namespaceHashTable)) {
                    if (this.checkLicense()) {
                        Element element = this.m_xmlhelp.constructFaultNode("Client.BAC-UnknownMessage", "Unknown message format cannot be handled by Dispatcher.", "http://www.baan.com/basis/bac/disp/Dispatcher", false);
                        throw new FaultException(element);
                    }
                    throw new GenericRequestException(this.m_license.getWarningMessage(), "Server.BAC-ConfigurationError");
                }
            }
            catch (FaultException faultException) {
                if (!this.checkLicense()) {
                    throw new GenericRequestException(this.m_license.getWarningMessage(), "Server.BAC-ConfigurationError");
                }
                throw faultException;
            }
            string = this.m_namespaceHashTable.get(METHOD).toString();
            Element element = this.m_xmlhelp.retriveSubTree(this.m_reqElement);
            if (this.m_xmlhelp.retrieveObject(this.m_namespaceHashTable.get(OBJECT).toString()).equals(REPOSITORY)) {
                if (string.equals(LIST_OBJECTS)) {
                    document = new Repository().ListObjects(element, this.m_namespaceHashTable);
                } else if (string.equals(GET_OBJECT_METADATA)) {
                    document = new Repository().getObjectMetadata(element, this.m_namespaceHashTable);
                }
                string2 = new NiceW3CDOMWriter(document.getDocumentElement()).toString();
                s_logger.message("Dispatcher-IRequest : Response: " + string2);
                IReply iReply = this.m_irep = new Reply(document.getDocumentElement());
                return iReply;
            }
            this.m_runtime = new Runtime();
            document = this.m_runtime.callExecute(element, this.m_componentName, this.m_userSession, this.m_namespaceHashTable);
            string2 = new NiceW3CDOMWriter(document.getDocumentElement()).toString();
            s_logger.message("Dispatcher-IRequest : Response: " + string2);
            IReply iReply = this.m_irep = new Reply(document.getDocumentElement());
            return iReply;
        }
        catch (FaultException faultException) {
            string = new NiceW3CDOMWriter(faultException.getFault()).toString();
            s_logger.errorMessage("Dispatcher-IRequest : FaultException: " + string);
            throw faultException;
        }
        catch (GenericRequestException genericRequestException) {
            if (!this.checkLicense()) {
                s_logger.errorMessage("Valid license could not be found. Detail message : " + this.m_license.getWarningMessage());
                throw new GenericRequestException(this.m_license.getWarningMessage(), "Server.BAC-ConfigurationError");
            }
            s_logger.errorMessage("Dispatcher-IRequest : RequestException: ");
            s_logger.errorMessage("Message: " + genericRequestException.getMessage());
            throw genericRequestException;
        }
        finally {
            if (this.m_license != null) {
                this.m_license.release();
            }
            this.m_xmlhelp = null;
            this.m_namespaceHashTable.clear();
            this.m_license = null;
            s_logger.flowMessage("Dispatcher-IRequest : Exiting execute() method");
        }
    }

    public Element getRequestMsg() {
        return this.m_reqElement;
    }

    protected void close() {
        s_logger.flowMessage("Dispatcher-IRequest : Entered close() method");
        if (this.m_runtime != null) {
            this.m_runtime.close();
        }
        this.m_irep = null;
    }

    private boolean checkLicense() {
        try {
            this.m_license = LicenseFactory.createXMLConnectorLicense();
            if (this.m_license.getDaysLeft() < 0) {
                return false;
            }
        }
        catch (Exception exception) {
            throw new GenericRequestException(exception.getMessage(), "Server.BAC-ConfigurationError");
        }
        return true;
    }
}

