/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.xmlconnector.dispatcher;

import com.baan.b3.dom.Document;
import com.baan.b3.domain.Domain;
import com.baan.b3.domain.IBoiDescriptor;
import com.baan.b3.domain.IDomain;
import com.baan.ow.xmlconnector.IMetadataGenerator;
import com.baan.ow.xmlconnector.XMLConnectorFactory;
import com.baan.ow.xmlconnector.dispatcher.FaultException;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.baan.owimpl.xmlconnector.configimpl.XMLConnectorProperty;
import com.baan.owimpl.xmlconnector.dispatcher.DispatcherConstants;
import com.baan.owimpl.xmlconnector.dispatcher.GenericRequestException;
import com.baan.owimpl.xmlconnector.dispatcher.Runtime;
import com.baan.owimpl.xmlconnector.error.StatusHandler;
import com.baan.owimpl.xmlconnector.exception.CorruptRepositoryException;
import com.baan.owimpl.xmlconnector.exception.FileException;
import com.baan.owimpl.xmlconnector.wsdlgen.BOAttributes;
import com.baan.owimpl.xmlconnector.wsdlgen.Definition;
import com.baan.owimpl.xmlconnector.wsdlgen.RepositoryMetadata;
import com.eibus.services.licensing.ILicense;
import com.eibus.services.licensing.LicenseFactory;
import com.eibus.xml.util.DOMWriter;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class Repository
extends DispatcherConstants {
    private String m_componentName = null;
    private Vector m_fullyQlNames = new Vector();
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.owimpl.xmlconnector.dispatcher", "XMLConnectorDispatcher");

    Repository() {
    }

    public org.w3c.dom.Document ListObjects(Node node, Hashtable hashtable) throws FaultException, GenericRequestException {
        ILicense iLicense = null;
        org.w3c.dom.Document document = null;
        s_logger.message("Dispatcher-Internal(Repository) : Executing ListObjects");
        try {
            s_logger.message("Dispatcher-Internal(Repository) : Checking for License");
            iLicense = LicenseFactory.createXMLConnectorLicense();
            if (iLicense.getDaysLeft() < 0) {
                s_logger.errorMessage("Server.BAC-ConfigurationError" + iLicense.getWarningMessage());
                throw new GenericRequestException(iLicense.getWarningMessage(), "Server.BAC-ConfigurationError");
            }
            s_logger.message("Dispatcher-Internal(Repository) : License check successful");
        }
        catch (Exception exception) {
            s_logger.errorMessage("Dispatcher-Internal(Repository) : throwing an exception");
            s_logger.errorException(exception);
            throw new GenericRequestException(exception.getMessage(), DispatcherConstants.FAULT_CODE_CONFIG);
        }
        try {
            try {
                Vector vector = null;
                StringBuffer stringBuffer = new StringBuffer();
                document = this.m_xmlhelp.createDocument();
                vector = this.listAllBOINames(stringBuffer);
                if (vector == null) {
                    new Runtime().throwAppropriateException(this.m_xmlhelp.StringToDocument(stringBuffer.toString()), DispatcherConstants.GENERIC_FAULT_STRING, hashtable);
                }
                Element element = this.constructResponseHeaderDoc(document, hashtable);
                int n = 0;
                while (n < vector.size()) {
                    this.createObjectNode(document, element, (String)vector.elementAt(n), false, hashtable);
                    ++n;
                }
                this.createObjectNode(document, element, DispatcherConstants.QUALIFIED_REP_OBJ, true, hashtable);
            }
            catch (FaultException faultException) {
                s_logger.errorMessage("Dispatcher-Internal(Repository) : throwing FaultException ");
                s_logger.errorException(faultException);
                throw faultException;
            }
            catch (GenericRequestException genericRequestException) {
                s_logger.errorMessage("Dispatcher-Internal(Repository) : throwing RequestException ");
                s_logger.errorException(genericRequestException);
                throw genericRequestException;
            }
            Object var10_12 = null;
            if (iLicense != null) {
                iLicense.release();
            }
            iLicense = null;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (iLicense != null) {
                iLicense.release();
            }
            iLicense = null;
            throw throwable;
        }
        s_logger.flowMessage("Dispatcher-Internal(Repository) : Exiting ListObjects");
        return document;
    }

    public org.w3c.dom.Document getObjectMetadata(Node node, Hashtable hashtable) throws FaultException, GenericRequestException {
        org.w3c.dom.Document document = null;
        Node node2 = null;
        ILicense iLicense = null;
        IMetadataGenerator iMetadataGenerator = null;
        try {
            Object object;
            Object object2;
            String string = this.m_xmlhelp.retrieveObject(this.m_xmlhelp.getNodeValue(this.m_xmlhelp.getNode(node, DispatcherConstants.OBJECT_NAME)));
            s_logger.message("Dispatcher-Internal(Repository) : Executing getObjectMetadata");
            if (string != null && string.equals(DispatcherConstants.REPOSITORY)) {
                try {
                    iLicense = LicenseFactory.createXMLConnectorLicense();
                    if (iLicense.getDaysLeft() < 0) {
                        throw new GenericRequestException(iLicense.getWarningMessage(), "Server.BAC-ConfigurationError");
                    }
                }
                catch (Exception exception) {
                    s_logger.errorMessage("Dispatcher-Internal(Repository) : throwing a RequestException");
                    s_logger.errorException(exception);
                    throw new GenericRequestException(exception.getMessage(), "Server.BAC-ConfigurationError");
                }
                node2 = this.m_xmlhelp.StringToDocument(RepositoryMetadata.REPOSITORY_WSDL).getDocumentElement();
            } else {
                object2 = new StringBuffer();
                s_logger.flowMessage("Dispatcher-Internal(Repository) : Calling getMetadataGenerator() of IMetadataGenerator");
                iMetadataGenerator = XMLConnectorFactory.getMetadataGenerator();
                object = this.getMethodList(string, (StringBuffer)object2, iMetadataGenerator);
                if (object == null) {
                    new Runtime().throwAppropriateException(this.m_xmlhelp.StringToDocument(((StringBuffer)object2).toString()), DispatcherConstants.GENERIC_FAULT_STRING, hashtable);
                }
                BOAttributes bOAttributes = new BOAttributes(string, (String[])object);
                Definition definition = new Definition(iMetadataGenerator);
                try {
                    definition.create(bOAttributes);
                }
                catch (Exception exception) {
                    Document document2 = new StatusHandler().createFailureDoc(exception);
                    String string2 = new DOMWriter(document2).toString();
                    new Runtime().throwAppropriateException(this.m_xmlhelp.StringToDocument(string2), DispatcherConstants.GENERIC_FAULT_STRING, hashtable);
                }
                try {
                    node2 = definition.toXML();
                }
                catch (Exception exception) {
                    throw new GenericRequestException(exception.getMessage(), "");
                }
            }
            document = this.m_xmlhelp.createDocument();
            object = this.constructResponseHeaderDoc(document, hashtable);
            object2 = this.m_xmlhelp.createElement(document, DispatcherConstants.WSDL_METADATA_TAG, (Element)object);
            object2.appendChild(document.importNode(node2, true));
        }
        catch (FaultException faultException) {
            throw faultException;
        }
        catch (GenericRequestException genericRequestException) {
            throw genericRequestException;
        }
        finally {
            if (iLicense != null) {
                iLicense.release();
            }
            if (iMetadataGenerator != null) {
                iMetadataGenerator.close();
            }
            iLicense = null;
        }
        s_logger.flowMessage("Dispatcher-Internal(Repository) : Exiting getObjectMetadata");
        return document;
    }

    private Vector listAllBOINames(StringBuffer stringBuffer) {
        Vector<String> vector = new Vector<String>();
        try {
            String[] stringArray = null;
            XMLConnectorProperty xMLConnectorProperty = XMLConnectorProperty.getXMLConnectorProperty();
            stringArray = xMLConnectorProperty.getRepositoryNames();
            if (stringArray != null && stringArray.length > 0) {
                int n = 0;
                while (n < stringArray.length) {
                    String[] stringArray2 = this.getBOINames(stringArray[n]);
                    if (stringArray2 != null && stringArray2.length > 0) {
                        int n2 = 0;
                        while (n2 < stringArray2.length) {
                            vector.addElement(stringArray2[n2]);
                            ++n2;
                        }
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            Document document = new StatusHandler().createFailureDoc(exception);
            stringBuffer.append(new DOMWriter(document).toString());
            return null;
        }
        return vector;
    }

    private String[] getBOINames(String string) throws Exception {
        String[] stringArray;
        IDomain iDomain;
        block5: {
            iDomain = null;
            try {
                stringArray = ClassLoader.getSystemResource(string);
                if (stringArray != null) {
                    iDomain = Domain.open((URL)stringArray);
                    break block5;
                }
                throw new FileException("The repository file, " + string + " not found in the classpath");
            }
            catch (Exception exception) {
                if (exception instanceof FileException) {
                    throw exception;
                }
                throw new CorruptRepositoryException("The repository file, " + string + " is corrupt");
            }
        }
        stringArray = iDomain.getBoiNames();
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n] = this.getFullyQName(iDomain, stringArray[n]);
            ++n;
        }
        return stringArray2;
    }

    private String getFullyQName(IDomain iDomain, String string) {
        try {
            IBoiDescriptor iBoiDescriptor = iDomain.getBoi(string);
            String string2 = iBoiDescriptor.getManagerClass();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
            int n = stringTokenizer.countTokens();
            String[] stringArray = new String[n];
            int n2 = 0;
            String string3 = "";
            String string4 = "";
            String string5 = "";
            if (n > 1) {
                while (stringTokenizer.hasMoreTokens()) {
                    String string6 = stringTokenizer.nextToken();
                    if (n2 == 0) {
                        string4 = string6;
                    } else if (n2 == 1) {
                        string5 = string6;
                    } else if (n2 != n - 1) {
                        string3 = string3 + "/" + string6;
                    }
                    ++n2;
                }
                string3 = string5 + "." + string4 + string3;
                return "http://" + string3 + "/" + string;
            }
            return "http://" + string;
        }
        catch (Exception exception) {
            return "";
        }
    }

    private void createObjectNode(org.w3c.dom.Document document, Node node, String string, boolean bl, Hashtable hashtable) throws FaultException, GenericRequestException {
        try {
            if (!string.equals("") && !this.m_fullyQlNames.contains(string)) {
                this.m_fullyQlNames.addElement(string);
                Element element = this.m_xmlhelp.createElement(document, DispatcherConstants.OBJECT, (Element)node);
                this.m_xmlhelp.createTextNode(document, DispatcherConstants.NAME, string, element);
                this.m_xmlhelp.createTextNode(document, DispatcherConstants.DESCRIPTION, "BOI for " + this.getBOName(string), element);
                this.m_xmlhelp.createTextNode(document, DispatcherConstants.LICENSED, "true", element);
            }
        }
        catch (Exception exception) {
            String string2 = new DOMWriter(new StatusHandler().createFailureDoc(exception)).toString();
            new Runtime().throwAppropriateException(this.m_xmlhelp.StringToDocument(string2), DispatcherConstants.GENERIC_FAULT_STRING, hashtable);
        }
    }

    private String getBOName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        return string2;
    }

    private String[] getMethodList(String string, StringBuffer stringBuffer, IMetadataGenerator iMetadataGenerator) {
        String[] stringArray;
        block4: {
            stringArray = null;
            StringBuffer stringBuffer2 = new StringBuffer();
            try {
                if (iMetadataGenerator.getMethodList(string, stringBuffer, stringBuffer2)) {
                    org.w3c.dom.Document document = this.m_xmlhelp.StringToDocument(stringBuffer.toString());
                    NodeList nodeList = document.getDocumentElement().getElementsByTagName(DispatcherConstants.METHOD_NAME);
                    stringArray = new String[nodeList.getLength()];
                    int n = 0;
                    while (n < nodeList.getLength()) {
                        Text text = (Text)nodeList.item(n).getFirstChild();
                        stringArray[n] = text == null ? "" : text.getNodeValue();
                        ++n;
                    }
                    break block4;
                }
                stringBuffer.append(stringBuffer2.toString());
                return null;
            }
            catch (Exception exception) {
                stringBuffer.append(stringBuffer2.toString());
                return null;
            }
        }
        return stringArray;
    }
}

