/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.xmlconnector.dispatcher;

import com.baan.b3.boi1.IUserSession;
import com.baan.ow.xmlconnector.dispatcher.AuthenticationException;
import com.baan.ow.xmlconnector.dispatcher.IDispatcher;
import com.baan.ow.xmlconnector.dispatcher.IRequest;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.baan.owimpl.xmlconnector.dispatcher.GenericRequestException;
import com.baan.owimpl.xmlconnector.dispatcher.Request;
import com.baan.owimpl.xmlconnector.util.dom2.DispatcherValidator;
import com.baan.owimpl.xmlconnector.util.dom2.XMLHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DispatcherImpl
implements IDispatcher {
    private String m_componentname = "";
    private IUserSession m_userSession = null;
    private int m_timeOut = 0;
    private Request m_req = null;
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.owimpl.xmlconnector.dispatcher", "XMLConnectorDispatcher");

    public DispatcherImpl(String string, String string2, String string3, String string4) throws GenericRequestException {
        s_logger.flowMessage("Dispatcher-IDiaptcher: Initializing IDispatcher");
        s_logger.message("Dispatcher-IDiaptcher: Backend Type : " + string + ", ComponentName : " + string2);
        this.m_componentname = string2;
        try {
            this.m_userSession = new DispatcherValidator().checkBackend(string2, string3, string4);
        }
        catch (GenericRequestException genericRequestException) {
            throw genericRequestException;
        }
        catch (AuthenticationException authenticationException) {
            throw authenticationException;
        }
    }

    public DispatcherImpl(String string, String string2, String string3) throws GenericRequestException {
        s_logger.flowMessage("Dispatcher-IDiaptcher: Initializing IDispatcher");
        s_logger.message("Dispatcher-IDiaptcher: Backend Type : " + string);
        try {
            this.m_userSession = new DispatcherValidator().checkBackend2(string2, string3);
        }
        catch (GenericRequestException genericRequestException) {
            throw genericRequestException;
        }
        catch (AuthenticationException authenticationException) {
            throw authenticationException;
        }
    }

    public IRequest newRequest() {
        try {
            s_logger.flowMessage("Dispatcher-IDiaptcher: In newRequest()");
            Document document = new XMLHelper().createDocument();
            Element element = document.createElementNS("http://www.baan.com/basis/bac/disp", "disp:Request");
            document.appendChild(element);
            this.m_req = new Request(element);
            return this.m_req;
        }
        catch (Exception exception) {
            throw new GenericRequestException(exception.getMessage(), "");
        }
    }

    public IRequest newRequest(Element element) {
        s_logger.flowMessage("Dispatcher-IDiaptcher: In newRequest( Element p_requestElement )");
        this.m_req = new Request(element, this.m_componentname, this.m_userSession);
        return this.m_req;
    }

    public void close() {
        s_logger.flowMessage("Dispatcher-IDiaptcher: Closing Dispatcher instance");
        this.m_req.close();
        this.m_req = null;
    }

    public void setTimeout(int n) {
        s_logger.flowMessage("Dispatcher-IDiaptcher: Setting adapter time out");
        this.m_timeOut = n;
    }
}

