/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.xmlconnector.configimpl;

import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.baan.owimpl.fw.ccf.XMLConnectorConfiguration;
import com.baan.owimpl.fw.ccf.XMLConnectorContext;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.baan.owimpl.xmlconnector.exception.NegativePriorityException;

public class XMLConnectorProperty {
    private static XMLConnectorProperty s_XMLConnectorProperties = null;
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.owimpl.xmlconnector.configimpl", "XMLConnectorConfig");
    private XMLConnectorConfiguration m_config;

    private XMLConnectorProperty() throws Exception {
        try {
            this.m_config = XMLConnectorContext.getInstance().search();
        }
        catch (OWConfigurationException oWConfigurationException) {
            s_logger.message("Cannot load configuration");
            throw new Exception("Cannot load configuration: " + oWConfigurationException.getMessage());
        }
    }

    public static XMLConnectorProperty getXMLConnectorProperty() throws Exception {
        if (s_XMLConnectorProperties == null) {
            s_XMLConnectorProperties = new XMLConnectorProperty();
        }
        return s_XMLConnectorProperties;
    }

    public boolean getErrorInResponse() {
        return this.m_config.getErrorInResponse();
    }

    public String getRepositoryName(int n) throws Exception {
        try {
            return this.getRepositoryNames()[n - 1];
        }
        catch (Exception exception) {
            s_logger.errorMessage(this.getClass().getName());
            s_logger.errorException(exception);
            throw exception;
        }
    }

    public String[] getRepositoryNames() throws NegativePriorityException {
        return this.m_config.getDomainPriority();
    }
}

