/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.test;

import com.baan.b3.boi1.BoiException;
import com.baan.b3.boi1.BoiSynchronizationException;
import com.baan.b3.boi1.BusinessObject;
import com.baan.b3.boi1.BusinessObjectManager;
import com.baan.b3.boi1.IExceptionDescriptor;
import com.baan.b3.boi1.ISynchronizationExceptionDescriptor;
import com.baan.b3.boi1.Iterator;
import com.baan.b3.boi1.dt.TransactionScope;
import com.baan.b3.boi1.metadata.IBusinessObjectMetadata;
import com.baan.b3.boi1.metadata.IIteratorMetadata;
import com.baan.b3.boi1.metadata.IManagerMetadata;
import com.baan.b3.boi1.metadata.IMemberMetadata;
import com.baan.b3.boi1.metadata.IMethodMetadata;
import com.baan.b3.boi1.metadata.IParameterMetadata;
import com.baan.b3.boi1.metadata.IPrimalMemberMetadata;
import com.baan.b3.boi1.metadata.IPrimalObjectMetadata;
import com.baan.b3.boi1.metadata.MetadataUtil;
import com.baan.b3.dom.Document;
import com.baan.b3.dom.Element;
import com.baan.b3.dom.Node;
import com.baan.b3.dom.NodeList;
import com.baan.b3.dom.Text;
import com.baan.owimpl.test.Converter;
import com.baan.owimpl.test.XMLReader;
import com.eibus.xml.dom.DocumentImpl;
import com.eibus.xml.util.DOMWriter;
import java.lang.reflect.InvocationTargetException;

class InputProcessor {
    private Document m_inputDocument;
    private Document m_outputDocument;
    private String m_managerName;
    private String m_methodName;
    private BusinessObjectManager m_managerObject;
    private String m_erroneousTag = "";
    private double m_timeElapsed;

    InputProcessor(Document document) {
        this.m_inputDocument = document;
        this.m_outputDocument = new DocumentImpl();
    }

    boolean processInput() throws Exception {
        this.m_managerName = XMLReader.getTextNodeValue(this.m_inputDocument, "ManagerName");
        try {
            Class<?> clazz = Class.forName(this.m_managerName);
            this.m_managerObject = (BusinessObjectManager)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Exception("BOI Manager Class not found in CLASSPATH");
        }
        catch (InstantiationException instantiationException) {
            throw new Exception("class could not be instantiated");
        }
        try {
            String string = XMLReader.getTextNodeValue(this.m_inputDocument, "ComponentName");
            this.m_managerObject.initialize(string);
        }
        catch (BoiException boiException) {
            throw new Exception(boiException.toString());
        }
        this.m_methodName = XMLReader.getTextNodeValue(this.m_inputDocument, "Method");
        NodeList nodeList = XMLReader.getNode(this.m_inputDocument.getDocumentElement(), "Parameters");
        if (nodeList == null) {
            throw new Exception("No Parameters Found");
        }
        Node node = nodeList.item(0);
        if (this.m_methodName.equals("synchronize")) {
            return this.synchronize(node);
        }
        if (this.m_methodName.equals("addShow") || this.m_methodName.equals("addList") || this.m_methodName.length() >= 3 && this.m_methodName.trim().substring(0, 3).equals("add")) {
            return this.addShowOrList(nodeList);
        }
        return this.invokeMethod(node);
    }

    boolean invokeMethod(Node node) throws Exception {
        IMethodMetadata iMethodMetadata = null;
        boolean bl = false;
        DocumentImpl documentImpl = new DocumentImpl();
        IManagerMetadata iManagerMetadata = MetadataUtil.getManagerMetadata(this.m_managerObject.getClass().getName());
        IMethodMetadata[] iMethodMetadataArray = iManagerMetadata.getMethods();
        int n = 0;
        while (n < iMethodMetadataArray.length) {
            if (iMethodMetadataArray[n].getName().equals(this.m_methodName)) {
                iMethodMetadata = iMethodMetadataArray[n];
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            throw new Exception("method " + this.m_methodName + " not supported by the BOI");
        }
        IParameterMetadata[] iParameterMetadataArray = iMethodMetadata.getParameters();
        Object[] objectArray = new Object[iParameterMetadataArray.length];
        try {
            Element element = documentImpl.createElement("TestOutput");
            Element element2 = documentImpl.createElement("Tester");
            Text text = documentImpl.createTextNode(System.getProperty("user.name"));
            element2.appendChild(text);
            element.appendChild(element2);
            this.fillParametersFromXml(objectArray, iParameterMetadataArray, node);
            Object object = null;
            double d = 0.0;
            double d2 = 0.0;
            d = System.currentTimeMillis();
            object = iMethodMetadata.invokeWithStrings(this.m_managerObject, objectArray);
            d2 = System.currentTimeMillis();
            this.m_timeElapsed = (d2 - d) / 1000.0;
            element2 = documentImpl.createElement("TimeTaken");
            element.appendChild(element2);
            IParameterMetadata iParameterMetadata = iMethodMetadata.getReturnType();
            this.m_outputDocument.appendChild(element);
            if (iParameterMetadata.getType() instanceof IBusinessObjectMetadata) {
                BusinessObject businessObject = (BusinessObject)object;
                this.retrieveValuesFromObject(businessObject, element);
            } else if (iParameterMetadata.getType() instanceof IIteratorMetadata) {
                Iterator iterator = (Iterator)object;
                while (iterator.hasMoreElements()) {
                    d = System.currentTimeMillis();
                    BusinessObject businessObject = iterator.nextElement();
                    d2 = System.currentTimeMillis();
                    this.m_timeElapsed += (d2 - d) / 1000.0;
                    this.retrieveValuesFromObject(businessObject, element);
                }
            }
            text = documentImpl.createTextNode(String.valueOf(this.m_timeElapsed));
            element2.appendChild(text);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = illegalArgumentException.getLocalizedMessage();
            if (string == null || string.trim().equals("")) {
                string = "IllegalArgumentException";
            }
            this.m_managerObject.close();
            throw new Exception("Illegal argument " + string);
        }
        catch (InvocationTargetException invocationTargetException) {
            String string = invocationTargetException.getTargetException().toString();
            if (string == null || string.trim().equals("")) {
                string = "InvocationTargetException";
            }
            this.m_managerObject.close();
            throw new Exception(string);
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string == null || string.trim().equals("")) {
                string = "Record Not Found";
            }
            this.m_managerObject.close();
            throw new Exception(string);
        }
        this.m_managerObject.close();
        return true;
    }

    private void fillParametersFromXml(Object[] objectArray, IParameterMetadata[] iParameterMetadataArray, Node node) throws Exception {
        int n = 0;
        while (n < iParameterMetadataArray.length) {
            Object object;
            if (iParameterMetadataArray[n].getType() instanceof IPrimalObjectMetadata) {
                if (iParameterMetadataArray[n].getType().getTypeName().equals("org.w3c.dom.Node")) {
                    object = new String();
                    Node node2 = XMLReader.getNode(node, iParameterMetadataArray[n].getName()).item(0).getFirstChild();
                    while (node2 != null && node2.getNodeType() != 1) {
                        node2 = node2.getNextSibling();
                    }
                    if (node2 != null) {
                        DOMWriter dOMWriter = new DOMWriter(node2);
                        objectArray[n] = object = dOMWriter.toString();
                    } else {
                        objectArray[n] = "";
                    }
                } else {
                    String string = XMLReader.getNodeValue(node, iParameterMetadataArray[n].getName());
                    objectArray[n] = string;
                }
            } else {
                object = XMLReader.getNode(node, iParameterMetadataArray[n].getName()).item(0);
                objectArray[n] = (BusinessObject)((IBusinessObjectMetadata)iParameterMetadataArray[n].getType()).newInstance();
                this.fillObjectFromXml((BusinessObject)objectArray[n], (IBusinessObjectMetadata)iParameterMetadataArray[n].getType(), (Node)object);
            }
            ++n;
        }
    }

    private void fillObjectFromXml(BusinessObject businessObject, IBusinessObjectMetadata iBusinessObjectMetadata, Node node) throws Exception {
        IMemberMetadata[] iMemberMetadataArray = iBusinessObjectMetadata.getMembers();
        int n = 0;
        while (n < iMemberMetadataArray.length) {
            Object object;
            Object object2;
            if (iMemberMetadataArray[n].isAttribute()) {
                object2 = null;
                object2 = XMLReader.getAttributeValue(node, iMemberMetadataArray[n].getName());
                object = (IPrimalMemberMetadata)iMemberMetadataArray[n];
                if (object2 != null) {
                    object.setValueFromString(businessObject, object2);
                }
            } else {
                object2 = XMLReader.getNode(node, iMemberMetadataArray[n].getName());
                if (object2 != null && object2.getLength() != 0) {
                    int n2 = object2.getLength();
                    if (iMemberMetadataArray[n].getCardinalityMax() != 1) {
                        this.multiMemberFromXml(businessObject, iMemberMetadataArray[n], node, n2);
                    } else {
                        object = object2.item(0);
                        this.memberFromXml(businessObject, iMemberMetadataArray[n], (Node)object);
                    }
                }
            }
            ++n;
        }
    }

    private void memberFromXml(BusinessObject businessObject, IMemberMetadata iMemberMetadata, Node node) throws Exception {
        if (iMemberMetadata.getType() instanceof IPrimalObjectMetadata) {
            IPrimalMemberMetadata iPrimalMemberMetadata = (IPrimalMemberMetadata)iMemberMetadata;
            if (iMemberMetadata.getType().getTypeName().equals("org.w3c.dom.Node")) {
                if (iPrimalMemberMetadata.getCardinalityMax() == 1) {
                    String string;
                    Node node2 = XMLReader.getNode(node.getParentNode(), iMemberMetadata.getName()).item(0).getFirstChild();
                    while (node2 != null && node2.getNodeType() != 1) {
                        node2 = node2.getNextSibling();
                    }
                    if (node2 != null) {
                        DOMWriter dOMWriter = new DOMWriter(node2);
                        string = dOMWriter.toString();
                    } else {
                        string = "";
                    }
                    iPrimalMemberMetadata.setValueFromString(businessObject, string);
                } else {
                    NodeList nodeList = XMLReader.getNode(node.getParentNode(), iMemberMetadata.getName());
                    String[] stringArray = new String[nodeList.getLength()];
                    int n = 0;
                    while (n < nodeList.getLength()) {
                        Node node3 = nodeList.item(n).getFirstChild();
                        while (node3 != null && node3.getNodeType() != 1) {
                            node3 = node3.getNextSibling();
                        }
                        if (node3 != null) {
                            DOMWriter dOMWriter = new DOMWriter(node3);
                            stringArray[n] = dOMWriter.toString();
                        } else {
                            stringArray[n] = "";
                        }
                        ++n;
                    }
                    iPrimalMemberMetadata.setValueFromString(businessObject, stringArray);
                }
            } else {
                String string = XMLReader.getNodeValue(node.getParentNode(), node.getNodeName());
                this.m_erroneousTag = node.getNodeName();
                if (iPrimalMemberMetadata.getCardinalityMax() == 1) {
                    IPrimalObjectMetadata iPrimalObjectMetadata = (IPrimalObjectMetadata)iPrimalMemberMetadata.getType();
                    iPrimalMemberMetadata.setValueFromString(businessObject, string);
                } else {
                    String[] stringArray = XMLReader.getNodeValues(node.getParentNode(), node.getNodeName());
                    iPrimalMemberMetadata.setValueFromString(businessObject, stringArray);
                }
            }
        } else {
            BusinessObject businessObject2 = (BusinessObject)((IBusinessObjectMetadata)iMemberMetadata.getType()).newInstance();
            BusinessObject[] businessObjectArray = new BusinessObject[]{businessObject2};
            if (iMemberMetadata.getCardinalityMax() == 1) {
                iMemberMetadata.setValue(businessObject, businessObjectArray[0]);
            } else {
                iMemberMetadata.setValue(businessObject, businessObjectArray);
            }
            IBusinessObjectMetadata iBusinessObjectMetadata = MetadataUtil.getBusinessObjectMetadata(iMemberMetadata.getType().getTypeName());
            this.fillObjectFromXml(businessObjectArray[0], iBusinessObjectMetadata, node);
        }
    }

    private void multiMemberFromXml(BusinessObject businessObject, IMemberMetadata iMemberMetadata, Node node, int n) throws Exception {
        String string = null;
        String[] stringArray = null;
        if (iMemberMetadata.getType() instanceof IPrimalObjectMetadata) {
            Object object;
            stringArray = new String[n];
            if (iMemberMetadata.getType().getTypeName().equals("org.w3c.dom.Node")) {
                object = XMLReader.getNode(node, iMemberMetadata.getName());
                int n2 = 0;
                while (n2 < n) {
                    Node node2 = object.item(n2).getFirstChild();
                    while (node2 != null && node2.getNodeType() != 1) {
                        node2 = node2.getNextSibling();
                    }
                    if (node2 != null) {
                        DOMWriter dOMWriter = new DOMWriter(node2);
                        stringArray[n2] = dOMWriter.toString();
                    } else {
                        stringArray[n2] = "";
                    }
                    ++n2;
                }
            } else {
                string = node.getNodeName();
                object = node.getChildNodes();
                Node node3 = null;
                node3 = object.item(0);
                string = node3.getNodeValue();
                string = node3.getNodeName();
                stringArray = XMLReader.getNodeValues(node, iMemberMetadata.getName());
                this.m_erroneousTag = node.getNodeName();
            }
            object = (IPrimalMemberMetadata)iMemberMetadata;
            object.setValueFromString(businessObject, stringArray);
        } else {
            BusinessObject[] businessObjectArray = new BusinessObject[n];
            NodeList nodeList = XMLReader.getNode(node, iMemberMetadata.getName());
            Node node4 = null;
            BusinessObject businessObject2 = null;
            int n3 = 0;
            while (n3 < n) {
                node4 = nodeList.item(n3);
                businessObjectArray[n3] = businessObject2 = (BusinessObject)((IBusinessObjectMetadata)iMemberMetadata.getType()).newInstance();
                ++n3;
            }
            iMemberMetadata.setValue(businessObject, businessObjectArray);
            int n4 = 0;
            while (n4 < n) {
                node4 = nodeList.item(n4);
                IBusinessObjectMetadata iBusinessObjectMetadata = MetadataUtil.getBusinessObjectMetadata(iMemberMetadata.getType().getTypeName());
                this.fillObjectFromXml(businessObjectArray[n4], iBusinessObjectMetadata, node4);
                ++n4;
            }
        }
    }

    private void retrieveValuesFromObject(BusinessObject businessObject, Node node) throws Exception {
        DocumentImpl documentImpl = new DocumentImpl();
        Element element = null;
        Element element2 = null;
        Text text = null;
        String string = null;
        String[] stringArray = null;
        IBusinessObjectMetadata iBusinessObjectMetadata = MetadataUtil.getBusinessObjectMetadata(businessObject.getClass().getName());
        element = documentImpl.createElement(iBusinessObjectMetadata.getXmlDataType());
        node.appendChild(element);
        IMemberMetadata[] iMemberMetadataArray = iBusinessObjectMetadata.getMembers();
        int n = 0;
        while (n < iMemberMetadataArray.length) {
            BusinessObject[] businessObjectArray = null;
            if (iMemberMetadataArray[n].getType() instanceof IPrimalObjectMetadata) {
                Object object;
                Object object2 = null;
                IPrimalObjectMetadata iPrimalObjectMetadata = (IPrimalObjectMetadata)iMemberMetadataArray[n].getType();
                if (iMemberMetadataArray[n].getCardinalityMax() == 1) {
                    if (iPrimalObjectMetadata.getXmlDataType().equals("dateTime") || iPrimalObjectMetadata.getXmlDataType().equals("xml.node") || iPrimalObjectMetadata.getXmlDataType().equals("bin.base64")) {
                        object = (IPrimalMemberMetadata)iMemberMetadataArray[n];
                        string = (String)object.getValueToString(businessObject);
                    } else {
                        object2 = iMemberMetadataArray[n].getValue(businessObject);
                        if (object2 != null) {
                            string = object2.toString();
                        }
                    }
                } else {
                    IPrimalMemberMetadata iPrimalMemberMetadata = (IPrimalMemberMetadata)iMemberMetadataArray[n];
                    stringArray = (String[])iPrimalMemberMetadata.getValueToString(businessObject);
                }
                if (iMemberMetadataArray[n].isAttribute() && object2 != null) {
                    element.setAttribute(iMemberMetadataArray[n].getName(), string);
                } else if (string != "" && iMemberMetadataArray[n].getCardinalityMax() == 1) {
                    element2 = documentImpl.createElement(iMemberMetadataArray[n].getName());
                    if (iMemberMetadataArray[n].getType().getTypeName().equalsIgnoreCase("org.w3c.dom.Node")) {
                        object = Converter.stringToDocument(string).getDocumentElement();
                        element2.appendChild((Node)object);
                    } else {
                        text = documentImpl.createTextNode(string);
                        element2.appendChild(text);
                    }
                    element.appendChild(element2);
                } else if (stringArray != null && iMemberMetadataArray[n].getCardinalityMax() != 1) {
                    if (iMemberMetadataArray[n].getType().getTypeName().equalsIgnoreCase("org.w3c.dom.Node")) {
                        int n2 = 0;
                        while (n2 <= stringArray.length - 1) {
                            element2 = documentImpl.createElement(iMemberMetadataArray[n].getName());
                            Document document = Converter.stringToDocument(stringArray[n2]);
                            element2.appendChild(document.getDocumentElement());
                            element.appendChild(element2);
                            ++n2;
                        }
                    } else {
                        int n3 = 0;
                        while (n3 <= stringArray.length - 1) {
                            element2 = documentImpl.createElement(iMemberMetadataArray[n].getName());
                            text = documentImpl.createTextNode(stringArray[n3]);
                            element2.appendChild(text);
                            element.appendChild(element2);
                            ++n3;
                        }
                    }
                }
            } else {
                int n4 = iMemberMetadataArray[n].getCardinalityMax();
                if (n4 == 1) {
                    BusinessObject businessObject2 = (BusinessObject)iMemberMetadataArray[n].getValue(businessObject);
                    if (businessObject2 != null) {
                        this.retrieveValuesFromObject(businessObject2, element);
                    }
                } else {
                    businessObjectArray = (BusinessObject[])iMemberMetadataArray[n].getValue(businessObject);
                    if (businessObjectArray != null) {
                        int n5 = 0;
                        while (n5 < businessObjectArray.length) {
                            this.retrieveValuesFromObject(businessObjectArray[n5], element);
                            ++n5;
                        }
                    }
                }
            }
            string = "";
            stringArray = null;
            ++n;
        }
    }

    Document getDocument() {
        return this.m_outputDocument;
    }

    private boolean synchronize(Node node) throws Exception {
        Object object;
        Object object2;
        Object object3;
        String string;
        IManagerMetadata iManagerMetadata = MetadataUtil.getManagerMetadata(this.m_managerObject.getClass().getName());
        IBusinessObjectMetadata[] iBusinessObjectMetadataArray = iManagerMetadata.getManagedObjects();
        Node node2 = null;
        NodeList nodeList = XMLReader.getNode(node, "Tuple");
        if (nodeList == null) {
            throw new Exception("<Tuple> node not found.");
        }
        int n = nodeList.getLength();
        BusinessObject[] businessObjectArray = new BusinessObject[n];
        BusinessObject[] businessObjectArray2 = new BusinessObject[n];
        int n2 = 0;
        while (n2 < n) {
            try {
                Object object4;
                string = "";
                node2 = nodeList.item(n2);
                object3 = null;
                object2 = null;
                IBusinessObjectMetadata iBusinessObjectMetadata = null;
                object = XMLReader.getNode(node2, "Old");
                if (object == null) {
                    object = XMLReader.getNode(node2, "old");
                }
                Object object5 = nodeList.item(n2);
                if (object != null && object.getLength() != 0) {
                    if (object.getLength() > 1) {
                        throw new Exception("Malformed Input Document");
                    }
                    object4 = new Node[]{object5};
                    iBusinessObjectMetadata = this.getObjectType((NodeList)object, iBusinessObjectMetadataArray, string, (Node[])object4);
                    if (iBusinessObjectMetadata == null) {
                        throw new Exception("Object passed for synchronization is not managed by the manager.");
                    }
                    object5 = object4[0];
                    object3 = (BusinessObject)iBusinessObjectMetadata.newInstance();
                    this.m_managerObject.introduce((BusinessObject)object3);
                    this.fillObjectFromXml((BusinessObject)object3, iBusinessObjectMetadata, (Node)object5);
                    businessObjectArray[n2] = object3;
                } else {
                    businessObjectArray[n2] = object3 = null;
                }
                object4 = XMLReader.getNode(node2, "New");
                if (object4 == null) {
                    object4 = XMLReader.getNode(node2, "new");
                }
                if (object4 != null && object4.getLength() != 0) {
                    if (object4.getLength() > 1) {
                        throw new Exception("Malformed Input Document");
                    }
                    Node[] nodeArray = new Node[]{object5};
                    iBusinessObjectMetadata = this.getObjectType((NodeList)object4, iBusinessObjectMetadataArray, string, nodeArray);
                    if (iBusinessObjectMetadata == null) {
                        throw new Exception("Object passed for synchronization is not managed by the manager.");
                    }
                    object5 = nodeArray[0];
                    object2 = (BusinessObject)iBusinessObjectMetadata.newInstance();
                    this.m_managerObject.introduce((BusinessObject)object2);
                    this.fillObjectFromXml((BusinessObject)object2, iBusinessObjectMetadata, (Node)object5);
                    businessObjectArray2[n2] = object2;
                } else {
                    businessObjectArray2[n2] = object2 = null;
                }
                this.m_managerObject.changeBusinessObject((BusinessObject)object3, (BusinessObject)object2);
            }
            catch (Exception exception) {
                object3 = exception.getMessage();
                if ((object3 == null || ((String)object3).trim().equals("")) && !this.m_erroneousTag.equals("")) {
                    object3 = "Error " + exception.getMessage() + " found at <" + this.m_erroneousTag + ">";
                }
                throw new Exception((String)object3);
            }
            ++n2;
        }
        try {
            string = XMLReader.getNodeValue(node, "Unconditional");
            if (string.equals("true")) {
                this.m_managerObject.setUnconditional(true);
            } else {
                this.m_managerObject.setUnconditional(false);
            }
            this.m_managerObject.setTransactionScope(TransactionScope.MANAGER);
            double d = 0.0;
            double d2 = 0.0;
            d = System.currentTimeMillis();
            this.m_managerObject.synchronize();
            d2 = System.currentTimeMillis();
            Element element = this.m_outputDocument.createElement("TestOutput");
            Element element2 = this.m_outputDocument.createElement("Tester");
            Text text = this.m_outputDocument.createTextNode(System.getProperty("user.name"));
            element2.appendChild(text);
            element.appendChild(element2);
            this.m_timeElapsed = (d2 - d) / 1000.0;
            element2 = this.m_outputDocument.createElement("TimeTaken");
            text = this.m_outputDocument.createTextNode(String.valueOf(this.m_timeElapsed));
            element2.appendChild(text);
            element.appendChild(element2);
            this.m_outputDocument.appendChild(element);
            int n3 = 0;
            while (n3 < n) {
                if (businessObjectArray2[n3] != null) {
                    this.retrieveValuesFromObject(businessObjectArray2[n3], element);
                } else {
                    this.retrieveValuesFromObject(businessObjectArray[n3], element);
                }
                ++n3;
            }
            this.m_managerObject.close();
        }
        catch (BoiSynchronizationException boiSynchronizationException) {
            object3 = null;
            object2 = boiSynchronizationException.getDescriptors();
            int n4 = 0;
            if (n4 < ((IExceptionDescriptor[])object2).length) {
                object3 = (ISynchronizationExceptionDescriptor)object2[n4];
                object = object3.getMessage();
                throw new Exception((String)object[0]);
            }
            this.m_managerObject.close();
            return false;
        }
        catch (BoiException boiException) {
            this.m_managerObject.close();
            throw new Exception(boiException.getMessage());
        }
        return true;
    }

    private IBusinessObjectMetadata getObjectType(NodeList nodeList, IBusinessObjectMetadata[] iBusinessObjectMetadataArray, String string, Node[] nodeArray) throws Exception {
        IBusinessObjectMetadata iBusinessObjectMetadata = null;
        Node node = nodeList.item(0);
        NodeList nodeList2 = node.getChildNodes();
        int n = 0;
        while (n < nodeList2.getLength()) {
            Node node2;
            nodeArray[0] = node2 = nodeList2.item(n);
            if (node2.getNodeType() == 1) {
                string = node2.getNodeName();
                break;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < iBusinessObjectMetadataArray.length) {
            String string2 = iBusinessObjectMetadataArray[n2].getTypeName();
            if (string == "") {
                throw new Exception("Malformed input document");
            }
            if (iBusinessObjectMetadataArray[n2].getXmlDataType().equals(string)) {
                iBusinessObjectMetadata = iBusinessObjectMetadataArray[n2];
                return iBusinessObjectMetadata;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < iBusinessObjectMetadataArray.length) {
            IMemberMetadata[] iMemberMetadataArray = iBusinessObjectMetadataArray[n3].getMembers();
            int n4 = 0;
            while (n4 < iMemberMetadataArray.length) {
                IBusinessObjectMetadata iBusinessObjectMetadata2 = this.getRecursiveObjectType(iMemberMetadataArray[n4], string);
                if (iBusinessObjectMetadata2 != null) {
                    iBusinessObjectMetadata = iBusinessObjectMetadata2;
                    return iBusinessObjectMetadata;
                }
                ++n4;
            }
            ++n3;
        }
        return iBusinessObjectMetadata;
    }

    private IBusinessObjectMetadata getRecursiveObjectType(IMemberMetadata iMemberMetadata, String string) {
        if (!(iMemberMetadata instanceof IPrimalObjectMetadata) && !(iMemberMetadata instanceof IPrimalMemberMetadata) && iMemberMetadata.getName().equals(string)) {
            return (IBusinessObjectMetadata)iMemberMetadata.getType();
        }
        return null;
    }

    private boolean addShowOrList(NodeList nodeList) throws Exception {
        IMethodMetadata iMethodMetadata = null;
        boolean bl = false;
        DocumentImpl documentImpl = new DocumentImpl();
        double d = 0.0;
        double d2 = 0.0;
        IManagerMetadata iManagerMetadata = MetadataUtil.getManagerMetadata(this.m_managerObject.getClass().getName());
        IMethodMetadata[] iMethodMetadataArray = iManagerMetadata.getMethods();
        int n = 0;
        while (n < iMethodMetadataArray.length) {
            if (iMethodMetadataArray[n].getName().equals(this.m_methodName)) {
                iMethodMetadata = iMethodMetadataArray[n];
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            throw new Exception("method " + this.m_methodName + " not supported by the BOI");
        }
        IParameterMetadata[] iParameterMetadataArray = iMethodMetadata.getParameters();
        Object[] objectArray = new Object[iParameterMetadataArray.length];
        this.m_timeElapsed = 0.0;
        try {
            Object object = null;
            int n2 = 0;
            while (n2 < nodeList.getLength()) {
                this.fillParametersFromXml(objectArray, iParameterMetadataArray, nodeList.item(n2));
                d = System.currentTimeMillis();
                object = iMethodMetadata.invokeWithStrings(this.m_managerObject, objectArray);
                d2 = System.currentTimeMillis();
                this.m_timeElapsed += (d2 - d) / 1000.0;
                ++n2;
            }
            d = System.currentTimeMillis();
            Iterator iterator = this.m_managerObject.getIterator();
            d2 = System.currentTimeMillis();
            this.m_timeElapsed += (d2 - d) / 1000.0;
            Element element = documentImpl.createElement("TestOutput");
            this.m_outputDocument.appendChild(element);
            Element element2 = documentImpl.createElement("Tester");
            Text text = documentImpl.createTextNode(System.getProperty("user.name"));
            element2.appendChild(text);
            element.appendChild(element2);
            element2 = documentImpl.createElement("TimeTaken");
            element.appendChild(element2);
            while (iterator.hasMoreElements()) {
                d = System.currentTimeMillis();
                BusinessObject businessObject = iterator.nextElement();
                d2 = System.currentTimeMillis();
                this.m_timeElapsed += (d2 - d) / 1000.0;
                this.retrieveValuesFromObject(businessObject, element);
            }
            this.m_managerObject.close();
            text = documentImpl.createTextNode(String.valueOf(this.m_timeElapsed));
            element2.appendChild(text);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = illegalArgumentException.getLocalizedMessage();
            if (string == null || string.trim().equals("")) {
                string = "IllegalArgumentException";
            }
            this.m_managerObject.close();
            throw new Exception(string);
        }
        catch (InvocationTargetException invocationTargetException) {
            String string = invocationTargetException.getTargetException().toString();
            if (string == null || string.trim().equals("")) {
                string = "InvocationTargetException";
            }
            this.m_managerObject.close();
            throw new Exception(string);
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string == null || string.trim().equals("")) {
                string = "Record Not Found";
            }
            this.m_managerObject.close();
            throw new Exception(string);
        }
    }
}

