/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.fw.log.control;

import com.baan.owimpl.fw.ccf.LoggingConfiguration;
import com.baan.owimpl.fw.ccf.LoggingContext;
import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.baan.owimpl.fw.ccf.dt.LogCategories;
import com.baan.owimpl.fw.ccf.dt.LogLevelEnum;
import com.baan.owimpl.fw.ccf.event.ConfigurationEvent;
import com.baan.owimpl.fw.ccf.event.ConfigurationListener;
import com.baan.owimpl.fw.log.ActualLogger;
import com.baan.owimpl.fw.log.ErrorLevelLogger;
import com.baan.owimpl.fw.log.FileLogger;
import com.baan.owimpl.fw.log.FlowLevelLogger;
import com.baan.owimpl.fw.log.IFileLogger;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.ILoggerImpl;
import com.baan.owimpl.fw.log.InfoLevelLogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.baan.owimpl.fw.log.NullLogger;
import com.baan.owimpl.fw.log.SourceLogger;
import com.baan.owimpl.fw.log.control.Categories;
import com.baan.owimpl.fw.log.control.LoggerList;
import com.baan.owimpl.fw.log.init.ActualInitLogger;
import com.baan.owimpl.fw.log.init.ErrorLevelInitLogger;
import com.baan.owimpl.fw.log.init.FlowLevelInitLogger;
import com.baan.owimpl.fw.log.init.IInitLogger;
import com.baan.owimpl.fw.log.init.InfoLevelInitLogger;
import com.baan.owimpl.fw.log.init.InitLogger;
import java.util.Enumeration;
import java.util.Vector;

public class LogController
implements ConfigurationListener {
    private static int REFRESH_TIME = 60;
    private ILogger m_logger = null;
    private static ILoggerImpl m_nullLogger = new NullLogger();
    private ILoggerImpl m_errorLevelLogger = null;
    private ILoggerImpl m_infoLevelLogger = null;
    private ILoggerImpl m_flowLevelLogger = null;
    private LoggingConfiguration m_loggingConfig = null;
    private Categories m_categories = null;
    private ILogger m_actualLogger = null;
    private IFileLogger m_fileLogger = null;
    private static LoggerList m_loggerList = null;
    private Vector m_sourceLoggersInitList = new Vector();
    private static final int LOADING = 0;
    private static final int INITIALIZING = 1;
    private static final int READY = 2;
    private static int status;

    public ILogger getLogger(String string, String string2) {
        if (status == 0) {
            status = 1;
            new LogInitialize(this).start();
        }
        if (status == 1) {
            SourceLogger sourceLogger = new SourceLogger(new InitLogger(string2), string, string2);
            this.m_sourceLoggersInitList.addElement(sourceLogger);
            m_loggerList.addSourceLogger(sourceLogger);
            return sourceLogger;
        }
        ILogger iLogger = this.getSourceLogger(string, string2);
        m_loggerList.addSourceLogger(iLogger);
        return iLogger;
    }

    ILogger getSourceLogger(String string, String string2) {
        if (this.m_categories.logPackage(string2)) {
            return new SourceLogger(this.m_actualLogger, string, string2);
        }
        return new SourceLogger(this.m_errorLevelLogger, string, string2);
    }

    public ILogger getNewActualLogger(LogLevelEnum logLevelEnum) {
        ActualLogger actualLogger = null;
        this.m_errorLevelLogger = new ErrorLevelLogger(this.m_fileLogger);
        this.m_infoLevelLogger = new InfoLevelLogger(this.m_fileLogger);
        this.m_flowLevelLogger = new FlowLevelLogger(this.m_fileLogger);
        if (logLevelEnum == LogLevelEnum.ERROR) {
            actualLogger = new ActualLogger(this.m_errorLevelLogger, m_nullLogger, m_nullLogger);
        } else if (logLevelEnum == LogLevelEnum.INFO) {
            actualLogger = new ActualLogger(this.m_errorLevelLogger, this.m_infoLevelLogger, m_nullLogger);
        } else if (logLevelEnum == LogLevelEnum.FLOW) {
            actualLogger = new ActualLogger(this.m_errorLevelLogger, this.m_infoLevelLogger, this.m_flowLevelLogger);
        }
        return actualLogger;
    }

    void reinitialize(Categories categories, LogLevelEnum logLevelEnum) {
        this.m_actualLogger = this.getNewActualLogger(logLevelEnum);
        m_loggerList.reinitializeSourceLoggers(categories, this.m_actualLogger);
    }

    public void configurationChanged(ConfigurationEvent configurationEvent) {
        this.m_logger.message("Got new loggingConfiguration from CCF");
        LogCategories logCategories = this.m_loggingConfig.getCategories();
        this.m_categories = new Categories(logCategories);
        LogLevelEnum logLevelEnum = this.m_loggingConfig.getLevel();
        this.m_actualLogger = this.getNewActualLogger(logLevelEnum);
        this.m_logger.message("Reinitializing logging");
        m_loggerList.reinitializeSourceLoggers(this.m_categories, this.m_actualLogger);
        this.m_logger.message("Reinitialized logging");
        this.m_logger.message("Log Level = " + this.m_loggingConfig.getLevel().toString());
        this.m_logger.message("Log Categories = " + this.m_loggingConfig.getCategories().toString());
    }

    public static String getLogFileName(String string) {
        String string2 = System.getProperty("file.separator");
        String string3 = System.getProperty("user.home");
        if (string != null && string.length() > 0) {
            if (string.startsWith(string2)) {
                return string;
            }
            if (string.length() > 2 && string.charAt(1) == ':') {
                return string;
            }
            string = string3 + string2 + ".owlog" + string2 + string;
        } else {
            String string4 = System.getProperty("user.name");
            string = string3 + string2 + ".owlog" + string2 + string4 + ".log";
        }
        return string;
    }

    public static String getLogLocation(String string) {
        String string2 = System.getProperty("file.separator");
        String string3 = LogController.getLogFileName(string);
        int n = string3.lastIndexOf(string2);
        return string3.substring(0, n + 1);
    }

    static {
        m_loggerList = new LoggerList(m_nullLogger);
        status = 0;
    }

    public class LogInitialize
    extends Thread {
        ConfigurationListener m_configurationListener = null;

        public LogInitialize(ConfigurationListener configurationListener) {
            this.setName("LogInitThread");
            LoggerFactory.setInitThread(this);
            this.m_configurationListener = configurationListener;
        }

        public void run() {
            Object object;
            LogLevelEnum logLevelEnum = LogLevelEnum.ERROR;
            String string = null;
            boolean bl = true;
            LogController.this.m_logger = LoggerFactory.createLogger("com.baan.owimpl.fw.log.control", "LogController");
            try {
                LogController.this.m_loggingConfig = LoggingContext.getInstance().search();
                LogController.this.m_logger.message("Using Logging Configuration " + LogController.this.m_loggingConfig);
                object = LogController.this.m_loggingConfig.getCategories();
                LogController.this.m_logger.message("Log Categories      : " + ((LogCategories)object).toString());
                LogController.this.m_categories = new Categories((LogCategories)object);
                logLevelEnum = LogController.this.m_loggingConfig.getLevel();
                LogController.this.m_logger.message("Log Level           : " + LogController.this.m_loggingConfig.getLevel().toString());
                bl = LogController.this.m_loggingConfig.getPerProcess();
                LogController.this.m_logger.message("Log per process     : " + bl);
                string = LogController.this.m_loggingConfig.getFileName();
            }
            catch (OWConfigurationException oWConfigurationException) {
                LogController.this.m_logger.errorMessage("Logging Initialization code cannot access logging configuration");
                LogController.this.m_logger.errorException(oWConfigurationException);
                LogController.this.m_logger.errorMessage("Initializing Logging to Level Error");
                logLevelEnum = LogLevelEnum.ERROR;
                LogController.this.m_categories = new Categories(new LogCategories(0));
            }
            LogController.this.m_logger.message("Log file configured : '" + string + "'");
            string = LogController.getLogFileName(string);
            LogController.this.m_logger.message("Log file to use     : '" + string + "'");
            LogController.this.m_fileLogger = new FileLogger(string, bl);
            LogController.this.m_actualLogger = LogController.this.getNewActualLogger(logLevelEnum);
            if (LogController.this.m_loggingConfig != null) {
                LogController.this.m_loggingConfig.addConfigurationListener(this.m_configurationListener);
                LogController.this.m_loggingConfig.setRefreshTime(REFRESH_TIME);
            }
            object = null;
            ErrorLevelInitLogger errorLevelInitLogger = new ErrorLevelInitLogger(LogController.this.m_fileLogger);
            if (logLevelEnum == LogLevelEnum.ERROR) {
                object = new ActualInitLogger(errorLevelInitLogger, (IInitLogger)((Object)m_nullLogger), (IInitLogger)((Object)m_nullLogger));
            } else if (logLevelEnum == LogLevelEnum.INFO) {
                object = new ActualInitLogger(errorLevelInitLogger, new InfoLevelInitLogger(LogController.this.m_fileLogger), (IInitLogger)((Object)m_nullLogger));
            } else if (logLevelEnum == LogLevelEnum.FLOW) {
                object = new ActualInitLogger(errorLevelInitLogger, new InfoLevelInitLogger(LogController.this.m_fileLogger), new FlowLevelInitLogger(LogController.this.m_fileLogger));
            }
            Enumeration enumeration2 = LogController.this.m_sourceLoggersInitList.elements();
            while (enumeration2.hasMoreElements()) {
                SourceLogger sourceLogger = (SourceLogger)enumeration2.nextElement();
                if (LogController.this.m_categories.logPackage(sourceLogger.getPackageName())) {
                    sourceLogger.setActualLogger(LogController.this.m_actualLogger, (IInitLogger)object);
                    continue;
                }
                sourceLogger.setActualLogger(LogController.this.m_errorLevelLogger, errorLevelInitLogger);
            }
            LogController.this.m_sourceLoggersInitList = null;
            status = 2;
            LoggerFactory.setInitThread(null);
        }
    }
}

