/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.fw.log;

import com.baan.b3.dom.Node;
import com.baan.owimpl.fw.log.LogEntry;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.services.guid.Guid;
import com.eibus.xml.util.NiceDOMWriter;
import java.io.PrintWriter;
import java.util.Vector;

public class LogEvent {
    private Vector m_store = new Vector();
    private Guid m_eventID;

    LogEvent(Guid guid) {
        this.m_eventID = guid;
    }

    Guid getEventID() {
        return this.m_eventID;
    }

    public void storeMessage(String string) {
        this.m_store.addElement(string);
    }

    public void storeBytes(byte[] byArray) {
        this.m_store.addElement(byArray);
    }

    public void storeXml(Node node) {
        if (node != null) {
            this.m_store.addElement(node);
        } else {
            this.m_store.addElement("XML is null!!");
        }
    }

    void print(PrintWriter printWriter) {
        LoggerFactory.removeLogEvent(this);
        printWriter.println(this.m_eventID);
        printWriter.println();
        int n = 0;
        while (n < this.m_store.size()) {
            if (n < 9) {
                printWriter.print("[ " + (n + 1) + "]: ");
            } else {
                printWriter.print("[" + (n + 1) + "]: ");
            }
            Object e = this.m_store.elementAt(n);
            if (e instanceof String) {
                printWriter.println((String)e);
            } else if (e instanceof Node) {
                printWriter.println("xml:");
                printWriter.print(new NiceDOMWriter((Node)e).toString());
            } else if (e instanceof byte[]) {
                byte[] byArray = (byte[])e;
                printWriter.println("bytes (" + byArray.length + "):");
                LogEntry.printByteArray(byArray, printWriter);
                printWriter.println();
            }
            ++n;
        }
    }
}

