/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.fw.log;

import com.baan.b3.dom.Node;
import com.baan.owimpl.fw.ccf.dt.LogLevelEnum;
import com.baan.owimpl.fw.log.LogEvent;
import com.eibus.xml.util.NiceDOMWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LogEntry {
    private static final String EMPTY = "                  ";
    private String m_message = null;
    private Throwable m_throwable = null;
    private LogEvent m_event = null;
    private Node m_xml = null;
    private byte[] m_bytes = null;
    private final LogLevelEnum m_level;
    private final String m_threadName;
    private final Date m_timeStamp;
    private static final SimpleDateFormat m_formatter = new SimpleDateFormat("MMM dd HH:mm:ss");

    public LogEntry(String string, LogLevelEnum logLevelEnum) {
        this.m_message = string;
        this.m_level = logLevelEnum;
        this.m_threadName = Thread.currentThread().getName();
        this.m_timeStamp = new Date();
    }

    public LogEntry(Throwable throwable, LogLevelEnum logLevelEnum) {
        this.m_message = null;
        this.m_throwable = throwable;
        this.m_level = logLevelEnum;
        this.m_threadName = Thread.currentThread().getName();
        this.m_timeStamp = new Date();
    }

    public LogEntry(LogEvent logEvent, LogLevelEnum logLevelEnum) {
        this.m_event = logEvent;
        this.m_level = logLevelEnum;
        this.m_threadName = Thread.currentThread().getName();
        this.m_timeStamp = new Date();
    }

    public LogEntry(Node node, LogLevelEnum logLevelEnum) {
        this.m_xml = node;
        this.m_level = logLevelEnum;
        this.m_threadName = Thread.currentThread().getName();
        this.m_timeStamp = new Date();
    }

    public LogEntry(byte[] byArray, LogLevelEnum logLevelEnum) {
        this.m_bytes = byArray;
        this.m_level = logLevelEnum;
        this.m_threadName = Thread.currentThread().getName();
        this.m_timeStamp = new Date();
    }

    private String printException(Throwable throwable) {
        String string = "";
        return null;
    }

    public LogLevelEnum getLogLevel() {
        return this.m_level;
    }

    public String getLevel(LogLevelEnum logLevelEnum) {
        if (logLevelEnum == LogLevelEnum.ERROR) {
            return " [ERROR] ";
        }
        if (logLevelEnum == LogLevelEnum.INFO) {
            return " [INFO ] ";
        }
        return " [FLOW ] ";
    }

    public static void printByteArray(byte[] byArray, PrintWriter printWriter) {
        int n = 1;
        while (n <= byArray.length) {
            byte by = byArray[n - 1];
            if (by >= 32) {
                printWriter.print((char)by);
            } else {
                String string = Integer.toHexString(by);
                switch (string.length()) {
                    case 1: {
                        printWriter.print("%0" + string);
                        break;
                    }
                    case 8: {
                        printWriter.print("%" + string.substring(6));
                        break;
                    }
                    default: {
                        printWriter.print("%" + string);
                    }
                }
            }
            if (0 == n % 100) {
                printWriter.println();
            }
            ++n;
        }
    }

    public void print(PrintWriter printWriter) {
        printWriter.print(m_formatter.format(this.m_timeStamp));
        String string = " (" + this.m_threadName + EMPTY;
        printWriter.print(string.substring(0, 17) + ")");
        printWriter.print(this.getLevel(this.m_level));
        if (this.m_message != null) {
            printWriter.println(this.m_message);
        } else if (this.m_throwable != null) {
            printWriter.println("Exception:");
            printWriter.println();
            this.m_throwable.printStackTrace(printWriter);
            printWriter.println();
        } else if (this.m_event != null) {
            printWriter.print("event ");
            this.m_event.print(printWriter);
            printWriter.println();
        } else if (this.m_xml != null) {
            printWriter.println("xml:");
            printWriter.println(new NiceDOMWriter(this.m_xml).toString());
        } else if (this.m_bytes != null) {
            printWriter.println("bytes (" + this.m_bytes.length + "):");
            printWriter.println();
            LogEntry.printByteArray(this.m_bytes, printWriter);
            printWriter.println();
        }
    }
}

