/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.fw.log;

import com.baan.b3impl.about.AdapterComponentInfo;
import com.baan.owimpl.fw.ccf.impl.DirectoryURL;
import com.baan.owimpl.fw.log.IFileLogger;
import com.baan.owimpl.fw.log.LogEntry;
import com.baan.owimpl.fw.log.LoggerFactory;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public final class FileLogger
implements IFileLogger {
    private boolean m_isInitialised = false;
    private PrintWriter m_printer = null;
    private final String m_configLogFileName;
    private final boolean m_doLogPerProcess;
    private final String m_applicationName;
    public static boolean s_LogEnabled = true;

    public FileLogger(String string, boolean bl) {
        this.m_configLogFileName = string;
        this.m_doLogPerProcess = bl;
        this.m_applicationName = LoggerFactory.getApplicationName();
    }

    private void initialise() {
        if (s_LogEnabled) {
            Object object;
            String string;
            Object object2;
            int n;
            Object object3;
            String string2 = System.getProperty("file.separator");
            if (this.m_doLogPerProcess && this.m_configLogFileName != null) {
                object3 = "" + System.currentTimeMillis();
                int n2 = this.m_configLogFileName.lastIndexOf(".");
                n = this.m_configLogFileName.lastIndexOf(string2);
                if (n2 > 0 && n2 > n) {
                    object2 = this.m_configLogFileName.substring(n2);
                    string = this.m_configLogFileName.substring(0, n2) + '_' + this.m_applicationName + '_' + (String)object3 + (String)object2;
                } else {
                    string = this.m_configLogFileName + '_' + this.m_applicationName + '_' + (String)object3;
                }
            } else {
                string = this.m_configLogFileName;
            }
            if (string != null) {
                try {
                    object3 = new File(string);
                    if (((File)object3).exists()) {
                        this.m_printer = new PrintWriter(new FileWriter(string, true));
                    } else {
                        File file2;
                        String string3 = ((File)object3).getParent();
                        if (string3 != null && !(file2 = new File(string3)).exists()) {
                            file2.mkdirs();
                        }
                        this.m_printer = new PrintWriter(new FileWriter(string, true));
                    }
                }
                catch (IOException iOException) {
                    System.err.println("While trying to open log file with name '" + string + "':");
                    iOException.printStackTrace(System.err);
                }
            }
            if (this.m_printer == null) {
                this.m_printer = new PrintWriter(System.err);
            }
            this.m_isInitialised = true;
            if (this.m_doLogPerProcess) {
                this.m_printer.println("Process: " + this.m_applicationName);
                this.m_printer.println();
            }
            object3 = DirectoryURL.getConfigurationPath();
            String string4 = DirectoryURL.get();
            n = 0;
            if (object3 == null) {
                object3 = "Can't find owconfig.properties file";
                n = 1;
            }
            if (string4 == null) {
                string4 = "Directory URL not set";
            }
            object2 = new AdapterComponentInfo();
            this.m_printer.println("-- SSA Integration Information --");
            this.m_printer.println("Version       = '" + ((AdapterComponentInfo)object2).getVersion() + "." + ((AdapterComponentInfo)object2).getPatchLevel() + "." + ((AdapterComponentInfo)object2).getBuildNumber() + "'");
            this.m_printer.println("Build date    = '" + ((AdapterComponentInfo)object2).getBuildDateString() + "'");
            this.m_printer.println("Build guid    = '" + ((AdapterComponentInfo)object2).getBuildGuid() + "'");
            this.m_printer.println("OwConfig path = '" + (String)object3 + "'");
            if (n == 0) {
                this.m_printer.println("Directory URL = '" + string4 + "'");
            }
            this.m_printer.println();
            String string5 = System.getProperty("java.vendor.url");
            if (string5.equals("http://www.microsoft.com/")) {
                object = System.getProperty("java.version");
                this.m_printer.println("!!!  Microsoft JVM (" + (String)object + ") Detected !!!");
                this.m_printer.println();
            }
            this.m_printer.println("-- properties listing --");
            object = ((Hashtable)System.getProperties()).elements();
            Enumeration enumeration2 = ((Hashtable)System.getProperties()).keys();
            while (enumeration2.hasMoreElements()) {
                this.m_printer.println(enumeration2.nextElement() + "=" + object.nextElement());
            }
            this.m_printer.println();
            this.m_printer.println("-- Start of Logging -- " + new Date() + " --");
            this.m_printer.flush();
        }
    }

    public synchronized void logEntry(LogEntry logEntry) {
        if (s_LogEnabled) {
            if (!this.m_isInitialised) {
                this.initialise();
            }
            logEntry.print(this.m_printer);
            this.m_printer.flush();
        }
    }
}

