/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.fw.ccf.impl;

import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.eibus.services.directory.URI;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class DirectoryURL {
    public static final String PROP_FILE = "owconfig.properties";
    private static final String PROP_DIRECTORY_URL = "ow.directory.url";
    private static final String BASENAME = "ow.jar";
    private static String s_directoryURL = null;
    static /* synthetic */ Class class$com$baan$owimpl$fw$ccf$impl$DirectoryURL;

    public static String get() {
        s_directoryURL = null;
        s_directoryURL = System.getProperty(PROP_DIRECTORY_URL);
        if (s_directoryURL == null) {
            DirectoryURL.load();
        }
        return s_directoryURL;
    }

    public static String getConfigurationPath() {
        URL uRL = (class$com$baan$owimpl$fw$ccf$impl$DirectoryURL == null ? (class$com$baan$owimpl$fw$ccf$impl$DirectoryURL = DirectoryURL.class$("com.baan.owimpl.fw.ccf.impl.DirectoryURL")) : class$com$baan$owimpl$fw$ccf$impl$DirectoryURL).getResource("/owconfig.properties");
        if (uRL == null) {
            return null;
        }
        return DirectoryURL.replaceString(uRL.getFile());
    }

    public static void set(String string) throws OWConfigurationException {
        DirectoryURL.URLValidate(string);
        s_directoryURL = string;
        DirectoryURL.save();
    }

    private static void load() {
        try {
            Properties properties = new Properties();
            InputStream inputStream = (class$com$baan$owimpl$fw$ccf$impl$DirectoryURL == null ? (class$com$baan$owimpl$fw$ccf$impl$DirectoryURL = DirectoryURL.class$("com.baan.owimpl.fw.ccf.impl.DirectoryURL")) : class$com$baan$owimpl$fw$ccf$impl$DirectoryURL).getResourceAsStream("/owconfig.properties");
            if (inputStream == null) {
                throw new Exception("Can't find owconfig.properties");
            }
            properties.load(inputStream);
            s_directoryURL = properties.getProperty(PROP_DIRECTORY_URL);
            if (s_directoryURL.length() == 0) {
                s_directoryURL = null;
            }
            inputStream.close();
        }
        catch (Exception exception) {}
    }

    private static void save() throws OWConfigurationException {
        try {
            Object object;
            String string = null;
            String string2 = System.getProperty("user.name");
            Properties properties = new Properties();
            ((Hashtable)properties).put(PROP_DIRECTORY_URL, s_directoryURL);
            URL uRL = (class$com$baan$owimpl$fw$ccf$impl$DirectoryURL == null ? (class$com$baan$owimpl$fw$ccf$impl$DirectoryURL = DirectoryURL.class$("com.baan.owimpl.fw.ccf.impl.DirectoryURL")) : class$com$baan$owimpl$fw$ccf$impl$DirectoryURL).getResource("/owconfig.properties");
            if (uRL == null) {
                object = System.getProperty("path.separator");
                String string3 = System.getProperty("java.class.path");
                StringTokenizer stringTokenizer = new StringTokenizer(string3, (String)object);
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    String string5 = string4.toLowerCase();
                    if (!string5.endsWith("\\ow.jar") && !string5.endsWith("/ow.jar")) continue;
                    string = string4.substring(0, string4.length() - BASENAME.length());
                    string = string + PROP_FILE;
                    break;
                }
                if (string == null) {
                    throw new OWConfigurationException("ow.jar not found in the classpath, owconfig.properties cannot be created");
                }
            } else {
                string = uRL.getFile();
                string = DirectoryURL.URLDecode(string);
            }
            object = new FileOutputStream(string);
            properties.save((OutputStream)object, "file last modified by: " + string2);
            ((FileOutputStream)object).close();
        }
        catch (Exception exception) {
            throw new OWConfigurationException("Save of the URL " + s_directoryURL + " failed: " + exception.getMessage());
        }
    }

    private static void URLValidate(String string) throws OWConfigurationException {
        try {
            URI uRI = URI.createURI(string);
            String string2 = uRI.getProtocol();
            if (!(string2.equalsIgnoreCase("ldap") || string2.equalsIgnoreCase("file") || string2.equalsIgnoreCase("http"))) {
                throw new OWConfigurationException("URL protocol " + string + " must be: ldap, file or http");
            }
        }
        catch (Exception exception) {
            throw new OWConfigurationException("URL has invalid format (" + exception.getMessage() + ")");
        }
    }

    private static String URLDecode(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("/FILE")) {
            string = string.substring(5);
        }
        byte[] byArray = string.getBytes();
        int n = byArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            int n4;
            if ((n4 = byArray[n2++]) == 43) {
                if (byArray[n2 - 2] == 47 && n2 < n && byArray[n2] == 47) {
                    ++n2;
                    --n3;
                    continue;
                }
                n4 = 32;
            } else if (n4 == 37 && n2 + 1 < n) {
                n4 = (byte)((DirectoryURL.convertHexDigit(byArray[n2++]) << 4) + DirectoryURL.convertHexDigit(byArray[n2++]));
            }
            byArray[n3++] = n4;
        }
        return new String(byArray, 0, n3);
    }

    private static byte convertHexDigit(byte by) {
        if (by >= 48 && by <= 57) {
            return (byte)(by - 48);
        }
        if (by >= 97 && by <= 102) {
            return (byte)(by - 97 + 10);
        }
        if (by >= 65 && by <= 70) {
            return (byte)(by - 65 + 10);
        }
        return 0;
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(DirectoryURL.get());
            DirectoryURL.set("ldap://cnl077171/o=baan.com");
            System.out.println(DirectoryURL.get());
            DirectoryURL.set("file://localhost/C:/test/config.xml");
            System.out.println(DirectoryURL.get());
            DirectoryURL.set("http://localhost/C:/test/config.xml");
            System.out.println(DirectoryURL.get());
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    private static String replaceString(String string) {
        String string2 = "%20";
        StringBuffer stringBuffer = new StringBuffer();
        int n = string2.length();
        int n2 = -1;
        int n3 = 0;
        while ((n2 = string.indexOf(string2, n3)) != -1) {
            stringBuffer.append(string.substring(n3, n2));
            stringBuffer.append(" ");
            n3 = n2 + n;
        }
        stringBuffer.append(string.substring(n3, string.length()));
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

