/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.fw.ccf.impl;

import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class ConfigurationData
implements Serializable {
    static final long serialVersionUID = -9038835424941395800L;
    private int m_version;
    private long m_time;
    private String m_user;
    private Hashtable m_properties;
    private boolean m_dirty;

    public ConfigurationData(int n) {
        this.m_properties = new Hashtable();
        this.m_version = n;
        this.m_dirty = false;
        this.touch();
    }

    public ConfigurationData(ConfigurationData configurationData) {
        this.m_properties = configurationData.m_properties;
        this.m_version = configurationData.m_version;
        this.m_dirty = configurationData.m_dirty;
        this.touch();
    }

    public void touch() {
        this.m_time = new Date().getTime();
        this.m_user = System.getProperty("user.name");
    }

    public void setProperty(String string, Object object) {
        this.m_properties.put(string, object);
        this.m_dirty = true;
    }

    public Object getProperty(String string) {
        return this.m_properties.get(string);
    }

    public int getVersion() {
        return this.m_version;
    }

    public Date getDate() {
        return new Date(this.m_time);
    }

    public String getUser() {
        return this.m_user;
    }

    public boolean isDirty() {
        return this.m_dirty;
    }

    public void resetDirty() {
        this.m_dirty = false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        ConfigurationData configurationData = (ConfigurationData)object;
        if (this.m_version != configurationData.m_version) {
            return false;
        }
        if (this.m_properties.size() != configurationData.m_properties.size()) {
            return false;
        }
        Enumeration enumeration2 = this.m_properties.keys();
        while (enumeration2.hasMoreElements()) {
            Object k = enumeration2.nextElement();
            if (this.m_properties.get(k).equals(configurationData.m_properties.get(k))) continue;
            return false;
        }
        return true;
    }
}

