/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.fw.ccf;

import com.baan.owimpl.fw.ccf.Configuration;
import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.baan.owimpl.fw.ccf.SmartConfiguration;
import com.baan.owimpl.fw.ccf.XMLConnectorContext;
import java.io.PrintStream;
import java.util.Vector;

public class XMLConnectorConfiguration
extends SmartConfiguration {
    public static final int VERSION = 1;
    private static final String DOMAIN_PRIORITY = "xml.domain.priority";
    private static final String[] DEFAULT_DOMAIN_PRIORITY = new String[0];
    private static final String ERROR_IN_RESPONSE = "xml.error.in.response";
    private static final boolean DEFAULT_ERROR_IN_RESPONSE = false;

    public XMLConnectorConfiguration(XMLConnectorContext xMLConnectorContext, String string, String string2, String string3, boolean bl) throws OWConfigurationException {
        super(xMLConnectorContext, string, string2, string3, bl);
    }

    public void storeDefaults() throws OWConfigurationException {
        this.setDomainPriority(DEFAULT_DOMAIN_PRIORITY);
        this.setErrorInResponse(false);
        this.store();
    }

    public void print(PrintStream printStream) {
        super.print(printStream);
        Configuration.printArrayProperty(printStream, "Domain Priority", this.getDomainPriority());
        Configuration.printProperty(printStream, "Error in Response", "" + this.getErrorInResponse());
    }

    public String[] getDomainPriority() {
        Vector vector = (Vector)this.m_configurationData.getProperty(DOMAIN_PRIORITY);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void setDomainPriority(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            vector.addElement(stringArray[n]);
            ++n;
        }
        this.m_configurationData.setProperty(DOMAIN_PRIORITY, vector);
    }

    public boolean getErrorInResponse() {
        Boolean bl = (Boolean)this.m_configurationData.getProperty(ERROR_IN_RESPONSE);
        return bl;
    }

    public void setErrorInResponse(boolean bl) {
        this.m_configurationData.setProperty(ERROR_IN_RESPONSE, new Boolean(bl));
    }
}

